/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.lang.reflect.Constructor;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.ParaStyle;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.TextStyle;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleCatalog {
    private Vector styles;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$TextStyle;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$ParaStyle;

    public StyleCatalog(int n) {
        this.styles = new Vector(n);
    }

    public void add(Node node, String[] stringArray, Class[] classArray, Class clazz, boolean bl) {
        if (node == null) {
            return;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (classArray == null) {
            classArray = new Class[]{};
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                boolean bl2 = false;
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                if (!string.equals("style:default-style") && !string.equals("style:style")) continue;
                String string2 = this.getFamilyName(node2);
                if (string2 == null) {
                    Debug.log(2, "familyName is null!");
                    continue;
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(string2)) continue;
                    Class clazz2 = classArray[j];
                    this.callConstructor(classArray[j], node2);
                    bl2 = true;
                }
                if (bl2 && !bl || clazz == null) continue;
                this.callConstructor(clazz, node2);
            }
        }
    }

    private void callConstructor(Class clazz, Node node) {
        Class[] classArray = new Class[]{Node.class, this.getClass()};
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{node, this};
            this.styles.add(constructor.newInstance(objectArray));
        }
        catch (Exception exception) {
            Debug.log(2, "Exception when calling constructor", exception);
        }
    }

    public void add(Style style) {
        this.styles.addElement(style);
    }

    public Style lookup(String string, String string2, String string3, Class clazz) {
        int n = this.styles.size();
        for (int i = 0; i < n; ++i) {
            Style style = (Style)this.styles.elementAt(i);
            if (string != null && style.getName() != null && !style.getName().equals(string) || string2 != null && style.getFamily() != null && !style.getFamily().equals(string2) || string3 != null && style.getParent() != null && !style.getParent().equals(string3) || clazz != null && style.getClass() != clazz || style.getName() == null) continue;
            return style;
        }
        return null;
    }

    public Style[] getMatching(Style style) {
        int n = 0;
        int n2 = this.styles.size();
        for (int i = 0; i < n2; ++i) {
            Style style2 = ((Style)this.styles.elementAt(i)).getResolved();
            if (!style2.isSubset(style)) continue;
            ++n;
        }
        Style[] styleArray = new Style[n];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            Style style3 = ((Style)this.styles.elementAt(i)).getResolved();
            if (!style3.isSubset(style)) continue;
            styleArray[n++] = style3;
        }
        return styleArray;
    }

    public Style getBestMatch(Style style) {
        return null;
    }

    public Element writeNode(Document document, String string) {
        Element element = document.createElement(string);
        int n = this.styles.size();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Style style = (Style)this.styles.get(i);
            Element element3 = document.createElement("style:style");
            if (style.getName() != null) {
                element3.setAttribute("style:name", style.getName());
            }
            if (style.getParent() != null) {
                element3.setAttribute("style:parent-style-name", style.getParent());
            }
            if (style.getFamily() != null) {
                element3.setAttribute("style:family", style.getFamily());
            }
            if ((element2 = (Element)style.createNode(document, "style:properties")) != null) {
                element3.appendChild(element2);
            }
            element.appendChild(element3);
        }
        return element;
    }

    public void dumpCSV(boolean bl) {
        if (!bl) {
            TextStyle.dumpHdr();
            int n = this.styles.size();
            for (int i = 0; i < n; ++i) {
                Style style = (Style)this.styles.get(i);
                if (!style.getClass().equals(class$org$openoffice$xmerge$converter$xml$TextStyle == null ? StyleCatalog.class$("org.openoffice.xmerge.converter.xml.TextStyle") : class$org$openoffice$xmerge$converter$xml$TextStyle)) continue;
                ((TextStyle)style).dumpCSV();
            }
        } else {
            ParaStyle.dumpHdr();
            int n = this.styles.size();
            for (int i = 0; i < n; ++i) {
                Style style = (Style)this.styles.get(i);
                if (!style.getClass().equals(class$org$openoffice$xmerge$converter$xml$ParaStyle == null ? StyleCatalog.class$("org.openoffice.xmerge.converter.xml.ParaStyle") : class$org$openoffice$xmerge$converter$xml$ParaStyle)) continue;
                ((ParaStyle)style).dumpCSV();
            }
        }
    }

    private Class getClass(Node node, String[] stringArray, Class[] classArray, Class clazz) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!node2.getNodeName().equals("style:family")) continue;
                String string = node2.getNodeValue();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(string)) continue;
                    return classArray[j];
                }
                return clazz;
            }
        }
        return null;
    }

    private String getFamilyName(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!node2.getNodeName().equals("style:family")) continue;
                return node2.getNodeValue();
            }
        }
        return null;
    }
}

