/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RemoteCommand;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Tag;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.TagListener;

public class RTag
extends RemoteCommand {
    public static final Command.LocalOption CREATE_BRANCH = Tag.CREATE_BRANCH;
    public static final Command.LocalOption CLEAR_FROM_REMOVED = new Command.LocalOption("-a", null);
    public static final Command.LocalOption FORCE_REASSIGNMENT = new Command.LocalOption("-F", null);
    public static final Command.LocalOption FORCE_BRANCH_REASSIGNMENT = new Command.LocalOption("-B", null);
    private static final ICommandOutputListener DEFAULT_OUTPUT_LISTENER = new TagListener();

    public static Command.LocalOption makeTagOption(CVSTag tag) {
        int type = tag.getType();
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return new Command.LocalOption("-r", tag.getName());
            }
            case 3: {
                return new Command.LocalOption("-D", tag.getName());
            }
        }
        throw new IllegalArgumentException();
    }

    protected String getRequestId() {
        return "rtag";
    }

    protected ICVSResource[] computeWorkResources(Session session, Command.LocalOption[] localOptions, String[] arguments) throws CVSException {
        if (arguments.length < 2) {
            throw new IllegalArgumentException();
        }
        return super.computeWorkResources(session, localOptions, arguments);
    }

    public IStatus execute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, CVSTag sourceTag, CVSTag tag, String[] arguments, IProgressMonitor monitor) throws CVSException {
        if (tag.getType() != 2 && tag.getType() != 1) {
            throw new CVSException((IStatus)new CVSStatus(4, CVSMessages.Tag_notVersionOrBranchError));
        }
        ArrayList<Command.LocalOption> modifiedLocalOptions = new ArrayList<Command.LocalOption>(localOptions.length + 1);
        if (sourceTag == null) {
            sourceTag = CVSTag.DEFAULT;
        }
        modifiedLocalOptions.addAll((Collection)Arrays.asList(localOptions));
        modifiedLocalOptions.add(RTag.makeTagOption(sourceTag));
        if (tag.getType() == 1 && !CREATE_BRANCH.isElementOf(localOptions)) {
            modifiedLocalOptions.add(CREATE_BRANCH);
        }
        String[] newArguments = new String[arguments.length + 1];
        newArguments[0] = tag.getName();
        System.arraycopy(arguments, 0, newArguments, 1, arguments.length);
        return this.execute(session, globalOptions, modifiedLocalOptions.toArray(new Command.LocalOption[modifiedLocalOptions.size()]), newArguments, null, monitor);
    }

    public IStatus execute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, CVSTag sourceTag, CVSTag tag, ICVSRemoteResource[] arguments, IProgressMonitor monitor) throws CVSException {
        String[] stringArguments = this.convertArgumentsForOpenSession(arguments, session);
        return this.execute(session, globalOptions, localOptions, sourceTag, tag, stringArguments, monitor);
    }

    protected ICommandOutputListener getDefaultCommandOutputListener() {
        return DEFAULT_OUTPUT_LISTENER;
    }
}

