/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStepFilters;

public abstract class DebugElement
extends PlatformObject
implements IDebugElement {
    private IDebugTarget fTarget;

    public DebugElement(IDebugTarget target) {
        this.fTarget = target;
    }

    public IDebugTarget getDebugTarget() {
        return this.fTarget;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IDebugElement.class) {
            return this;
        }
        if (adapter == IStepFilters.class && this.getDebugTarget() instanceof IStepFilters) {
            return this.getDebugTarget();
        }
        if (adapter == IDebugTarget.class) {
            return this.getDebugTarget();
        }
        if (adapter == ILaunch.class) {
            return this.getLaunch();
        }
        if (adapter == IProcess.class) {
            return this.getDebugTarget().getProcess();
        }
        return super.getAdapter(adapter);
    }

    public void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    public void fireChangeEvent(int detail) {
        this.fireEvent(new DebugEvent(this, 16, detail));
    }

    public void fireCreationEvent() {
        this.fireEvent(new DebugEvent(this, 4));
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent(this, 1, detail));
    }

    public void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent(this, 2, detail));
    }

    public void fireTerminateEvent() {
        this.fireEvent(new DebugEvent(this, 8));
    }

    protected void requestFailed(String message, Throwable e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, message, e));
    }

    protected void notSupported(String message, Throwable e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5011, message, e));
    }
}

