/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DiffProject
implements IWorkbenchAdapter,
IAdaptable {
    List fDiffs = new ArrayList();
    IProject fProject;
    String fOriginalProjectName = null;

    DiffProject(IProject project) {
        this.fProject = project;
        this.fOriginalProjectName = project.getName();
    }

    void addDiff(Diff diff) {
        this.fDiffs.add(diff);
    }

    void addDiffs(Diff[] diffs) {
        int i = 0;
        while (i < diffs.length) {
            this.fDiffs.add(diffs[i]);
            ++i;
        }
    }

    IProject getProject() {
        return this.fProject;
    }

    String getName() {
        return this.fProject.getName();
    }

    void setProject(IProject project) {
        this.fProject = project;
    }

    ArrayList reset(WorkspacePatcher patcher, int strip, int fuzzfactor) {
        ArrayList hunksToCheck = new ArrayList();
        for (Diff diff : this.fDiffs) {
            hunksToCheck.addAll(diff.reset(patcher, strip, fuzzfactor));
        }
        return hunksToCheck;
    }

    public IFile getFile(IPath path) {
        return this.fProject.getFile(path);
    }

    public IFile[] getTargetFiles() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (Diff diff : this.fDiffs) {
            if (!diff.isEnabled()) continue;
            files.add(diff.getTargetFile());
        }
        return files.toArray(new IFile[files.size()]);
    }

    public Object[] getChildren(Object o) {
        return this.fDiffs.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        Object o = this.fProject.getAdapter(IWorkbenchAdapter.class);
        if (o instanceof IWorkbenchAdapter) {
            ImageDescriptor id = ((IWorkbenchAdapter)o).getImageDescriptor((Object)this.fProject);
            return id;
        }
        return null;
    }

    public String getLabel(Object o) {
        return this.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public String getOriginalProjectName() {
        return this.fOriginalProjectName;
    }
}

