/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.internal.index.IndexEntry;

public class Index
implements IIndex {
    protected TreeMap entries;

    public Index() {
        this.entries = new TreeMap();
    }

    public Index(Comparator comparator) {
        this.entries = new TreeMap(comparator);
    }

    public Index(Comparator comparator, List entries) {
        this(comparator);
        for (IndexEntry entry : entries) {
            this.entries.put(entry.getKeyword(), entry);
        }
    }

    protected IndexEntry addEntry(String keyword) {
        IndexEntry oldEntry = (IndexEntry)this.entries.get(keyword);
        if (oldEntry == null) {
            oldEntry = new IndexEntry(this.entries.comparator(), keyword);
            this.entries.put(keyword, oldEntry);
        }
        return oldEntry;
    }

    public Map getEntryMap() {
        return this.entries;
    }

    public IIndexEntry[] getEntries() {
        if (this.entries == null) {
            return new IIndexEntry[0];
        }
        Collection entryCollection = this.entries.values();
        IIndexEntry[] entryArray = new IIndexEntry[entryCollection.size()];
        entryCollection.toArray(entryArray);
        return entryArray;
    }

    public Comparator getComparator() {
        return this.entries.comparator();
    }
}

