/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;

public class ContextFinder
extends ClassLoader
implements PrivilegedAction {
    static ClassLoader finderClassLoader;
    static Finder contextFinder;
    private static ThreadLocal cycleDetector;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                finderClassLoader = ContextFinder.class.getClassLoader();
                contextFinder = new Finder();
                return null;
            }
        });
        cycleDetector = new ThreadLocal();
    }

    public ContextFinder(ClassLoader contextClassLoader) {
        super(contextClassLoader);
    }

    ArrayList basicFindClassLoaders() {
        Class[] stack = contextFinder.getClassContext();
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(1);
        int i = 1;
        while (i < stack.length) {
            ClassLoader tmp = stack[i].getClassLoader();
            if (stack[i] != ContextFinder.class && tmp != null && tmp != this) {
                if (this.checkClassLoader(tmp)) {
                    result.add(tmp);
                }
                if (tmp == finderClassLoader || tmp instanceof BundleClassLoader) break;
            }
            ++i;
        }
        return result;
    }

    private boolean checkClassLoader(ClassLoader classloader) {
        if (classloader == null || classloader == this.getParent()) {
            return false;
        }
        ClassLoader parent = classloader.getParent();
        while (parent != null) {
            if (parent == this) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    private ArrayList findClassLoaders() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoaders();
        }
        return (ArrayList)AccessController.doPrivileged(this);
    }

    public Object run() {
        return this.basicFindClassLoaders();
    }

    private boolean startLoading(String name) {
        HashSet<String> classesAndResources = (HashSet<String>)cycleDetector.get();
        if (classesAndResources != null && classesAndResources.contains(name)) {
            return false;
        }
        if (classesAndResources == null) {
            classesAndResources = new HashSet<String>(3);
            cycleDetector.set(classesAndResources);
        }
        classesAndResources.add(name);
        return true;
    }

    private void stopLoading(String name) {
        ((Set)cycleDetector.get()).remove(name);
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized Class loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        if (!this.startLoading(arg0)) {
            throw new ClassNotFoundException(arg0);
        }
        try {
            var6_3 = super.loadClass(arg0, arg1);
            return var6_3;
        }
        catch (ClassNotFoundException v0) {
            toConsult = this.findClassLoaders();
            loaders = toConsult.iterator();
            ** while (loaders.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            try {
                var6_4 = ((ClassLoader)loaders.next()).loadClass(arg0);
                return var6_4;
            }
            catch (ClassNotFoundException v1) {
                try {
                    continue;
lbl16:
                    // 1 sources

                    throw new ClassNotFoundException(arg0);
                }
                catch (Throwable var5_7) {
                    throw var5_7;
lbl19:
                    // 1 sources

                    ** GOTO lbl16
                }
            }
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    protected URL findResource(String arg0) {
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            Iterator loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                URL result = ((ClassLoader)loaders.next()).getResource(arg0);
                if (result == null) continue;
                URL uRL = result;
                return uRL;
            }
            URL uRL = super.findResource(arg0);
            return uRL;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    protected Enumeration findResources(String arg0) throws IOException {
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            Iterator loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                Enumeration<URL> result = ((ClassLoader)loaders.next()).getResources(arg0);
                if (result == null || !result.hasMoreElements()) continue;
                Enumeration<URL> enumeration = result;
                return enumeration;
            }
            Enumeration<URL> enumeration = super.findResources(arg0);
            return enumeration;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    private static final class Finder
    extends SecurityManager {
        private Finder() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

