/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Stack;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionsHandler
extends DefaultHandler {
    private Stack fOpenElements;
    private Locator fLocator;
    private Element fParent;

    public ExtensionsHandler(Element parent) {
        this.fParent = parent;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if ("eclipse".equals(target)) {
            this.fParent.setAttribute("schema", "version=\"3.0\"".equals(data) ? "3.0" : "3.2");
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.fOpenElements == null) {
            if (qName.equals("plugin") || qName.equals("fragment")) {
                this.fOpenElements = new Stack();
            }
        } else if (this.fOpenElements.size() == 0) {
            if (qName.equals("extension")) {
                this.createExtension(attributes);
            } else if (qName.equals("extension-point")) {
                this.createExtensionPoint(attributes);
            }
        } else {
            this.createElement(qName, attributes);
        }
    }

    private void createExtension(Attributes attributes) {
        String name;
        Element extension = this.fParent.getOwnerDocument().createElement("extension");
        String point = attributes.getValue("point");
        if (point == null) {
            return;
        }
        extension.setAttribute("point", point);
        String id = attributes.getValue("id");
        if (id != null) {
            extension.setAttribute("id", id);
        }
        if ((name = attributes.getValue("name")) != null) {
            extension.setAttribute("name", name);
        }
        extension.setAttribute("line", Integer.toString(this.fLocator.getLineNumber()));
        this.fParent.appendChild(extension);
        if (CoreUtility.isInterestingExtensionPoint(point)) {
            this.fOpenElements.push(extension);
        }
    }

    private void createExtensionPoint(Attributes attributes) {
        Element extPoint = this.fParent.getOwnerDocument().createElement("extension-point");
        String id = attributes.getValue("id");
        if (id == null) {
            return;
        }
        extPoint.setAttribute("id", id);
        String name = attributes.getValue("name");
        if (name == null) {
            return;
        }
        extPoint.setAttribute("name", name);
        String schema = attributes.getValue("schema");
        if (schema != null) {
            extPoint.setAttribute("schema", schema);
        }
        extPoint.setAttribute("line", Integer.toString(this.fLocator.getLineNumber()));
        this.fParent.appendChild(extPoint);
    }

    private void createElement(String tagName, Attributes attributes) {
        Element element = this.fParent.getOwnerDocument().createElement(tagName);
        int i = 0;
        while (i < attributes.getLength()) {
            element.setAttribute(attributes.getQName(i), attributes.getValue(i));
            ++i;
        }
        ((Element)this.fOpenElements.peek()).appendChild(element);
        this.fOpenElements.push(element);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.fOpenElements != null && !this.fOpenElements.isEmpty()) {
            this.fOpenElements.pop();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }
}

