/*******************************************************************************
* Copyright (c) 2000, 2004 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
package org.eclipse.wst.rdb.internal.outputview;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.core.resources.ResourcesPlugin;

/**
 * Contains utility methods for getting the output view.
 */
public class OutputUtil
{
   /** 
    * The active workbench window. 
    */
   protected static IWorkbenchWindow activeWindow = null;
   /** The active page. */
   protected static IWorkbenchPage activePage = null;
   /** The view part. */
   protected static IViewPart viewPart = null;
   
   /** 
    * Gets the output view synchronously.
    */
   public static OutputView getOutputView() {
      return getOutputView(false);
   }
   
   /**
    *     @param async       True if the update is to be performed asynchronously, meaning
    *                        the update is delayed to the event dispath thread via
    *                        the Display syncExec method.
    *                        False if the update is to be performed synchronously.
    */
   public static OutputView getOutputView(boolean async)
   {
      if (activeWindow == null)
         activeWindow = OutputViewPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
      
      // This is a workaround as in some cases (like build) we lose the active Window
      //   in the workbench somehow.  This occurs during DC code, possibly due to
      //   SwingUtilites.invokeLater().  This is not yet confirmed, so for now we find
      //   the Data perspective this way.  This has the implication that we display
      //   stuff not in the active window (when  more than one workbench window is open)
      //   and we assume we want the OutputView in the Data Perspetive when it could be opened
      //   in a different perspective.
      
      //if activeWindow is still null, then we get the first one on the list,
      //but that means it could be a wrong active window.
      if (activeWindow == null) {
         IWorkbenchWindow ww[] = PlatformUI.getWorkbench()
         .getWorkbenchWindows();
         if (ww.length > 0) {
            activeWindow = ww[0];
            if (activeWindow != null)
               activePage = activeWindow.getActivePage();
            else {
               return null;
            }
         } else
            return null;
         // if for some reason we can't find the active perspective either
         if (activePage == null) {
            IWorkbenchPage pages[] = activeWindow.getPages(); // get all
            // perspectives
            for (int i = 0; i < pages.length; i++) {
               // look for Data Perspective
               if (pages[i].getPerspective().getId().equals(
               /*"com.ibm.etools.rsc.ui.view.DBAPerspective"*/"com.ibm.datatools.core.internal.ui.perspective"))
                  activePage = pages[i];
            }
         }
      } else {
         activePage = activeWindow.getActivePage();
      }
      if (activePage == null)
         return null;
      
      
      //start to display.asyncExec.
      if (async) {
         //Get the display to deal with the async.
         viewPart = null;
         Display display = activeWindow.getShell().getDisplay();
         if (display != null) {
            IViewReference viewReference[] = activePage.getViewReferences();
            //IViewPart viewPart;
            
            //look for the output view. If we find it, then return it.
            for (int i = 0; i < viewReference.length; i++) {
               viewPart = viewReference[i].getView(false);
               if (viewPart instanceof OutputView) {
                  display.syncExec(new Runnable() {
                     public void run() {
                        activePage.bringToTop( viewPart );
                     }
                  });
                  return (OutputView) viewPart;
               }
            }
            
            //if no output view found, we need to show the view.
            display.syncExec(new Runnable() {
               public void run() {
                  try {
                     viewPart = activePage
                     .showView("org.eclipse.wst.rdb.internal.outputview.OutputView");
                     //return (OutputView) view;
                  } catch (PartInitException e) {
                     MessageDialog.openError(new Shell(), OutputViewPlugin
                              .getString("STR_OPEN_OUTPUT_ERROR"), e.getMessage());
                     OutputViewPlugin.getPlugin().writeLog(IStatus.ERROR, 0,
                              "OutputView:getOutputView.", e);
                     viewPart = null;
                  }
               }
            });
            if (viewPart != null) return (OutputView) viewPart;
            else return null;
         } else
            return null;
         
      } else {
         //if it is not async, copy the code here.
         
         IViewReference viewReference[] = activePage.getViewReferences();
         for (int i = 0; i < viewReference.length; i++) {
            viewPart = viewReference[i].getView(false);
            if (viewPart instanceof OutputView) {
               activePage.bringToTop( viewPart );
               return (OutputView) viewPart;
            }
         }
         try {
            viewPart = activePage
            .showView("org.eclipse.wst.rdb.internal.outputview.OutputView");
            return (OutputView) viewPart;
         } catch (PartInitException e) {
            MessageDialog.openError(new Shell(), OutputViewPlugin
                     .getString("STR_OPEN_OUTPUT_ERROR"), e.getMessage());
            OutputViewPlugin.getPlugin().writeLog(IStatus.ERROR, 0,
                     "OutputView:getOutputView.", e);
            return null;
         }			
      }
   }
   
   /**
    * Gets the encoding string from the Window->Preferences menu
    * @return the encoding string to be used for saving and loading
    */
   public static String getCharacterEncoding( )
   {
	   return ResourcesPlugin.getEncoding();
   }
   
}
