/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDParticleAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.IAnnotationProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IActionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IGraphElement;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IType;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.SetMultiplicityAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.DeleteCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNameCommand;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class XSDElementDeclarationAdapter
extends XSDParticleAdapter
implements IField,
IActionProvider,
IAnnotationProvider,
IGraphElement {
    protected XSDElementDeclaration getXSDElementDeclaration() {
        return (XSDElementDeclaration)this.target;
    }

    public String getName() {
        String name = this.getXSDElementDeclaration().getResolvedElementDeclaration().getName();
        return name == null ? "" : name;
    }

    public String getTypeName() {
        IType type = this.getType();
        if (type != null) {
            return type.getName();
        }
        return null;
    }

    public String getTypeNameQualifier() {
        return this.getXSDElementDeclaration().getTypeDefinition().getTargetNamespace();
    }

    public IType getType() {
        XSDTypeDefinition td = this.getXSDElementDeclaration().getResolvedElementDeclaration().getTypeDefinition();
        return td != null ? (IType)XSDAdapterFactory.getInstance().adapt((Notifier)td) : null;
    }

    public Image getImage() {
        XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)this.target;
        if (!xsdElementDeclaration.isElementDeclarationReference()) {
            if (this.isReadOnly()) {
                return XSDEditorPlugin.getPlugin().getIcon("obj16/XSDElementdis.gif");
            }
            return XSDEditorPlugin.getXSDImage("icons/XSDElement.gif");
        }
        if (this.isReadOnly()) {
            return XSDEditorPlugin.getPlugin().getIcon("obj16/XSDElementRefdis.gif");
        }
        return XSDEditorPlugin.getXSDImage("icons/XSDElementRef.gif");
    }

    public String getText() {
        XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)this.target;
        XSDElementDeclaration resolvedElementDeclaration = xsdElementDeclaration.getResolvedElementDeclaration();
        String name = resolvedElementDeclaration.getName();
        StringBuffer result = new StringBuffer();
        if (name == null) {
            result.append(Messages._UI_LABEL_ABSENT);
        } else {
            result.append(name);
        }
        if (!xsdElementDeclaration.isGlobal()) {
            Element element = xsdElementDeclaration.getElement();
            boolean hasMinOccurs = element.hasAttribute("minOccurs");
            boolean hasMaxOccurs = element.hasAttribute("maxOccurs");
            if (hasMinOccurs || hasMaxOccurs) {
                int max;
                int min;
                result.append(" [");
                if (hasMinOccurs) {
                    min = ((XSDParticle)xsdElementDeclaration.getContainer()).getMinOccurs();
                    if (min == -1) {
                        result.append("*");
                    } else {
                        result.append(String.valueOf(min));
                    }
                } else {
                    min = ((XSDParticle)xsdElementDeclaration.getContainer()).getMinOccurs();
                    result.append(String.valueOf(min));
                }
                if (hasMaxOccurs) {
                    max = ((XSDParticle)xsdElementDeclaration.getContainer()).getMaxOccurs();
                    result.append("..");
                    if (max == -1) {
                        result.append("*");
                    } else {
                        result.append(String.valueOf(max));
                    }
                } else {
                    result.append("..");
                    max = ((XSDParticle)xsdElementDeclaration.getContainer()).getMaxOccurs();
                    result.append(String.valueOf(max));
                }
                result.append("]");
            }
        }
        if (resolvedElementDeclaration.getAnonymousTypeDefinition() == null && resolvedElementDeclaration.getTypeDefinition() != null) {
            result.append(" : ");
            result.append(resolvedElementDeclaration.getTypeDefinition().getName());
        }
        return result.toString();
    }

    public ITreeElement[] getChildren() {
        XSDComplexTypeDefinition ctType;
        XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)this.target;
        ArrayList<XSDComplexTypeDefinition> list = new ArrayList<XSDComplexTypeDefinition>();
        XSDTypeDefinition type = null;
        if (xsdElementDeclaration.isElementDeclarationReference()) {
            type = xsdElementDeclaration.getResolvedElementDeclaration().getTypeDefinition();
        } else {
            type = xsdElementDeclaration.getAnonymousTypeDefinition();
            if (type == null) {
                type = xsdElementDeclaration.getTypeDefinition();
            }
        }
        if (type instanceof XSDComplexTypeDefinition && type.getTargetNamespace() != null && !type.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema") && (ctType = (XSDComplexTypeDefinition)type) != null && xsdElementDeclaration.isGlobal()) {
            list.add(ctType);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList.toArray(new ITreeElement[0]);
    }

    public String getKind() {
        return "element";
    }

    public boolean isGlobal() {
        return this.getXSDElementDeclaration().eContainer() instanceof XSDSchema;
    }

    public boolean isReference() {
        return ((XSDElementDeclaration)this.target).isElementDeclarationReference();
    }

    public Command getUpdateMaxOccursCommand(int maxOccurs) {
        return null;
    }

    public Command getUpdateMinOccursCommand(int minOccurs) {
        return null;
    }

    public Command getUpdateNameCommand(String name) {
        return new UpdateNameCommand(Messages._UI_ACTION_UPDATE_NAME, (XSDNamedComponent)this.getXSDElementDeclaration().getResolvedElementDeclaration(), name);
    }

    public Command getUpdateTypeNameCommand(String typeName, String quailifier) {
        return null;
    }

    public Command getDeleteCommand() {
        return new DeleteCommand("", (XSDConcreteComponent)this.getXSDElementDeclaration());
    }

    public String[] getActions(Object object) {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.isGlobal()) {
            list.add(AddXSDElementAction.ID);
        }
        list.add("SUBMENU_START_ID: " + Messages._UI_ACTION_SET_TYPE);
        list.add("SetTypeAction_AddType");
        list.add("SetTypeAction_ExistingType");
        list.add("SUBMENU_END_ID: ");
        list.add("SUBMENU_START_ID: " + Messages._UI_ACTION_SET_MULTIPLICITY);
        list.add(SetMultiplicityAction.REQUIRED_ID);
        list.add(SetMultiplicityAction.ZERO_OR_ONE_ID);
        list.add(SetMultiplicityAction.ZERO_OR_MORE_ID);
        list.add(SetMultiplicityAction.ONE_OR_MORE_ID);
        list.add("SUBMENU_END_ID: ");
        list.add("org.eclipse.jface.action.Separator");
        list.add("org.eclipse.wst.xsd.ui.internal.editor.DeleteAction");
        list.add("org.eclipse.jface.action.Separator");
        list.add("org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction");
        return list.toArray(new String[0]);
    }

    public IModel getModel() {
        Adapter adapter = XSDAdapterFactory.getInstance().adapt((Notifier)this.getXSDElementDeclaration().getSchema());
        return (IModel)adapter;
    }

    public boolean isFocusAllowed() {
        return this.isGlobal();
    }
}

