/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionUIProvider;

public class ConnectionUIHelper {
    private Map providerConnectionMap;
    private Map driverNameContribution = new HashMap();
    private Map configurationElement = new HashMap();
    private String product;
    private String version;
    private String defaultDriver = "";

    public ConnectionUIHelper(String product, String version, HashMap providerConnectionMap) {
        this.product = product;
        this.version = version;
        this.providerConnectionMap = providerConnectionMap;
    }

    private boolean isDefinitionSupported(IConfigurationElement definition) {
        return definition.getAttribute("version").equals(this.version) && definition.getAttribute("product").equals(this.product) || definition.getAttribute("version").equals("*") && definition.getAttribute("product").equals("*");
    }

    private void registerDriverNames(IConfigurationElement element) {
        String driverName = element.getAttribute("driverName");
        String uiContributor = element.getAttribute("uiContributor");
        String isDefault = element.getAttribute("isDefault");
        if (isDefault != null && isDefault.equals("true")) {
            this.defaultDriver = driverName;
        }
        this.driverNameContribution.put(driverName, uiContributor);
        this.configurationElement.put(uiContributor, element);
    }

    public String[] getDriverNames() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.connection.ui", "connectionUIProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("databaseDefinition") && this.isDefinitionSupported(configElements[j])) {
                    int k = 0;
                    while (k < configElements.length) {
                        if (configElements[k].getName().equals("driverContribution")) {
                            this.registerDriverNames(configElements[k]);
                        }
                        ++k;
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        return this.driverNameContribution.keySet().toArray(new String[this.driverNameContribution.keySet().size()]);
    }

    public IServerConnectionUIProvider getUIProvider(String driverName) {
        if (driverName == null || driverName.equals("")) {
            return null;
        }
        try {
            String uiContributor = (String)this.driverNameContribution.get(driverName);
            if (this.providerConnectionMap.containsKey(uiContributor)) {
                return (IServerConnectionUIProvider)this.providerConnectionMap.get(uiContributor);
            }
            IConfigurationElement element = (IConfigurationElement)this.configurationElement.get(uiContributor);
            IServerConnectionUIProvider provider = (IServerConnectionUIProvider)element.createExecutableExtension("uiContributor");
            this.providerConnectionMap.put(uiContributor, provider);
            return provider;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDefaultDriver() {
        return this.defaultDriver;
    }
}

