/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.internal.AbstractRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeManagerImpl;

public final class BridgedRuntime
extends AbstractRuntime {
    private final String bridgeId;
    private final String nativeRuntimeId;
    private final IRuntimeBridge.IStub stub;
    private Set supported;
    private List composition;

    BridgedRuntime(String bridgeId, String nativeRuntimeId, IRuntimeBridge.IStub stub) {
        this.bridgeId = bridgeId;
        this.nativeRuntimeId = nativeRuntimeId;
        this.stub = stub;
    }

    String getBridgeId() {
        return this.bridgeId;
    }

    String getNativeRuntimeId() {
        return this.nativeRuntimeId;
    }

    public List getRuntimeComponents() {
        return Collections.unmodifiableList(this.stub.getRuntimeComponents());
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.stub.getProperties());
    }

    public synchronized boolean supports(IProjectFacetVersion fv) {
        if (fv.getPluginId() == null) {
            return true;
        }
        List comp = this.stub.getRuntimeComponents();
        if (this.supported == null || !this.composition.equals(comp)) {
            this.supported = RuntimeManagerImpl.getSupportedFacets(comp);
            this.composition = comp;
        }
        return this.supported.contains(fv);
    }
}

