/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetRef;
import org.eclipse.wst.common.project.facet.core.internal.ValidationProblem;
import org.eclipse.wst.common.project.facet.core.internal.VersionExpr;

public final class Constraint
implements IConstraint {
    private final IProjectFacetVersion fv;
    private final IConstraint.Type type;
    private final List operands;

    Constraint(IProjectFacetVersion fv, IConstraint.Type type, Object[] operands) {
        this.fv = fv;
        this.type = type;
        ArrayList<Object> temp = new ArrayList<Object>();
        int i = 0;
        while (i < operands.length) {
            temp.add(operands[i]);
            ++i;
        }
        this.operands = Collections.unmodifiableList(temp);
    }

    public IConstraint.Type getType() {
        return this.type;
    }

    public List getOperands() {
        return this.operands;
    }

    public Object getOperand(int index) {
        return this.operands.get(index);
    }

    public IStatus check(Collection facets) {
        return this.check(facets, false);
    }

    public IStatus check(Collection facets, boolean validateSoftDeps) {
        MultiStatus result = Constraint.createMultiStatus();
        if (this.type == IConstraint.Type.AND) {
            Iterator itr = this.operands.iterator();
            while (itr.hasNext()) {
                IConstraint operand = (IConstraint)itr.next();
                IStatus st = operand.check(facets, validateSoftDeps);
                if (st.getSeverity() == 0) continue;
                result.addAll(st);
            }
        } else if (this.type == IConstraint.Type.OR) {
            boolean someBranchWorks = false;
            Iterator itr = this.operands.iterator();
            while (itr.hasNext()) {
                IConstraint operand = (IConstraint)itr.next();
                if (!operand.check(facets, validateSoftDeps).isOK()) continue;
                someBranchWorks = true;
                break;
            }
            if (!someBranchWorks) {
                ValidationProblem p = null;
                if (this.operands.size() == 2 && this.containsOnlyRequires()) {
                    ProjectFacetRef[] frefs = new ProjectFacetRef[2];
                    int i = 0;
                    while (i < 2) {
                        IConstraint c = (IConstraint)this.operands.get(i);
                        IProjectFacet rf = (IProjectFacet)c.getOperand(0);
                        VersionExpr vexpr = (VersionExpr)c.getOperand(1);
                        frefs[i] = new ProjectFacetRef(rf, vexpr);
                        ++i;
                    }
                    p = new ValidationProblem(ValidationProblem.Type.REQUIRES_ONE_OF_TWO, this.fv, frefs[0], frefs[1]);
                }
                if (p == null) {
                    p = new ValidationProblem(ValidationProblem.Type.COMPLEX, this.fv);
                }
                result.add(p);
            }
        } else if (this.type == IConstraint.Type.REQUIRES) {
            IProjectFacet rf = (IProjectFacet)this.operands.get(0);
            VersionExpr vexpr = (VersionExpr)this.operands.get(1);
            boolean soft = (Boolean)this.operands.get(2);
            if (!soft || validateSoftDeps) {
                boolean found = false;
                Iterator itr = facets.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
                    if (fv.getProjectFacet() != rf) continue;
                    try {
                        if (!vexpr.evaluate((IVersion)((Object)fv))) break;
                        found = true;
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log((Exception)((Object)e));
                    }
                    break;
                }
                if (!found) {
                    ValidationProblem.Type ptype = ValidationProblem.Type.REQUIRES;
                    ProjectFacetRef fref = new ProjectFacetRef(rf, vexpr);
                    ValidationProblem problem = new ValidationProblem(ptype, this.fv, fref);
                    result.add((IStatus)problem);
                }
            }
        } else if (this.type == IConstraint.Type.CONFLICTS) {
            Object firstOperand = this.operands.get(0);
            if (firstOperand instanceof IGroup) {
                IGroup group = (IGroup)firstOperand;
                Iterator itr = group.getMembers().iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion member = (IProjectFacetVersion)itr.next();
                    if (member.getProjectFacet() == this.fv.getProjectFacet() || !facets.contains(member)) continue;
                    ValidationProblem.Type t = ValidationProblem.Type.CONFLICTS;
                    ValidationProblem problem = new ValidationProblem(t, this.fv, member);
                    result.add((IStatus)problem);
                }
            } else {
                IProjectFacet f = (IProjectFacet)firstOperand;
                VersionExpr vexpr = this.operands.size() == 2 ? (VersionExpr)this.operands.get(1) : null;
                Iterator itr = facets.iterator();
                while (itr.hasNext()) {
                    IProjectFacetVersion fver = (IProjectFacetVersion)itr.next();
                    if (fver.getProjectFacet() != f) continue;
                    try {
                        if (vexpr != null && !vexpr.evaluate((IVersion)((Object)fver))) continue;
                        ValidationProblem.Type t = ValidationProblem.Type.CONFLICTS;
                        ValidationProblem problem = new ValidationProblem(t, this.fv, fver);
                        result.add((IStatus)problem);
                    }
                    catch (CoreException e) {
                        FacetCorePlugin.log((Exception)((Object)e));
                    }
                    break;
                }
            }
        } else {
            throw new IllegalStateException();
        }
        return result;
    }

    private boolean containsOnlyRequires() {
        Iterator itr = this.operands.iterator();
        while (itr.hasNext()) {
            if (((IConstraint)itr.next()).getType() == IConstraint.Type.REQUIRES) continue;
            return false;
        }
        return true;
    }

    static MultiStatus createMultiStatus() {
        return Constraint.createMultiStatus(new IStatus[0]);
    }

    static MultiStatus createMultiStatus(IStatus[] children) {
        return new MultiStatus("org.eclipse.wst.common.project.facet.core", 0, children, Resources.validationProblems, null);
    }

    private static final class Resources
    extends NLS {
        public static String validationProblems;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.Constraint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.Constraint$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

