/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.MIMEUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class AP1915
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1915(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        block14: {
            if (!entryContext.getMessageEntry().isMimeContent()) {
                this.result = "notApplicable";
            } else {
                MimeParts mimeParts = entryContext.getMessageEntry().getMimeParts();
                MimePart part = mimeParts.getRootPart();
                if (part == null) {
                    this.result = "notApplicable";
                } else {
                    String xmlEncoding = null;
                    String charset = MIMEUtils.getMimeHeaderSubAttribute(part.getHeaders(), "Content-Type", "charset");
                    try {
                        if (charset != null && (charset.equalsIgnoreCase("utf-8") || charset.equalsIgnoreCase("utf-16"))) {
                            int bom = 0;
                            bom = entryContext.getMessageEntry().getBOM();
                            if (bom != 0) {
                                if (bom == 0xEFBBBF && !charset.equalsIgnoreCase("utf-8") || bom == 65534 && !charset.equalsIgnoreCase("utf-16") || bom == 65279 && !charset.equalsIgnoreCase("utf-16")) {
                                    throw new AssertionFailException("The BOM (" + bom + ") and charset value (" + charset + ")do not match.");
                                }
                            } else {
                                xmlEncoding = Utils.getXMLEncoding(part.getContent());
                                if (xmlEncoding != null && !xmlEncoding.equals("")) {
                                    if (!xmlEncoding.equalsIgnoreCase(charset)) {
                                        throw new AssertionFailException("The XML declaration encoding (" + xmlEncoding + ") and charset value (" + charset + ") do not match.");
                                    }
                                } else if (!charset.equalsIgnoreCase("utf-8")) {
                                    throw new AssertionFailException("The no BOM attribute and no XML declaration, and the charset value is (" + charset + ")");
                                }
                            }
                            break block14;
                        }
                        throw new AssertionFailException("Either the Content-Type header is not present in the Root Part or a charset value is invalid.");
                    }
                    catch (AssertionFailException e) {
                        this.result = "failed";
                        this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
                    }
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

