/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.parser;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.external.m2.PomModuleDescriptorParser;
import fr.jayasoft.ivy.parser.AbstractModuleDescriptorParser;
import fr.jayasoft.ivy.parser.ModuleDescriptorParser;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ModuleDescriptorParserRegistry
extends AbstractModuleDescriptorParser {
    private static ModuleDescriptorParserRegistry INSTANCE = new ModuleDescriptorParserRegistry();
    private List _parsers = new LinkedList();

    public static ModuleDescriptorParserRegistry getInstance() {
        return INSTANCE;
    }

    private ModuleDescriptorParserRegistry() {
        this._parsers.add(PomModuleDescriptorParser.getInstance());
        this._parsers.add(XmlModuleDescriptorParser.getInstance());
    }

    public void addParser(ModuleDescriptorParser parser) {
        this._parsers.add(0, parser);
    }

    public ModuleDescriptorParser[] getParsers() {
        return this._parsers.toArray(new ModuleDescriptorParser[this._parsers.size()]);
    }

    public ModuleDescriptorParser getParser(Resource res) {
        Iterator iter = this._parsers.iterator();
        while (iter.hasNext()) {
            ModuleDescriptorParser parser = (ModuleDescriptorParser)iter.next();
            if (!parser.accept(res)) continue;
            return parser;
        }
        return null;
    }

    public ModuleDescriptor parseDescriptor(Ivy ivy, URL descriptorURL, Resource res, boolean validate) throws ParseException, IOException {
        ModuleDescriptorParser parser = this.getParser(res);
        if (parser == null) {
            Message.warn("no module descriptor parser found for " + res);
            return null;
        }
        return parser.parseDescriptor(ivy, descriptorURL, res, validate);
    }

    public boolean accept(Resource res) {
        return this.getParser(res) != null;
    }

    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws ParseException, IOException {
        ModuleDescriptorParser parser = this.getParser(res);
        if (parser == null) {
            Message.warn("no module descriptor parser found for " + res);
        } else {
            parser.toIvyFile(is, res, destFile, md);
        }
    }
}

