/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.heap;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ForwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.heap.FieldSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldSetAnalysis
extends ForwardDataflowAnalysis<FieldSet> {
    private ConstantPoolGen cpg;
    private Map<InstructionHandle, XField> instructionToFieldMap;

    public FieldSetAnalysis(DepthFirstSearch dfs, ConstantPoolGen cpg) {
        super(dfs);
        this.cpg = cpg;
        this.instructionToFieldMap = new HashMap<InstructionHandle, XField>();
    }

    public ConstantPoolGen getCPG() {
        return this.cpg;
    }

    @Override
    public void makeFactTop(FieldSet fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(FieldSet fact) {
        return fact.isTop();
    }

    @Override
    public void initEntryFact(FieldSet result) throws DataflowAnalysisException {
        result.clear();
    }

    @Override
    public void initResultFact(FieldSet result) {
        this.makeFactTop(result);
    }

    @Override
    public void meetInto(FieldSet fact, Edge edge, FieldSet result) throws DataflowAnalysisException {
        result.mergeWith(fact);
    }

    @Override
    public boolean same(FieldSet fact1, FieldSet fact2) {
        return fact1.sameAs(fact2);
    }

    @Override
    public FieldSet createFact() {
        return new FieldSet();
    }

    @Override
    public boolean isFactValid(FieldSet fact) {
        return fact.isValid();
    }

    @Override
    public void copy(FieldSet source, FieldSet dest) {
        dest.copyFrom(source);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, FieldSet fact) throws DataflowAnalysisException {
        if (!this.isFactValid(fact)) {
            return;
        }
        try {
            this.handleInstruction(handle, basicBlock, fact);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            fact.setBottom();
        }
    }

    private void handleInstruction(InstructionHandle handle, BasicBlock basicBlock, FieldSet fact) throws DataflowAnalysisException, ClassNotFoundException {
        Instruction ins = handle.getInstruction();
        short opcode = ins.getOpcode();
        switch (opcode) {
            case 178: 
            case 180: {
                XField field = this.lookupField(handle, (FieldInstruction)ins);
                if (field == null) break;
                this.sawLoad(fact, field);
                break;
            }
            case 179: 
            case 181: {
                XField field = this.lookupField(handle, (FieldInstruction)ins);
                if (field == null) break;
                this.sawStore(fact, field);
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                fact.setBottom();
            }
        }
    }

    private XField lookupField(InstructionHandle handle, FieldInstruction fins) throws ClassNotFoundException {
        XField field = this.instructionToFieldMap.get(handle);
        if (field == null) {
            field = Hierarchy.findXField(fins, this.getCPG());
            this.instructionToFieldMap.put(handle, field);
        }
        return field;
    }

    protected abstract void sawLoad(FieldSet var1, XField var2);

    protected abstract void sawStore(FieldSet var1, XField var2);

    @Override
    public /* synthetic */ boolean isFactValid(Object x0) {
        return this.isFactValid((FieldSet)x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (FieldSet)x2);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((FieldSet)x0, x1, (FieldSet)x2);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((FieldSet)x0, (FieldSet)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((FieldSet)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((FieldSet)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((FieldSet)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((FieldSet)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((FieldSet)x0, (FieldSet)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }
}

