/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DebugRepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFGPrinter {
    private CFG cfg;
    private boolean isForwards;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$CFGPrinter;

    public CFGPrinter(CFG cfg) {
        this.cfg = cfg;
        this.isForwards = true;
    }

    public void setIsForwards(boolean isForwards) {
        this.isForwards = isForwards;
    }

    public boolean isForwards() {
        return this.isForwards;
    }

    public void print(PrintStream out) {
        Iterator<BasicBlock> i = this.cfg.blockIterator();
        while (i.hasNext()) {
            Iterator edgeIter;
            CodeExceptionGen exceptionGen;
            BasicBlock bb = i.next();
            out.println();
            out.println(new StringBuffer().append("BASIC BLOCK: ").append(bb.getId()).append(bb.isExceptionThrower() ? " [EXCEPTION THROWER]" : "").append(this.blockStartAnnotate(bb)).toString());
            if (bb.isExceptionThrower()) {
                out.println(new StringBuffer().append("  Exception thrower: ").append(bb.getExceptionThrower()).toString());
            }
            if ((exceptionGen = bb.getExceptionGen()) != null) {
                out.println(new StringBuffer().append("\tCATCHES ").append(exceptionGen.getCatchType()).toString());
            }
            Iterator<InstructionHandle> j = this.instructionIterator(bb);
            while (j.hasNext()) {
                InstructionHandle handle = j.next();
                out.println(new StringBuffer().append(handle).append(this.instructionAnnotate(handle, bb)).toString());
            }
            out.println(new StringBuffer().append("END").append(this.blockAnnotate(bb)).toString());
            Iterator iterator = edgeIter = this.isForwards ? this.cfg.outgoingEdgeIterator(bb) : this.cfg.incomingEdgeIterator(bb);
            while (edgeIter.hasNext()) {
                Edge edge = (Edge)edgeIter.next();
                out.println(new StringBuffer().append("  ").append(edge.formatAsString(!this.isForwards)).append(" ").append(this.edgeAnnotate(edge)).toString());
            }
        }
    }

    public String edgeAnnotate(Edge edge) {
        return "";
    }

    public String blockStartAnnotate(BasicBlock block) {
        return "";
    }

    public String blockAnnotate(BasicBlock block) {
        return "";
    }

    public String instructionAnnotate(InstructionHandle handle, BasicBlock bb) {
        return "";
    }

    protected Iterator<InstructionHandle> instructionIterator(BasicBlock bb) {
        if (this.isForwards) {
            return bb.instructionIterator();
        }
        return bb.instructionReverseIterator();
    }

    public static void main(String[] argv) {
        try {
            if (argv.length == 0 || argv.length > 2) {
                System.out.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$CFGPrinter == null ? (class$edu$umd$cs$findbugs$ba$CFGPrinter = CFGPrinter.class$("edu.umd.cs.findbugs.ba.CFGPrinter")) : class$edu$umd$cs$findbugs$ba$CFGPrinter).getName()).append(" <class file> [outputFile]").toString());
                System.exit(1);
            }
            String className = argv[0];
            JavaClass cls = new ClassParser(className).parse();
            DebugRepositoryLookupFailureCallback lookupFailureCallback = new DebugRepositoryLookupFailureCallback();
            AnalysisContext analysisContext = AnalysisContext.create(lookupFailureCallback);
            ClassContext classContext = analysisContext.getClassContext(cls);
            Method[] methods = cls.getMethods();
            String methodName = SystemProperties.getProperty("cfg.method");
            PrintStream out = System.err;
            if (argv.length == 2) {
                out = new PrintStream(new FileOutputStream(argv[1]));
            }
            for (Method method : methods) {
                MethodGen methodGen = classContext.getMethodGen(method);
                if (methodGen == null || methodName != null && !method.getName().equals(methodName)) continue;
                out.println();
                out.println("----------------------------------------------------------------------------");
                out.println(new StringBuffer().append("Method ").append(SignatureConverter.convertMethodSignature(methodGen)).toString());
                out.println("----------------------------------------------------------------------------");
                CFG cfg = classContext.getCFG(method);
                CFGPrinter printer = new CFGPrinter(cfg);
                printer.print(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

