class Typo
  class Textfilter
    class TMCode < TextFilterPlugin::MacroPre
      plugin_display_name "TMCode"
      plugin_description "Ensures the CSS files for TextMate syntax highlighting are included."

      def self.help_text
        %{
You can use `<typo:tmcode>` to include blocks of HTML code output by TextMate.
Optionally you can default the block to hidden, to be expanded with a `<typo:tmcoderef>` reference.

    <typo:tmcode>
    <!-- TextMate-generated HTML code here -->
    </typo:tmcode>

    Expand or collapse my <typo:tmcoderef id="foo">code</typo:tmcoderef>.
    <typo:tmcode hidden="true" id="foo">
    <!-- TextMate-generated HTML code here -->
    </typo:tmcode>

You can also provide the optional attribute `theme` which specifies which theme to use for colorizing.
The list of available themes can be seen in the config screen, where you can also pick a theme to use
if the `theme` attribute isn't specified.

The HTML code that you enclose with this macro can be generated by selecting a block of text in TextMate
and selecting the TextMate->Create HTML From Document command.
}
      end

      def self.macrofilter(blog,content,attrib,params,text="")
        isHidden      = attrib['hidden'] || 'false'
        blockID       = attrib['id']
        theme         = (attrib['theme'] || config_value(params, 'default-theme')).downcase.gsub(' ', '_')

        isHidden = ["yes", "true", "1", "hidden"].include?(isHidden.downcase)

        set_whiteboard blog, content, isHidden, theme unless content.nil?

        %{<notextile><div class="textmate-source #{theme}#{isHidden ? ' tmcode-collapsed' : ''}"#{blockID ? %{ id="tmcode_#{blockID}"} : ''}>\n#{text}\n</div></notextile>}
      end

      def self.default_config
        {"default-theme" => {:default => "twilight",
                             :description => "Default theme for tmcode snippets",
                             :options => ["Twilight", "iPlastic", "Dawn", 'Space Cadet']}}
      end

      def self.set_whiteboard(blog, content, isHidden, theme)
        content.whiteboard['page_header_tmcode'] = <<-HTML
          <link href="#{blog.base_url}/stylesheets/textmate/textmate.css" media="all" rel="Stylesheet" type="text/css" />
        HTML
        content.whiteboard["page_header_tmcode_#{theme}"] = <<-HTML unless theme.blank?
          <link href="#{blog.base_url}/stylesheets/textmate/#{theme}.css" media="screen" rel="Stylesheet" type="text/css" />
        HTML
        TMCodeRef.set_whiteboard blog, content if isHidden
      end
    end

    class TMCodeRef < TextFilterPlugin::MacroPost
      plugin_display_name "TMCodeRef"
      plugin_description "Adds expand/collapse links for TMCode sections."

      def self.help_text
        %{
Use `<typo:tmcoderef id="ref">text</typo:tmcoderef>` to cause `text` to be a hyperlink which toggles
the collapsed state of the `<typo:tmcode>` block referenced by the `id`.
}
      end

      def self.macrofilter(blog,content,attrib,params,text="")
        blockID = attrib['id']

        set_whiteboard blog, content

        %{<a href="#" onclick="toggleCodeCollapse('tmcode_#{blockID.gsub("('|\\)", "\\\\\\1")}');return false;">#{text}</a>}
      end

      def self.set_whiteboard(blog, content)
        content.whiteboard['page_header_codecollapse'] = <<-HTML
          <link href="#{blog.base_url}/stylesheets/codecollapse.css" media="screen" rel="Stylesheet" type="text/css" />
          <script src="#{blog.base_url}/javascripts/codecollapse.js" type="text/javascript" defer="defer"></script>
        HTML
      end
    end
  end
end
