# Stub subroutines for octave file plplot_octave.cc.
# This file was automatically generated for octave by wrap_octave on
# Tue Mar 25 16:39:23 2008 from
# cc -D__builtin_va_list=void -E -I. -C plplot_octave.h.
#
# It was also massaged to add online documentation
# extracted from some PLplot distribution files

1;


## opt valuies for plmeshc()/plot3dc/plsurf3d()

global DRAW_LINEX DRAW_LINEY DRAW_LINEXY MAG_COLOR BASE_CONT
global TOP_CONT SURF_CONT DRAW_SIDES FACETED MESH

DRAW_LINEX  =   1; # draw lines parallel to the X axis  
DRAW_LINEY  =   2; # draw lines parallel to the Y axis  
DRAW_LINEXY =   3; # draw lines parallel to both the X and Y axis  
MAG_COLOR   =   4; # draw the mesh with a color dependent of the magnitude  
BASE_CONT   =   8; # draw contour plot at bottom xy plane  
TOP_CONT    =  16; # draw contour plot at top xy plane  
SURF_CONT   =  32; # draw contour plot at surface  
DRAW_SIDES  =  64; # draw sides  
FACETED     = 128; # draw outline for each square that makes up the surface  
MESH        = 256; # draw mesh  

## type values for plgriddata()

global GRID_CSA GRID_DTLI GRID_NNI GRID_NNIDW GRID_NNLI GRID_NNAIDW

GRID_CSA    = 1; # Bivariate Cubic Spline approximation 
GRID_DTLI   = 2; # Delaunay Triangulation Linear Interpolation 
GRID_NNI    = 3; # Natural Neighbors Interpolation 
GRID_NNIDW  = 4; # Nearest Neighbors Inverse Distance Weighted 
GRID_NNLI   = 5; # Nearest Neighbors Linear Interpolation
GRID_NNAIDW = 6; # Nearest Neighbors Around Inverse Distance Weighted 


function pl_setcontlabelformat(lexp, sigdig)
% pl_setcontlabelformat(lexp, sigdig)
%
%   Original PLplot call documentation:
%
% 
% pl_setcontlabelformat: Set
% format of numerical label for contours
% 
% DESCRIPTION:
% 
%     Set format of numerical label for contours. 
% 
% SYNOPSIS:
% 
% pl_setcontlabelformat(lexp, sigdig)
% 
% ARGUMENTS:
% 
%     lexp (PLINT, input) :    If the contour numerical label is greater
%     than 10^(lexp) or less than 10^(-lexp), then the exponential
%     format is used.  Default value of lexp is 4. 
% 
%     sigdig (PLINT, input) :    Number of significant digits.  Default
%     value is 2. 
%     value is 2. 
  plplot_octave(0, lexp, sigdig);
endfunction

function pl_setcontlabelparam(offset, size, spacing, active)
% pl_setcontlabelparam(offset, size, spacing, active)
%
%   Original PLplot call documentation:
%
% 
% pl_setcontlabelparam: Set parameters of
% contour labelling other than format of numerical label
% 
% DESCRIPTION:
% 
%     Set parameters of contour labelling other than those handled by
%     pl_setcontlabelformat. 
% 
% SYNOPSIS:
% 
% pl_setcontlabelparam(offset, size, spacing, active)
% 
% ARGUMENTS:
% 
%     offset (PLFLT, input) :    Offset of label from contour line (if set
%     to 0.0, labels are printed on the lines).  Default value is 0.006. 
% 
%     size (PLFLT, input) :    Font height for contour labels (normalized). 
%     Default value is 0.3. 
% 
%     spacing (PLFLT, input) :    Spacing parameter for contour labels. 
%     Default value is 0.1. 
% 
%     active (PLINT, input) :    Activate labels.  Set to 1 if you want
%     contour labels on. Default is off (0). 
%     contour labels on. Default is off (0). 
  plplot_octave(1, offset, size, spacing, active);
endfunction

function pladv(page)
% pladv(page)
%
%   Original PLplot call documentation:
%
% 
% pladv: Advance the (sub-)page
% 
% DESCRIPTION:
% 
%     Advances to the next subpage if sub=0, performing a page advance if
%     there are no remaining subpages on the current page.  If subpages
%     aren't being used, pladv(0) will always advance the page.  If sub>0,
%     PLplot switches to the specified subpage.  Note that this allows you
%     to overwrite a plot on the specified subpage; if this is not what you
%     intended, use pleop followed by plbop to first advance the page.  This
%     routine is called automatically (with sub=0) by plenv, but if plenv is
%     not used, pladv must be called after initializing PLplot but before
%     defining the viewport. 
% 
% SYNOPSIS:
% 
% pladv(sub)
% 
% ARGUMENTS:
% 
%     sub (PLINT, input) :    Specifies the subpage number (starting from 1
%     in the top left corner and increasing along the rows) to which to
%     advance.  Set to zero to advance to the next subpage. 
%     advance.  Set to zero to advance to the next subpage. 
  plplot_octave(2, page);
endfunction

function plaxes(x0, y0, xopt, xtick, nxsub, yopt, ytick, nysub)
% plaxes(x0, y0, xopt, xtick, nxsub, yopt, ytick, nysub)
%
%   Original PLplot call documentation:
%
% 
% plaxes: Draw a box with axes, etc. with arbitrary
% origin 
% 
% DESCRIPTION:
% 
%     Draws a box around the currently defined viewport with arbitrary
%     world-coordinate origin specified by x0 and y0 and labels it with
%     world coordinate values appropriate to the window.	Thus plaxes should
%     only be called after defining both viewport and window.  The character
%     strings xopt and yopt specify how the box should be drawn as described
%     below.  If ticks and/or subticks are to be drawn for a particular
%     axis, the tick intervals and number of subintervals may be specified
%     explicitly, or they may be defaulted by setting the appropriate
%     arguments to zero. 
% 
% SYNOPSIS:
% 
% plaxes(x0, y0, xopt, xtick, nxsub, yopt, ytick, nysub)
% 
% ARGUMENTS:
% 
%     x0 (PLFLT, input) :    World X coordinate of origin. 
% 
%     y0 (PLFLT, input) :    World Y coordinate of origin. 
% 
%     xopt (const char *, input) :    Pointer to character string specifying
%     options for horizontal axis.  The string can include any
%     combination of the following letters (upper or lower case) in any
%     order: a: Draws axis, X-axis is horizontal line (y=0), and Y-axis
%     is vertical line (x=0). 
%         b: Draws bottom (X) or left (Y) edge of frame. 
%         c: Draws top (X) or right (Y) edge of frame. 
%         f:    Always use fixed point numeric labels. 
%         g: Draws a grid at the major tick interval. 
%         h: Draws a grid at the minor tick interval. 
%         i: Inverts tick marks, so they are drawn outwards, rather than
%         inwards. 
%         l: Labels axis logarithmically.  This only affects the labels,
%         not the data, and so it is necessary to compute the logarithms
%         of data points before passing them to any of the drawing
%         routines. 
%         m: Writes numeric labels at major tick intervals in the
%         unconventional location (above box for X, right of box for Y). 
%         n: Writes numeric labels at major tick intervals in the
%         conventional location (below box for X, left of box for Y). 
%         s: Enables subticks between major ticks, only valid if t is
%         also specified. 
%         t: Draws major ticks. 
% 
% 
%     xtick (PLFLT, input) :    World coordinate interval between major
%     ticks on the x axis. If it is set to zero, PLplot automatically
%     generates a suitable tick interval. 
% 
%     nxsub (PLINT, input) :    Number of subintervals between major x axis
%     ticks for minor ticks.    If it is set to zero, PLplot automatically
%     generates a suitable minor tick interval. 
% 
%     yopt (const char *, input) :    Pointer to character string specifying
%     options for vertical axis.  The string can include any combination
%     of the letters defined above for xopt, and in addition may
%     contain: v: Write numeric labels for vertical axis parallel to the
%     base of the graph, rather than parallel to the axis. 
% 
% 
%     ytick (PLFLT, input) :    World coordinate interval between major
%     ticks on the y axis. If it is set to zero, PLplot automatically
%     generates a suitable tick interval. 
% 
%     nysub (PLINT, input) :    Number of subintervals between major y axis
%     ticks for minor ticks.    If it is set to zero, PLplot automatically
%     generates a suitable minor tick interval. 
%     generates a suitable minor tick interval. 
  plplot_octave(3, x0, y0, xopt, xtick, nxsub, yopt, ytick, nysub);
endfunction

function plbin(x, y, center)
% plbin(x, y, center)
%
%   Original PLplot call documentation:
%
% 
% plbin: Plot a histogram from binned data 
% 
% DESCRIPTION:
% 
%     Plots a histogram consisting of nbin bins.	The value associated with
%     the i'th bin is placed in x[i], and the number of points in the bin is
%     placed in y[i].  For proper operation, the values in x[i] must form a
%     strictly increasing sequence.  By default, x[i] is the left-hand edge
%     of the i'th bin. If opt=PL_BIN_CENTRED is used, the bin boundaries are
%     placed midway between the values in the x array.  Also see plhist for
%     drawing histograms from unbinned data. 
% 
% SYNOPSIS:
% 
% plbin(nbin, x, y, opt)
% 
% ARGUMENTS:
% 
%     nbin (PLINT, input) :    Number of bins (i.e., number of values in x
%     and y arrays.) 
% 
%     x (PLFLT *, input) :    Pointer to array containing values associated
%     with bins.  These must form a strictly increasing sequence. 
% 
%     y (PLFLT *, input) :    Pointer to array containing number of points
%     in bin.  This is a PLFLT (instead of PLINT) array so as to allow
%     histograms of probabilities, etc. 
% 
%     opt (PLINT, input) :    Is a combination of several flags:
%     opt=PL_BIN_DEFAULT: The x represent the lower bin boundaries, the
%     outer bins are expanded to fill up the entire x-axis and bins of
%     zero height are simply drawn. 
%         opt=PL_BIN_CENTRED|...: The bin boundaries are to be midway
%         between the x values. If the values in x are equally spaced,
%         the values are the center values of the bins. 
%         opt=PL_BIN_NOEXPAND|...: The outer bins are drawn with equal
%         size as the ones inside. 
%         opt=PL_BIN_NOEMPTY|...: Bins with zero height are not drawn
%         (there is a gap for such bins). 
%         (there is a gap for such bins). 
  plplot_octave(4, x, y, center);
endfunction

function plbop()
% plbop()
%
%   Original PLplot call documentation:
%
% 
% plbop: Begin a new page
% 
% DESCRIPTION:
% 
%     Begins a new page.	For a file driver, the output file is opened if
%     necessary.	Advancing the page via pleop and plbop is useful when a
%     page break is desired at a particular point when plotting to subpages.
%      Another use for pleop and plbop is when plotting pages to different
%     files, since you can manually set the file name by calling plsfnam
%     after the call to pleop. (In fact some drivers may only support a
%     single page per file, making this a necessity.)  One way to handle
%     this case automatically is to page advance via pladv, but enable
%     familying (see plsfam) with a small limit on the file size so that a
%     new family member file will be created on each page break. 
% 
% SYNOPSIS:
% 
% plbop()
% plbop()
  plplot_octave(5);
endfunction

function plbox(xopt, xtick, nxsub, yopt, ytick, nysub)
% plbox(xopt, xtick, nxsub, yopt, ytick, nysub)
%
%   Original PLplot call documentation:
%
% 
% plbox: Draw a box with axes, etc
% 
% DESCRIPTION:
% 
%     Draws a box around the currently defined viewport, and labels it with
%     world coordinate values appropriate to the window.	Thus plbox should
%     only be called after defining both viewport and window.  The character
%     strings xopt and yopt specify how the box should be drawn as described
%     below.  If ticks and/or subticks are to be drawn for a particular
%     axis, the tick intervals and number of subintervals may be specified
%     explicitly, or they may be defaulted by setting the appropriate
%     arguments to zero. 
% 
% SYNOPSIS:
% 
% plbox(xopt, xtick, nxsub, yopt, ytick, nysub)
% 
% ARGUMENTS:
% 
%     xopt (const char *, input) :    Pointer to character string specifying
%     options for horizontal axis.  The string can include any
%     combination of the following letters (upper or lower case) in any
%     order: a: Draws axis, X-axis is horizontal line (y=0), and Y-axis
%     is vertical line (x=0). 
%         b: Draws bottom (X) or left (Y) edge of frame. 
%         c: Draws top (X) or right (Y) edge of frame. 
%         f:    Always use fixed point numeric labels. 
%         g: Draws a grid at the major tick interval. 
%         h: Draws a grid at the minor tick interval. 
%         i: Inverts tick marks, so they are drawn outwards, rather than
%         inwards. 
%         l: Labels axis logarithmically.  This only affects the labels,
%         not the data, and so it is necessary to compute the logarithms
%         of data points before passing them to any of the drawing
%         routines. 
%         m: Writes numeric labels at major tick intervals in the
%         unconventional location (above box for X, right of box for Y). 
%         n: Writes numeric labels at major tick intervals in the
%         conventional location (below box for X, left of box for Y). 
%         s: Enables subticks between major ticks, only valid if t is
%         also specified. 
%         t: Draws major ticks. 
% 
% 
%     xtick (PLFLT, input) :    World coordinate interval between major
%     ticks on the x axis. If it is set to zero, PLplot automatically
%     generates a suitable tick interval. 
% 
%     nxsub (PLINT, input) :    Number of subintervals between major x axis
%     ticks for minor ticks.    If it is set to zero, PLplot automatically
%     generates a suitable minor tick interval. 
% 
%     yopt (const char *, input) :    Pointer to character string specifying
%     options for vertical axis.  The string can include any combination
%     of the letters defined above for xopt, and in addition may
%     contain: v: Write numeric labels for vertical axis parallel to the
%     base of the graph, rather than parallel to the axis. 
% 
% 
%     ytick (PLFLT, input) :    World coordinate interval between major
%     ticks on the y axis. If it is set to zero, PLplot automatically
%     generates a suitable tick interval. 
% 
%     nysub (PLINT, input) :    Number of subintervals between major y axis
%     ticks for minor ticks.    If it is set to zero, PLplot automatically
%     generates a suitable minor tick interval. 
%     generates a suitable minor tick interval. 
  plplot_octave(6, xopt, xtick, nxsub, yopt, ytick, nysub);
endfunction

function plbox3(xopt, xlabel, xtick, nsubx, yopt, ylabel, ytick, nsuby, zopt, zlabel, ztick, nsubz)
% plbox3(xopt, xlabel, xtick, nsubx, yopt, ylabel, ytick, nsuby, zopt, zlabel, ztick, nsubz)
%
%   Original PLplot call documentation:
%
% 
% plbox3: Draw a box with axes, etc, in 3-d 
% 
% DESCRIPTION:
% 
%     Draws axes, numeric and text labels for a three-dimensional surface
%     plot.  For a more complete description of three-dimensional plotting
%     see the PLplot documentation. 
% 
% SYNOPSIS:
% 
% plbox3(xopt, xlabel, xtick, nxsub, yopt, ylabel, ytick, nysub, zopt, zlabel, ztick, nzsub)
% 
% ARGUMENTS:
% 
%     xopt (const char *, input) :    Pointer to character string specifying
%     options for the x axis. The string can include any combination of
%     the following letters (upper or lower case) in any order: b: Draws
%     axis at base, at height z=
%     zmin where zmin is defined by call to plw3d.  This character must be
%     specified in order to use any of the other options. 
%         f: Always use fixed point numeric labels. 
%         i: Inverts tick marks, so they are drawn downwards, rather
%         than upwards. 
%         l: Labels axis logarithmically.  This only affects the labels,
%         not the data, and so it is necessary to compute the logarithms
%         of data points before passing them to any of the drawing
%         routines. 
%         n: Writes numeric labels at major tick intervals. 
%         s: Enables subticks between major ticks, only valid if t is
%         also specified. 
%         t: Draws major ticks. 
%         u: If this is specified, the text label for the axis is
%         written under the axis. 
% 
% 
%     xlabel (const char *, input) :    Pointer to character string
%     specifying text label for the x axis.  It is only drawn if u is in
%     the xopt string. 
% 
%     xtick (PLFLT, input) :    World coordinate interval between major
%     ticks on the x axis. If it is set to zero, PLplot automatically
%     generates a suitable tick interval. 
% 
%     nxsub (PLINT, input) :    Number of subintervals between major x axis
%     ticks for minor ticks.    If it is set to zero, PLplot automatically
%     generates a suitable minor tick interval. 
% 
%     yopt (const char *, input) :    Pointer to character string specifying
%     options for the y axis. The string is interpreted in the same way
%     as xopt. 
% 
%     ylabel (const char *, input) :    Pointer to character string
%     specifying text label for the y axis.  It is only drawn if u is in
%     the yopt string. 
% 
%     ytick (PLFLT, input) :    World coordinate interval between major
%     ticks on the y axis. If it is set to zero, PLplot automatically
%     generates a suitable tick interval. 
% 
%     nysub (PLINT, input) :    Number of subintervals between major y axis
%     ticks for minor ticks.    If it is set to zero, PLplot automatically
%     generates a suitable minor tick interval. 
% 
%     zopt (const char *, input) :    Pointer to character string specifying
%     options for the z axis. The string can include any combination of
%     the following letters (upper or lower case) in any order: b: Draws
%     z axis to the left of the surface plot. 
%         c: Draws z axis to the right of the surface plot. 
%         d: Draws grid lines parallel to the x-y plane behind the
%         figure.  These lines are not drawn until after plot3d or
%         plmesh are called because of the need for hidden line removal. 
%         f: Always use fixed point numeric labels. 
%         i: Inverts tick marks, so they are drawn away from the center. 
%         l: Labels axis logarithmically.  This only affects the labels,
%         not the data, and so it is necessary to compute the logarithms
%         of data points before passing them to any of the drawing
%         routines. 
%         m: Writes numeric labels at major tick intervals on the
%         right-hand vertical axis. 
%         n: Writes numeric labels at major tick intervals on the
%         left-hand vertical axis. 
%         s: Enables subticks between major ticks, only valid if t is
%         also specified. 
%         t: Draws major ticks. 
%         u: If this is specified, the text label is written beside the
%         left-hand axis. 
%         v: If this is specified, the text label is written beside the
%         right-hand axis. 
% 
% 
%     zlabel (const char *, input) :    Pointer to character string
%     specifying text label for the z axis.  It is only drawn if u or v
%     are in the zopt string. 
% 
%     ztick (PLFLT, input) :    World coordinate interval between major
%     ticks on the z axis. If it is set to zero, PLplot automatically
%     generates a suitable tick interval. 
% 
%     nzsub (PLINT, input) :    Number of subintervals between major z axis
%     ticks for minor ticks.    If it is set to zero, PLplot automatically
%     generates a suitable minor tick interval. 
%     generates a suitable minor tick interval. 
  plplot_octave(7, xopt, xlabel, xtick, nsubx, yopt, ylabel, ytick, nsuby, zopt, zlabel, ztick, nsubz);
endfunction

function plclear()
% plclear()
%
%   Original PLplot call documentation:
%
% 
% plclear: Clear current (sub)page 
% 
% DESCRIPTION:
% 
%     Clears the current page, effectively erasing everything that have been
%     drawn.  This command only works with interactive drivers; if the
%     driver does not support this, the page is filled with the background
%     color in use. If the current page is divided into subpages, only the
%     current subpage is erased.	The nth subpage can be selected with
%     pladv(n). 
% 
% SYNOPSIS:
% 
% plclear()
% plclear()
  plplot_octave(8);
endfunction

function plcol0(icol0)
% plcol0(icol0)
%
%   Original PLplot call documentation:
%
% 
% plcol0: Set color, map0 
% 
% DESCRIPTION:
% 
%     Sets the color for color map0 (see the PLplot documentation). 
% 
% SYNOPSIS:
% 
% plcol0(color)
% 
% ARGUMENTS:
% 
%     color (PLINT, input) :    Integer representing the color.  The
%     defaults at present are (these may change): 0 black (default
%     background)1 red (default foreground)2 yellow3 green4 aquamarine5
%     pink6 wheat7 grey8 brown9 blue10 BlueViolet11 cyan12 turquoise13
%     magenta14 salmon15 white Use plscmap0 to change the entire map0
%     color palette and plscol0 to change an individual color in the
%     map0 color palette. 
%     map0 color palette. 
  plplot_octave(9, icol0);
endfunction

function plcol1(col1)
% plcol1(col1)
%
%   Original PLplot call documentation:
%
% 
% plcol1: Set color, map1 
% 
% DESCRIPTION:
% 
%     Sets the color for color map1 (see the PLplot documentation).  
% 
% SYNOPSIS:
% 
% plcol1(col1)
% 
% ARGUMENTS:
% 
%     col1 (PLFLT, input) :    This value must be in the range from 0. to 1.
%     and is mapped to color using the continuous map1 color palette
%     which by default ranges from blue to the background color to red. 
%     The map1 palette can also be straightforwardly changed by the user
%     with plscmap1 or plscmap1l. 
%     with plscmap1 or plscmap1l. 
  plplot_octave(10, col1);
endfunction

function plcpstrm(iplsr, flags)
% plcpstrm(iplsr, flags)
%
%   Original PLplot call documentation:
%
% 
% plcpstrm: Copy state parameters from the
% reference stream to the current stream 
% 
% DESCRIPTION:
% 
%     This function is used for making save files of selected plots (e.g.
%     from the TK driver).  After initializing, you can get a copy of the
%     current plot to the specified device by switching to this stream and
%     issuing a plcpstrm and a plreplot, with calls to plbop and pleop as
%     appropriate.  The plot buffer must have previously been enabled (done
%     automatically by some display drivers, such as X). 
% 
% SYNOPSIS:
% 
% plcpstrm(iplsr, flags)
% 
% ARGUMENTS:
% 
%     iplsr (PLINT, input) :    Number of reference stream. 
% 
%     flags (PLBOOL, input) :    If flags is set to true the device
%     coordinates are not copied from the reference to current stream. 
%     coordinates are not copied from the reference to current stream. 
  plplot_octave(11, iplsr, flags);
endfunction

function plend()
% plend()
%
%   Original PLplot call documentation:
%
% 
% plend: End plotting session 
% 
% DESCRIPTION:
% 
%     Ends a plotting session, tidies up all the output files, switches
%     interactive devices back into text mode and frees up any memory that
%     was allocated.  Must be called before end of program. 
% 
% SYNOPSIS:
% 
% plend()
% plend()
  plplot_octave(12);
endfunction

function plend1()
% plend1()
%
%   Original PLplot call documentation:
%
% 
% plend1: End plotting session for current stream 
% 
% DESCRIPTION:
% 
%     Ends a plotting session for the current output stream only.  See
%     plsstrm for more info. 
% 
% SYNOPSIS:
% 
% plend1()
% plend1()
  plplot_octave(13);
endfunction

function plenv(xmin, xmax, ymin, ymax, just, axis)
% plenv(xmin, xmax, ymin, ymax, just, axis)
%
%   Original PLplot call documentation:
%
% 
% plenv: Set up standard window and draw box 
% 
% DESCRIPTION:
% 
%     Sets up plotter environment for simple graphs by calling pladv and
%     setting up viewport and window to sensible default values.	plenv
%     leaves enough room around most graphs for axis labels and a title.
%     When these defaults are not suitable, use the individual routines
%     plvpas, plvpor, or plvasp for setting up the viewport, plwind for
%     defining the window, and plbox for drawing the box. 
% 
% SYNOPSIS:
% 
% plenv(xmin, xmax, ymin, ymax, just, axis)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT, input) :    Value of x at left-hand edge of window (in
%     world coordinates). 
% 
%     xmax (PLFLT, input) :    Value of x at right-hand edge of window (in
%     world coordinates). 
% 
%     ymin (PLFLT, input) :    Value of y at bottom edge of window (in world
%     coordinates). 
% 
%     ymax (PLFLT, input) :    Value of y at top edge of window (in world
%     coordinates). 
% 
%     just (PLINT, input) :    Controls how the axes will be scaled: -1: the
%     scales will not be set, the user must set up the scale before
%     calling plenv using plsvpa, plvasp or other. 
%         0: the x and y axes are scaled independently to use as much of
%         the screen as possible. 
%         1: the scales of the x and y axes are made equal. 
%         2: the axis of the x and y axes are made equal, and the plot
%         box will be square. 
% 
% 
%     axis (PLINT, input) :    Controls drawing of the box around the plot:
%     -2: draw no box, no tick marks, no
%     numeric tick labels, no axes. 
%         -1: draw box only. 
%         0: draw box, ticks, and numeric tick labels. 
%         1: also draw coordinate axes at x=0 and y=0. 
%         2: also draw a grid at major tick
%     positions in both coordinates. 
%         3: also draw a grid at minor tick
%     positions in both coordinates. 
%         10: same as 0 except logarithmic x tick marks. (The x data
%         have to be converted to logarithms separately.) 
%         11: same as 1 except logarithmic x tick marks. (The x data
%         have to be converted to logarithms separately.) 
%         12: same as 2 except logarithmic x tick marks. (The x data
%         have to be converted to logarithms separately.) 
%         13: same as 3 except logarithmic x tick marks. (The x data
%         have to be converted to logarithms separately.) 
%         20: same as 0 except logarithmic y tick marks. (The y data
%         have to be converted to logarithms separately.) 
%         21: same as 1 except logarithmic y tick marks. (The y data
%         have to be converted to logarithms separately.) 
%         22: same as 2 except logarithmic y tick marks. (The y data
%         have to be converted to logarithms separately.) 
%         23: same as 3 except logarithmic y tick marks. (The y data
%         have to be converted to logarithms separately.) 
%         30: same as 0 except logarithmic x and y tick marks. (The x
%         and y data have to be converted to logarithms separately.) 
%         31: same as 1 except logarithmic x and y tick marks. (The x
%         and y data have to be converted to logarithms separately.) 
%         32: same as 2 except logarithmic x and y tick marks. (The x
%         and y data have to be converted to logarithms separately.) 
%         33: same as 3 except logarithmic x and y tick marks. (The x
%         and y data have to be converted to logarithms separately.) 
%         and y data have to be converted to logarithms separately.) 
  plplot_octave(14, xmin, xmax, ymin, ymax, just, axis);
endfunction

function plenv0(xmin, xmax, ymin, ymax, just, axis)
% plenv0(xmin, xmax, ymin, ymax, just, axis)
%
%   Original PLplot call documentation:
%
% 
% plenv0: Same as plenv but if in multiplot mode does not advance the subpage, instead clears it. 
% 
% DESCRIPTION:
% 
%     Sets up plotter environment for simple graphs by calling pladv and
%     setting up viewport and window to sensible default values.	plenv0
%     leaves enough room around most graphs for axis labels and a title.
%     When these defaults are not suitable, use the individual routines
%     plvpas, plvpor, or plvasp for setting up the viewport, plwind for
%     defining the window, and plbox for drawing the box. 
% 
% SYNOPSIS:
% 
% plenv0(xmin, xmax, ymin, ymax, just, axis)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT, input) :    Value of x at left-hand edge of window (in
%     world coordinates). 
% 
%     xmax (PLFLT, input) :    Value of x at right-hand edge of window (in
%     world coordinates). 
% 
%     ymin (PLFLT, input) :    Value of y at bottom edge of window (in world
%     coordinates). 
% 
%     ymax (PLFLT, input) :    Value of y at top edge of window (in world
%     coordinates). 
% 
%     just (PLINT, input) :    Controls how the axes will be scaled: -1: the
%     scales will not be set, the user must set up the scale before
%     calling plenv0 using plsvpa, plvasp or other. 
%         0: the x and y axes are scaled independently to use as much of
%         the screen as possible. 
%         1: the scales of the x and y axes are made equal. 
%         2: the axis of the x and y axes are made equal, and the plot
%         box will be square. 
% 
% 
%     axis (PLINT, input) :    Controls drawing of the box around the plot:
%     -2: draw no box, no tick marks, no
%     numeric tick labels, no axes. 
%         -1: draw box only. 
%         0: draw box, ticks, and numeric tick labels. 
%         1: also draw coordinate axes at x=0 and y=0. 
%         2: also draw a grid at major tick
%     positions in both coordinates. 
%         3: also draw a grid at minor tick
%     positions in both coordinates. 
%         10: same as 0 except logarithmic x tick marks. (The x data
%         have to be converted to logarithms separately.) 
%         11: same as 1 except logarithmic x tick marks. (The x data
%         have to be converted to logarithms separately.) 
%         12: same as 2 except logarithmic x tick marks. (The x data
%         have to be converted to logarithms separately.) 
%         13: same as 3 except logarithmic x tick marks. (The x data
%         have to be converted to logarithms separately.) 
%         20: same as 0 except logarithmic y tick marks. (The y data
%         have to be converted to logarithms separately.) 
%         21: same as 1 except logarithmic y tick marks. (The y data
%         have to be converted to logarithms separately.) 
%         22: same as 2 except logarithmic y tick marks. (The y data
%         have to be converted to logarithms separately.) 
%         23: same as 3 except logarithmic y tick marks. (The y data
%         have to be converted to logarithms separately.) 
%         30: same as 0 except logarithmic x and y tick marks. (The x
%         and y data have to be converted to logarithms separately.) 
%         31: same as 1 except logarithmic x and y tick marks. (The x
%         and y data have to be converted to logarithms separately.) 
%         32: same as 2 except logarithmic x and y tick marks. (The x
%         and y data have to be converted to logarithms separately.) 
%         33: same as 3 except logarithmic x and y tick marks. (The x
%         and y data have to be converted to logarithms separately.) 
%         and y data have to be converted to logarithms separately.) 
  plplot_octave(15, xmin, xmax, ymin, ymax, just, axis);
endfunction

function pleop()
% pleop()
%
%   Original PLplot call documentation:
%
% 
% pleop: Eject current page 
% 
% DESCRIPTION:
% 
%     Clears the graphics screen of an interactive device, or ejects a page
%     on a plotter.  See plbop for more information. 
% 
% SYNOPSIS:
% 
% pleop()
% pleop()
  plplot_octave(16);
endfunction

function plerrx(xmin, xmax, y)
% plerrx(xmin, xmax, y)
%
%   Original PLplot call documentation:
%
% 
% plerrx: Draw x error bar 
% 
% DESCRIPTION:
% 
%     Draws a set of n horizontal error bars, the
%     i'th error
%     bar extending from xmin[i] to xmax[i] at y coordinate
%     y[i].  The terminals of the error bar are of length equal to the
%     minor tick length (settable using plsmin). 
% 
% SYNOPSIS:
% 
% plerrx(n, xmin, xmax, y)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of error bars to draw. 
% 
%     xmin (PLFLT *, input) :    Pointer to array with x coordinates of
%     left-hand endpoint of error bars. 
% 
%     xmax (PLFLT *, input) :    Pointer to array with x coordinates of
%     right-hand endpoint of error bars. 
% 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of
%     error bar. 
%     error bar. 
  plplot_octave(17, xmin, xmax, y);
endfunction

function plerry(x, ymin, ymax)
% plerry(x, ymin, ymax)
%
%   Original PLplot call documentation:
%
% 
% plerry: Draw y error bar 
% 
% DESCRIPTION:
% 
%     Draws a set of n vertical error bars, the i'th error bar extending
%     from ymin[i] to ymax[i] at x coordinate x[i].  The terminals of the
%     error bar are of length equal to the minor tick length (settable using
%     plsmin). 
% 
% SYNOPSIS:
% 
% plerry(n, x, ymin, ymax)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of error bars to draw. 
% 
%     x (PLFLT *, input) :    Pointer to array with x coordinates of error
%     bars. 
% 
%     ymin (PLFLT *, input) :    Pointer to array with y coordinates of
%     lower endpoint of error bars. 
% 
%     ymax (PLFLT *, input) :    Pointer to array with y coordinate of upper
%     endpoint of error bar. 
%     endpoint of error bar. 
  plplot_octave(18, x, ymin, ymax);
endfunction

function plfamadv()
% plfamadv()
%
%   Original PLplot call documentation:
%
% 
% plfamadv: Advance to the next family file on the
% next new page 
% 
% DESCRIPTION:
% 
%     Advance to the next family file on the next new page. 
% 
% SYNOPSIS:
% 
% plfamadv()
% plfamadv()
  plplot_octave(19);
endfunction

function plfill(x, y)
% plfill(x, y)
%
%   Original PLplot call documentation:
%
% 
% plfill: Draw filled polygon 
% 
% DESCRIPTION:
% 
%     Fills the polygon defined by the n points (
%     x[i], 
%     y[i]) using the pattern defined by plpsty or plpat.  The routine will
%     automatically close the polygon between the last and first vertices. 
%     If multiple closed polygons are passed in x and y then plfill will
%     fill in between them. 
% 
% SYNOPSIS:
% 
% plfill(n, x, y)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of vertices in polygon. 
% 
%     x (PLFLT *, input) :    Pointer to array with x coordinates of
%     vertices. 
% 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of
%     vertices. 
%     vertices. 
  plplot_octave(20, x, y);
endfunction

function plfill3(x, y, z)
% plfill3(x, y, z)
%
%   Original PLplot call documentation:
%
% 
% plfill3: Draw filled polygon in 3D 
% 
% DESCRIPTION:
% 
%     Fills the 3D polygon defined by the n points in the x, y, and z arrays
%     using the pattern defined by plpsty or plpat.  The routine will
%     automatically close the polygon between the last and first vertices. 
%     If multiple closed polygons are passed in x, y, and z then plfill3
%     will fill in between them. 
% 
% SYNOPSIS:
% 
% plfill3(n, x, y, z)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of vertices in polygon. 
% 
%     x (PLFLT *, input) :    Pointer to array with x coordinates of
%     vertices. 
% 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of
%     vertices. 
% 
%     z (PLFLT *, input) :    Pointer to array with z coordinates of
%     vertices. 
%     vertices. 
  plplot_octave(21, x, y, z);
endfunction

function plflush()
% plflush()
%
%   Original PLplot call documentation:
%
% 
% plflush: Flushes the output stream 
% 
% DESCRIPTION:
% 
%     Flushes the output stream. Use sparingly, if at all. 
% 
% SYNOPSIS:
% 
% plflush()
% plflush()
  plplot_octave(22);
endfunction

function plfont(ifont)
% plfont(ifont)
%
%   Original PLplot call documentation:
%
% 
% plfont: Set character font 
% 
% DESCRIPTION:
% 
%     Sets the default character font for subsequent character drawing. Also
%     affects symbols produced by plpoin.  This routine has no effect unless
%     the extended character set is loaded (see plfontld). 
% 
% SYNOPSIS:
% 
% plfont(font)
% 
% ARGUMENTS:
% 
%     font (PLINT, input) :    Specifies the font: 1: Normal font (simplest
%     and fastest) 
%         2: Roman font 
%         3: Italic font 
%         4: Script font 
%         4: Script font 
  plplot_octave(23, ifont);
endfunction

function plfontld(fnt)
% plfontld(fnt)
%
%   Original PLplot call documentation:
%
% 
% plfontld: Load character font 
% 
% DESCRIPTION:
% 
%     Sets the character set to use for subsequent character drawing.  May
%     be called before calling initializing PLplot. 
% 
% SYNOPSIS:
% 
% plfontld(set)
% 
% ARGUMENTS:
% 
%     set (PLINT, input) :    Specifies the character set to load: 0:
%     Standard character set 
%         1: Extended character set 
%         1: Extended character set 
  plplot_octave(24, fnt);
endfunction

function [p_def, p_ht] = plgchr()
% [p_def, p_ht] = plgchr()
%
%   Original PLplot call documentation:
%
% 
% plgchr: Get character default height and current
% (scaled) height 
% 
% DESCRIPTION:
% 
%     Get character default height and current (scaled) height. 
% 
% SYNOPSIS:
% 
% plgchr(p_def, p_ht)
% 
% ARGUMENTS:
% 
%     p_def (PLFLT *, output) :     Pointer to default character height (mm). 
% 
%     p_ht (PLFLT *, output) :    Pointer to current (scaled) character
%     height (mm). 
%     height (mm). 
  [p_def, p_ht] = plplot_octave(25);
endfunction

function [r, g, b] = plgcol0(icol0)
% [r, g, b] = plgcol0(icol0)
%
%   Original PLplot call documentation:
%
% 
% plgcol0: Returns 8-bit RGB values for given color
% from color map0 
% 
% DESCRIPTION:
% 
%     Returns 8-bit RGB values (-255) for given color from color map0 (see
%     the PLplot documentation).	Values are negative if an invalid color id
%     is given. 
% 
% SYNOPSIS:
% 
% plgcol0(icol0, r, g, b)
% 
% ARGUMENTS:
% 
%     icol0 (PLINT, input) :    Index of desired cmap0 color. 
% 
%     r (PLINT *, output) :    Pointer to 8-bit red value. 
% 
%     g (PLINT *, output) :    Pointer to 8-bit green value. 
% 
%     b (PLINT *, output) :    Pointer to 8-bit blue value. 
%     b (PLINT *, output) :    Pointer to 8-bit blue value. 
  [r, g, b] = plplot_octave(26, icol0);
endfunction

function [r, g, b] = plgcolbg()
% [r, g, b] = plgcolbg()
%
%   Original PLplot call documentation:
%
% 
% plgcolbg:  Returns the background color
% (cmap0[0]) by 8-bit RGB value 
% 
% DESCRIPTION:
% 
%     Returns the background color (cmap0[0]) by 8-bit RGB value. 
% 
% SYNOPSIS:
% 
% plgcolbg(r, g, b)
% 
% ARGUMENTS:
% 
%     r (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
%     representing the degree of red in the color. 
% 
%     g (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
%     representing the degree of green in the color. 
% 
%     b (PLINT *, output) :    Pointer to an unsigned 8-bit integer (0-255)
%     representing the degree of blue in the color. 
%     representing the degree of blue in the color. 
  [r, g, b] = plplot_octave(27);
endfunction

function plgcompression(compression)
% plgcompression(compression)
%
%   Original PLplot call documentation:
%
% 
% plgcompression: Get the current device-compression setting 
% 
% DESCRIPTION:
% 
%     Get the current device-compression setting.  This parameter is only
%     used for drivers that provide compression. 
% 
% SYNOPSIS:
% 
% plgcompression(compression)
% 
% ARGUMENTS:
% 
%     compression (PLINT *, output) :    Pointer to a variable to be filled
%     with the current device-compression setting. 
%     with the current device-compression setting. 
  plplot_octave(28, compression);
endfunction

function p_dev = plgdev()
% p_dev = plgdev()
%
%   Original PLplot call documentation:
%
% 
% plgdev: Get the current device (keyword) name 
% 
% DESCRIPTION:
% 
%     Get the current device (keyword) name.  Note: you
%     must have allocated
%     space for this (80 characters is safe). 
% 
% SYNOPSIS:
% 
% plgdev(p_dev)
% 
% ARGUMENTS:
% 
%     p_dev (char *, output) :    Pointer to device (keyword) name string. 
%     p_dev (char *, output) :    Pointer to device (keyword) name string. 
  p_dev = plplot_octave(29);
endfunction

function [p_mar, p_aspect, p_jx, p_jy] = plgdidev()
% [p_mar, p_aspect, p_jx, p_jy] = plgdidev()
%
%   Original PLplot call documentation:
%
% 
% plgdidev: Get parameters that define current device-space window 
% 
% DESCRIPTION:
% 
%     Get relative margin width, aspect ratio, and relative justification
%     that define current device-space window. If plsdidev has not been
%     called the default values pointed to by p_mar, p_aspect, p_jx, and
%     p_jy will all be 0. 
% 
% SYNOPSIS:
% 
% plgdidev(p_mar, p_aspect, p_jx, p_jy)
% 
% ARGUMENTS:
% 
%     p_mar (PLFLT *, output) :     Pointer to relative margin width. 
% 
%     p_aspect (PLFLT *, output) :    Pointer to aspect ratio. 
% 
%     p_jx (PLFLT *, output) :    Pointer to relative justification in x. 
% 
%     p_jy (PLFLT *, output) :    Pointer to relative justification in y. 
%     p_jy (PLFLT *, output) :    Pointer to relative justification in y. 
  [p_mar, p_aspect, p_jx, p_jy] = plplot_octave(30);
endfunction

function p_rot = plgdiori()
% p_rot = plgdiori()
%
%   Original PLplot call documentation:
%
% 
% plgdiori: Get plot orientation 
% 
% DESCRIPTION:
% 
%     Get plot orientation parameter which is multiplied by 90 degrees to
%     obtain the angle of rotation.  Note, arbitrary rotation parameters
%     such as 0.2 (corresponding to 18 degrees) are possible, but the usual
%     values for the rotation parameter are 0., 1., 2., and 3. corresponding
%     to 0 degrees (landscape mode), 90 degrees (portrait mode), 180 degrees
%     (seascape mode), and 270 degrees (upside-down mode). If plsdiori has
%     not been called the default value pointed to by p_rot will be 0. 
% 
% SYNOPSIS:
% 
% plgdiori(p_rot)
% 
% ARGUMENTS:
% 
%     p_rot (PLFLT *, output) :     Pointer to orientation parameter. 
%     p_rot (PLFLT *, output) :     Pointer to orientation parameter. 
  p_rot = plplot_octave(31);
endfunction

function [p_xmin, p_ymin, p_xmax, p_ymax] = plgdiplt()
% [p_xmin, p_ymin, p_xmax, p_ymax] = plgdiplt()
%
%   Original PLplot call documentation:
%
% 
% plgdiplt: Get parameters that define current plot-space window 
% 
% DESCRIPTION:
% 
%     Get relative minima and maxima that define current plot-space window.
%     If plsdiplt has not been called the default values pointed to by
%     p_xmin, p_ymin, p_xmax, and p_ymax will be 0., 0., 1., and 1. 
% 
% SYNOPSIS:
% 
% plgdiplt(p_xmin, p_ymin, p_xmax, p_ymax)
% 
% ARGUMENTS:
% 
%     p_xmin (PLFLT *, output) :      Pointer to relative minimum in x. 
% 
%     p_ymin (PLFLT *, output) :      Pointer to relative minimum in y. 
% 
%     p_xmax (PLFLT *, output) :      Pointer to relative maximum in x. 
% 
%     p_ymax (PLFLT *, output) :      Pointer to relative maximum in y. 
%     p_ymax (PLFLT *, output) :      Pointer to relative maximum in y. 
  [p_xmin, p_ymin, p_xmax, p_ymax] = plplot_octave(32);
endfunction

function [p_fam, p_num, p_bmax] = plgfam()
% [p_fam, p_num, p_bmax] = plgfam()
%
%   Original PLplot call documentation:
%
% 
% plgfam: Get family file parameters 
% 
% DESCRIPTION:
% 
%     Gets information about current family file, if familying is enabled. 
%     See the PLplot documentation for more information. 
% 
% SYNOPSIS:
% 
% plgfam(fam, num, bmax)
% 
% ARGUMENTS:
% 
%     fam (PLINT *, output) :    Pointer to variable with the Boolean family
%     flag value.  If nonzero, familying is enabled. 
% 
%     num (PLINT *, output) :    Pointer to variable with the current family
%     file number. 
% 
%     bmax (PLINT *, output) :    Pointer to variable with the maximum file
%     size (in bytes) for a family file. 
%     size (in bytes) for a family file. 
  [p_fam, p_num, p_bmax] = plplot_octave(33);
endfunction

function fnam = plgfnam()
% fnam = plgfnam()
%
%   Original PLplot call documentation:
%
% 
% plgfnam: Get output file name 
% 
% DESCRIPTION:
% 
%     Gets the current output file name, if applicable. 
% 
% SYNOPSIS:
% 
% plgfnam(fnam)
% 
% ARGUMENTS:
% 
%     fnam (char *, output) :    Pointer to file name string (a preallocated
%     string of 80 characters or more). 
%     string of 80 characters or more). 
  fnam = plplot_octave(34);
endfunction

function p_level = plglevel()
% p_level = plglevel()
%
%   Original PLplot call documentation:
%
% 
% plglevel: Get the (current) run level 
% 
% DESCRIPTION:
% 
%     Get the (current) run level. Valid settings are: 0,  uninitialized 
% 	    1,	initialized 
% 	    2,	viewport defined 
% 	    3,	world coords defined 
% 
% 
% SYNOPSIS:
% 
% plglevel(p_level)
% 
% ARGUMENTS:
% 
%     p_level (PLINT *, output) :    Pointer to the run level. 
%     p_level (PLINT *, output) :    Pointer to the run level. 
  p_level = plplot_octave(35);
endfunction

function [p_xp, p_yp, p_xleng, p_yleng, p_xoff, p_yoff] = plgpage()
% [p_xp, p_yp, p_xleng, p_yleng, p_xoff, p_yoff] = plgpage()
%
%   Original PLplot call documentation:
%
% 
% plgpage: Get page parameters 
% 
% DESCRIPTION:
% 
%     Gets the current page configuration. The parameters are expressed in
%     units that are specific to the current driver. For instance: screen
%     drivers will usually interpret them as number of pixels, whereas
%     printer drivers will usually use mm. 
% 
% SYNOPSIS:
% 
% plgpage(xp, yp, xleng, yleng, xoff, yoff)
% 
% ARGUMENTS:
% 
%     xp (PLFLT *, output) :    Pointer to number of pixels in x. 
% 
%     yp (PLFLT *, output) :    Pointer to number of pixels in y. 
% 
%     xleng (PLINT *, output) :     Pointer to x page length value. 
% 
%     yleng (PLINT *, output) :     Pointer to y page length value. 
% 
%     xoff (PLINT *, output) :    Pointer to x page offset. 
% 
%     yoff (PLINT *, output) :    Pointer to y page offset. 
%     yoff (PLINT *, output) :    Pointer to y page offset. 
  [p_xp, p_yp, p_xleng, p_yleng, p_xoff, p_yoff] = plplot_octave(36);
endfunction

function plgra()
% plgra()
%
%   Original PLplot call documentation:
%
% 
% plgra: Switch to graphics screen 
% 
% DESCRIPTION:
% 
%     Sets an interactive device to graphics mode, used in conjunction with
%     pltext to allow graphics and text to be interspersed.  On a device
%     which supports separate text and graphics windows, this command causes
%     control to be switched to the graphics window.  If already in graphics
%     mode, this command is ignored.  It is also ignored on devices which
%     only support a single window or use a different method for shifting
%     focus.  See also pltext. 
% 
% SYNOPSIS:
% 
% plgra()
% plgra()
  plplot_octave(37);
endfunction

function [xmin, xmax, ymin, ymax] = plgspa()
% [xmin, xmax, ymin, ymax] = plgspa()
%
%   Original PLplot call documentation:
%
% 
% plgspa: Get current subpage parameters 
% 
% DESCRIPTION:
% 
%     Gets the size of the current subpage in millimeters measured from the
%     bottom left hand corner of the output device page or screen.  Can be
%     used in conjunction with plsvpa for setting the size of a viewport in
%     absolute coordinates (millimeters). 
% 
% SYNOPSIS:
% 
% plgspa(xmin, xmax, ymin, ymax)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT *, output) :    Pointer to variable with position of left
%     hand edge of subpage in millimeters. 
% 
%     xmax (PLFLT *, output) :    Pointer to variable with position of right
%     hand edge of subpage in millimeters. 
% 
%     ymin (PLFLT *, output) :    Pointer to variable with position of
%     bottom edge of subpage in millimeters. 
% 
%     ymax (PLFLT *, output) :    Pointer to variable with position of top
%     edge of subpage in millimeters. 
%     edge of subpage in millimeters. 
  [xmin, xmax, ymin, ymax] = plplot_octave(38);
endfunction

function p_strm = plgstrm()
% p_strm = plgstrm()
%
%   Original PLplot call documentation:
%
% 
% plgstrm: Get current stream number 
% 
% DESCRIPTION:
% 
%     Gets the number of the current output stream. See also plsstrm. 
% 
% SYNOPSIS:
% 
% plgstrm(strm)
% 
% ARGUMENTS:
% 
%     strm (PLINT *, output) :    Pointer to current stream value. 
%     strm (PLINT *, output) :    Pointer to current stream value. 
  p_strm = plplot_octave(39);
endfunction

function p_ver = plgver()
% p_ver = plgver()
%
%   Original PLplot call documentation:
%
% 
% plgver: Get the current library version number 
% 
% DESCRIPTION:
% 
%     Get the current library version number.  Note: you must have allocated
%     space for this (80 characters is safe). 
% 
% SYNOPSIS:
% 
% plgver(p_ver)
% 
% ARGUMENTS:
% 
%     p_ver (char *, output) :    Pointer to the current library version
%     number. 
%     number. 
  p_ver = plplot_octave(40);
endfunction

function [p_digmax, p_digits] = plgxax()
% [p_digmax, p_digits] = plgxax()
%
%   Original PLplot call documentation:
%
% 
% plgxax: Get x axis parameters 
% 
% DESCRIPTION:
% 
%     Returns current values of the digmax and digits flags for the x axis. 
%     digits is updated after the plot is drawn, so this routine should only
%     be called after the call to plbox (or plbox3) is complete.	See the
%     PLplot documentation for more information. 
% 
% SYNOPSIS:
% 
% plgxax(digmax, digits)
% 
% ARGUMENTS:
% 
%     digmax (PLINT *, output) :      Pointer to variable with the maximum
%     number of digits for the x axis.  If nonzero, the printed label
%     has been switched to a floating point representation when the
%     number of digits exceeds digmax. 
% 
%     digits (PLINT *, output) :      Pointer to variable with the actual
%     number of digits for the numeric labels (x axis) from the last
%     plot. 
%     plot. 
  [p_digmax, p_digits] = plplot_octave(41);
endfunction

function [p_digmax, p_digits] = plgyax()
% [p_digmax, p_digits] = plgyax()
%
%   Original PLplot call documentation:
%
% 
% plgyax: Get y axis parameters 
% 
% DESCRIPTION:
% 
%     Identical to plgxax, except that arguments are flags for y axis. See
%     the description of plgxax for more detail. 
% 
% SYNOPSIS:
% 
% plgyax(digmax, digits)
% 
% ARGUMENTS:
% 
%     digmax (PLINT *, output) :      Pointer to variable with the maximum
%     number of digits for the y axis.  If nonzero, the printed label
%     has been switched to a floating point representation when the
%     number of digits exceeds digmax. 
% 
%     digits (PLINT *, output) :      Pointer to variable with the actual
%     number of digits for the numeric labels (y axis) from the last
%     plot. 
%     plot. 
  [p_digmax, p_digits] = plplot_octave(42);
endfunction

function [p_digmax, p_digits] = plgzax()
% [p_digmax, p_digits] = plgzax()
%
%   Original PLplot call documentation:
%
% 
% plgzax: Get z axis parameters 
% 
% DESCRIPTION:
% 
%     Identical to plgxax, except that arguments are flags for z axis. See
%     the description of plgxax for more detail. 
% 
% SYNOPSIS:
% 
% plgzax(digmax, digits)
% 
% ARGUMENTS:
% 
%     digmax (PLINT *, output) :      Pointer to variable with the maximum
%     number of digits for the z axis.  If nonzero, the printed label
%     has been switched to a floating point representation when the
%     number of digits exceeds digmax. 
% 
%     digits (PLINT *, output) :      Pointer to variable with the actual
%     number of digits for the numeric labels (z axis) from the last
%     plot. 
%     plot. 
  [p_digmax, p_digits] = plplot_octave(43);
endfunction

function plhist(data, datmin, datmax, nbin, oldwin)
% plhist(data, datmin, datmax, nbin, oldwin)
%
%   Original PLplot call documentation:
%
% 
% plhist: Plot a histogram from unbinned data 
% 
% DESCRIPTION:
% 
%     Plots a histogram from n data points stored in the array data.  This
%     routine bins the data into nbin bins equally spaced between datmin and
%     datmax, and calls plbin to draw the resulting histogram.  Parameter
%     opt allows, among other things, the histogram either to be plotted in
%     an existing window or causes plhist to call plenv with suitable limits
%     before plotting the histogram. 
% 
% SYNOPSIS:
% 
% plhist(n, data, datmin, datmax, nbin, opt)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of data points. 
% 
%     data (PLFLT *, input) :    Pointer to array with values of the n data
%     points. 
% 
%     datmin (PLFLT, input) :    Left-hand edge of lowest-valued bin. 
% 
%     datmax (PLFLT, input) :    Right-hand edge of highest-valued bin. 
% 
%     nbin (PLINT, input) :    Number of (equal-sized) bins into which to
%     divide the interval xmin to xmax. 
% 
%     opt (PLINT, input) :    Is a combination of several flags:
%     opt=PL_HIST_DEFAULT: The axes are automatically rescaled to fit
%     the histogram data, the outer bins are expanded to fill up the
%     entire x-axis, data outside the given extremes are assigned to the
%     outer bins and bins of zero height are simply drawn. 
%         opt=PL_HIST_NOSCALING|...: The existing axes are not rescaled
%         to fit the histogram data, without this flag, plenv is called
%         to set the world coordinates. 
%         opt=PL_HIST_IGNORE_OUTLIERS|...: Data outside the given
%         extremes are not taken into account. This option should
%         probably be combined with opt=PL_HIST_NOEXPAND|..., so as to
%         properly present the data. 
%         opt=PL_HIST_NOEXPAND|...: The outer bins are drawn with equal
%         size as the ones inside. 
%         opt=PL_HIST_NOEMPTY|...: Bins with zero height are not drawn
%         (there is a gap for such bins). 
%         (there is a gap for such bins). 
  plplot_octave(44, data, datmin, datmax, nbin, oldwin);
endfunction

function plhls(h, l, s)
% plhls(h, l, s)
%
% Set current color -map 0- by hue, lightness, and saturation.  
  plplot_octave(45, h, l, s);
endfunction

function [p_r, p_g, p_b] = c_plhlsrgb(h, l, s)
% [p_r, p_g, p_b] = c_plhlsrgb(h, l, s)
%
%   Original PLplot call documentation:
%
% 
% plhlsrgb: Convert HLS color to RGB 
% 
% DESCRIPTION:
% 
%     Convert HLS color coordinates to RGB 
% 
% SYNOPSIS:
% 
% plhlsrgb(h, l, s, p_r, p_g, p_b)
% 
% ARGUMENTS:
% 
%     h (PLFLT, input) :      Hue, in degrees on the colour cone (0.0-360.0) 
% 
%     l (PLFLT, input) :      Lightness, expressed as a fraction of the axis
%     of the colour cone (0.0-1.0) 
% 
%     s (PLFLT, input) :      Saturation, expressed as a fraction of the
%     radius of the colour cone (0.0-1.0) 
% 
%     p_r (PLFLT *, output) :    Pointer to red intensity (0.0-1.0) of the
%     colour 
% 
%     p_g (PLFLT *, output) :    Pointer to green intensity (0.0-1.0) of the
%     colour 
% 
%     p_b (PLFLT *, output) :    Pointer to blue intensity (0.0-1.0) of the
%     colour 
%     colour 
  [p_r, p_g, p_b] = plplot_octave(46, h, l, s);
endfunction

function plinit()
% plinit()
%
%   Original PLplot call documentation:
%
% 
% plinit: Initialize PLplot 
% 
% DESCRIPTION:
% 
%     Initializing the plotting package.	The program prompts for the device
%     keyword or number of the desired output device.  Hitting a RETURN in
%     response to the prompt is the same as selecting the first device. 
%     plinit will issue no prompt if either the device was specified
%     previously (via command line flag, the plsetopt function, or the
%     plsdev function), or if only one device is enabled when PLplot is
%     installed.	If subpages have been specified, the output device is
%     divided into nx by ny subpages, each of which may be used
%     independently.  If plinit is called again during a program, the
%     previously opened file will be closed.  The subroutine pladv is used
%     to advance from one subpage to the next. 
% 
% SYNOPSIS:
% 
% plinit()
% plinit()
  plplot_octave(47);
endfunction

function pljoin(x1, y1, x2, y2)
% pljoin(x1, y1, x2, y2)
%
%   Original PLplot call documentation:
%
% 
% pljoin: Draw a line between two points 
% 
% DESCRIPTION:
% 
%     Joins the point (
%     x1, 
%     y1) to (
%     x2, 
%     y2). 
% 
% SYNOPSIS:
% 
% pljoin(x1, y1, x2, y2)
% 
% ARGUMENTS:
% 
%     x1 (PLFLT, input) :    x coordinate of first point. 
% 
%     y1 (PLFLT, input) :    y coordinate of first point. 
% 
%     x2 (PLFLT, input) :    x coordinate of second point. 
% 
%     y2 (PLFLT, input) :    y coordinate of second point. 
%     y2 (PLFLT, input) :    y coordinate of second point. 
  plplot_octave(48, x1, y1, x2, y2);
endfunction

function pllab(xlabel, ylabel, tlabel)
% pllab(xlabel, ylabel, tlabel)
%
%   Original PLplot call documentation:
%
% 
% pllab: Simple routine to write labels 
% 
% DESCRIPTION:
% 
%     Routine for writing simple labels. Use plmtex for more complex labels. 
% 
% SYNOPSIS:
% 
% pllab(xlabel, ylabel, tlabel)
% 
% ARGUMENTS:
% 
%     xlabel (const char *, input) :    Label for horizontal axis. 
% 
%     ylabel (const char *, input) :    Label for vertical axis. 
% 
%     tlabel (const char *, input) :    Title of graph. 
%     tlabel (const char *, input) :    Title of graph. 
  plplot_octave(49, xlabel, ylabel, tlabel);
endfunction

function pllightsource(x, y, z)
% pllightsource(x, y, z)
%
%   Original PLplot call documentation:
%
% 
% pllightsource: Sets the 3D position of the light
% source 
% 
% DESCRIPTION:
% 
%     Sets the 3D position of the light source for use with plsurf3d. 
% 
% SYNOPSIS:
% 
% pllightsource(x, y, z)
% 
% ARGUMENTS:
% 
%     x (PLFLT, input) :      X-coordinate of the light source. 
% 
%     y (PLFLT, input) :      Y-coordinate of the light source. 
% 
%     z (PLFLT, input) :      Z-coordinate of the light source. 
%     z (PLFLT, input) :      Z-coordinate of the light source. 
  plplot_octave(50, x, y, z);
endfunction

function plline(x, y)
% plline(x, y)
%
%   Original PLplot call documentation:
%
% 
% plline: Draw a line 
% 
% DESCRIPTION:
% 
%     Draws line defined by n points in x and y. 
% 
% SYNOPSIS:
% 
% plline(n, x, y)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of points defining line. 
% 
%     x (PLFLT *, input) :    Pointer to array with x coordinates of points. 
% 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of points. 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of points. 
  plplot_octave(51, x, y);
endfunction

function plline3(x, y, z)
% plline3(x, y, z)
%
%   Original PLplot call documentation:
%
% 
% plline3: Draw a line in 3 space 
% 
% DESCRIPTION:
% 
%     Draws line in 3 space defined by n points in x, y, and z. You must
%     first set up the viewport, the 2d viewing window (in world
%     coordinates), and the 3d normalized coordinate box.  See x18c.c for
%     more info. 
% 
% SYNOPSIS:
% 
% plline3(n, x, y, z)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of points defining line. 
% 
%     x (PLFLT *, input) :    Pointer to array with x coordinates of points. 
% 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of points. 
% 
%     z (PLFLT *, input) :    Pointer to array with z coordinates of points. 
%     z (PLFLT *, input) :    Pointer to array with z coordinates of points. 
  plplot_octave(52, x, y, z);
endfunction

function pllsty(lin)
% pllsty(lin)
%
%   Original PLplot call documentation:
%
% 
% pllsty: Select line style 
% 
% DESCRIPTION:
% 
%     This sets the line style according to one of eight predefined patterns
%     (also see plstyl). 
% 
% SYNOPSIS:
% 
% pllsty(n)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Integer value between 1 and 8. Line style 1 is a
%     continuous line, line style 2 is a line with short dashes and
%     gaps, line style 3 is a line with long dashes and gaps, line style
%     4 has long dashes and short gaps and so on. 
%     4 has long dashes and short gaps and so on. 
  plplot_octave(53, lin);
endfunction

function p_strm = plmkstrm()
% p_strm = plmkstrm()
%
%   Original PLplot call documentation:
%
% 
% plmkstrm: Creates a new stream and makes it the
% default 
% 
% DESCRIPTION:
% 
%     Creates a new stream and makes it the default.  Differs from using
%     plsstrm, in that a free stream number is found, and returned.
%     Unfortunately, I have to start at stream 1 and work upward, since
%     stream 0 is preallocated.  One of the big flaws in the PLplot API is
%     that no initial, library-opening call is required.	So stream 0 must
%     be preallocated, and there is no simple way of determining whether it
%     is already in use or not. 
% 
% SYNOPSIS:
% 
% plmkstrm(p_strm)
% 
% ARGUMENTS:
% 
%     p_strm (PLINT *, output) :      Pointer to stream number of the created
%     stream. 
%     stream. 
  p_strm = plplot_octave(54);
endfunction

function plmtex(side, disp, pos, just, text)
% plmtex(side, disp, pos, just, text)
%
%   Original PLplot call documentation:
%
% 
% plmtex: Write text relative to viewport boundaries 
% 
% DESCRIPTION:
% 
%     Writes text at a specified position relative to the viewport
%     boundaries.  Text may be written inside or outside the viewport, but
%     is clipped at the subpage boundaries.  The reference point of a string
%     lies along a line passing through the string at half the height of a
%     capital letter.  The position of the reference point along this line
%     is determined by just, and the position of the reference point
%     relative to the viewport is set by disp and pos. 
% 
% SYNOPSIS:
% 
% plmtex(side, disp, pos, just, text)
% 
% ARGUMENTS:
% 
%     side (const char *, input) :    Specifies the side of the viewport
%     along which the text is to be written. The string must be one of:
%     b: Bottom of viewport, text written parallel to edge. 
%         bv: Bottom of viewport, text written at right angles to edge. 
%         l: Left of viewport, text written parallel to edge. 
%         lv: Left of viewport, text written at right angles to edge. 
%         r: Right of viewport, text written parallel to edge. 
%         rv: Right of viewport, text written at right angles to edge. 
%         t: Top of viewport, text written parallel to edge. 
%         tv: Top of viewport, text written at right angles to edge. 
% 
% 
%     disp (PLFLT, input) :    Position of the reference point of string,
%     measured outwards from the specified viewport edge in units of the
%     current character height.  Use negative disp to write within the
%     viewport. 
% 
%     pos (PLFLT, input) :    Position of the reference point of string
%     along the specified edge, expressed as a fraction of the length of
%     the edge. 
% 
%     just (PLFLT, input) :    Specifies the position of the string relative
%     to its reference point.  If just=0, the reference point is at the
%     left and if just=1, it is at the right of the string.  Other
%     values of just give intermediate justifications. 
% 
%     text (const char *, input) :    The string to be written out. 
%     text (const char *, input) :    The string to be written out. 
  plplot_octave(55, side, disp, pos, just, text);
endfunction

function retval = c_plparseopts(p_argc, argv, mode)
% retval = c_plparseopts(p_argc, argv, mode)
%
%   Original PLplot call documentation:
%
% 
% plparseopts: Parse command-line arguments 
% 
% DESCRIPTION:
% 
%     Parse command-line arguments. 
% 
% SYNOPSIS:
% 
% plparseopts(p_argc, argv, mode)
% 
% ARGUMENTS:
% 
%     p_argc (int *, input) :    pointer to number of arguments. 
% 
%     argv (char **, input) :    Pointer to character array containing
%     *p_argc command-line arguments. 
% 
%     mode (PLINT, input) :    Parsing mode with the following
%     possibilities:
%     PL_PARSE_FULL (1) -- Full parsing of command line and all error
%     messages
%     enabled, including program exit when an error occurs.  Anything on the
%     command line that isn't recognized as a valid option or option
%     argument is
%     flagged as an error.
% 
%         PL_PARSE_QUIET (2) -- Turns off all output except in the case
%         of errors.
% 
%         PL_PARSE_NODELETE (4) -- Turns off deletion of processed
%         arguments.
% 
%         PL_PARSE_SHOWALL (8) -- Show invisible options
% 
%         PL_PARSE_NOPROGRAM (32) -- Specified if argv[0] is NOT a
%         pointer to the
%     program name.
% 
%         PL_PARSE_NODASH (64) -- Set if leading dash is NOT required.
% 
%         PL_PARSE_SKIP (128) -- Set to quietly skip over any
%         unrecognized args.
%         unrecognized args.
  retval = plplot_octave(56, p_argc, argv, mode);
endfunction

function plpat(inc, del)
% plpat(inc, del)
%
%   Original PLplot call documentation:
%
% 
% plpat: Set area fill pattern 
% 
% DESCRIPTION:
% 
%     Sets the area fill pattern.  The pattern consists of 1 or 2 sets of
%     parallel lines with specified inclinations and spacings.  The
%     arguments to this routine are the number of sets to use (1 or 2)
%     followed by two pointers to integer arrays (of 1 or 2 elements)
%     specifying the inclinations in tenths of a degree and the spacing in
%     micrometers.  (also see plpsty) 
% 
% SYNOPSIS:
% 
% plpat(nlin, inc, del)
% 
% ARGUMENTS:
% 
%     nlin (PLINT, input) :    Number of sets of lines making up the
%     pattern, either 1 or 2. 
% 
%     inc (PLINT *, input) :    Pointer to array with nlin elements.
%     Specifies the line inclination in tenths of a degree.  (Should be
%     between -900 and 900). 
% 
%     del (PLINT *, input) :    Pointer to array with nlin elements.
%     Specifies the spacing in micrometers between the lines making up
%     the pattern. 
%     the pattern. 
  plplot_octave(57, inc, del);
endfunction

function plpoin(x, y, code)
% plpoin(x, y, code)
%
%   Original PLplot call documentation:
%
% 
% plpoin: Plots a character at the specified points 
% 
% DESCRIPTION:
% 
%     Marks a set of n points in x and y using the symbol defined by code.
%     If code is between 32 and 127, the symbol is simply the corresponding
%     printable ASCII character in the default font. 
% 
% SYNOPSIS:
% 
% plpoin(n, x, y, code)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of points to be marked. 
% 
%     x (PLFLT *, input) :    Pointer to array with x coordinates of the
%     points. 
% 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of the
%     points. 
% 
%     code (PLINT, input) :    Code number for the symbol to be plotted. 
%     code (PLINT, input) :    Code number for the symbol to be plotted. 
  plplot_octave(58, x, y, code);
endfunction

function plpoin3(x, y, z, code)
% plpoin3(x, y, z, code)
%
%   Original PLplot call documentation:
%
% 
% plpoin3:  Plots a character at the specified points in 3 space 
% 
% DESCRIPTION:
% 
%     Marks a set of n points in x, y, and z using the symbol defined by
%     code. If code is between 32 and 127, the symbol is simply the
%     corresponding printable ASCII character in the default font. Setup
%     similar to plline3. 
% 
% SYNOPSIS:
% 
% plpoin3(n, x, y, z, code)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of points to be marked. 
% 
%     x (PLFLT *, input) :    Pointer to array with x coordinates of the
%     points. 
% 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of the
%     points. 
% 
%     z (PLFLT *, input) :    Pointer to array with z coordinates of the
%     points. 
% 
%     code (PLINT, input) :    Code number for the symbol to be plotted. 
%     code (PLINT, input) :    Code number for the symbol to be plotted. 
  plplot_octave(59, x, y, z, code);
endfunction

function plprec(setp, prec)
% plprec(setp, prec)
%
%   Original PLplot call documentation:
%
% 
% plprec: Set precision in numeric labels 
% 
% DESCRIPTION:
% 
%     Sets the number of places after the decimal point in numeric labels. 
% 
% SYNOPSIS:
% 
% plprec(set, prec)
% 
% ARGUMENTS:
% 
%     set (PLINT, input) :    If set is equal to 0 then PLplot automatically
%     determines the number of places to use after the decimal point in
%     numeric labels (like those used to label axes).  If set is 1 then
%     prec sets the number of places. 
% 
%     prec (PLINT, input) :    The number of characters to draw after the
%     decimal point in numeric labels. 
%     decimal point in numeric labels. 
  plplot_octave(60, setp, prec);
endfunction

function plpsty(patt)
% plpsty(patt)
%
%   Original PLplot call documentation:
%
% 
% plpsty: Select area fill pattern 
% 
% DESCRIPTION:
% 
%     Select one of eight predefined area fill patterns to use (also see
%     plpat). 
% 
% SYNOPSIS:
% 
% plpsty(n)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      The desired pattern. Pattern 1 consists of
%     horizontal lines, pattern 2 consists of vertical lines, pattern 3
%     consists of lines at 45 degrees angle (upward), and so on. 
%     consists of lines at 45 degrees angle (upward), and so on. 
  plplot_octave(61, patt);
endfunction

function plptex(x, y, dx, dy, just, text)
% plptex(x, y, dx, dy, just, text)
%
%   Original PLplot call documentation:
%
% 
% plptex: Write text inside the viewport 
% 
% DESCRIPTION:
% 
%     Writes text at a specified position and inclination within the
%     viewport.  Text is clipped at the viewport boundaries.  The reference
%     point of a string lies along a line passing through the string at half
%     the height of a capital letter.  The position of the reference point
%     along this line is determined by just, the reference point is placed
%     at world coordinates (
%     x, 
%     y) within the viewport.  The inclination of the string is specified in
%     terms of differences of world coordinates making it easy to write text
%     parallel to a line in a graph. 
% 
% SYNOPSIS:
% 
% plptex(x, y, dx, dy, just, text)
% 
% ARGUMENTS:
% 
%     x (PLFLT, input) :      x coordinate of reference point of string. 
% 
%     y (PLFLT, input) :      y coordinate of reference point of string. 
% 
%     dx (PLFLT, input) :    Together with dy, this specifies the
%     inclination of the string.  The baseline of the string is parallel
%     to a line joining (
%     x, 
%     y) to (
%     x+
%     dx, 
%     y+
%     dy). 
% 
%     dy (PLFLT, input) :    Together with dx, this specifies the
%     inclination of the string. 
% 
%     just (PLFLT, input) :    Specifies the position of the string relative
%     to its reference point.  If just=0, the reference point is at the
%     left and if just=1, it is at the right of the string.  Other
%     values of just give intermediate justifications. 
% 
%     text (const char *, input) :    The string to be written out. 
%     text (const char *, input) :    The string to be written out. 
  plplot_octave(62, x, y, dx, dy, just, text);
endfunction

function plreplot()
% plreplot()
%
%   Original PLplot call documentation:
%
% 
% plreplot: Replays contents of plot buffer to
% current device/file 
% 
% DESCRIPTION:
% 
%     Replays contents of plot buffer to current device/file. 
% 
% SYNOPSIS:
% 
% plreplot()
% plreplot()
  plplot_octave(63);
endfunction

function plrgb(r, g, b)
% plrgb(r, g, b)
%
% Set line color by red, green, blue from  0. to 1.  
  plplot_octave(64, r, g, b);
endfunction

function plrgb1(r, g, b)
% plrgb1(r, g, b)
%
% Set line color by 8 bit RGB values.  
  plplot_octave(65, r, g, b);
endfunction

function [p_h, p_l, p_s] = c_plrgbhls(r, g, b)
% [p_h, p_l, p_s] = c_plrgbhls(r, g, b)
%
%   Original PLplot call documentation:
%
% 
% plrgbhls: Convert RGB color to HLS 
% 
% DESCRIPTION:
% 
%     Convert RGB color coordinates to HLS 
% 
% SYNOPSIS:
% 
% plrgbhls(r, g, b, p_h, p_l, p_s)
% 
% ARGUMENTS:
% 
%     r (PLFLT, output) :    Red intensity (0.0-1.0) of the colour 
% 
%     g (PLFLT, output) :    Green intensity (0.0-1.0) of the colour 
% 
%     b (PLFLT, output) :    Blue intensity (0.0-1.0) of the colour 
% 
%     p_h (PLFLT *, input) :    Pointer to hue, in degrees on the colour
%     cone (0.0-360.0) 
% 
%     p_l (PLFLT *, input) :    Pointer to lightness, expressed as a
%     fraction of the axis of the colour cone (0.0-1.0) 
% 
%     p_s (PLFLT *, input) :    Pointer to saturation, expressed as a
%     fraction of the radius of the colour cone (0.0-1.0) 
%     fraction of the radius of the colour cone (0.0-1.0) 
  [p_h, p_l, p_s] = plplot_octave(66, r, g, b);
endfunction

function plschr(def, scale)
% plschr(def, scale)
%
%   Original PLplot call documentation:
%
% 
% plschr: Set character size 
% 
% DESCRIPTION:
% 
%     This sets up the size of all subsequent characters drawn.  The actual
%     height of a character is the product of the default character size and
%     a scaling factor. 
% 
% SYNOPSIS:
% 
% plschr(def, scale)
% 
% ARGUMENTS:
% 
%     def (PLFLT, input) :    The default height of a character in
%     millimeters, should be set to zero if the default height is to
%     remain unchanged. 
% 
%     scale (PLFLT, input) :    Scale factor to be applied to default to get
%     actual character height. 
%     actual character height. 
  plplot_octave(67, def, scale);
endfunction

function plscmap0(r, g, b)
% plscmap0(r, g, b)
%
%   Original PLplot call documentation:
%
% 
% plscmap0: Set color map0 colors by 8-bit RGB
% values 
% 
% DESCRIPTION:
% 
%     Set color map0 colors using 8-bit RGB values (see the PLplot
%     documentation).  This sets the entire color map -- only as many colors
%     as specified will be allocated. 
% 
% SYNOPSIS:
% 
% plscmap0(r, g, b, ncol0)
% 
% ARGUMENTS:
% 
%     r (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
%     integers (0-255) representing the degree of red in the color. 
% 
%     g (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
%     integers (0-255) representing the degree of green in the color. 
% 
%     b (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
%     integers (0-255) representing the degree of blue in the color. 
% 
%     ncol0 (PLINT, input) :    Number of items in the r, g, and b arrays. 
%     ncol0 (PLINT, input) :    Number of items in the r, g, and b arrays. 
  plplot_octave(68, r, g, b);
endfunction

function plscmap0n(ncol0)
% plscmap0n(ncol0)
%
%   Original PLplot call documentation:
%
% 
% plscmap0n: Set number of colors in color map0 
% 
% DESCRIPTION:
% 
%     The drivers are not guaranteed to support more than 16 colors. 
% 
% SYNOPSIS:
% 
% plscmap0n(ncol0)
% 
% ARGUMENTS:
% 
%     ncol0 (PLINT, input) :    Number of colors that will be allocated in
%     the map0 palette. If this number is zero or less, then the value
%     from the previous call to plscmap0n is used and if there is no
%     previous call, then a default value is used. 
%     previous call, then a default value is used. 
  plplot_octave(69, ncol0);
endfunction

function plscmap1(r, g, b)
% plscmap1(r, g, b)
%
%   Original PLplot call documentation:
%
% 
% plscmap1: Set color map1 colors using 8-bit RGB
% values 
% 
% DESCRIPTION:
% 
%     Set color map1 colors using 8-bit RGB values (see the PLplot
%     documentation).  This also sets the number of colors. 
% 
% SYNOPSIS:
% 
% plscmap1(r, g, b, ncol1)
% 
% ARGUMENTS:
% 
%     r (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
%     integers (0-255) representing the degree of red in the color. 
% 
%     g (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
%     integers (0-255) representing the degree of green in the color. 
% 
%     b (PLINT *, input) :    Pointer to array with set of unsigned 8-bit
%     integers (0-255) representing the degree of blue in the color. 
% 
%     ncol1 (PLINT, input) :    Number of items in the r, g, and b arrays. 
%     ncol1 (PLINT, input) :    Number of items in the r, g, and b arrays. 
  plplot_octave(70, r, g, b);
endfunction

function plscmap1l(itype, intensity, coord1, coord2, coord3, rev)
% plscmap1l(itype, intensity, coord1, coord2, coord3, rev)
%
%   Original PLplot call documentation:
%
% 
% plscmap1l: Set color map1 colors using a
% piece-wise linear relationship 
% 
% DESCRIPTION:
% 
%     Bounds on coordinatesRGBR[0, 1]magnitudeRGBG[0, 1]magnitudeRGBB[0,
%     1]magnitudeHLShue[0, 360]degreesHLSlightness[0,
%     1]magnitudeHLSsaturation[0, 1]magnitude
% 
% SYNOPSIS:
% 
% plscmap1l(itype, npts, pos, coord1, coord2, coord3, rev)
% 
% ARGUMENTS:
% 
%     itype (PLBOOL, input) :    true: RGB, false: HLS. 
% 
%     npts (PLINT, input) :    number of control points 
% 
%     pos (PLFLT *, input) :    position for each control point (between 0.0
%     and 1.0, in ascending order) 
% 
%     coord1 (PLFLT *, input) :     first coordinate (H or R) for each
%     control point 
% 
%     coord2 (PLFLT *, input) :     second coordinate (L or G) for each
%     control point 
% 
%     coord3 (PLFLT *, input) :     third coordinate (S or B) for each
%     control point 
% 
%     rev (PLBOOL: *, input) :    reverse flag for each control point.
%     (rev[i] refers to the interpolation interval between the i and i +
%     1 control points). 
%     1 control points). 
  plplot_octave(71, itype, intensity, coord1, coord2, coord3, rev);
endfunction

function plscmap1n(ncol1)
% plscmap1n(ncol1)
%
%   Original PLplot call documentation:
%
% 
% plscmap1n: Set number of colors in color map1 
% 
% DESCRIPTION:
% 
%     Set number of colors in color map1, (re-)allocate color map1, and set
%     default values if this is the first allocation (see the PLplot
%     documentation). 
% 
% SYNOPSIS:
% 
% plscmap1n(ncol1)
% 
% ARGUMENTS:
% 
%     ncol1 (PLINT, input) :    Number of colors that will be allocated in
%     the map1 palette. If this number is zero or less, then the value
%     from the previous call to plscmap1n is used and if there is no
%     previous call, then a default value is used. 
%     previous call, then a default value is used. 
  plplot_octave(72, ncol1);
endfunction

function plscol0(icol0, r, g, b)
% plscol0(icol0, r, g, b)
%
%   Original PLplot call documentation:
%
% 
% plscol0:  Set a given color from color map0 by 8
% bit RGB value 
% 
% DESCRIPTION:
% 
%     Set a given color by 8-bit RGB value for color map0 (see the PLplot
%     documentation).  Overwrites the previous color value for the given
%     index and, thus, does not result in any additional allocation of space
%     for colors. 
% 
% SYNOPSIS:
% 
% plscol0(icol0, r, g, b)
% 
% ARGUMENTS:
% 
%     icol0 (PLINT, input) :    Color index.  Must be less than the maximum
%     number of colors (which is set by default, by plscmap0n, or even
%     by plscmap0). 
% 
%     r (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
%     degree of red in the color. 
% 
%     g (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
%     degree of green in the color. 
% 
%     b (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
%     degree of blue in the color. 
%     degree of blue in the color. 
  plplot_octave(73, icol0, r, g, b);
endfunction

function plscolbg(r, g, b)
% plscolbg(r, g, b)
%
%   Original PLplot call documentation:
%
% 
% plscolbg: Set the background color
% by 8-bit RGB value 
% 
% DESCRIPTION:
% 
%     Set the background color (color 0 in color map 0) by 8-bit RGB value
%     (see
%     the PLplot documentation). 
% 
% SYNOPSIS:
% 
% plscolbg(r, g, b)
% 
% ARGUMENTS:
% 
%     r (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
%     degree of red in the color. 
% 
%     g (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
%     degree of green in the color. 
% 
%     b (PLINT, input) :      Unsigned 8-bit integer (0-255) representing the
%     degree of blue in the color. 
%     degree of blue in the color. 
  plplot_octave(74, r, g, b);
endfunction

function plscolor(color)
% plscolor(color)
%
%   Original PLplot call documentation:
%
% 
% plscolor: Used to globally turn color output on/off 
% 
% DESCRIPTION:
% 
%     Used to globally turn color output on/off for those drivers/devices
%     that support it. 
% 
% SYNOPSIS:
% 
% plscolor(color)
% 
% ARGUMENTS:
% 
%     color (PLINT, input) :    Color flag (Boolean).  If zero, color is
%     turned off.  If non-zero, color is turned on. 
%     turned off.  If non-zero, color is turned on. 
  plplot_octave(75, color);
endfunction

function plscompression(compression)
% plscompression(compression)
%
%   Original PLplot call documentation:
%
% 
% plscompression: Set device-compression level 
% 
% DESCRIPTION:
% 
%     Set device-compression level.  Only used for drivers that provide
%     compression.  This function, if used, should be invoked before a call
%     to plinit. 
% 
% SYNOPSIS:
% 
% plscompression(compression)
% 
% ARGUMENTS:
% 
%     compression (PLINT, input) :    The desired compression level. This is
%     a device-dependent value. 
%     a device-dependent value. 
  plplot_octave(76, compression);
endfunction

function plsdev(devname)
% plsdev(devname)
%
%   Original PLplot call documentation:
%
% 
% plsdev: Set the device (keyword) name 
% 
% DESCRIPTION:
% 
%     Set the device (keyword) name. 
% 
% SYNOPSIS:
% 
% plsdev(devname)
% 
% ARGUMENTS:
% 
%     devname (const char *, output) :    Pointer to device (keyword) name
%     string. 
%     string. 
  plplot_octave(77, devname);
endfunction

function plsdidev(mar, aspect, jx, jy)
% plsdidev(mar, aspect, jx, jy)
%
%   Original PLplot call documentation:
%
% 
% plsdidev: Set parameters that define current device-space window 
% 
% DESCRIPTION:
% 
%     Set relative margin width, aspect ratio, and relative justification
%     that define current device-space window.  If you want to just use the
%     previous value for any of these, just pass in the magic value
%     PL_NOTSET. It is unlikely that one should ever need to change the
%     aspect ratio but it's in there for completeness. If plsdidev is not
%     called the default values of mar, jx, and jy are all 0. aspect is set
%     to a device-specific value. 
% 
% SYNOPSIS:
% 
% plsdidev(mar, aspect, jx, jy)
% 
% ARGUMENTS:
% 
%     mar (PLFLT, input) :    Relative margin width. 
% 
%     aspect (PLFLT, input) :    Aspect ratio. 
% 
%     jx (PLFLT, input) :    Relative justification in x. 
% 
%     jy (PLFLT, input) :    Relative justification in y. 
%     jy (PLFLT, input) :    Relative justification in y. 
  plplot_octave(78, mar, aspect, jx, jy);
endfunction

function plsdimap(dimxmin, dimxmax, dimymin, dimymax, dimxpmm, dimypmm)
% plsdimap(dimxmin, dimxmax, dimymin, dimymax, dimxpmm, dimypmm)
%
%   Original PLplot call documentation:
%
% 
% plsdimap: Set up transformation from metafile
% coordinates 
% 
% DESCRIPTION:
% 
%     Set up transformation from metafile coordinates.  The size of the plot
%     is scaled so as to preserve aspect ratio.  This isn't intended to be a
%     general-purpose facility just yet (not sure why the user would need
%     it, for one). 
% 
% SYNOPSIS:
% 
% plsdimap(dimxmin, dimxmax, dimymin, dimymax, dimxpmm, dimypmm)
% 
% ARGUMENTS:
% 
%     dimxmin (PLINT, input) :    NEEDS DOCUMENTATION 
% 
%     dimxmax (PLINT, input) :    NEEDS DOCUMENTATION 
% 
%     dimymin (PLINT, input) :    NEEDS DOCUMENTATION 
% 
%     dimymax (PLINT, input) :    NEEDS DOCUMENTATION 
% 
%     dimxpmm (PLFLT, input) :    NEEDS DOCUMENTATION 
% 
%     dimypmm (PLFLT, input) :    NEEDS DOCUMENTATION 
%     dimypmm (PLFLT, input) :    NEEDS DOCUMENTATION 
  plplot_octave(79, dimxmin, dimxmax, dimymin, dimymax, dimxpmm, dimypmm);
endfunction

function plsdiori(rot)
% plsdiori(rot)
%
%   Original PLplot call documentation:
%
% 
% plsdiori: Set plot orientation 
% 
% DESCRIPTION:
% 
%     Set plot orientation parameter which is multiplied by 90 degrees to
%     obtain the angle of rotation.  Note, arbitrary rotation parameters
%     such as 0.2 (corresponding to 18 degrees) are possible, but the usual
%     values for the rotation parameter are 0., 1., 2., and 3. corresponding
%     to 0 degrees (landscape mode), 90 degrees (portrait mode), 180 degrees
%     (seascape mode), and 270 degrees (upside-down mode). If plsdiori is
%     not called the default value of rot is 0. 
% 
% SYNOPSIS:
% 
% plsdiori(rot)
% 
% ARGUMENTS:
% 
%     rot (PLFLT, input) :    Plot orientation parameter. 
%     rot (PLFLT, input) :    Plot orientation parameter. 
  plplot_octave(80, rot);
endfunction

function plsdiplt(xmin, ymin, xmax, ymax)
% plsdiplt(xmin, ymin, xmax, ymax)
%
%   Original PLplot call documentation:
%
% 
% plsdiplt: Set parameters that define current plot-space window 
% 
% DESCRIPTION:
% 
%     Set relative minima and maxima that define the current plot-space
%     window.  If plsdiplt is not called the default values of xmin, ymin,
%     xmax, and ymax are 0., 0., 1., and 1. 
% 
% SYNOPSIS:
% 
% plsdiplt(xmin, ymin, xmax, ymax)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT, input) :    Relative minimum in x. 
% 
%     ymin (PLFLT, input) :    Relative minimum in y. 
% 
%     xmax (PLFLT, input) :    Relative maximum in x. 
% 
%     ymax (PLFLT, input) :    Relative maximum in y. 
%     ymax (PLFLT, input) :    Relative maximum in y. 
  plplot_octave(81, xmin, ymin, xmax, ymax);
endfunction

function plsdiplz(xmin, ymin, xmax, ymax)
% plsdiplz(xmin, ymin, xmax, ymax)
%
%   Original PLplot call documentation:
%
% 
% plsdiplz: Set parameters incrementally (zoom mode) that define current plot-space window 
% 
% DESCRIPTION:
% 
%     Set relative minima and maxima incrementally (zoom mode) that define
%     the current plot-space window.  This function has the same effect as
%     plsdiplt if that function has not been previously called.  Otherwise,
%     this function implements zoom mode using the transformation min_used =
%     old_min + old_length*min  and max_used = old_min + old_length*max  for
%     each axis.	For example, if min = 0.05 and max = 0.95 for each axis,
%     repeated calls to plsdiplz will zoom in by 10 per cent for each call. 
% 
% SYNOPSIS:
% 
% plsdiplz(xmin, ymin, xmax, ymax)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT, input) :    Relative (incremental) minimum in x. 
% 
%     ymin (PLFLT, input) :    Relative (incremental) minimum in y. 
% 
%     xmax (PLFLT, input) :    Relative (incremental) maximum in x. 
% 
%     ymax (PLFLT, input) :    Relative (incremental) maximum in y. 
%     ymax (PLFLT, input) :    Relative (incremental) maximum in y. 
  plplot_octave(82, xmin, ymin, xmax, ymax);
endfunction

function plsesc(esc)
% plsesc(esc)
%
%   Original PLplot call documentation:
%
% 
% plsesc: Set the escape character for text strings 
% 
% DESCRIPTION:
% 
%     Set the escape character for text strings.	From C (in contrast to
%     Fortran 77, see plsescfortran77) you pass esc as a character. Only
%     selected characters are allowed to prevent the user from shooting
%     himself in the foot (For example, a \ isn't allowed since it conflicts
%     with C's use of backslash as a character escape).  Here are the
%     allowed escape
%     characters and their corresponding decimal ASCII values:
%     !, ASCII 33     #, ASCII 35     $, ASCII 36     %, ASCII 37     &,
%     ASCII 38	 *, ASCII 42	 @, ASCII 64	 ^, ASCII 94	 ~, ASCII
%     126
% 
% SYNOPSIS:
% 
% plsesc(esc)
% 
% ARGUMENTS:
% 
%     esc (char, input) :    Escape character. 
%     esc (char, input) :    Escape character. 
  plplot_octave(83, esc);
endfunction

function plsfam(fam, num, bmax)
% plsfam(fam, num, bmax)
%
%   Original PLplot call documentation:
%
% 
% plsfam: Set family file parameters 
% 
% DESCRIPTION:
% 
%     Sets variables dealing with output file familying.	Does nothing if
%     familying not supported by the driver.  This routine, if used, must be
%     called before initializing PLplot.	See the PLplot documentation for
%     more information. 
% 
% SYNOPSIS:
% 
% plsfam(fam, num, bmax)
% 
% ARGUMENTS:
% 
%     fam (PLINT, input) :    Family flag (Boolean).  If nonzero, familying
%     is enabled. 
% 
%     num (PLINT, input) :    Current family file number. 
% 
%     bmax (PLINT, input) :    Maximum file size (in bytes) for a family
%     file. 
%     file. 
  plplot_octave(84, fam, num, bmax);
endfunction

function plsfnam(fnam)
% plsfnam(fnam)
%
%   Original PLplot call documentation:
%
% 
% plsfnam: Set output file name 
% 
% DESCRIPTION:
% 
%     Sets the current output file name, if applicable.  If the file name
%     has not been specified and is required by the driver, the user will be
%     prompted for it.  If using the X-windows output driver, this sets the
%     display name.  This routine, if used, must be called before
%     initializing PLplot. 
% 
% SYNOPSIS:
% 
% plsfnam(fnam)
% 
% ARGUMENTS:
% 
%     fnam (const char *, input) :    Pointer to file name string. 
%     fnam (const char *, input) :    Pointer to file name string. 
  plplot_octave(85, fnam);
endfunction

function plsmaj(def, scale)
% plsmaj(def, scale)
%
%   Original PLplot call documentation:
%
% 
% plsmaj: Set length of major ticks 
% 
% DESCRIPTION:
% 
%     This sets up the length of the major ticks.  The actual length is the
%     product of the default length and a scaling factor as for character
%     height. 
% 
% SYNOPSIS:
% 
% plsmaj(def, scale)
% 
% ARGUMENTS:
% 
%     def (PLFLT, input) :    The default length of a major tick in
%     millimeters, should be set to zero if the default length is to
%     remain unchanged. 
% 
%     scale (PLFLT, input) :    Scale factor to be applied to default to get
%     actual tick length. 
%     actual tick length. 
  plplot_octave(86, def, scale);
endfunction

function plsmin(def, scale)
% plsmin(def, scale)
%
%   Original PLplot call documentation:
%
% 
% plsmin: Set length of minor ticks 
% 
% DESCRIPTION:
% 
%     This sets up the length of the minor ticks and the length of the
%     terminals on error bars.  The actual length is the product of the
%     default length and a scaling factor as for character height. 
% 
% SYNOPSIS:
% 
% plsmin(def, scale)
% 
% ARGUMENTS:
% 
%     def (PLFLT, input) :    The default length of a minor tick in
%     millimeters, should be set to zero if the default length is to
%     remain unchanged. 
% 
%     scale (PLFLT, input) :    Scale factor to be applied to default to get
%     actual tick length. 
%     actual tick length. 
  plplot_octave(87, def, scale);
endfunction

function plsori(ori)
% plsori(ori)
%
%   Original PLplot call documentation:
%
% 
% plsori: Set orientation 
% 
% DESCRIPTION:
% 
%     Sets the current orientation.  If ori is equal to zero (default) then
%     landscape is used (x axis is parallel to the longest edge of the
%     page), otherwise portrait is used.	This option is not supported by
%     all output drivers (in particular, most interactive screen drivers
%     ignore the orientation).  This routine, if used, must be called before
%     initializing PLplot. 
% 
% SYNOPSIS:
% 
% plsori(ori)
% 
% ARGUMENTS:
% 
%     ori (PLINT, input) :    Orientation value (0 for landscape, 1 for
%     portrait; the value is multiplied by 90 degrees to get the angle) 
%     portrait; the value is multiplied by 90 degrees to get the angle) 
  plplot_octave(88, ori);
endfunction

function plspage(xp, yp, xleng, yleng, xoff, yoff)
% plspage(xp, yp, xleng, yleng, xoff, yoff)
%
%   Original PLplot call documentation:
%
% 
% plspage: Set page parameters 
% 
% DESCRIPTION:
% 
%     Sets the page configuration (optional).  Not all parameters are
%     recognized by all drivers and the interpretation is device-dependent.
%     The X-window driver uses the length and offset parameters to determine
%     the window size and location.  This routine, if used, must be called
%     before initializing PLplot. 
% 
% SYNOPSIS:
% 
% plspage(xp, yp, xleng, yleng, xoff, yoff)
% 
% ARGUMENTS:
% 
%     xp (PLFLT, input) :    Number of pixels, x. 
% 
%     yp (PLFLT, input) :    Number of pixels, y. 
% 
%     xleng (PLINT , input) :    Page length, x. 
% 
%     yleng (PLINT, input) :    Page length, y. 
% 
%     xoff (PLINT, input) :    Page offset, x. 
% 
%     yoff (PLINT, input) :    Page offset, y. 
%     yoff (PLINT, input) :    Page offset, y. 
  plplot_octave(89, xp, yp, xleng, yleng, xoff, yoff);
endfunction

function plspause(pause)
% plspause(pause)
%
%   Original PLplot call documentation:
%
% 
% plspause: Set the pause (on end-of-page) status 
% 
% DESCRIPTION:
% 
%     Set the pause (on end-of-page) status. 
% 
% SYNOPSIS:
% 
% plspause(pause)
% 
% ARGUMENTS:
% 
%     pause (PLBOOL, input) :    If pause is true there will be a pause on
%     end-of-page for those drivers which support this.  Otherwise there
%     is no pause. 
%     is no pause. 
  plplot_octave(90, pause);
endfunction

function plsstrm(strm)
% plsstrm(strm)
%
%   Original PLplot call documentation:
%
% 
% plsstrm: Set current output stream 
% 
% DESCRIPTION:
% 
%     Sets the number of the current output stream.  The stream number
%     defaults to 0 unless changed by this routine.  The first use of this
%     routine must be followed by a call initializing PLplot (e.g. plstar). 
% 
% SYNOPSIS:
% 
% plsstrm(strm)
% 
% ARGUMENTS:
% 
%     strm (PLINT, input) :    The current stream number. 
%     strm (PLINT, input) :    The current stream number. 
  plplot_octave(91, strm);
endfunction

function plssub(nx, ny)
% plssub(nx, ny)
%
%   Original PLplot call documentation:
%
% 
% plssub: Set the number of subpages in x and y 
% 
% DESCRIPTION:
% 
%     Set the number of subpages in x and y. 
% 
% SYNOPSIS:
% 
% plssub(nx, ny)
% 
% ARGUMENTS:
% 
%     nx (PLINT, input) :    Number of windows in x direction (i.e., number
%     of window columns). 
% 
%     ny (PLINT, input) :    Number of windows in y direction (i.e., number
%     of window rows). 
%     of window rows). 
  plplot_octave(92, nx, ny);
endfunction

function plssym(def, scale)
% plssym(def, scale)
%
%   Original PLplot call documentation:
%
% 
% plssym: Set symbol size 
% 
% DESCRIPTION:
% 
%     This sets up the size of all subsequent symbols drawn by plpoin and
%     plsym.  The actual height of a symbol is the product of the default
%     symbol size and a scaling factor as for the character height. 
% 
% SYNOPSIS:
% 
% plssym(def, scale)
% 
% ARGUMENTS:
% 
%     def (PLFLT, input) :    The default height of a symbol in millimeters,
%     should be set to zero if the default height is to remain
%     unchanged. 
% 
%     scale (PLFLT, input) :    Scale factor to be applied to default to get
%     actual symbol height. 
%     actual symbol height. 
  plplot_octave(93, def, scale);
endfunction

function plstar(nx, ny)
% plstar(nx, ny)
%
%   Original PLplot call documentation:
%
% 
% plstar: Initialization 
% 
% DESCRIPTION:
% 
%     Initializing the plotting package.	The program prompts for the device
%     keyword or number of the desired output device.  Hitting a RETURN in
%     response to the prompt is the same as selecting the first device.  If
%     only one device is enabled when PLplot is installed, plstar will issue
%     no prompt.	The output device is divided into nx by ny subpages, each
%     of which may be used independently.  The subroutine pladv is used to
%     advance from one subpage to the next. 
% 
% SYNOPSIS:
% 
% plstar(nx, ny)
% 
% ARGUMENTS:
% 
%     nx (PLINT, input) :    Number of subpages to divide output page in the
%     horizontal direction. 
% 
%     ny (PLINT, input) :    Number of subpages to divide output page in the
%     vertical direction. 
%     vertical direction. 
  plplot_octave(94, nx, ny);
endfunction

function plstart(devname, nx, ny)
% plstart(devname, nx, ny)
%
%   Original PLplot call documentation:
%
% 
% plstart: Initialization 
% 
% DESCRIPTION:
% 
%     Alternative to plstar for initializing the plotting package.  The
%     device name keyword for the desired output device must be supplied as
%     an argument.  The device keywords are the same as those printed out by
%     plstar.  If the requested device is not available, or if the input
%     string is empty or begins with ``?'', the prompted startup of plstar
%     is used.  This routine also divides the output device into nx by ny
%     subpages, each of which may be used independently.	The subroutine
%     pladv is used to advance from one subpage to the next. 
% 
% SYNOPSIS:
% 
% plstart(device, nx, ny)
% 
% ARGUMENTS:
% 
%     device (const char *, input) :    Device name (keyword) of the
%     required output device.  If NULL or if the first character is a
%     ``?'', the normal (prompted) startup is used. 
% 
%     nx (PLINT, input) :    Number of subpages to divide output page in the
%     horizontal direction. 
% 
%     ny (PLINT, input) :    Number of subpages to divide output page in the
%     vertical direction. 
%     vertical direction. 
  plplot_octave(95, devname, nx, ny);
endfunction

function plstripa(id, pen, x, y)
% plstripa(id, pen, x, y)
%
%   Original PLplot call documentation:
%
% 
% plstripa: Add a point to a stripchart 
% 
% DESCRIPTION:
% 
%     Add a point to a given pen of a given stripchart. There is no need for
%     all pens to have the same number of points or to be equally sampled in
%     the x coordinate. Allocates memory and rescales as necessary. 
% 
% SYNOPSIS:
% 
% plstripa(id, p, x, y)
% 
% ARGUMENTS:
% 
%     id (PLINT, input) :    Identification number (set up in plstripc) of
%     the stripchart. 
% 
%     p (PLINT, input) :      Pen number (ranges from 0 to 3). 
% 
%     x (PLFLT, input) :      X coordinate of point to plot. 
% 
%     y (PLFLT, input) :      Y coordinate of point to plot. 
%     y (PLFLT, input) :      Y coordinate of point to plot. 
  plplot_octave(96, id, pen, x, y);
endfunction

function plstripd(id)
% plstripd(id)
%
%   Original PLplot call documentation:
%
% 
% plstripd: Deletes and releases memory used by a
% stripchart 
% 
% DESCRIPTION:
% 
%     Deletes and releases memory used by a stripchart. 
% 
% SYNOPSIS:
% 
% plstripd(id)
% 
% ARGUMENTS:
% 
%     id (PLINT, input) :    Identitification number of stripchart to
%     delete. 
%     delete. 
  plplot_octave(97, id);
endfunction

function plstyl(nms, mark, space)
% plstyl(nms, mark, space)
%
%   Original PLplot call documentation:
%
% 
% plstyl: Set line style 
% 
% DESCRIPTION:
% 
%     This sets up the line style for all lines subsequently drawn.  A line
%     consists of segments in which the pen is alternately down and up. The
%     lengths of these segments are passed in the arrays mark and space
%     respectively.  The number of mark-space pairs is specified by nels. 
%     In order to return the line style to the default continuous line,
%     plstyl should be called with nels=0.(see also pllsty) 
% 
% SYNOPSIS:
% 
% plstyl(nels, mark, space)
% 
% ARGUMENTS:
% 
%     nels (PLINT, input) :    The number of mark and space elements in a
%     line.  Thus a simple broken line can be obtained by setting
%     nels=1.  A continuous line is specified by setting nels=0. 
% 
%     mark (PLINT *, input) :    Pointer to array with the lengths of the
%     segments during which the pen is down, measured in micrometers. 
% 
%     space (PLINT *, input) :    Pointer to array with the lengths of the
%     segments during which the pen is up, measured in micrometers. 
%     segments during which the pen is up, measured in micrometers. 
  plplot_octave(98, nms, mark, space);
endfunction

function plsvpa(xmin, xmax, ymin, ymax)
% plsvpa(xmin, xmax, ymin, ymax)
%
%   Original PLplot call documentation:
%
% 
% plsvpa: Specify viewport in absolute coordinates 
% 
% DESCRIPTION:
% 
%     Alternate routine to plvpor for setting up the viewport.  This routine
%     should be used only if the viewport is required to have a definite
%     size in millimeters.  The routine plgspa is useful for finding out the
%     size of the current subpage. 
% 
% SYNOPSIS:
% 
% plsvpa(xmin, xmax, ymin, ymax)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT, input) :    The distance of the left-hand edge of the
%     viewport from the left-hand edge of the subpage in millimeters. 
% 
%     xmax (PLFLT, input) :    The distance of the right-hand edge of the
%     viewport from the left-hand edge of the subpage in millimeters. 
% 
%     ymin (PLFLT, input) :    The distance of the bottom edge of the
%     viewport from the bottom edge of the subpage in millimeters. 
% 
%     ymax (PLFLT, input) :    The distance of the top edge of the viewport
%     from the bottom edge of the subpage in millimeters. 
%     from the bottom edge of the subpage in millimeters. 
  plplot_octave(99, xmin, xmax, ymin, ymax);
endfunction

function plsxax(digmax, digits)
% plsxax(digmax, digits)
%
%   Original PLplot call documentation:
%
% 
% plsxax: Set x axis parameters 
% 
% DESCRIPTION:
% 
%     Sets values of the digmax and digits flags for the x axis.	See the
%     PLplot documentation for more information. 
% 
% SYNOPSIS:
% 
% plsxax(digmax, digits)
% 
% ARGUMENTS:
% 
%     digmax (PLINT, input) :    Variable to set the maximum number of
%     digits for the x axis.    If nonzero, the printed label will be
%     switched to a floating point representation when the number of
%     digits exceeds digmax. 
% 
%     digits (PLINT, input) :    Field digits value.  Currently, changing
%     its value here has no effect since it is set only by plbox or
%     plbox3.  However, the user may obtain its value after a call to
%     either of these functions by calling plgxax. 
%     either of these functions by calling plgxax. 
  plplot_octave(100, digmax, digits);
endfunction

function plsyax(digmax, digits)
% plsyax(digmax, digits)
%
%   Original PLplot call documentation:
%
% 
% plsyax: Set y axis parameters 
% 
% DESCRIPTION:
% 
%     Identical to plsxax, except that arguments are flags for y axis. See
%     the description of plsxax for more detail. 
% 
% SYNOPSIS:
% 
% plsyax(digmax, digits)
% 
% ARGUMENTS:
% 
%     digmax (PLINT, input) :    Variable to set the maximum number of
%     digits for the y axis.    If nonzero, the printed label will be
%     switched to a floating point representation when the number of
%     digits exceeds digmax. 
% 
%     digits (PLINT, input) :    Field digits value.  Currently, changing
%     its value here has no effect since it is set only by plbox or
%     plbox3.  However, the user may obtain its value after a call to
%     either of these functions by calling plgyax. 
%     either of these functions by calling plgyax. 
  plplot_octave(101, digmax, digits);
endfunction

function plsym(x, y, code)
% plsym(x, y, code)
%
%   Original PLplot call documentation:
%
% 
% plsym: Plots a symbol at the specified points 
% 
% DESCRIPTION:
% 
%     Marks out a set of n points at positions (
%     x[i], 
%     y[i]), using the symbol defined by code.  The code is interpreted as
%     an index in the Hershey font tables. 
% 
% SYNOPSIS:
% 
% plsym(n, x, y, code)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of points to be marked. 
% 
%     x (PLFLT *, input) :    Pointer to array with set of x coordinate
%     values for the points. 
% 
%     y (PLFLT *, input) :    Pointer to array with set of y coordinate
%     values for the points. 
% 
%     code (PLINT, input) :    Code number for the symbol to be plotted. 
%     code (PLINT, input) :    Code number for the symbol to be plotted. 
  plplot_octave(102, x, y, code);
endfunction

function plszax(digmax, digits)
% plszax(digmax, digits)
%
%   Original PLplot call documentation:
%
% 
% plszax: Set z axis parameters 
% 
% DESCRIPTION:
% 
%     Identical to plsxax, except that arguments are flags for z axis. See
%     the description of plsxax for more detail. 
% 
% SYNOPSIS:
% 
% plszax(digmax, digits)
% 
% ARGUMENTS:
% 
%     digmax (PLINT, input) :    Variable to set the maximum number of
%     digits for the z axis.    If nonzero, the printed label will be
%     switched to a floating point representation when the number of
%     digits exceeds digmax. 
% 
%     digits (PLINT, input) :    Field digits value.  Currently, changing
%     its value here has no effect since it is set only by plbox or
%     plbox3.  However, the user may obtain its value after a call to
%     either of these functions by calling plgzax. 
%     either of these functions by calling plgzax. 
  plplot_octave(103, digmax, digits);
endfunction

function pltext()
% pltext()
%
%   Original PLplot call documentation:
%
% 
% pltext: Switch to text screen 
% 
% DESCRIPTION:
% 
%     Sets an interactive device to text mode, used in conjunction with
%     plgra to allow graphics and text to be interspersed.  On a device
%     which supports separate text and graphics windows, this command causes
%     control to be switched to the text window.	This can be useful for
%     printing diagnostic messages or getting user input, which would
%     otherwise interfere with the plots.  The program must switch back to
%     the graphics window before issuing plot commands, as the text (or
%     console) device will probably become quite confused otherwise.  If
%     already in text mode, this command is ignored.  It is also ignored on
%     devices which only support a single window or use a different method
%     for shifting focus (see also plgra). 
% 
% SYNOPSIS:
% 
% pltext()
% pltext()
  plplot_octave(104);
endfunction

function plvasp(aspect)
% plvasp(aspect)
%
%   Original PLplot call documentation:
%
% 
% plvasp: Specify viewport using aspect ratio only 
% 
% DESCRIPTION:
% 
%     Sets the viewport so that the ratio of the length of the y axis to
%     that of the x axis is equal to aspect. 
% 
% SYNOPSIS:
% 
% plvasp(aspect)
% 
% ARGUMENTS:
% 
%     aspect (PLFLT, input) :    Ratio of length of y axis to length of x
%     axis. 
%     axis. 
  plplot_octave(105, aspect);
endfunction

function plvpas(xmin, xmax, ymin, ymax, aspect)
% plvpas(xmin, xmax, ymin, ymax, aspect)
%
%   Original PLplot call documentation:
%
% 
% plvpas: Specify viewport using coordinates and aspect ratio 
% 
% DESCRIPTION:
% 
%     Device-independent routine for setting up the viewport.  The viewport
%     is chosen to be the largest with the given aspect ratio that fits
%     within the specified region (in terms of normalized subpage
%     coordinates).  This routine is functionally equivalent to plvpor when
%     a ``natural'' aspect ratio (0.0) is chosen.  Unlike plvasp, this
%     routine reserves no extra space at the edges for labels. 
% 
% SYNOPSIS:
% 
% plvpas(xmin, xmax, ymin, ymax, aspect)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT, input) :    The normalized subpage coordinate of the
%     left-hand edge of the viewport. 
% 
%     xmax (PLFLT, input) :    The normalized subpage coordinate of the
%     right-hand edge of the viewport. 
% 
%     ymin (PLFLT, input) :    The normalized subpage coordinate of the
%     bottom edge of the viewport. 
% 
%     ymax (PLFLT, input) :    The normalized subpage coordinate of the top
%     edge of the viewport. 
% 
%     aspect (PLFLT, input) :    Ratio of length of y axis to length of x
%     axis. 
%     axis. 
  plplot_octave(106, xmin, xmax, ymin, ymax, aspect);
endfunction

function plvpor(xmin, xmax, ymin, ymax)
% plvpor(xmin, xmax, ymin, ymax)
%
%   Original PLplot call documentation:
%
% 
% plvpor: Specify viewport using coordinates 
% 
% DESCRIPTION:
% 
%     Device-independent routine for setting up the viewport.  This defines
%     the viewport in terms of normalized subpage coordinates which run from
%     0.0 to 1.0 (left to right and bottom to top) along each edge of the
%     current subpage.  Use the alternate routine plsvpa in order to create
%     a viewport of a definite size. 
% 
% SYNOPSIS:
% 
% plvpor(xmin, xmax, ymin, ymax)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT, input) :    The normalized subpage coordinate of the
%     left-hand edge of the viewport. 
% 
%     xmax (PLFLT, input) :    The normalized subpage coordinate of the
%     right-hand edge of the viewport. 
% 
%     ymin (PLFLT, input) :    The normalized subpage coordinate of the
%     bottom edge of the viewport. 
% 
%     ymax (PLFLT, input) :    The normalized subpage coordinate of the top
%     edge of the viewport. 
%     edge of the viewport. 
  plplot_octave(107, xmin, xmax, ymin, ymax);
endfunction

function plvsta()
% plvsta()
%
%   Original PLplot call documentation:
%
% 
% plvsta: Select standard viewport 
% 
% DESCRIPTION:
% 
%     Sets up a standard viewport, leaving a left-hand margin of seven
%     character heights, and four character heights around the other three
%     sides. 
% 
% SYNOPSIS:
% 
% plvsta()
% plvsta()
  plplot_octave(108);
endfunction

function plw3d(basex, basey, height, xmin0, xmax0, ymin0, ymax0, zmin0, zmax0, alt, az)
% plw3d(basex, basey, height, xmin0, xmax0, ymin0, ymax0, zmin0, zmax0, alt, az)
%
%   Original PLplot call documentation:
%
% 
% plw3d: Set up window for 3-d plotting 
% 
% DESCRIPTION:
% 
%     Sets up a window for a three-dimensional surface plot within the
%     currently defined two-dimensional window.  The enclosing box for the
%     surface plot defined by xmin, xmax, ymin, ymax, zmin and zmax in
%     user-coordinate space is mapped into a box of world coordinate size
%     basex by basey by height so that xmin maps to -
%     basex/2, xmax maps to basex/2, ymin maps to -
%     basey/2, ymax maps to basey/2, zmin maps to 0 and zmax maps to height.
%      The resulting world-coordinate box is then viewed by an observer at
%     altitude alt and azimuth az.  This routine must be called before
%     plbox3 or plot3d.  For a more complete description of
%     three-dimensional plotting see the PLplot documentation. 
% 
% SYNOPSIS:
% 
% plw3d(basex, basey, height, xmin, xmax, ymin, ymax, zmin, zmax, alt, az)
% 
% ARGUMENTS:
% 
%     basex (PLFLT, input) :    The x coordinate size of the
%     world-coordinate box. 
% 
%     basey (PLFLT, input) :    The y coordinate size of the
%     world-coordinate box. 
% 
%     height (PLFLT, input) :    The z coordinate size of the
%     world-coordinate box. 
% 
%     xmin (PLFLT, input) :    The minimum user x coordinate value. 
% 
%     xmax (PLFLT, input) :    The maximum user x coordinate value. 
% 
%     ymin (PLFLT, input) :    The minimum user y coordinate value. 
% 
%     ymax (PLFLT, input) :    The maximum user y coordinate value. 
% 
%     zmin (PLFLT, input) :    The minimum user z coordinate value. 
% 
%     zmax (PLFLT, input) :    The maximum user z coordinate value. 
% 
%     alt (PLFLT, input) :    The viewing altitude in degrees above the xy
%     plane. 
% 
%     az (PLFLT, input) :    The viewing azimuth in degrees.  When az=0, the
%     observer is looking face onto the zx plane, and as az is
%     increased, the observer moves clockwise around the box when viewed
%     from above the xy plane. 
%     from above the xy plane. 
  plplot_octave(109, basex, basey, height, xmin0, xmax0, ymin0, ymax0, zmin0, zmax0, alt, az);
endfunction

function plwid(width)
% plwid(width)
%
%   Original PLplot call documentation:
%
% 
% plwid: Set pen width 
% 
% DESCRIPTION:
% 
%     Sets the pen width. 
% 
% SYNOPSIS:
% 
% plwid(width)
% 
% ARGUMENTS:
% 
%     width (PLINT, input) :    The desired pen width.  If width is negative
%     or the same as the previous value no action is taken.
%     width = 0 should be interpreted as
%     as the minimum valid pen width for the device.  The interpretation of
%     positive
%     width values is also device
%     dependent. 
%     dependent. 
  plplot_octave(110, width);
endfunction

function plwind(xmin, xmax, ymin, ymax)
% plwind(xmin, xmax, ymin, ymax)
%
%   Original PLplot call documentation:
%
% 
% plwind: Specify world coordinates of viewport boundaries 
% 
% DESCRIPTION:
% 
%     Sets up the world coordinates of the edges of the viewport. 
% 
% SYNOPSIS:
% 
% plwind(xmin, xmax, ymin, ymax)
% 
% ARGUMENTS:
% 
%     xmin (PLFLT, input) :    The world x coordinate of the left-hand edge
%     of the viewport. 
% 
%     xmax (PLFLT, input) :    The world x coordinate of the right-hand edge
%     of the viewport. 
% 
%     ymin (PLFLT, input) :    The world y coordinate of the bottom edge of
%     the viewport. 
% 
%     ymax (PLFLT, input) :    The world y coordinate of the top edge of the
%     viewport. 
%     viewport. 
  plplot_octave(111, xmin, xmax, ymin, ymax);
endfunction

function status = plxormod(mode)
% status = plxormod(mode)
%
%   Original PLplot call documentation:
%
% 
% plxormod: Enter or leave xor mode 
% 
% DESCRIPTION:
% 
%     Enter (when mode is true)  or leave (when mode is false) xor mode for
%     those drivers (e.g., the xwin driver) that support it.  Enables
%     erasing plots by drawing twice the same line, symbol, etc.	If driver
%     is not capable of xor operation it returns a status of false. 
% 
% SYNOPSIS:
% 
% plxormod(mode, status)
% 
% ARGUMENTS:
% 
%     mode (PLBOOL, input) :    mode is true means enter xor mode and  mode
%     is false means leave xor mode. 
% 
%     status (PLBOOL *, output) :    Pointer to status. Returned    modestatus
%     of true (false) means driver is capable (incapable) of xor mode. 
%     of true (false) means driver is capable (incapable) of xor mode. 
  status = plplot_octave(112, mode);
endfunction

function [retval, state, keysym, button, string, pX, pY, dX, dY, wX, wY, subwin] = plGetCursor()
% [retval, state, keysym, button, string, pX, pY, dX, dY, wX, wY, subwin] = plGetCursor()
%
% Wait for graphics input event and translate to world coordinates  
  [retval, state, keysym, button, string, pX, pY, dX, dY, wX, wY, subwin] = plplot_octave(113);
endfunction

function [retval, x, y] = plTranslateCursor(x_in, y_in)
% [retval, x, y] = plTranslateCursor(x_in, y_in)
%
% Translates relative device coordinates to world coordinates.   
  [retval, x, y] = plplot_octave(114, x_in, y_in);
endfunction

function plcol(icol0)
% plcol(icol0)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(115, icol0);
endfunction

function plcont(f, kx, lx, ky, ly, clevel, tr)
% plcont(f, kx, lx, ky, ly, clevel, tr)
%
%   Original PLplot call documentation:
%
% 
% plcont: Contour plot 
% 
% DESCRIPTION:
% 
%     Draws a contour plot of the data in z[
%     nx][
%     ny], using the nlevel contour levels specified by clevel. Only the
%     region of the array from kx to lx and from ky to ly is plotted out.  A
%     transformation routine pointed to by pltr with a pointer pltr_data for
%     additional data required by the transformation routine is used to map
%     indices within the array to the world coordinates.	See the following
%     discussion of the arguments and the PLplot documentation for more
%     information. 
% 
% SYNOPSIS:
% 
% plcont(z, nx, ny, kx, lx, ky, ly, clevel, nlevel, pltr, pltr_data)
% 
% ARGUMENTS:
% 
%     z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
%     containing data to be contoured. 
% 
%     nx, ny (PLINT, input) :    Physical dimensions of array z. 
% 
%     kx, lx (PLINT, input) :    Range of x indices to consider. 
% 
%     ky, ly (PLINT, input) :    Range of y indices to consider. 
% 
%     clevel (PLFLT *, input) :     Pointer to array specifying levels at
%     which to draw contours. 
% 
%     nlevel (PLINT, input) :    Number of contour levels to draw. 
% 
%     pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) : 
%       Pointer to function that defines transformation between indices
%     in array z and the world coordinates (C only).    Transformation
%     functions are provided in the PLplot library: pltr0 for identity
%     mapping, and pltr1 and pltr2 for arbitrary mappings respectively
%     defined by one- and two-dimensional arrays.  In addition,
%     user-supplied routines for the transformation can be used as well.
%      Examples of all of these approaches are given in the PLplot
%     documentation. The transformation function should have the form
%     given by any of pltr0, pltr1, or pltr2. 
% 
%     pltr_data (PLPointer, input) :    Extra parameter to help pass
%     information to pltr0, pltr1, pltr2, or whatever routine that is
%     externally supplied. 
%     externally supplied. 
  plplot_octave(116, f, kx, lx, ky, ly, clevel, tr);
endfunction

function plcont0(f, kx, lx, ky, ly, clevel)
% plcont0(f, kx, lx, ky, ly, clevel)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(117, f, kx, lx, ky, ly, clevel);
endfunction

function plcont1(f, kx, lx, ky, ly, clevel, xg, yg)
% plcont1(f, kx, lx, ky, ly, clevel, xg, yg)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(118, f, kx, lx, ky, ly, clevel, xg, yg);
endfunction

function plcont2(f, kx, lx, ky, ly, clevel, xg, yg)
% plcont2(f, kx, lx, ky, ly, clevel, xg, yg)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(119, f, kx, lx, ky, ly, clevel, xg, yg);
endfunction

function plcont2p(f, kx, lx, ky, ly, clevel, xg, yg)
% plcont2p(f, kx, lx, ky, ly, clevel, xg, yg)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(120, f, kx, lx, ky, ly, clevel, xg, yg);
endfunction

function zg = plgriddata(x, y, z, xg, yg, type, data)
% zg = plgriddata(x, y, z, xg, yg, type, data)
%
%   Original PLplot call documentation:
%
% 
% plgriddata: Grid data from irregularly sampled data 
% 
% DESCRIPTION:
% 
%     Real world data is frequently irregularly sampled, but all PLplot 3D
%     plots require data placed in a uniform grid. This function takes
%     irregularly sampled data from three input arrays x[npts], y[npts], and
%     z[npts], reads the desired grid location from input arrays xg[nptsx]
%     and yg[nptsy], and returns the gridded data into output array
%     zg[nptsx][nptsy].  The algorithm used to grid the data is specified
%     with the argument type which can have one parameter specified in
%     argument data. 
% 
% SYNOPSIS:
% 
% plggriddata(x, y, z, npts, xg, nptsx, yg, nptsy, zg, type, data)
% 
% ARGUMENTS:
% 
%     x (PLFLT *, input) :    The input x array. 
% 
%     y (PLFLT *, input) :    The input y array. 
% 
%     z (PLFLT *, input) :    The input z array. Each triple x[i], y[i],
%     z[i] represents one data sample coordinates. 
% 
%     npts (PLINT, input) :    The number of data samples in the x, y and z
%     arrays. 
% 
%     xg (PLFLT *, input) :    The input array that specifies the grid
%     spacing in the x direction. Usually xg has nptsx equaly spaced
%     values from the mininum to the maximum values of the x input
%     array. 
% 
%     nptsx (PLINT, input) :    The number of points in the xg array. 
% 
%     yg (PLFLT *, input) :    The input array that specifies the grid
%     spacing in the y direction. Similar to the xg parameter. 
% 
%     nptsy (PLINT, input) :    The number of points in the yg array. 
% 
%     sg (PLFLT **, output) :    The output array, where data lies in the
%     regular grid specified by xg and yg. the zg array must exists or
%     be allocated by the user prior to the calling, and must have
%     dimension zg[nptsx][xptsy]. 
% 
%     type (PLINT, input) :    The type of gridding algorithm to use, which
%     can be: GRID_CSA: Bivariate Cubic Spline approximation 
%         GRID_DTLI: Delaunay Triangulation Linear Interpolation 
%         GRID_NNI: Natural Neighbors Interpolation 
%         GRID_NNIDW: Nearest Neighbors Inverse Distance Weighted 
%         GRID_NNLI: Nearest Neighbors Linear Interpolation 
%         GRID_NNAIDW:  Nearest Neighbors Around Inverse Distance
%         Weighted 
%     For details on the algorithm read the source file plgridd.c. 
% 
%     data (PLFLT, input) :    Some gridding algorithms require extra data,
%     which can be specified through this argument. Currently, for
%     algoritm: GRID_NNIDW, data specifies the number of neighbors to
%     use, the lower the value, the noisier (more local) the
%     approximation is. 
%         GRID_NNLI, data specifies what a thin triangle is, in the
%         range [1. .. 2.]. High values enable the usage of very thin
%         triangles for interpolation, possibly resulting in error in
%         the approximation. 
%         GRID_NNI, only weights greater than data will be accepted. If
%         0, all weigths will be accepted. 
%         0, all weigths will be accepted. 
  zg = plplot_octave(121, x, y, z, xg, yg, type, data);
endfunction

function pplimage(a, xmin, xmax, ymin, ymax, zmin, zmax, dxmin, dxmax, dymin, dymax)
% pplimage(a, xmin, xmax, ymin, ymax, zmin, zmax, dxmin, dxmax, dymin, dymax)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(122, a, xmin, xmax, ymin, ymax, zmin, zmax, dxmin, dxmax, dymin, dymax);
endfunction

function plmesh(x, y, z, opt)
% plmesh(x, y, z, opt)
%
%   Original PLplot call documentation:
%
% 
% plmesh: Plot surface mesh 
% 
% DESCRIPTION:
% 
%     Plots a surface mesh within the environment set up by plw3d.  The
%     surface is defined by the two-dimensional array z[
%     nx][
%     ny], the point z[i][j] being the value of the function at (
%     x[i], 
%     y[j]).  Note that the points in arrays x and y do not need to be
%     equally spaced, but must be stored in ascending order.  The parameter
%     opt controls the way in which the surface is displayed.  For further
%     details see the PLplot documentation. 
% 
% SYNOPSIS:
% 
% plmesh(x, y, z, nx, ny, opt)
% 
% ARGUMENTS:
% 
%     x (PLFLT *, input) :    Pointer to set of x coordinate values at which
%     the function is evaluated. 
% 
%     y (PLFLT *, input) :    Pointer to set of y coordinate values at which
%     the function is evaluated. 
% 
%     z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
%     with set of function values. 
% 
%     nx (PLINT, input) :    Number of x values at which function is
%     evaluated. 
% 
%     ny (PLINT, input) :    Number of y values at which function is
%     evaluated. 
% 
%     opt (PLINT, input) :    Determines the way in which the surface is
%     represented: opt=DRAW_LINEX: Lines are drawn showing z as a
%     function of x for each value of y[j]. 
%         opt=DRAW_LINEY: Lines are drawn showing z as a function of y
%         for each value of x[i]. 
%         opt=DRAW_LINEXY: Network of lines is drawn connecting points
%         at which function is defined. 
%         at which function is defined. 
  plplot_octave(123, x, y, z, opt);
endfunction

function plmeshc(x, y, z, opt, clevel)
% plmeshc(x, y, z, opt, clevel)
%
%   Original PLplot call documentation:
%
% 
% plmeshc: Magnitude colored plot surface mesh with contour. 
% 
% DESCRIPTION:
% 
%     Identical to plmesh but with extra functionalities: the surface mesh
%     can be colored accordingly to the current z value being plotted, a
%     contour plot can be drawn at the base XY plane, and a curtain can be
%     drawn between the plotted function border and the base XY plane. 
% 
% SYNOPSIS:
% 
% plmeshc(x, y, z, nx, ny, opt, clevel, nlevel)
% 
% ARGUMENTS:
% 
%     x (PLFLT *, input) :    Pointer to set of x coordinate values at which
%     the function is evaluated. 
% 
%     y (PLFLT *, input) :    Pointer to set of y coordinate values at which
%     the function is evaluated. 
% 
%     z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
%     with set of function values. 
% 
%     nx (PLINT, input) :    Number of x values at which function is
%     evaluated. 
% 
%     ny (PLINT, input) :    Number of y values at which function is
%     evaluated. 
% 
%     opt (PLINT, input) :    Determines the way in which the surface is
%     represented. To specify more than one option just add the options,
%     e.g. DRAW_LINEXY + MAG_COLOR opt=DRAW_LINEX: Lines are drawn
%     showing z as a function of x for each value of y[j]. 
%         opt=DRAW_LINEY: Lines are drawn showing z as a function of y
%         for each value of x[i]. 
%         opt=DRAW_LINEXY: Network of lines is drawn connecting points
%         at which function is defined. 
%         opt=MAG_COLOR: Each line in the mesh is colored according to
%         the z value being plotted. The color is used from the current
%         colormap 1. 
%         opt=BASE_CONT: A contour plot is drawn at the base XY plane
%         using parameters 
%     nlevel and 
%     clevel. 
%         opt=DRAW_SIDES: draws a curtain between the base XY plane and
%         the borders of the plotted function. 
% 
% 
%     clevel (PLFLT *, input) :     Pointer to the array that defines the
%     contour level spacing. 
% 
%     nlevel (PLINT, input) :    Number of elements in the clevel array. 
%     nlevel (PLINT, input) :    Number of elements in the clevel array. 
  plplot_octave(124, x, y, z, opt, clevel);
endfunction

function plot3d(x, y, z, opt, side)
% plot3d(x, y, z, opt, side)
%
%   Original PLplot call documentation:
%
% 
% plot3d: Plot 3-d surface plot 
% 
% DESCRIPTION:
% 
%     Plots a three dimensional surface plot within the environment set up
%     by plw3d.  The surface is defined by the two-dimensional array z[
%     nx][
%     ny], the point z[i][j] being the value of the function at (
%     x[i], 
%     y[j]).  Note that the points in arrays x and y do not need to be
%     equally spaced, but must be stored in ascending order.  The parameter
%     opt controls the way in which the surface is displayed.  For further
%     details see the PLplot documentation. The only difference between
%     plmesh and plot3d is that plmesh draws the botton side of the surface,
%     while plot3d only draws the surface as viewed from the top. 
% 
% SYNOPSIS:
% 
% plot3d(x, y, z, nx, ny, opt, side)
% 
% ARGUMENTS:
% 
%     x (PLFLT *, input) :    Pointer to set of x coordinate values at which
%     the function is evaluated. 
% 
%     y (PLFLT *, input) :    Pointer to set of y coordinate values at which
%     the function is evaluated. 
% 
%     z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
%     with set of function values. 
% 
%     nx (PLINT, input) :    Number of x values at which function is
%     evaluated. 
% 
%     ny (PLINT, input) :    Number of y values at which function is
%     evaluated. 
% 
%     opt (PLINT, input) :    Determines the way in which the surface is
%     represented: opt=DRAW_LINEX: Lines are drawn showing z as a
%     function of x for each value of y[j]. 
%         opt=DRAW_LINEY: Lines are drawn showing z as a function of y
%         for each value of x[i]. 
%         opt=DRAW_LINEXY: Network of lines is drawn connecting points
%         at which function is defined. 
% 
% 
%     side (PLBOOL, input) :    Flag to indicate whether or not ``sides''
%     should be draw on the figure.  If side is true sides are drawn,
%     otherwise no sides are drawn. 
%     otherwise no sides are drawn. 
  plplot_octave(125, x, y, z, opt, side);
endfunction

function plot3dc(x, y, z, opt, clevel)
% plot3dc(x, y, z, opt, clevel)
%
%   Original PLplot call documentation:
%
% 
% plot3dc: Magnitude colored plot surface with contour. 
% 
% DESCRIPTION:
% 
%     Identical to plot3d but with extra functionalities: the surface mesh
%     can be colored accordingly to the current z value being plotted, a
%     contour plot can be drawn at the base XY plane, and a curtain can be
%     drawn between the plotted function border and the base XY plane. The
%     arguments are identical to plmeshc. The only difference between
%     plmeshc and plot3dc is that plmeshc draws the botton side of the
%     surface, while plot3dc only draws the surface as viewed from the top. 
% 
% SYNOPSIS:
% 
% plot3dc(x, y, z, nx, ny, opt, clevel, nlevel)
% plot3dc(x, y, z, nx, ny, opt, clevel, nlevel)
  plplot_octave(126, x, y, z, opt, clevel);
endfunction

function plpoly3(x, y, z, draw, clockwise)
% plpoly3(x, y, z, draw, clockwise)
%
%   Original PLplot call documentation:
%
% 
% plpoly3: Draw a polygon in 3 space 
% 
% DESCRIPTION:
% 
%     Bugs:  If one of the first two segments is of zero length, or if they
%     are colinear, the calculation of visibility has a 50/50 chance of
%     being correct.  Avoid such situations :-).	See x18c.c for an example
%     of this problem. (Search for 20.1). 
% 
% SYNOPSIS:
% 
% plpoly3(n, x, y, z, draw, ifcc)
% 
% ARGUMENTS:
% 
%     n (PLINT, input) :      Number of points defining line. 
% 
%     x (PLFLT *, input) :    Pointer to array with x coordinates of points. 
% 
%     y (PLFLT *, input) :    Pointer to array with y coordinates of points. 
% 
%     z (PLFLT *, input) :    Pointer to array with z coordinates of points. 
% 
%     draw (PLBOOL *, input) :    Pointer to array which controls drawing
%     the segments of the polygon.  If draw[i] is true, then the polygon
%     segment from index [i] to [i+1] is drawn, otherwise, not. 
% 
%     ifcc (PLBOOL, input) :    If ifcc is true the directionality of the
%     polygon is determined by assuming the points are laid out in a
%     counter-clockwise order.  Otherwise, the directionality of the
%     polygon is determined by assuming the points are laid out in a
%     clockwise order. 
%     clockwise order. 
  plplot_octave(127, x, y, z, draw, clockwise);
endfunction

function plshade(a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, tr)
% plshade(a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, tr)
%
%   Original PLplot call documentation:
%
% 
% plshade:  Shade individual region on the basis of value 
% 
% DESCRIPTION:
% 
%     Shade individual region on the basis of value.  Use plshades if you
%     want to shade a number of regions using continuous colors. plshade is
%     identical to plshade1 except for the type of the first parameter. See
%     plshade1 for further discussion. 
% 
% SYNOPSIS:
% 
% plshade(a, nx, ny, defined, xmin, xmax, ymin, ymax, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, fill, rectangular, pltr, pltr_data)
% 
% ARGUMENTS:
% 
%     a (PLFLT **, input) :    
% 
%     nx (PLINT, input) :    
% 
%     ny (PLINT, input) :    
% 
%     defined (PLINT (*) (PLFLT, PLFLT), input) :    
% 
%     xmin (PLFLT, input) :    
% 
%     xmax (PLFLT, input) :    
% 
%     ymin (PLFLT, input) :    
% 
%     ymax (PLFLT, input) :    
% 
%     shade_min (PLFLT, input) :      
% 
%     shade_max (PLFLT, input) :      
% 
%     sh_cmap (PLINT, input) :    
% 
%     sh_color (PLFLT, input) :     
% 
%     sh_width (PLINT, input) :     
% 
%     min_color (PLINT, input) :      
% 
%     min_width (PLINT, input) :      
% 
%     max_color (PLINT, input) :      
% 
%     max_width (PLINT, input) :      
% 
%     fill (void (*) (PLINT, PLFLT *, PLFLT *), input) :      
% 
%     rectangular (PLBOOL, input) :    
% 
%     pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) :  
% 
%     pltr_data (PLPointer, input) :    
%     pltr_data (PLPointer, input) :    
  plplot_octave(128, a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, tr);
endfunction

function plshade1(a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, xg, yg)
% plshade1(a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, xg, yg)
%
%   Original PLplot call documentation:
%
% 
% plshade1: Shade individual region on the basis of value 
% 
% DESCRIPTION:
% 
%     Shade individual region on the basis of value.  Use plshades if you
%     want to shade a number of contiguous regions using continuous colors. 
%     In particular the edge contours are treated properly in plshades. If
%     you attempt to do contiguous regions with plshade1 (or plshade) the
%     contours at the edge of the shade are partially obliterated by
%     subsequent plots of contiguous shaded regions. plshade1 differs from
%     plshade by the type of the first argument.	Look at the argument list
%     below, plcont and the PLplot documentation for more information about
%     the transformation from grid to world coordinates.	Shading NEEDS
%     DOCUMENTATION, but as a stopgap look at how plshade is used in
%     examples/c/x15c.c
% 
% SYNOPSIS:
% 
% plshade1(a, nx, ny, defined, xmin, xmax, ymin, ymax, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, fill, rectangular, pltr, pltr_data)
% 
% ARGUMENTS:
% 
%     a (PLFLT *, input) :    Contains array to be plotted. The array must
%     have been declared as PLFLT a[nx][ny]. 
% 
%     nx (PLINT, input) :    First dimension of array "a". 
% 
%     ny (PLINT, input) :    Second dimension of array "a". 
% 
%     defined (PLINT (*) (PLFLT, PLFLT), input) :    User function
%     specifying regions excluded from the shading plot.  This function
%     accepts x and y coordinates as input arguments and must return 0
%     if the point is in the excluded region or 1 otherwise. This
%     argument can be NULL if all the values are valid. 
% 
%     xmin (PLFLT, input) :    Defines the "grid" coordinates.  The data
%     a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
%     at (xmax,ymin) and so on. 
% 
%     xmax (PLFLT, input) :    Defines the "grid" coordinates.  The data
%     a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
%     at (xmax,ymin) and so on. 
% 
%     ymin (PLFLT, input) :    Defines the "grid" coordinates.  The data
%     a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
%     at (xmax,ymin) and so on. 
% 
%     ymax (PLFLT, input) :    Defines the "grid" coordinates.  The data
%     a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
%     at (xmax,ymin) and so on. 
% 
%     shade_min (PLFLT, input) :      Defines the lower end of the interval to
%     be shaded. If shade_max <= shade_min, plshade1 does nothing. 
% 
%     shade_max (PLFLT, input) :      Defines the upper end of the interval to
%     be shaded. If shade_max <= shade_min, plshade1 does nothing. 
% 
%     sh_cmap (PLINT, input) :    Defines color map. 
% 
%     sh_color (PLFLT, input) :     Defines color map index if cmap0 or color
%     map input value (ranging from 0. to 1.) if cmap1. 
% 
%     sh_width (PLINT, input) :     Defines width used by the fill pattern. 
% 
%     min_color (PLINT, input) :      Defines pen color, width used by the
%     boundary of shaded region. The min values are used for the
%     shade_min boundary, and the max values are used on the shade_max
%     boundary.  Set color and width to zero for no plotted boundaries. 
% 
%     min_width (PLINT, input) :      Defines pen color, width used by the
%     boundary of shaded region. The min values are used for the
%     shade_min boundary, and the max values are used on the shade_max
%     boundary.  Set color and width to zero for no plotted boundaries. 
% 
%     max_color (PLINT, input) :      Defines pen color, width used by the
%     boundary of shaded region. The min values are used for the
%     shade_min boundary, and the max values are used on the shade_max
%     boundary.  Set color and width to zero for no plotted boundaries. 
% 
%     max_width (PLINT, input) :      Defines pen color, width used by the
%     boundary of shaded region. The min values are used for the
%     shade_min boundary, and the max values are used on the shade_max
%     boundary.  Set color and width to zero for no plotted boundaries. 
% 
%     fill (void (*) (PLINT, PLFLT *, PLFLT *), input) :      Routine used to
%     fill the region.  Use plfill.  Future version of plplot may have
%     other fill routines. 
% 
%     rectangular (PLBOOL, input) :    Set rectangular to true if rectangles
%     map to rectangles after coordinate transformation with pltrl. 
%     Otherwise, set rectangular to false. If rectangular is set to
%     true, plshade tries to save time by filling large rectangles. 
%     This optimization fails if the coordinate transformation distorts
%     the shape of rectangles. For example a plot in polor coordinates
%     has to have rectangular set to false. 
% 
%     pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) : 
%       Pointer to function that defines transformation between indices
%     in array z and the world coordinates (C only).    Transformation
%     functions are provided in the PLplot library: pltr0 for identity
%     mapping, and pltr1 and pltr2 for arbitrary mappings respectively
%     defined by one- and two-dimensional arrays.  In addition,
%     user-supplied routines for the transformation can be used as well.
%      Examples of all of these approaches are given in the PLplot
%     documentation. The transformation function should have the form
%     given by any of pltr0, pltr1, or pltr2. 
% 
%     pltr_data (PLPointer, input) :    Extra parameter to help pass
%     information to pltr0, pltr1, pltr2, or whatever routine that is
%     externally supplied. 
%     externally supplied. 
  plplot_octave(129, a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, xg, yg);
endfunction

function plshade2(a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, xg, yg)
% plshade2(a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, xg, yg)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(130, a, defined, left, right, bottom, top, shade_min, shade_max, sh_cmap, sh_color, sh_width, min_color, min_width, max_color, max_width, rectangular, xg, yg);
endfunction

function plshades(a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular)
% plshades(a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular)
%
%   Original PLplot call documentation:
%
% 
% plshades: Shade regions on the basis of value 
% 
% DESCRIPTION:
% 
%     Shade regions on the basis of value.  This is the high-level routine
%     for making continuous color shaded plots with cmap1 while plshade (or
%     plshade1) are used for individual shaded regions using either cmap0 or
%     cmap1. examples/c/x16c.c shows a number of examples for using this
%     function. See the following discussion of the arguments and the PLplot
%     documentation for more information.    
% 
% SYNOPSIS:
% 
% plshades(a, nx, ny, defined, xmin, xmax, ymin, ymax, clevel, nlevel, fill_width, cont_color, cont_width, fill, rectangular, pltr, pltr_data)
% 
% ARGUMENTS:
% 
%     a (PLFLT **, input) :    Contains ** pointer to array to be plotted.
%     The array must have been declared as PLFLT a[nx][ny]. 
% 
%     nx (PLINT, input) :    First dimension of array "a". 
% 
%     ny (PLINT, input) :    Second dimension of array "a". 
% 
%     defined (PLINT (*) (PLFLT, PLFLT), input) :    User function
%     specifying regions excluded from the shading plot.  This function
%     accepts x and y coordinates as input arguments and must return 0
%     if the point is in the excluded region or 1 otherwise. This
%     argument can be NULL if all the values are valid. 
% 
%     xmin (PLFLT, input) :    Defines the "grid" coordinates.  The data
%     a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
%     at (xmax,ymin) and so on.
%     (xmax,ymin) 
% 
%     xmax (PLFLT, input) :    Defines the "grid" coordinates.  The data
%     a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
%     at (xmax,ymin) and so on. 
% 
%     ymin (PLFLT, input) :    Defines the "grid" coordinates.  The data
%     a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
%     at (xmax,ymin) and so on. 
% 
%     ymax (PLFLT, input) :    Defines the "grid" coordinates.  The data
%     a[0][0] has a position of (xmin,ymin), a[nx-1][0] has a position
%     at (xmax,ymin) and so on. 
% 
%     clevel (PLFLT *, input) :     Pointer to array containing the data
%     levels corresponding to the edges of each shaded region that will
%     be plotted by this function.  To work properly the levels should
%     be monotonic. 
% 
%     nlevel (PLINT, input) :    Number of shades plus 1 (i.e., the number
%     of shade edge values in clevel). 
% 
%     fill_width (PLINT, input) :    Defines width used by the fill pattern. 
% 
%     cont_color (PLINT, input) :    Defines pen color used for contours
%     defining edges of shaded regions.  The pen color is only temporary
%     set for the contour drawing.  Set this value to zero or less if no
%     shade edge contours are wanted. 
% 
%     cont_width (PLINT, input) :    Defines pen width used for contours
%     defining edges of shaded regions.  This value may not be honored
%     by all drivers. The pen width is only temporary set for the
%     contour drawing.  Set this value to zero or less if no shade edge
%     contours are wanted. 
% 
%     fill (void (*) (PLINT, PLFLT *, PLFLT *), input) :      Routine used to
%     fill the region.  Use plfill.  Future version of PLplot may have
%     other fill routines. 
% 
%     rectangular (PLBOOL, input) :    Set rectangular to true if rectangles
%     map to rectangles after coordinate transformation with pltrl. 
%     Otherwise, set rectangular to false. If rectangular is set to
%     true, plshade tries to save time by filling large rectangles. 
%     This optimization fails if the coordinate transformation distorts
%     the shape of rectangles. For example a plot in polor coordinates
%     has to have  rectangular set to false. 
% 
%     pltr (void (*) (PLFLT, PLFLT, PLFLT *, PLFLT *, PLPointer) , input) : 
%       Pointer to function that defines transformation between indices
%     in array z and the world coordinates (C only).    Transformation
%     functions are provided in the PLplot library: pltr0 for identity
%     mapping, and pltr1 and pltr2 for arbitrary mappings respectively
%     defined by one- and two-dimensional arrays.  In addition,
%     user-supplied routines for the transformation can be used as well.
%      Examples of all of these approaches are given in the PLplot
%     documentation. The transformation function should have the form
%     given by any of pltr0, pltr1, or pltr2. 
% 
%     pltr_data (PLPointer, input) :    Extra parameter to help pass
%     information to pltr0, pltr1, pltr2, or whatever routine that is
%     externally supplied. 
%     externally supplied. 
  plplot_octave(131, a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular);
endfunction

function plshades1(a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, xg, yg)
% plshades1(a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, xg, yg)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(132, a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, xg, yg);
endfunction

function plshades2(a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, xg, yg)
% plshades2(a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, xg, yg)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(133, a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, xg, yg);
endfunction

function plshadesx(a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, tr)
% plshadesx(a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, tr)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(134, a, left, right, bottom, top, clevel, fill_width, cont_color, cont_width, rectangular, tr);
endfunction

function id = plstripc(xspec, yspec, xmin, xmax, xjump, ymin, ymax, xlpos, ylpos, y_ascl, acc, colbox, collab, colline, styline, legline1, legline2, legline3, legline4, labx, laby, labtop)
% id = plstripc(xspec, yspec, xmin, xmax, xjump, ymin, ymax, xlpos, ylpos, y_ascl, acc, colbox, collab, colline, styline, legline1, legline2, legline3, legline4, labx, laby, labtop)
%
%   Original PLplot call documentation:
%
% 
% plstripc: Create a 4-pen stripchart 
% 
% DESCRIPTION:
% 
%     Create a 4-pen stripchart, to be used afterwards by plstripa
% 
% SYNOPSIS:
% 
% plstripc(id, xspec, yspec, xmin, xmax, xjump, ymin, ymax, xlpos, ylpos, y_ascl, acc, colbox, collab, colline, styline, legline[], labx, laby, labtop)
% 
% ARGUMENTS:
% 
%     id (PLINT *, output) :    Identification number of stripchart to use
%     on plstripa and plstripd. 
% 
%     xspec (char *, input) :    X-axis specification as in plbox. 
% 
%     yspec (char *, input) :    Y-axis specification as in plbox. 
% 
%     xmin (PLFLT, input) :    Initial coordinates of plot box; they will
%     change as data are added. 
% 
%     xmax (PLFLT, input) :    Initial coordinates of plot box; they will
%     change as data are added. 
% 
%     xjump (PLFLT, input) :    When x attains xmax, the length of the plot
%     is multiplied by the factor (1 + 
%     xjump). 
% 
%     ymin (PLFLT, input) :    Initial coordinates of plot box; they will
%     change as data are added. 
% 
%     ymax (PLFLT, input) :    Initial coordinates of plot box; they will
%     change as data are added. 
% 
%     xlpos (PLFLT, input) :    X legend box position (range from 0 to 1). 
% 
%     ylpos (PLFLT, input) :    Y legend box position (range from 0 to 1). 
% 
%     y_ascl (PLBOOL, input) :    Autoscale y between x jumps if y_ascl is
%     true, otherwise not. 
% 
%     acc (PLBOOL, input) :    Accumulate strip plot if acc is true,
%     otherwise slide display. 
% 
%     colbox (PLINT, input) :    Plot box color index (cmap0). 
% 
%     collab (PLINT, input) :    Legend color index (cmap0). 
% 
%     colline (PLINT *, input) :      Pointer to array with color indices
%     (cmap0) for the 4 pens. 
% 
%     styline (PLINT *, input) :      Pointer to array with line styles for
%     the 4 pens. 
% 
%     legline (char **, input) :      Pointer to character array containing
%     legends for the 4 pens. 
% 
%     labx (char *, input) :    X-axis label. 
% 
%     laby (char *, input) :    Y-axis label. 
% 
%     labtop (char *, input) :    Plot title. 
%     labtop (char *, input) :    Plot title. 
  id = plplot_octave(135, xspec, yspec, xmin, xmax, xjump, ymin, ymax, xlpos, ylpos, y_ascl, acc, colbox, collab, colline, styline, legline1, legline2, legline3, legline4, labx, laby, labtop);
endfunction

function plsurf3d(x, y, z, opt, clevel)
% plsurf3d(x, y, z, opt, clevel)
%
%   Original PLplot call documentation:
%
% 
% plsurf3d: Plot shaded 3-d surface plot 
% 
% DESCRIPTION:
% 
%     Plots a three dimensional shaded surface plot within the environment
%     set up by plw3d.  The surface is defined by the two-dimensional array
%     z[
%     nx][
%     ny], the point z[i][j] being the value of the function at (
%     x[i], 
%     y[j]).  Note that the points in arrays x and y do not need to be
%     equally spaced, but must be stored in ascending order. For further
%     details see the PLplot documentation. 
% 
% SYNOPSIS:
% 
% plsurf3d(x, y, z, nx, ny, opt, clevel, nlevel)
% 
% ARGUMENTS:
% 
%     x (PLFLT *, input) :    Pointer to set of x coordinate values at which
%     the function is evaluated. 
% 
%     y (PLFLT *, input) :    Pointer to set of y coordinate values at which
%     the function is evaluated. 
% 
%     z (PLFLT **, input) :    Pointer to a vectored two-dimensional array
%     with set of function values. 
% 
%     nx (PLINT, input) :    Number of x values at which function is
%     evaluated. 
% 
%     ny (PLINT, input) :    Number of y values at which function is
%     evaluated. 
% 
%     opt (PLINT, input) :    Determines the way in which the surface is
%     represented. To specify more than one option just add the options,
%     e.g. FACETED + SURF_CONT opt=FACETED: Network of lines is drawn
%     connecting points at which function is defined. 
%         opt=BASE_CONT: A contour plot is drawn at the base XY plane
%         using parameters 
%     nlevel and 
%     clevel. 
%         opt=SURF_CONT: A contour plot is drawn at the surface plane
%         using parameters 
%     nlevel and 
%     clevel. 
%         opt=DRAW_SIDES: draws a curtain between the base XY plane and
%         the borders of the plotted function. 
%         opt=MAG_COLOR: the surface is colored according to the value
%         of Z; if MAG_COLOR is not used, then the default the surface
%         is colored according to the intensity of the reflected light
%         in the surface from a light source whose position is set using
%         pllightsource. 
% 
% 
%     clevel (PLFLT *, input) :     Pointer to the array that defines the
%     contour level spacing. 
% 
%     nlevel (PLINT, input) :    Number of elements in the clevel array. 
%     nlevel (PLINT, input) :    Number of elements in the clevel array. 
  plplot_octave(136, x, y, z, opt, clevel);
endfunction

function plClearOpts()
% plClearOpts()
%
% Clear external option table info structure.  
  plplot_octave(137);
endfunction

function retval = plGetFlt(s)
% retval = plGetFlt(s)
%
% Prompts human to input a float in response to given message.  
  retval = plplot_octave(138, s);
endfunction

function retval = plGetInt(s)
% retval = plGetInt(s)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  retval = plplot_octave(139, s);
endfunction

function plOptUsage()
% plOptUsage()
%
% Print usage & syntax message.  
  plplot_octave(140);
endfunction

function plResetOpts()
% plResetOpts()
%
% Reset external option table info structure.  
  plplot_octave(141);
endfunction

function retval = plSetOpt(opt, optarg)
% retval = plSetOpt(opt, optarg)
%
% Process input strings, treating them as an option and argument pair.  
  retval = plplot_octave(142, opt, optarg);
endfunction

function plSetUsage(program_string, usage_string)
% plSetUsage(program_string, usage_string)
%
% Set the strings used in usage and syntax messages.  
  plplot_octave(143, program_string, usage_string);
endfunction

function plarrows(u, v, x, y, scale, dx, dy)
% plarrows(u, v, x, y, scale, dx, dy)
%
% No online help available. Help me, write and submit the documentation, or at least write a one line descriptive text.
  plplot_octave(144, u, v, x, y, scale, dx, dy);
endfunction

function pldid2pc(xmin, ymin, xmax, ymax)
% pldid2pc(xmin, ymin, xmax, ymax)
%
% Converts input values from relative device coordinates to relative plot  coordinates.  
  plplot_octave(145, xmin, ymin, xmax, ymax);
endfunction

function pldip2dc(xmin, ymin, xmax, ymax)
% pldip2dc(xmin, ymin, xmax, ymax)
%
% Converts input values from relative plot coordinates to relative  device coordinates.  
  plplot_octave(146, xmin, ymin, xmax, ymax);
endfunction

function plsError(errcode, errmsg)
% plsError(errcode, errmsg)
%
% Set the variables to be used for storing error info
  plplot_octave(147, errcode, errmsg);
endfunction

function plsxwin(window_id)
% plsxwin(window_id)
%
% Set inferior X window  
  plplot_octave(148, window_id);
endfunction

