/*
 *  MICO --- a free CORBA implementation
 *  Copyright (C) 1997-98 Kay Roemer & Arno Puder
 *
 *  This file was automatically generated. DO NOT EDIT!
 */

#include <CORBA.h>
#include <mico/throw.h>

#ifndef __CCM_H__
#define __CCM_H__





namespace Components {


typedef char* FeatureName;
typedef CORBA::String_var FeatureName_var;
typedef CORBA::String_out FeatureName_out;

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_FeatureName;

typedef StringSequenceTmpl<CORBA::String_var> NameList;
#ifdef _WINDOWS
static NameList _dummy_NameList;
#endif
typedef TSeqVar<StringSequenceTmpl<CORBA::String_var> > NameList_var;
typedef TSeqOut<StringSequenceTmpl<CORBA::String_var> > NameList_out;

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_NameList;

struct InvalidName : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  InvalidName();
  ~InvalidName();
  InvalidName( const InvalidName& s );
  InvalidName& operator=( const InvalidName& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  InvalidName *operator->() { return this; }
  InvalidName& operator*() { return *this; }
  operator InvalidName*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static InvalidName *_downcast( CORBA::Exception *ex );
  static const InvalidName *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef InvalidName InvalidName_catch;
#else
typedef ExceptVar<InvalidName> InvalidName_var;
typedef TVarOut<InvalidName> InvalidName_out;
typedef InvalidName_var InvalidName_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_InvalidName;

struct FacetDescription;
typedef TVarVar<FacetDescription> FacetDescription_var;
typedef TVarOut<FacetDescription> FacetDescription_out;


struct FacetDescription {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef FacetDescription_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  FacetDescription();
  ~FacetDescription();
  FacetDescription( const FacetDescription& s );
  FacetDescription& operator=( const FacetDescription& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  CORBA::String_var InterfaceID;
  FeatureName_var Name;
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_FacetDescription;

struct Facet;
typedef TVarVar<Facet> Facet_var;
typedef TVarOut<Facet> Facet_out;


struct Facet {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef Facet_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  Facet();
  ~Facet();
  Facet( const Facet& s );
  Facet& operator=( const Facet& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  CORBA::String_var InterfaceID;
  FeatureName_var Name;
  CORBA::Object_var ref;
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_Facet;

typedef SequenceTmpl<Facet,MICO_TID_DEF> Facets;
#ifdef _WINDOWS
static Facets _dummy_Facets;
#endif
typedef TSeqVar<SequenceTmpl<Facet,MICO_TID_DEF> > Facets_var;
typedef TSeqOut<SequenceTmpl<Facet,MICO_TID_DEF> > Facets_out;

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_Facets;

typedef SequenceTmpl<FacetDescription,MICO_TID_DEF> FacetDescriptions;
#ifdef _WINDOWS
static FacetDescriptions _dummy_FacetDescriptions;
#endif
typedef TSeqVar<SequenceTmpl<FacetDescription,MICO_TID_DEF> > FacetDescriptions_var;
typedef TSeqOut<SequenceTmpl<FacetDescription,MICO_TID_DEF> > FacetDescriptions_out;

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_FacetDescriptions;

class Navigation;
typedef Navigation *Navigation_ptr;
typedef Navigation_ptr NavigationRef;
typedef ObjVar<Navigation> Navigation_var;
typedef ObjOut<Navigation> Navigation_out;


/*
 * Base class and common definitions for interface Navigation
 */

class Navigation : 
  virtual public CORBA::Object
{
  public:
    virtual ~Navigation();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef Navigation_ptr _ptr_type;
    typedef Navigation_var _var_type;
    #endif

    static Navigation_ptr _narrow( CORBA::Object_ptr obj );
    static Navigation_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static Navigation_ptr _duplicate( Navigation_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static Navigation_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CORBA::Object_ptr provide_facet( const char* name ) = 0;
    virtual FacetDescriptions* describe_facets() = 0;
    virtual Facets* provide_all_facets() = 0;
    virtual Facets* provide_named_facets( const NameList& names ) = 0;
    virtual CORBA::Boolean same_component( CORBA::Object_ptr ref ) = 0;

  protected:
    Navigation() {};
  private:
    Navigation( const Navigation& );
    void operator=( const Navigation& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_Navigation;

// Stub for interface Navigation
class Navigation_stub:
  virtual public Navigation
{
  public:
    virtual ~Navigation_stub();
    CORBA::Object_ptr provide_facet( const char* name );
    FacetDescriptions* describe_facets();
    Facets* provide_all_facets();
    Facets* provide_named_facets( const NameList& names );
    CORBA::Boolean same_component( CORBA::Object_ptr ref );

  private:
    void operator=( const Navigation_stub& );
};

#ifndef MICO_CONF_NO_POA

class Navigation_stub_clp :
  virtual public Navigation_stub,
  virtual public PortableServer::StubBase
{
  public:
    Navigation_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~Navigation_stub_clp ();
    CORBA::Object_ptr provide_facet( const char* name );
    FacetDescriptions* describe_facets();
    Facets* provide_all_facets();
    Facets* provide_named_facets( const NameList& names );
    CORBA::Boolean same_component( CORBA::Object_ptr ref );

  protected:
    Navigation_stub_clp ();
  private:
    void operator=( const Navigation_stub_clp & );
};

#endif // MICO_CONF_NO_POA

struct Cookie;
typedef TVarVar<Cookie> Cookie_var;
typedef TVarOut<Cookie> Cookie_out;


struct Cookie {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef Cookie_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  Cookie();
  ~Cookie();
  Cookie( const Cookie& s );
  Cookie& operator=( const Cookie& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  typedef SequenceTmpl<CORBA::Octet,MICO_TID_OCTET> _CookieValue_seq;
  _CookieValue_seq CookieValue;
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_Cookie;

struct ConnectionDescription;
typedef TVarVar<ConnectionDescription> ConnectionDescription_var;
typedef TVarOut<ConnectionDescription> ConnectionDescription_out;


struct ConnectionDescription {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef ConnectionDescription_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  ConnectionDescription();
  ~ConnectionDescription();
  ConnectionDescription( const ConnectionDescription& s );
  ConnectionDescription& operator=( const ConnectionDescription& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  Cookie ck;
  CORBA::Object_var objref;
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_ConnectionDescription;

struct AlreadyConnected : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  AlreadyConnected();
  ~AlreadyConnected();
  AlreadyConnected( const AlreadyConnected& s );
  AlreadyConnected& operator=( const AlreadyConnected& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  AlreadyConnected *operator->() { return this; }
  AlreadyConnected& operator*() { return *this; }
  operator AlreadyConnected*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static AlreadyConnected *_downcast( CORBA::Exception *ex );
  static const AlreadyConnected *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef AlreadyConnected AlreadyConnected_catch;
#else
typedef ExceptVar<AlreadyConnected> AlreadyConnected_var;
typedef TVarOut<AlreadyConnected> AlreadyConnected_out;
typedef AlreadyConnected_var AlreadyConnected_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_AlreadyConnected;

struct InvalidConnection : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  InvalidConnection();
  ~InvalidConnection();
  InvalidConnection( const InvalidConnection& s );
  InvalidConnection& operator=( const InvalidConnection& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  InvalidConnection *operator->() { return this; }
  InvalidConnection& operator*() { return *this; }
  operator InvalidConnection*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static InvalidConnection *_downcast( CORBA::Exception *ex );
  static const InvalidConnection *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef InvalidConnection InvalidConnection_catch;
#else
typedef ExceptVar<InvalidConnection> InvalidConnection_var;
typedef TVarOut<InvalidConnection> InvalidConnection_out;
typedef InvalidConnection_var InvalidConnection_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_InvalidConnection;

struct NoConnection : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  NoConnection();
  ~NoConnection();
  NoConnection( const NoConnection& s );
  NoConnection& operator=( const NoConnection& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  NoConnection *operator->() { return this; }
  NoConnection& operator*() { return *this; }
  operator NoConnection*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static NoConnection *_downcast( CORBA::Exception *ex );
  static const NoConnection *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef NoConnection NoConnection_catch;
#else
typedef ExceptVar<NoConnection> NoConnection_var;
typedef TVarOut<NoConnection> NoConnection_out;
typedef NoConnection_var NoConnection_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_NoConnection;

struct ExceededConnectionLimit : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  ExceededConnectionLimit();
  ~ExceededConnectionLimit();
  ExceededConnectionLimit( const ExceededConnectionLimit& s );
  ExceededConnectionLimit& operator=( const ExceededConnectionLimit& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  ExceededConnectionLimit *operator->() { return this; }
  ExceededConnectionLimit& operator*() { return *this; }
  operator ExceededConnectionLimit*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static ExceededConnectionLimit *_downcast( CORBA::Exception *ex );
  static const ExceededConnectionLimit *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef ExceededConnectionLimit ExceededConnectionLimit_catch;
#else
typedef ExceptVar<ExceededConnectionLimit> ExceededConnectionLimit_var;
typedef TVarOut<ExceededConnectionLimit> ExceededConnectionLimit_out;
typedef ExceededConnectionLimit_var ExceededConnectionLimit_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_ExceededConnectionLimit;

struct CookieRequired : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  CookieRequired();
  ~CookieRequired();
  CookieRequired( const CookieRequired& s );
  CookieRequired& operator=( const CookieRequired& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  CookieRequired *operator->() { return this; }
  CookieRequired& operator*() { return *this; }
  operator CookieRequired*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static CookieRequired *_downcast( CORBA::Exception *ex );
  static const CookieRequired *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef CookieRequired CookieRequired_catch;
#else
typedef ExceptVar<CookieRequired> CookieRequired_var;
typedef TVarOut<CookieRequired> CookieRequired_out;
typedef CookieRequired_var CookieRequired_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_CookieRequired;

typedef SequenceTmpl<ConnectionDescription,MICO_TID_DEF> ConnectionDescriptions;
#ifdef _WINDOWS
static ConnectionDescriptions _dummy_ConnectionDescriptions;
#endif
typedef TSeqVar<SequenceTmpl<ConnectionDescription,MICO_TID_DEF> > ConnectionDescriptions_var;
typedef TSeqOut<SequenceTmpl<ConnectionDescription,MICO_TID_DEF> > ConnectionDescriptions_out;

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_ConnectionDescriptions;

class Receptacles;
typedef Receptacles *Receptacles_ptr;
typedef Receptacles_ptr ReceptaclesRef;
typedef ObjVar<Receptacles> Receptacles_var;
typedef ObjOut<Receptacles> Receptacles_out;


/*
 * Base class and common definitions for interface Receptacles
 */

class Receptacles : 
  virtual public CORBA::Object
{
  public:
    virtual ~Receptacles();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef Receptacles_ptr _ptr_type;
    typedef Receptacles_var _var_type;
    #endif

    static Receptacles_ptr _narrow( CORBA::Object_ptr obj );
    static Receptacles_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static Receptacles_ptr _duplicate( Receptacles_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static Receptacles_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual Cookie* connect( const char* name, CORBA::Object_ptr connection ) = 0;
    virtual void disconnect( const char* name, const Cookie& ck ) = 0;
    virtual ConnectionDescriptions* get_connections( const char* name ) = 0;

  protected:
    Receptacles() {};
  private:
    Receptacles( const Receptacles& );
    void operator=( const Receptacles& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_Receptacles;

// Stub for interface Receptacles
class Receptacles_stub:
  virtual public Receptacles
{
  public:
    virtual ~Receptacles_stub();
    Cookie* connect( const char* name, CORBA::Object_ptr connection );
    void disconnect( const char* name, const Cookie& ck );
    ConnectionDescriptions* get_connections( const char* name );

  private:
    void operator=( const Receptacles_stub& );
};

#ifndef MICO_CONF_NO_POA

class Receptacles_stub_clp :
  virtual public Receptacles_stub,
  virtual public PortableServer::StubBase
{
  public:
    Receptacles_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~Receptacles_stub_clp ();
    Cookie* connect( const char* name, CORBA::Object_ptr connection );
    void disconnect( const char* name, const Cookie& ck );
    ConnectionDescriptions* get_connections( const char* name );

  protected:
    Receptacles_stub_clp ();
  private:
    void operator=( const Receptacles_stub_clp & );
};

#endif // MICO_CONF_NO_POA

class Events;
typedef Events *Events_ptr;
typedef Events_ptr EventsRef;
typedef ObjVar<Events> Events_var;
typedef ObjOut<Events> Events_out;


/*
 * Base class and common definitions for interface Events
 */

class Events : 
  virtual public CORBA::Object
{
  public:
    virtual ~Events();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef Events_ptr _ptr_type;
    typedef Events_var _var_type;
    #endif

    static Events_ptr _narrow( CORBA::Object_ptr obj );
    static Events_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static Events_ptr _duplicate( Events_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static Events_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

  protected:
    Events() {};
  private:
    Events( const Events& );
    void operator=( const Events& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_Events;

// Stub for interface Events
class Events_stub:
  virtual public Events
{
  public:
    virtual ~Events_stub();
  private:
    void operator=( const Events_stub& );
};

#ifndef MICO_CONF_NO_POA

class Events_stub_clp :
  virtual public Events_stub,
  virtual public PortableServer::StubBase
{
  public:
    Events_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~Events_stub_clp ();
  protected:
    Events_stub_clp ();
  private:
    void operator=( const Events_stub_clp & );
};

#endif // MICO_CONF_NO_POA

class CCMObject;
typedef CCMObject *CCMObject_ptr;
typedef CCMObject_ptr CCMObjectRef;
typedef ObjVar<CCMObject> CCMObject_var;
typedef ObjOut<CCMObject> CCMObject_out;

class CCMHome;
typedef CCMHome *CCMHome_ptr;
typedef CCMHome_ptr CCMHomeRef;
typedef ObjVar<CCMHome> CCMHome_var;
typedef ObjOut<CCMHome> CCMHome_out;


/*
 * Base class and common definitions for interface CCMHome
 */

class CCMHome : 
  virtual public CORBA::Object
{
  public:
    virtual ~CCMHome();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef CCMHome_ptr _ptr_type;
    typedef CCMHome_var _var_type;
    #endif

    static CCMHome_ptr _narrow( CORBA::Object_ptr obj );
    static CCMHome_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static CCMHome_ptr _duplicate( CCMHome_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static CCMHome_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CORBA::Object_ptr get_component_def() = 0;
    virtual CORBA::Object_ptr get_home_def() = 0;
    virtual void remove_component( CCMObject_ptr comp ) = 0;

  protected:
    CCMHome() {};
  private:
    CCMHome( const CCMHome& );
    void operator=( const CCMHome& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_CCMHome;

// Stub for interface CCMHome
class CCMHome_stub:
  virtual public CCMHome
{
  public:
    virtual ~CCMHome_stub();
    CORBA::Object_ptr get_component_def();
    CORBA::Object_ptr get_home_def();
    void remove_component( CCMObject_ptr comp );

  private:
    void operator=( const CCMHome_stub& );
};

#ifndef MICO_CONF_NO_POA

class CCMHome_stub_clp :
  virtual public CCMHome_stub,
  virtual public PortableServer::StubBase
{
  public:
    CCMHome_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~CCMHome_stub_clp ();
    CORBA::Object_ptr get_component_def();
    CORBA::Object_ptr get_home_def();
    void remove_component( CCMObject_ptr comp );

  protected:
    CCMHome_stub_clp ();
  private:
    void operator=( const CCMHome_stub_clp & );
};

#endif // MICO_CONF_NO_POA


/*
 * Base class and common definitions for interface CCMObject
 */

class CCMObject : 
  virtual public ::Components::Navigation,
  virtual public ::Components::Receptacles,
  virtual public ::Components::Events
{
  public:
    typedef ::Components::Navigation _VCHACK__Components__Navigation;
    typedef ::Components::Receptacles _VCHACK__Components__Receptacles;
    typedef ::Components::Events _VCHACK__Components__Events;
    virtual ~CCMObject();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef CCMObject_ptr _ptr_type;
    typedef CCMObject_var _var_type;
    #endif

    static CCMObject_ptr _narrow( CORBA::Object_ptr obj );
    static CCMObject_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static CCMObject_ptr _duplicate( CCMObject_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static CCMObject_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CORBA::Object_ptr get_component_def() = 0;
    virtual CCMHome_ptr get_ccm_home() = 0;
    virtual void configuration_complete() = 0;
    virtual void remove() = 0;

  protected:
    CCMObject() {};
  private:
    CCMObject( const CCMObject& );
    void operator=( const CCMObject& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_CCMObject;

// Stub for interface CCMObject
class CCMObject_stub:
  virtual public CCMObject,
  virtual public ::Components::Navigation_stub,
  virtual public ::Components::Receptacles_stub,
  virtual public ::Components::Events_stub
{
  public:
    virtual ~CCMObject_stub();
    CORBA::Object_ptr get_component_def();
    CCMHome_ptr get_ccm_home();
    void configuration_complete();
    void remove();

  private:
    void operator=( const CCMObject_stub& );
};

#ifndef MICO_CONF_NO_POA

class CCMObject_stub_clp :
  virtual public CCMObject_stub,
  virtual public ::Components::Navigation_stub_clp,
  virtual public ::Components::Receptacles_stub_clp,
  virtual public ::Components::Events_stub_clp
{
  public:
    CCMObject_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~CCMObject_stub_clp ();
    CORBA::Object_ptr get_component_def();
    CCMHome_ptr get_ccm_home();
    void configuration_complete();
    void remove();

  protected:
    CCMObject_stub_clp ();
  private:
    void operator=( const CCMObject_stub_clp & );
};

#endif // MICO_CONF_NO_POA

struct DuplicateKeyValue : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  DuplicateKeyValue();
  ~DuplicateKeyValue();
  DuplicateKeyValue( const DuplicateKeyValue& s );
  DuplicateKeyValue& operator=( const DuplicateKeyValue& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  DuplicateKeyValue *operator->() { return this; }
  DuplicateKeyValue& operator*() { return *this; }
  operator DuplicateKeyValue*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static DuplicateKeyValue *_downcast( CORBA::Exception *ex );
  static const DuplicateKeyValue *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef DuplicateKeyValue DuplicateKeyValue_catch;
#else
typedef ExceptVar<DuplicateKeyValue> DuplicateKeyValue_var;
typedef TVarOut<DuplicateKeyValue> DuplicateKeyValue_out;
typedef DuplicateKeyValue_var DuplicateKeyValue_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_DuplicateKeyValue;

struct UnknownKeyValue : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  UnknownKeyValue();
  ~UnknownKeyValue();
  UnknownKeyValue( const UnknownKeyValue& s );
  UnknownKeyValue& operator=( const UnknownKeyValue& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  UnknownKeyValue *operator->() { return this; }
  UnknownKeyValue& operator*() { return *this; }
  operator UnknownKeyValue*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static UnknownKeyValue *_downcast( CORBA::Exception *ex );
  static const UnknownKeyValue *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef UnknownKeyValue UnknownKeyValue_catch;
#else
typedef ExceptVar<UnknownKeyValue> UnknownKeyValue_var;
typedef TVarOut<UnknownKeyValue> UnknownKeyValue_out;
typedef UnknownKeyValue_var UnknownKeyValue_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_UnknownKeyValue;

struct InvalidKey : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  InvalidKey();
  ~InvalidKey();
  InvalidKey( const InvalidKey& s );
  InvalidKey& operator=( const InvalidKey& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  InvalidKey *operator->() { return this; }
  InvalidKey& operator*() { return *this; }
  operator InvalidKey*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static InvalidKey *_downcast( CORBA::Exception *ex );
  static const InvalidKey *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef InvalidKey InvalidKey_catch;
#else
typedef ExceptVar<InvalidKey> InvalidKey_var;
typedef TVarOut<InvalidKey> InvalidKey_out;
typedef InvalidKey_var InvalidKey_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_InvalidKey;

class KeylessCCMHome;
typedef KeylessCCMHome *KeylessCCMHome_ptr;
typedef KeylessCCMHome_ptr KeylessCCMHomeRef;
typedef ObjVar<KeylessCCMHome> KeylessCCMHome_var;
typedef ObjOut<KeylessCCMHome> KeylessCCMHome_out;


/*
 * Base class and common definitions for interface KeylessCCMHome
 */

class KeylessCCMHome : 
  virtual public CORBA::Object
{
  public:
    virtual ~KeylessCCMHome();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef KeylessCCMHome_ptr _ptr_type;
    typedef KeylessCCMHome_var _var_type;
    #endif

    static KeylessCCMHome_ptr _narrow( CORBA::Object_ptr obj );
    static KeylessCCMHome_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static KeylessCCMHome_ptr _duplicate( KeylessCCMHome_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static KeylessCCMHome_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CCMObject_ptr create_component() = 0;

  protected:
    KeylessCCMHome() {};
  private:
    KeylessCCMHome( const KeylessCCMHome& );
    void operator=( const KeylessCCMHome& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_KeylessCCMHome;

// Stub for interface KeylessCCMHome
class KeylessCCMHome_stub:
  virtual public KeylessCCMHome
{
  public:
    virtual ~KeylessCCMHome_stub();
    CCMObject_ptr create_component();

  private:
    void operator=( const KeylessCCMHome_stub& );
};

#ifndef MICO_CONF_NO_POA

class KeylessCCMHome_stub_clp :
  virtual public KeylessCCMHome_stub,
  virtual public PortableServer::StubBase
{
  public:
    KeylessCCMHome_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~KeylessCCMHome_stub_clp ();
    CCMObject_ptr create_component();

  protected:
    KeylessCCMHome_stub_clp ();
  private:
    void operator=( const KeylessCCMHome_stub_clp & );
};

#endif // MICO_CONF_NO_POA

struct HomeNotFound : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  HomeNotFound();
  ~HomeNotFound();
  HomeNotFound( const HomeNotFound& s );
  HomeNotFound& operator=( const HomeNotFound& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  HomeNotFound *operator->() { return this; }
  HomeNotFound& operator*() { return *this; }
  operator HomeNotFound*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static HomeNotFound *_downcast( CORBA::Exception *ex );
  static const HomeNotFound *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef HomeNotFound HomeNotFound_catch;
#else
typedef ExceptVar<HomeNotFound> HomeNotFound_var;
typedef TVarOut<HomeNotFound> HomeNotFound_out;
typedef HomeNotFound_var HomeNotFound_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_HomeNotFound;

class HomeFinder;
typedef HomeFinder *HomeFinder_ptr;
typedef HomeFinder_ptr HomeFinderRef;
typedef ObjVar<HomeFinder> HomeFinder_var;
typedef ObjOut<HomeFinder> HomeFinder_out;


/*
 * Base class and common definitions for interface HomeFinder
 */

class HomeFinder : 
  virtual public CORBA::Object
{
  public:
    virtual ~HomeFinder();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef HomeFinder_ptr _ptr_type;
    typedef HomeFinder_var _var_type;
    #endif

    static HomeFinder_ptr _narrow( CORBA::Object_ptr obj );
    static HomeFinder_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static HomeFinder_ptr _duplicate( HomeFinder_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static HomeFinder_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CCMHome_ptr find_home_by_component_type( const char* comp_repid ) = 0;
    virtual CCMHome_ptr find_home_by_home_type( const char* home_repid ) = 0;
    virtual CCMHome_ptr find_home_by_name( const char* home_name ) = 0;

  protected:
    HomeFinder() {};
  private:
    HomeFinder( const HomeFinder& );
    void operator=( const HomeFinder& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_HomeFinder;

// Stub for interface HomeFinder
class HomeFinder_stub:
  virtual public HomeFinder
{
  public:
    virtual ~HomeFinder_stub();
    CCMHome_ptr find_home_by_component_type( const char* comp_repid );
    CCMHome_ptr find_home_by_home_type( const char* home_repid );
    CCMHome_ptr find_home_by_name( const char* home_name );

  private:
    void operator=( const HomeFinder_stub& );
};

#ifndef MICO_CONF_NO_POA

class HomeFinder_stub_clp :
  virtual public HomeFinder_stub,
  virtual public PortableServer::StubBase
{
  public:
    HomeFinder_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~HomeFinder_stub_clp ();
    CCMHome_ptr find_home_by_component_type( const char* comp_repid );
    CCMHome_ptr find_home_by_home_type( const char* home_repid );
    CCMHome_ptr find_home_by_name( const char* home_name );

  protected:
    HomeFinder_stub_clp ();
  private:
    void operator=( const HomeFinder_stub_clp & );
};

#endif // MICO_CONF_NO_POA

struct IllegalState : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  IllegalState();
  ~IllegalState();
  IllegalState( const IllegalState& s );
  IllegalState& operator=( const IllegalState& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS


  #ifdef HAVE_STD_EH
  IllegalState *operator->() { return this; }
  IllegalState& operator*() { return *this; }
  operator IllegalState*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static IllegalState *_downcast( CORBA::Exception *ex );
  static const IllegalState *_downcast( const CORBA::Exception *ex );
};

#ifdef HAVE_STD_EH
typedef IllegalState IllegalState_catch;
#else
typedef ExceptVar<IllegalState> IllegalState_var;
typedef TVarOut<IllegalState> IllegalState_out;
typedef IllegalState_var IllegalState_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_IllegalState;

class CCMContext;
typedef CCMContext *CCMContext_ptr;
typedef CCMContext_ptr CCMContextRef;
typedef ObjVar<CCMContext> CCMContext_var;
typedef ObjOut<CCMContext> CCMContext_out;


/*
 * Base class and common definitions for local interface CCMContext
 */

class CCMContext : 
  virtual public CORBA::LocalObject
{
  public:
    virtual ~CCMContext();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef CCMContext_ptr _ptr_type;
    typedef CCMContext_var _var_type;
    #endif

    static CCMContext_ptr _narrow( CORBA::Object_ptr obj );
    static CCMContext_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static CCMContext_ptr _duplicate( CCMContext_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static CCMContext_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CCMHome_ptr get_CCM_home() = 0;

  protected:
    CCMContext() {};
  private:
    CCMContext( const CCMContext& );
    void operator=( const CCMContext& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_CCMContext;


class SessionContext;
typedef SessionContext *SessionContext_ptr;
typedef SessionContext_ptr SessionContextRef;
typedef ObjVar<SessionContext> SessionContext_var;
typedef ObjOut<SessionContext> SessionContext_out;


/*
 * Base class and common definitions for local interface SessionContext
 */

class SessionContext : 
  virtual public ::Components::CCMContext
{
  public:
    typedef ::Components::CCMContext _VCHACK__Components__CCMContext;
    virtual ~SessionContext();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef SessionContext_ptr _ptr_type;
    typedef SessionContext_var _var_type;
    #endif

    static SessionContext_ptr _narrow( CORBA::Object_ptr obj );
    static SessionContext_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static SessionContext_ptr _duplicate( SessionContext_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static SessionContext_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CORBA::Object_ptr get_CCM_object() = 0;

  protected:
    SessionContext() {};
  private:
    SessionContext( const SessionContext& );
    void operator=( const SessionContext& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_SessionContext;


class ComponentBase;
typedef ComponentBase *ComponentBase_ptr;
typedef ComponentBase_ptr ComponentBaseRef;
typedef ObjVar<ComponentBase> ComponentBase_var;
typedef ObjOut<ComponentBase> ComponentBase_out;


/*
 * Base class and common definitions for local interface ComponentBase
 */

class ComponentBase : 
  virtual public CORBA::LocalObject
{
  public:
    virtual ~ComponentBase();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef ComponentBase_ptr _ptr_type;
    typedef ComponentBase_var _var_type;
    #endif

    static ComponentBase_ptr _narrow( CORBA::Object_ptr obj );
    static ComponentBase_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static ComponentBase_ptr _duplicate( ComponentBase_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static ComponentBase_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

  protected:
    ComponentBase() {};
  private:
    ComponentBase( const ComponentBase& );
    void operator=( const ComponentBase& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_ComponentBase;


class EnterpriseComponent;
typedef EnterpriseComponent *EnterpriseComponent_ptr;
typedef EnterpriseComponent_ptr EnterpriseComponentRef;
typedef ObjVar<EnterpriseComponent> EnterpriseComponent_var;
typedef ObjOut<EnterpriseComponent> EnterpriseComponent_out;


/*
 * Base class and common definitions for local interface EnterpriseComponent
 */

class EnterpriseComponent : 
  virtual public ::Components::ComponentBase
{
  public:
    typedef ::Components::ComponentBase _VCHACK__Components__ComponentBase;
    virtual ~EnterpriseComponent();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef EnterpriseComponent_ptr _ptr_type;
    typedef EnterpriseComponent_var _var_type;
    #endif

    static EnterpriseComponent_ptr _narrow( CORBA::Object_ptr obj );
    static EnterpriseComponent_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static EnterpriseComponent_ptr _duplicate( EnterpriseComponent_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static EnterpriseComponent_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

  protected:
    EnterpriseComponent() {};
  private:
    EnterpriseComponent( const EnterpriseComponent& );
    void operator=( const EnterpriseComponent& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_EnterpriseComponent;


enum CCMExceptionReason {
  SYSTEM_ERROR = 0,
  CREATE_ERROR,
  REMOVE_ERROR,
  DUPLICATE_KEY,
  FIND_ERROR,
  OBJECT_NOT_FOUND,
  NO_SUCH_ENTITY
};

typedef CCMExceptionReason& CCMExceptionReason_out;

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_CCMExceptionReason;

struct CCMException : public CORBA::UserException {
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  CCMException();
  ~CCMException();
  CCMException( const CCMException& s );
  CCMException& operator=( const CCMException& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  #ifndef HAVE_EXPLICIT_STRUCT_OPS
  CCMException();
  #endif //HAVE_EXPLICIT_STRUCT_OPS
  CCMException( CCMExceptionReason _m0 );

  #ifdef HAVE_STD_EH
  CCMException *operator->() { return this; }
  CCMException& operator*() { return *this; }
  operator CCMException*() { return this; }
  #endif // HAVE_STD_EH

  void _throwit() const;
  const char *_repoid() const;
  void _encode( CORBA::DataEncoder &en ) const;
  void _encode_any( CORBA::Any &a ) const;
  CORBA::Exception *_clone() const;
  static CCMException *_downcast( CORBA::Exception *ex );
  static const CCMException *_downcast( const CORBA::Exception *ex );
  CCMExceptionReason reason;
};

#ifdef HAVE_STD_EH
typedef CCMException CCMException_catch;
#else
typedef ExceptVar<CCMException> CCMException_var;
typedef TVarOut<CCMException> CCMException_out;
typedef CCMException_var CCMException_catch;
#endif // HAVE_STD_EH

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_CCMException;

class SessionComponent;
typedef SessionComponent *SessionComponent_ptr;
typedef SessionComponent_ptr SessionComponentRef;
typedef ObjVar<SessionComponent> SessionComponent_var;
typedef ObjOut<SessionComponent> SessionComponent_out;


/*
 * Base class and common definitions for local interface SessionComponent
 */

class SessionComponent : 
  virtual public ::Components::EnterpriseComponent
{
  public:
    typedef ::Components::EnterpriseComponent _VCHACK__Components__EnterpriseComponent;
    virtual ~SessionComponent();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef SessionComponent_ptr _ptr_type;
    typedef SessionComponent_var _var_type;
    #endif

    static SessionComponent_ptr _narrow( CORBA::Object_ptr obj );
    static SessionComponent_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static SessionComponent_ptr _duplicate( SessionComponent_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static SessionComponent_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual void set_session_context( SessionContext_ptr ctx ) = 0;
    virtual void ccm_activate() = 0;
    virtual void ccm_passivate() = 0;
    virtual void ccm_remove() = 0;

  protected:
    SessionComponent() {};
  private:
    SessionComponent( const SessionComponent& );
    void operator=( const SessionComponent& );
};

MICO_EXPORT_VAR_DECL CORBA::TypeCodeConst _tc_SessionComponent;


}


#ifndef MICO_CONF_NO_POA



namespace POA_Components {


class Navigation : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~Navigation ();
    Components::Navigation_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static Navigation * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::Object_ptr provide_facet( const char* name ) = 0;
    virtual Components::FacetDescriptions* describe_facets() = 0;
    virtual Components::Facets* provide_all_facets() = 0;
    virtual Components::Facets* provide_named_facets( const Components::NameList& names ) = 0;
    virtual CORBA::Boolean same_component( CORBA::Object_ptr ref ) = 0;

  protected:
    Navigation () {};

  private:
    Navigation (const Navigation &);
    void operator= (const Navigation &);
};

class Receptacles : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~Receptacles ();
    Components::Receptacles_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static Receptacles * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual Components::Cookie* connect( const char* name, CORBA::Object_ptr connection ) = 0;
    virtual void disconnect( const char* name, const Components::Cookie& ck ) = 0;
    virtual Components::ConnectionDescriptions* get_connections( const char* name ) = 0;

  protected:
    Receptacles () {};

  private:
    Receptacles (const Receptacles &);
    void operator= (const Receptacles &);
};

class Events : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~Events ();
    Components::Events_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static Events * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

  protected:
    Events () {};

  private:
    Events (const Events &);
    void operator= (const Events &);
};

class CCMHome : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~CCMHome ();
    Components::CCMHome_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static CCMHome * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::Object_ptr get_component_def() = 0;
    virtual CORBA::Object_ptr get_home_def() = 0;
    virtual void remove_component( Components::CCMObject_ptr comp ) = 0;

  protected:
    CCMHome () {};

  private:
    CCMHome (const CCMHome &);
    void operator= (const CCMHome &);
};

class CCMObject : 
  virtual public POA_Components::Navigation,
  virtual public POA_Components::Receptacles,
  virtual public POA_Components::Events
{
  public:
    virtual ~CCMObject ();
    Components::CCMObject_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static CCMObject * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::Object_ptr get_component_def() = 0;
    virtual Components::CCMHome_ptr get_ccm_home() = 0;
    virtual void configuration_complete() = 0;
    virtual void remove() = 0;

  protected:
    CCMObject () {};

  private:
    CCMObject (const CCMObject &);
    void operator= (const CCMObject &);
};

class KeylessCCMHome : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~KeylessCCMHome ();
    Components::KeylessCCMHome_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static KeylessCCMHome * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual Components::CCMObject_ptr create_component() = 0;

  protected:
    KeylessCCMHome () {};

  private:
    KeylessCCMHome (const KeylessCCMHome &);
    void operator= (const KeylessCCMHome &);
};

class HomeFinder : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~HomeFinder ();
    Components::HomeFinder_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static HomeFinder * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual Components::CCMHome_ptr find_home_by_component_type( const char* comp_repid ) = 0;
    virtual Components::CCMHome_ptr find_home_by_home_type( const char* home_repid ) = 0;
    virtual Components::CCMHome_ptr find_home_by_name( const char* home_name ) = 0;

  protected:
    HomeFinder () {};

  private:
    HomeFinder (const HomeFinder &);
    void operator= (const HomeFinder &);
};

}


#endif // MICO_CONF_NO_POA

void operator<<=( CORBA::Any &a, const ::Components::InvalidName &e );
void operator<<=( CORBA::Any &a, ::Components::InvalidName *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::InvalidName &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::InvalidName *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_InvalidName;

void operator<<=( CORBA::Any &_a, const ::Components::FacetDescription &_s );
void operator<<=( CORBA::Any &_a, ::Components::FacetDescription *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::Components::FacetDescription &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::Components::FacetDescription *&_s );

extern CORBA::StaticTypeInfo *_marshaller_Components_FacetDescription;

void operator<<=( CORBA::Any &_a, const ::Components::Facet &_s );
void operator<<=( CORBA::Any &_a, ::Components::Facet *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::Components::Facet &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::Components::Facet *&_s );

extern CORBA::StaticTypeInfo *_marshaller_Components_Facet;

void operator<<=( CORBA::Any &a, const Components::Navigation_ptr obj );
void operator<<=( CORBA::Any &a, Components::Navigation_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, Components::Navigation_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_Components_Navigation;

void operator<<=( CORBA::Any &_a, const ::Components::Cookie &_s );
void operator<<=( CORBA::Any &_a, ::Components::Cookie *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::Components::Cookie &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::Components::Cookie *&_s );

extern CORBA::StaticTypeInfo *_marshaller_Components_Cookie;

void operator<<=( CORBA::Any &_a, const ::Components::ConnectionDescription &_s );
void operator<<=( CORBA::Any &_a, ::Components::ConnectionDescription *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, ::Components::ConnectionDescription &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const ::Components::ConnectionDescription *&_s );

extern CORBA::StaticTypeInfo *_marshaller_Components_ConnectionDescription;

void operator<<=( CORBA::Any &a, const ::Components::AlreadyConnected &e );
void operator<<=( CORBA::Any &a, ::Components::AlreadyConnected *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::AlreadyConnected &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::AlreadyConnected *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_AlreadyConnected;

void operator<<=( CORBA::Any &a, const ::Components::InvalidConnection &e );
void operator<<=( CORBA::Any &a, ::Components::InvalidConnection *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::InvalidConnection &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::InvalidConnection *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_InvalidConnection;

void operator<<=( CORBA::Any &a, const ::Components::NoConnection &e );
void operator<<=( CORBA::Any &a, ::Components::NoConnection *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::NoConnection &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::NoConnection *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_NoConnection;

void operator<<=( CORBA::Any &a, const ::Components::ExceededConnectionLimit &e );
void operator<<=( CORBA::Any &a, ::Components::ExceededConnectionLimit *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::ExceededConnectionLimit &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::ExceededConnectionLimit *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_ExceededConnectionLimit;

void operator<<=( CORBA::Any &a, const ::Components::CookieRequired &e );
void operator<<=( CORBA::Any &a, ::Components::CookieRequired *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::CookieRequired &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::CookieRequired *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_CookieRequired;

void operator<<=( CORBA::Any &a, const Components::Receptacles_ptr obj );
void operator<<=( CORBA::Any &a, Components::Receptacles_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, Components::Receptacles_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_Components_Receptacles;

void operator<<=( CORBA::Any &a, const Components::Events_ptr obj );
void operator<<=( CORBA::Any &a, Components::Events_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, Components::Events_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_Components_Events;

void operator<<=( CORBA::Any &a, const Components::CCMHome_ptr obj );
void operator<<=( CORBA::Any &a, Components::CCMHome_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, Components::CCMHome_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_Components_CCMHome;

void operator<<=( CORBA::Any &a, const Components::CCMObject_ptr obj );
void operator<<=( CORBA::Any &a, Components::CCMObject_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, Components::CCMObject_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_Components_CCMObject;

void operator<<=( CORBA::Any &a, const ::Components::DuplicateKeyValue &e );
void operator<<=( CORBA::Any &a, ::Components::DuplicateKeyValue *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::DuplicateKeyValue &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::DuplicateKeyValue *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_DuplicateKeyValue;

void operator<<=( CORBA::Any &a, const ::Components::UnknownKeyValue &e );
void operator<<=( CORBA::Any &a, ::Components::UnknownKeyValue *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::UnknownKeyValue &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::UnknownKeyValue *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_UnknownKeyValue;

void operator<<=( CORBA::Any &a, const ::Components::InvalidKey &e );
void operator<<=( CORBA::Any &a, ::Components::InvalidKey *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::InvalidKey &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::InvalidKey *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_InvalidKey;

void operator<<=( CORBA::Any &a, const Components::KeylessCCMHome_ptr obj );
void operator<<=( CORBA::Any &a, Components::KeylessCCMHome_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, Components::KeylessCCMHome_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_Components_KeylessCCMHome;

void operator<<=( CORBA::Any &a, const ::Components::HomeNotFound &e );
void operator<<=( CORBA::Any &a, ::Components::HomeNotFound *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::HomeNotFound &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::HomeNotFound *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_HomeNotFound;

void operator<<=( CORBA::Any &a, const Components::HomeFinder_ptr obj );
void operator<<=( CORBA::Any &a, Components::HomeFinder_ptr* obj_ptr );
CORBA::Boolean operator>>=( const CORBA::Any &a, Components::HomeFinder_ptr &obj );

extern CORBA::StaticTypeInfo *_marshaller_Components_HomeFinder;

void operator<<=( CORBA::Any &a, const ::Components::IllegalState &e );
void operator<<=( CORBA::Any &a, ::Components::IllegalState *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::IllegalState &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::IllegalState *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_IllegalState;

void operator<<=( CORBA::Any &a, const ::Components::CCMExceptionReason &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::CCMExceptionReason &e );

extern CORBA::StaticTypeInfo *_marshaller_Components_CCMExceptionReason;

void operator<<=( CORBA::Any &a, const ::Components::CCMException &e );
void operator<<=( CORBA::Any &a, ::Components::CCMException *e );
CORBA::Boolean operator>>=( const CORBA::Any &a, ::Components::CCMException &e );

CORBA::Boolean operator>>=( const CORBA::Any &a, const ::Components::CCMException *&e );

extern CORBA::StaticTypeInfo *_marshaller_Components_CCMException;

void operator<<=( CORBA::Any &_a, const StringSequenceTmpl<CORBA::String_var> &_s );
void operator<<=( CORBA::Any &_a, StringSequenceTmpl<CORBA::String_var> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, StringSequenceTmpl<CORBA::String_var> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const StringSequenceTmpl<CORBA::String_var> *&_s );

void operator<<=( CORBA::Any &_a, const SequenceTmpl<Components::Facet,MICO_TID_DEF> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl<Components::Facet,MICO_TID_DEF> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl<Components::Facet,MICO_TID_DEF> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl<Components::Facet,MICO_TID_DEF> *&_s );

extern CORBA::StaticTypeInfo *_marshaller__seq_Components_Facet;

void operator<<=( CORBA::Any &_a, const SequenceTmpl<Components::FacetDescription,MICO_TID_DEF> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl<Components::FacetDescription,MICO_TID_DEF> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl<Components::FacetDescription,MICO_TID_DEF> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl<Components::FacetDescription,MICO_TID_DEF> *&_s );

extern CORBA::StaticTypeInfo *_marshaller__seq_Components_FacetDescription;

void operator<<=( CORBA::Any &_a, const SequenceTmpl<CORBA::Octet,MICO_TID_OCTET> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl<CORBA::Octet,MICO_TID_OCTET> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl<CORBA::Octet,MICO_TID_OCTET> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl<CORBA::Octet,MICO_TID_OCTET> *&_s );

void operator<<=( CORBA::Any &_a, const SequenceTmpl<Components::ConnectionDescription,MICO_TID_DEF> &_s );
void operator<<=( CORBA::Any &_a, SequenceTmpl<Components::ConnectionDescription,MICO_TID_DEF> *_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, SequenceTmpl<Components::ConnectionDescription,MICO_TID_DEF> &_s );
CORBA::Boolean operator>>=( const CORBA::Any &_a, const SequenceTmpl<Components::ConnectionDescription,MICO_TID_DEF> *&_s );

extern CORBA::StaticTypeInfo *_marshaller__seq_Components_ConnectionDescription;

#endif
