/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Node;

public class TextOptimizer {
    public static void concatenate(Compiler compiler, Node.Nodes page) throws JasperException {
        TextCatVisitor v = new TextCatVisitor(compiler);
        page.visit(v);
        v.collectText();
    }

    static class TextCatVisitor
    extends Node.Visitor {
        private int textNodeCount = 0;
        private Node.TemplateText firstTextNode = null;
        private StringBuffer textBuffer;
        private final String emptyText = new String("");

        public TextCatVisitor(Compiler compiler) {
        }

        public void doVisit(Node n) throws JasperException {
            this.collectText();
        }

        public void visit(Node.PageDirective n) throws JasperException {
        }

        public void visit(Node.TaglibDirective n) throws JasperException {
        }

        public void visitBody(Node n) throws JasperException {
            super.visitBody(n);
            this.collectText();
        }

        public void visit(Node.TemplateText n) throws JasperException {
            if (this.textNodeCount++ == 0) {
                this.firstTextNode = n;
                this.textBuffer = new StringBuffer(n.getText());
            } else {
                this.textBuffer.append(n.getText());
                n.setText(this.emptyText);
            }
        }

        private void collectText() {
            if (this.textNodeCount > 1) {
                this.firstTextNode.setText(this.textBuffer.toString());
            }
            this.textNodeCount = 0;
        }
    }
}

