'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.8/tcllib-1.8/modules/ldap/ldap.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\" Copyright (c) 2004 Jochen Loewer <loewerj@web.de>
'\"
'\" -*- tcl -*- doctools manpage
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "ldap" n 1.2 ldap "LDAP client"
.BS
.SH "NAME"
ldap \- LDAP client
.SH "SYNOPSIS"
package require \fBTcl  8.2\fR
.sp
package require \fBldap  ?1.2?\fR
.sp
\fB::ldap::connect\fR \fIhost\fR ?\fIport\fR?
.sp
\fB::ldap::secure_connect\fR \fIhost\fR ?\fIport\fR?
.sp
\fB::ldap::disconnect\fR \fIhandle\fR
.sp
\fB::ldap::bind\fR \fIhandle\fR ?\fIname\fR? ?\fIpassword\fR?
.sp
\fB::ldap::unbind\fR \fIhandle\fR
.sp
\fB::ldap::search\fR \fIhandle\fR \fIbaseObject\fR \fIfilterString\fR \fIattributes\fR
.sp
\fB::ldap::modify\fR \fIhandle\fR \fIdn\fR \fIattrValToReplace\fR ?\fIattrToDelete\fR? ?\fIattrValToAdd\fR?
.sp
\fB::ldap::add\fR \fIhandle\fR \fIdn\fR \fIattrValueTuples\fR
.sp
\fB::ldap::delete\fR \fIhandle\fR \fIdn\fR
.sp
\fB::ldap::modifyDN\fR \fIhandle\fR \fIdn\fR \fInewrdn\fR ?\fIdeleteOld\fR?
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBldap\fR package provides a simple Tcl-only client library
for the LDAPv3 protocol as specified in
RFC 2251 (\fIhttp://www.rfc-editor.org/rfc/rfc2251.txt\fR).
It works by opening the standard (or secure) LDAP socket on the
server, and then providing a Tcl API to access the LDAP protocol
commands.  All server errors are returned as Tcl errors (thrown) which
must be caught with the Tcl \fBcatch\fR command.
.SH "COMMANDS"
.TP
\fB::ldap::connect\fR \fIhost\fR ?\fIport\fR?
Opens a LDAPv3 connection to the specified \fIhost\fR, at the given
\fIport\fR, and returns a token for the connection. This token is the
\fIhandle\fR argument for all other commands. If no \fIport\fR is
specified it will default to \fB389\fR.
.sp
The command blocks until the connection has been established, or
establishment definitely failed.
.TP
\fB::ldap::secure_connect\fR \fIhost\fR ?\fIport\fR?
Like \fB::ldap::connect\fR, except that the created connection is
secured by SSL. The port defaults to \fB636\fR.  This command
depends on the availability of the package \fBTLS\fR, which is a
SSL binding for Tcl. If \fBTLS\fR is not available, then this
command will fail.
.sp
The command blocks until the connection has been established, or
establishment definitely failed.
.TP
\fB::ldap::disconnect\fR \fIhandle\fR
Closes the ldap connection refered to by the token
\fIhandle\fR. Returns the empty string as its result.
.TP
\fB::ldap::bind\fR \fIhandle\fR ?\fIname\fR? ?\fIpassword\fR?
This command authenticates the ldap connection refered to by the token
in \fIhandle\fR, with a user name and associated password. It blocks
until a response from the ldap server arrives. Its result is the empty
string.
Both \fIname\fR and \fIpasswd\fR default to the empty string if they
are not specified.
.TP
\fB::ldap::unbind\fR \fIhandle\fR
This command asks the ldap server to release the last bind done for
the connection refered to by the token in \fIhandle\fR.
.TP
\fB::ldap::search\fR \fIhandle\fR \fIbaseObject\fR \fIfilterString\fR \fIattributes\fR
This command performs a LDAP search below the \fIbaseObject\fR tree
using a complex LDAP search expression \fIfilterString\fR and returns
the specified \fIattributes\fR of all matching objects (DNs). If the
list of \fIattributes\fR was empty all attributes are returned. The
command blocks until it has received all results.
.sp
An example of a search expression is
.sp
.nf

    set filterString "|(cn=Linus*)(sn=Torvalds*)"

.fi
.sp
The return value of the command is a list of nested dictionaries. The
first level keys are object identifiers (DNs), second levels keys are
attribute names. In other words, it is in the form
.sp
.nf

    {dn1 {attr1 val1 attr2 val2 ...}} {dn2 {a1 v1 ...}} ...

.fi
.sp
.TP
\fB::ldap::modify\fR \fIhandle\fR \fIdn\fR \fIattrValToReplace\fR ?\fIattrToDelete\fR? ?\fIattrValToAdd\fR?
This command modifies the object \fIdn\fR on the ldap server we are
connected to via \fIhandle\fR. It replaces attributes with new values,
deletes attributes, and adds new attributes with new values.
All arguments are dictionaries mapping attribute names to values. The
optional arguments default to the empty dictionary, which means that
no attributes will be deleted nor added.
.RS
.TP
\fIattrValToReplace\fR dictionary (in)
No attributes will be changed if this argument is empty. The
dictionary contains the new attributes and their values. They
\fIreplace all\fR attributes known to the object.
.TP
\fIattrToDelete\fR dictionary (in)
No attributes will be deleted if this argument is empty. The
dictionary values are restrictions on the deletion. An attribute
listed here will be deleted if and only if its current value at the
server matches the value specified in the dictionary, or if the value
in the dictionary is the empty string.
.TP
\fIattrValToAdd\fR dictionary (in)
No attributes will be added if this argument is empty. The dictionary
values are the values for the new attributes.
.RE
.sp
The command blocks until all modifications have completed. Its result
is the empty string.
.TP
\fB::ldap::add\fR \fIhandle\fR \fIdn\fR \fIattrValueTuples\fR
This command creates a new object using the specified \fIdn\fR. The
attributes of the new object are set to the values in the dictionary
\fIattrValueTuples\fR (which is keyed by the attribute names).
The command blocks until the operation has completed. Its result
is the empty string.
.TP
\fB::ldap::delete\fR \fIhandle\fR \fIdn\fR
This command removes the object specified by \fIdn\fR, and all its
attributes from the server.
The command blocks until the operation has completed. Its result
is the empty string.
.TP
\fB::ldap::modifyDN\fR \fIhandle\fR \fIdn\fR \fInewrdn\fR ?\fIdeleteOld\fR?
This command moves or copies the object specified by \fIdn\fR
to a new location in the tree of object. This location is
specified by \fInewrdn\fR, a \fIrelative\fR designation.
The optional argument \fIdeleteOld\fR default to to \fBtrue\fR,
i.e. a move operation. If \fIdeleteOld\fR is not set, then the
operation will create a copy of \fIdn\fR in the new location.
The command blocks until the operation has completed. Its result
is the empty string.
.PP
.SH "EXAMPLES"
.PP
A small example, extracted from the test application coming with this
code.
.PP
.nf

    package require ldap

    # Connect, bind, add a new object, modify it in various ways

    set handle [ldap::connect localhost 9009]

    set dn "cn=Manager, o=University of Michigan, c=US"
    set pw secret

    ldap::bind $handle $dn $pw

    set dn "cn=Test User,ou=People,o=University of Michigan,c=US"

    ldap::add $handle $dn {
	objectClass OpenLDAPperson
	cn          "Test User"
	mail        "test.user@google.com"
	uid         "testuid"
	sn          User
    }

    # Replace all attributes
    ldap::modify $handle $dn [list drink icetea uid JOLO]

    # Add some more
    ldap::modify $handle $dn {} {} [list drink water  drink orangeJuice pager "+1 313 555 7671"]

    # Delete
    ldap::modify $handle $dn {} [list drink water  pager ""]

    # Move
    ldap::modifyDN $handle $dn "cn=Tester"

    # Kill the test object, and shut the connection down.
    set dn "cn=Tester,ou=People,o=University of Michigan,c=US"
    ldap::delete $handle $dn

    ldap::unbind     $handle
    ldap::disconnect $handle

.fi
.PP
And a another example, a simple query, and processing the
results.
.PP
.nf

    package require ldap
    set handle [ldap::connect ldap.acme.com 389]
    ldap::bind $handle
    set results [ldap::search $handle "o=acme,dc=com" "(uid=jdoe)" {}]
    foreach result $results {
	foreach {object attributes} $result break

	# The processing here is similar to what 'parray' does.
	# I.e. finding the longest attribute name and then
	# generating properly aligned output listing all attributes
	# and their values.

	set width 0
	set sortedAttribs {}
	foreach {type values} $attributes {
	    if {[string length $type] > $width} {
		set width [string length $type]
	    }
	    lappend sortedAttribs [list $type $values]
	}

	puts "object='$object'"

	foreach sortedAttrib  $sortedAttribs {
	    foreach {type values} $sortedAttrib break
	    foreach value $values {
		regsub -all "\\[\\x01-\\x1f\\]" $value ? value
		puts [format "  %-${width}s %s" $type $value]
	    }
	}
	puts ""
    }
    ldap::unbind $handle
    ldap::disconnect $handle

.fi
.SH "KEYWORDS"
asn, ber, directory access, internet, ldap, ldap client, protocol, rfc 2251, x.680, x.690
.SH "COPYRIGHT"
.nf
Copyright (c) 2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
Copyright (c) 2004 Jochen Loewer <loewerj@web.de>

.fi