/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web.data;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.document.XStandaloneDocumentInfo;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.DateTime;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.XMLHelper;
import com.sun.star.wizards.common.XMLProvider;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.ui.event.Task;
import com.sun.star.wizards.web.data.CGDesign;
import com.sun.star.wizards.web.data.CGExporter;
import com.sun.star.wizards.web.data.ConfigSetItem;
import java.io.File;
import java.io.FileNotFoundException;
import org.w3c.dom.Node;

public class CGDocument
extends ConfigSetItem
implements XMLProvider {
    public static final int PAGE_TYPE_UNKNOWN = 0;
    public static final int PAGE_TYPE_PAGE = 1;
    public static final int PAGE_TYPE_SLIDE = 2;
    public String cp_Title = "";
    public String cp_Description = "";
    public String cp_URL;
    public String cp_Author = "";
    public String cp_Exporter;
    public String localFilename = "";
    public String urlFilename = "";
    public String title = "";
    public String description = "";
    public String author = "";
    public DateTime createDate;
    public DateTime updateDate;
    public int sizeBytes = -1;
    public int pages = -1;
    public String dirName;
    public String appType;
    public PropertyValue[] mediaDescriptor;
    public boolean isSODocument;
    public boolean isSOOpenable;
    public boolean valid = false;
    public String targetTypeName;

    public CGDocument() {
    }

    public CGDocument(String string, XMultiServiceFactory xMultiServiceFactory, Task task) throws Exception {
        this.cp_URL = this.getSettings().getFileAccess(xMultiServiceFactory).getURL(string);
        if (task == null) {
            task = new Task("", "", 5);
        }
        this.validate(xMultiServiceFactory, task);
    }

    public void validate(XMultiServiceFactory xMultiServiceFactory, Task task) throws FileNotFoundException, IllegalArgumentException, Exception {
        if (!this.getSettings().getFileAccess(xMultiServiceFactory).exists(this.cp_URL, false)) {
            throw new FileNotFoundException("The given URL does not point to a file");
        }
        if (this.getSettings().getFileAccess(xMultiServiceFactory).isDirectory(this.cp_URL)) {
            throw new IllegalArgumentException("The given URL points to a directory");
        }
        this.mediaDescriptor = OfficeDocument.getFileMediaDecriptor(xMultiServiceFactory, this.cp_URL);
        task.advance(true);
        this.analyzeFileType(this.mediaDescriptor);
        task.advance(true);
        String string = this.getSettings().getFileAccess(xMultiServiceFactory).getPath(this.cp_URL, "");
        this.localFilename = FileAccess.getFilename(string, File.separator);
        Object object = null;
        if (this.isSODocument) {
            object = xMultiServiceFactory.createInstance("com.sun.star.document.StandaloneDocumentInfo");
            ((XStandaloneDocumentInfo)UnoRuntime.queryInterface((Class)XStandaloneDocumentInfo.class, (Object)object)).loadFromURL(this.cp_URL);
        }
        task.advance(true);
        if (!this.isSODocument && this.isSOOpenable) {
            XDesktop xDesktop = Desktop.getDesktop(xMultiServiceFactory);
            PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty("Hidden", Boolean.TRUE), Properties.createProperty("MacroExecutionMode", new Short(0)), Properties.createProperty("UpdateDocMode", new Short(0))};
            XComponent xComponent = ((XComponentLoader)UnoRuntime.queryInterface((Class)XComponentLoader.class, (Object)xDesktop)).loadComponentFromURL(this.cp_URL, "_default", 0, propertyValueArray);
            object = ((XDocumentInfoSupplier)UnoRuntime.queryInterface((Class)XDocumentInfoSupplier.class, (Object)xComponent)).getDocumentInfo();
        }
        task.advance(true);
        if (this.isSODocument || this.isSOOpenable) {
            this.title = (String)Helper.getUnoPropertyValue(object, "Title");
            this.description = (String)Helper.getUnoPropertyValue(object, "Description");
            this.author = (String)Helper.getUnoPropertyValue(object, "Author");
            this.createDate = (DateTime)Helper.getUnoPropertyValue(object, "CreationDate", DateTime.class);
            this.updateDate = (DateTime)Helper.getUnoPropertyValue(object, "ModifyDate", DateTime.class);
        } else {
            this.title = this.localFilename;
            this.updateDate = this.getSettings().getFileAccess(xMultiServiceFactory).getLastModified(this.cp_URL);
        }
        task.advance(true);
        this.valid = true;
        if (this.cp_Title.equals("")) {
            this.cp_Title = this.title;
        }
        if (this.cp_Title.equals("")) {
            this.cp_Title = this.localFilename;
        }
        if (this.cp_Description.equals("")) {
            this.cp_Description = this.description;
        }
        if (this.cp_Author.equals("")) {
            this.cp_Author = this.author;
        }
        if (this.cp_Exporter == null || this.cp_Exporter.equals("")) {
            this.cp_Exporter = (String)this.getSettings().cp_Exporters.getKey(this.getSettings().getExporters(this.appType)[0]);
        }
    }

    private void analyzeFileType(PropertyValue[] propertyValueArray) {
        if (propertyValueArray == null) {
            // empty if block
        }
        String string = propertyValueArray == null ? "" : (String)Properties.getPropertyValue(this.mediaDescriptor, "Name");
        this.appType = this.getDocType(string);
        this.isSOOpenable = this.appType == "writer" || this.appType == "calc" || this.appType == "impress" || this.appType == "draw" || this.appType == "html";
        String[] stringArray = JavaTools.ArrayoutofString(string, "_");
        this.isSODocument = stringArray.length < 2 ? false : this.isSOOpenable && stringArray[1].startsWith("Star");
    }

    private String getDocType(String string) {
        if (string.equals("")) {
            return "other";
        }
        if (string.startsWith("writer")) {
            if (string.startsWith("writer_web_HTML")) {
                return "html";
            }
            return "writer";
        }
        if (string.startsWith("calc")) {
            return "calc";
        }
        if (string.startsWith("draw")) {
            return "draw";
        }
        if (string.startsWith("impress")) {
            return "impress";
        }
        if (string.startsWith("pdf")) {
            return "pdf";
        }
        if (string.startsWith("gif") || string.startsWith("jpg")) {
            return "graphics";
        }
        if (string.startsWith("wav")) {
            return "sound";
        }
        return "other";
    }

    public Node createDOM(Node node) {
        CGDesign cGDesign = this.getSettings().cp_DefaultSession.cp_Design;
        CGExporter cGExporter = (CGExporter)this.getSettings().cp_Exporters.getElement(this.cp_Exporter);
        return XMLHelper.addElement(node, "document", new String[]{"title", "description", "author", "format", "filename", "create-date", "update-date", "pages", "size", "icon", "dir", "fn"}, new String[]{cGDesign.cp_DisplayTitle ? this.cp_Title : "", cGDesign.cp_DisplayDescription ? this.cp_Description : "", cGDesign.cp_DisplayAuthor ? this.cp_Author : "", cGDesign.cp_DisplayFileFormat ? this.getTargetTypeName(cGExporter) : "", cGDesign.cp_DisplayFilename ? this.localFilename : "", cGDesign.cp_DisplayCreateDate ? this.createDate() : "", cGDesign.cp_DisplayUpdateDate ? this.updateDate() : "", cGDesign.cp_DisplayPages && this.pages > -1 ? "" + this.pages() : "", cGDesign.cp_DisplaySize ? this.sizeKB() : "", cGDesign.cp_DisplayFormatIcon ? this.getIcon(cGExporter) : "", this.dirName, this.urlFilename});
    }

    private String updateDate() {
        if (this.updateDate == null) {
            return "";
        }
        return this.getSettings().formatter.formatCreated(this.updateDate);
    }

    private String createDate() {
        if (this.createDate == null) {
            return "";
        }
        return this.getSettings().formatter.formatCreated(this.createDate);
    }

    private String sizeKB() {
        if (this.sizeBytes == -1) {
            return "";
        }
        return this.getSettings().formatter.formatFileSize(this.sizeBytes);
    }

    private String pages() {
        return this.pages == -1 ? "" : JavaTools.replaceSubString(this.pagesTemplate(), "" + this.pages, "%NUMBER");
    }

    private String pagesTemplate() {
        int n = ((CGExporter)this.getSettings().cp_Exporters.getElement((Object)this.cp_Exporter)).cp_PageType;
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getSettings().resources[0];
            }
            case 2: {
                return this.getSettings().resources[1];
            }
        }
        return "";
    }

    private String getTargetTypeName(CGExporter cGExporter) {
        return cGExporter.targetTypeName.equals("") ? (String)Properties.getPropertyValue(this.mediaDescriptor, "UIName") : cGExporter.targetTypeName;
    }

    private String getIcon(CGExporter cGExporter) {
        return cGExporter.cp_Icon.equals("") ? this.getIcon(this.appType) : cGExporter.cp_Icon;
    }

    private String getIcon(String string) {
        return string + ".gif";
    }

    public short[] getExporter() {
        return new short[]{this.getExporterIndex()};
    }

    public void setExporter(short[] sArray) {
        CGExporter cGExporter = this.getSettings().getExporters(this.appType)[sArray[0]];
        this.cp_Exporter = (String)this.getSettings().cp_Exporters.getKey(cGExporter);
    }

    private short getExporterIndex() {
        if (this.cp_Exporter == null) {
            return 0;
        }
        Object object = this.getSettings().cp_Exporters.getElement(this.cp_Exporter);
        CGExporter[] cGExporterArray = this.getSettings().getExporters(this.appType);
        for (short s = 0; s < cGExporterArray.length; s = (short)(s + 1)) {
            if (cGExporterArray[s] != object) continue;
            return s;
        }
        return -1;
    }

    public String toString() {
        return this.localFilename;
    }
}

