/*
 * Decompiled with CFR 0.152.
 */
package writer2latex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.OfficeDocument;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import writer2latex.bibtex.DocumentSerializerImpl;
import writer2latex.latex.ConverterPalette;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xmerge.SxiDocument;

public final class Application {
    private static final String VERSION = "0.4b";
    private static final String DATE = "2006-11-03";
    private String sOutputFormat = null;
    private String toMime = null;
    private String sFileName = null;
    private String sOutPathName = null;
    private String sOutFileName = null;
    private String sConfigFileName = null;
    Config config;

    public static String getVersion() {
        return VERSION;
    }

    public static String getDate() {
        return DATE;
    }

    public static final void main(String[] stringArray) {
        try {
            Application application = new Application();
            application.parseCommandLine(stringArray);
            System.out.println("Starting conversion...");
            application.doConversion();
            System.out.println("Done!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getMessage();
            Application.showUsage(string);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null) {
                System.out.println("\n" + string);
            }
            exception.printStackTrace();
        }
    }

    private void doConversion() {
        Object object;
        boolean bl = this.sFileName.toLowerCase().endsWith(".xml");
        boolean bl2 = this.sFileName.toLowerCase().endsWith(".sxc");
        boolean bl3 = this.sFileName.toLowerCase().endsWith(".sxi");
        ConvertData convertData = null;
        OfficeDocument officeDocument = bl2 ? new SxcDocument(this.sFileName) : (bl3 ? new SxiDocument(this.sFileName) : new SxwDocument(this.sFileName));
        File file = new File(this.sFileName);
        try {
            if (!file.exists()) {
                System.out.println("I'm sorry, I can't find " + this.sFileName);
                System.exit(0);
            }
            object = new FileInputStream(file);
            officeDocument.read((InputStream)object, !bl);
        }
        catch (IOException iOException) {
            System.out.println("Oops, there was an error reading " + this.sFileName);
            iOException.printStackTrace();
        }
        try {
            if (this.toMime.equals("application/x-latex")) {
                object = new ConverterPalette((SxwDocument)officeDocument, this.sConfigFileName);
                ((ConverterPalette)object).setOutFileName(this.sOutFileName);
                convertData = ((ConverterPalette)object).convert();
            } else if (this.toMime.equals("application/x-bibtex")) {
                object = new DocumentSerializerImpl((SxwDocument)officeDocument);
                ((DocumentSerializerImpl)object).setOutFileName(this.sOutFileName);
                convertData = ((DocumentSerializerImpl)object).serialize();
            }
        }
        catch (Exception exception) {
            System.out.println("Conversion failed");
            exception.printStackTrace();
        }
        object = new File(this.sOutPathName);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        Enumeration enumeration = convertData.getDocumentEnumeration();
        while (enumeration.hasMoreElements()) {
            Document document = (Document)enumeration.nextElement();
            String string = this.sOutPathName + document.getFileName();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                document.write(fileOutputStream);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.out.println("\nThere was an error writing out file <" + string + ">");
                exception.printStackTrace();
            }
        }
    }

    private static void showUsage(String string) {
        System.out.println();
        System.out.println("This is Writer2LaTeX, Version 0.4b (2006-11-03)");
        System.out.println();
        if (string != null) {
            System.out.println(string);
        }
        System.out.println();
        System.out.println("Usage:");
        System.out.println("   java -jar <path>/writer2latex.jar <options> <document> [<output path/file name>]");
        System.out.println("where <options> is one of the following:");
        System.out.println("   [-latex] [-config <configuration file>]");
        System.out.println("   -bibtex");
    }

    private void parseCommandLine(String[] stringArray) throws IllegalArgumentException {
        String string;
        if (stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        String string2 = this.getArg(n, stringArray);
        if ("-bibtex".equals(string2)) {
            this.sOutputFormat = "BibTeX";
            this.toMime = "application/x-bibtex";
            ++n;
        } else if ("-latex".equals(string2)) {
            this.sOutputFormat = "LaTeX";
            this.toMime = "application/x-latex";
            ++n;
        } else {
            this.sOutputFormat = "LaTeX";
            this.toMime = "application/x-latex";
        }
        string2 = this.getArg(n, stringArray);
        if ("-config".equals(string2)) {
            int n2 = ++n;
            this.sConfigFileName = this.getArg(n2, stringArray);
        }
        int n3 = ++n;
        this.sFileName = this.getArg(n3, stringArray);
        if ((string = ++n < stringArray.length ? this.getArg(n, stringArray) : Misc.removeExtension(this.sFileName)).endsWith(File.separator)) {
            this.sOutPathName = string;
            this.sOutFileName = new File(this.sFileName).getName();
        } else {
            File file = new File(string);
            this.sOutPathName = file.getParent();
            this.sOutPathName = this.sOutPathName == null ? "" : this.sOutPathName + File.separator;
            this.sOutFileName = file.getName();
        }
        this.sOutFileName = Misc.removeExtension(this.sOutFileName);
        System.out.println();
        System.out.println("This is Writer2" + this.sOutputFormat + ", Version " + VERSION + " (" + DATE + ")");
        System.out.println();
    }

    private String getArg(int n, String[] stringArray) throws IllegalArgumentException {
        if (n < stringArray.length) {
            return stringArray[n];
        }
        throw new IllegalArgumentException("I'm sorry, the commandline ended abnormally");
    }
}

