/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.tools.shell.ConsoleTextArea;
import org.mozilla.javascript.tools.shell.Main;

public class JSConsole
extends JFrame
implements ActionListener {
    private File CWD;
    private JFileChooser dlg;
    private ConsoleTextArea consoleTextArea;

    public String chooseFile() {
        String string;
        if (this.CWD == null && (string = System.getProperty("user.dir")) != null) {
            this.CWD = new File(string);
        }
        if (this.CWD != null) {
            this.dlg.setCurrentDirectory(this.CWD);
        }
        this.dlg.setDialogTitle("Select a file to load");
        int n = this.dlg.showOpenDialog(this);
        if (n == 0) {
            String string2 = this.dlg.getSelectedFile().getPath();
            this.CWD = new File(this.dlg.getSelectedFile().getParent());
            return string2;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        JSConsole jSConsole = new JSConsole(stringArray);
    }

    public void createFileChooser() {
        this.dlg = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string;
                if (file.isDirectory()) {
                    return true;
                }
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                return n > 0 && n < string2.length() - 1 && (string = string2.substring(n + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(fileFilter);
    }

    public JSConsole(String[] stringArray) {
        super("Rhino JavaScript Console");
        JMenuItem jMenuItem;
        int n;
        JMenuBar jMenuBar = new JMenuBar();
        this.createFileChooser();
        String[] stringArray2 = new String[]{"Load...", "Exit"};
        String[] stringArray3 = new String[]{"Load", "Exit"};
        char[] cArray = new char[]{'L', 'X'};
        String[] stringArray4 = new String[]{"Cut", "Copy", "Paste"};
        char[] cArray2 = new char[]{'T', 'C', 'P'};
        String[] stringArray5 = new String[]{"Metal", "Windows", "Motif"};
        boolean[] blArray = new boolean[]{true, false, false};
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        JMenu jMenu3 = new JMenu("Platform");
        jMenu3.setMnemonic('P');
        for (n = 0; n < stringArray2.length; ++n) {
            jMenuItem = new JMenuItem(stringArray2[n], cArray[n]);
            jMenuItem.setActionCommand(stringArray3[n]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        for (n = 0; n < stringArray4.length; ++n) {
            jMenuItem = new JMenuItem(stringArray4[n], cArray2[n]);
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < stringArray5.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(stringArray5[i], blArray[i]);
            buttonGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(this);
            jMenu3.add(jRadioButtonMenuItem);
        }
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.consoleTextArea = new ConsoleTextArea(stringArray);
        JScrollPane jScrollPane = new JScrollPane(this.consoleTextArea);
        this.setContentPane(jScrollPane);
        this.consoleTextArea.setRows(24);
        this.consoleTextArea.setColumns(80);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.pack();
        this.setVisible(true);
        Main.setIn(this.consoleTextArea.getIn());
        Main.setOut(this.consoleTextArea.getOut());
        Main.setErr(this.consoleTextArea.getErr());
        Main.main(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = null;
        if (string.equals("Load")) {
            String string3 = this.chooseFile();
            if (string3 != null) {
                string3 = string3.replace('\\', '/');
                this.consoleTextArea.eval("load(\"" + string3 + "\");");
            }
        } else if (string.equals("Exit")) {
            System.exit(0);
        } else if (string.equals("Cut")) {
            this.consoleTextArea.cut();
        } else if (string.equals("Copy")) {
            this.consoleTextArea.copy();
        } else if (string.equals("Paste")) {
            this.consoleTextArea.paste();
        } else {
            if (string.equals("Metal")) {
                string2 = "javax.swing.plaf.metal.MetalLookAndFeel";
            } else if (string.equals("Windows")) {
                string2 = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            } else if (string.equals("Motif")) {
                string2 = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
            if (string2 != null) {
                try {
                    UIManager.setLookAndFeel(string2);
                    SwingUtilities.updateComponentTreeUI(this);
                    this.consoleTextArea.postUpdateUI();
                    this.createFileChooser();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage(), "Platform", 0);
                }
            }
        }
    }
}

