/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class OptRuntime
extends ScriptRuntime {
    private OptRuntime() {
    }

    public static Object getElem(Object object, double d, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3;
        int n = (int)d;
        if ((double)n != d) {
            String string = OptRuntime.toString(d);
            for (scriptable3 = scriptable2 = object instanceof Scriptable ? (Scriptable)object : OptRuntime.toObject(scriptable, object); scriptable3 != null; scriptable3 = scriptable3.getPrototype()) {
                Object object2 = scriptable3.get(string, scriptable2);
                if (object2 == Scriptable.NOT_FOUND) continue;
                return object2;
            }
        } else {
            while (scriptable3 != null) {
                Object object3 = scriptable3.get(n, scriptable2);
                if (object3 != Scriptable.NOT_FOUND) {
                    return object3;
                }
                scriptable3 = scriptable3.getPrototype();
            }
        }
        return Undefined.instance;
    }

    public static Object setElem(Object object, double d, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        int n = (int)d;
        Scriptable scriptable3 = scriptable2 = object instanceof Scriptable ? (Scriptable)object : OptRuntime.toObject(scriptable, object);
        if ((double)n != d) {
            String string = OptRuntime.toString(d);
            do {
                if (!scriptable3.has(string, scriptable2)) continue;
                scriptable3.put(string, scriptable2, object2);
                return object2;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2.put(string, scriptable2, object2);
        } else {
            do {
                if (!scriptable3.has(n, scriptable2)) continue;
                scriptable3.put(n, scriptable2, object2);
                return object2;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2.put(n, scriptable2, object2);
        }
        return object2;
    }

    public static Object add(Object object, double d) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (!(object instanceof String)) {
            return new Double(OptRuntime.toNumber(object) + d);
        }
        return OptRuntime.toString(object) + OptRuntime.toString(d);
    }

    public static Object add(double d, Object object) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (!(object instanceof String)) {
            return new Double(OptRuntime.toNumber(object) + d);
        }
        return OptRuntime.toString(d) + OptRuntime.toString(object);
    }

    public static boolean neq(Object object, Object object2) {
        return !OptRuntime.eq(object, object2);
    }

    public static boolean shallowNeq(Object object, Object object2) {
        return !OptRuntime.shallowEq(object, object2);
    }

    public static Boolean cmp_LTB(double d, Object object) {
        if (OptRuntime.cmp_LT(d, object) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(double d, Object object) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String)) {
            if (d != d) {
                return 0;
            }
            double d2 = OptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            return d < d2 ? 1 : 0;
        }
        return OptRuntime.toString(d).compareTo(OptRuntime.toString(object)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LTB(Object object, double d) {
        if (OptRuntime.cmp_LT(object, d) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object object, double d) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String)) {
            double d2 = OptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            if (d != d) {
                return 0;
            }
            return d2 < d ? 1 : 0;
        }
        return OptRuntime.toString(object).compareTo(OptRuntime.toString(d)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(double d, Object object) {
        if (OptRuntime.cmp_LE(d, object) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(double d, Object object) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String)) {
            if (d != d) {
                return 0;
            }
            double d2 = OptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            return d <= d2 ? 1 : 0;
        }
        return OptRuntime.toString(d).compareTo(OptRuntime.toString(object)) <= 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object object, double d) {
        if (OptRuntime.cmp_LE(object, d) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(Object object, double d) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String)) {
            double d2 = OptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            if (d != d) {
                return 0;
            }
            return d2 <= d ? 1 : 0;
        }
        return OptRuntime.toString(object).compareTo(OptRuntime.toString(d)) <= 0 ? 1 : 0;
    }

    public static int cmp(Object object, Object object2) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d = OptRuntime.toNumber(object);
            if (d != d) {
                return -1;
            }
            double d2 = OptRuntime.toNumber(object2);
            if (d2 != d2) {
                return -1;
            }
            return d < d2 ? 1 : 0;
        }
        return OptRuntime.toString(object).compareTo(OptRuntime.toString(object2)) < 0 ? 1 : 0;
    }

    public static Object callSimple(Context context, String string, Scriptable objectArray, Object[] objectArray2) throws JavaScriptException {
        Object object;
        Object object2 = null;
        Object object3 = null;
        block2: for (Object object4 = objectArray; object4 != null; object4 = object4.getParentScope()) {
            object = object4;
            do {
                if ((object2 = object.get(string, (Scriptable)object4)) == Scriptable.NOT_FOUND) continue;
                object3 = object4;
                break block2;
            } while ((object = object.getPrototype()) != null);
        }
        if (object2 == null || object2 == Scriptable.NOT_FOUND) {
            object = new Object[]{string};
            throw NativeGlobal.constructError(context, "ReferenceError", ScriptRuntime.getMessage("msg.is.not.defined", (Object[])object), objectArray);
        }
        while (object3 instanceof NativeWith) {
            object3 = object3.getPrototype();
        }
        if (object3 instanceof NativeCall) {
            object3 = ScriptableObject.getTopLevelScope((Scriptable)object3);
        }
        try {
            object = (Function)object2;
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray3 = new Object[]{OptRuntime.toString(object2)};
            throw Context.reportRuntimeError(OptRuntime.getMessage("msg.isnt.function", objectArray3));
        }
        return object.call(context, (Scriptable)objectArray, (Scriptable)object3, objectArray2);
    }

    public static Object thisGet(Scriptable scriptable, String string, Scriptable scriptable2) {
        if (scriptable == null) {
            throw Context.reportRuntimeError(OptRuntime.getMessage("msg.null.to.object", null));
        }
        Object object = scriptable.get(string, scriptable);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        for (Scriptable scriptable3 = scriptable.getPrototype(); scriptable3 != null; scriptable3 = scriptable3.getPrototype()) {
            object = scriptable3.get(string, scriptable);
            if (object == Scriptable.NOT_FOUND) continue;
            return object;
        }
        return Undefined.instance;
    }

    public static Object[] padStart(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length + n];
        System.arraycopy(objectArray, 0, objectArray2, n, objectArray.length);
        return objectArray2;
    }

    public static void initFunction(NativeFunction nativeFunction, int n, Scriptable scriptable, Context context) {
        ScriptRuntime.initFunction(context, scriptable, nativeFunction, n, false);
    }
}

