/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.FileEntry;
import org.openide.loaders.FilesSet;
import org.openide.loaders.FolderList;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public class MultiDataObject
extends DataObject {
    static final long serialVersionUID = -7750146802134210308L;
    private static final Object cookieSetLock = new Object();
    private static final Object secondaryCreationLock = new Object();
    private static final RequestProcessor firingProcessor = new RequestProcessor("MDO PropertyChange processor");
    private static final RequestProcessor delayProcessor = new RequestProcessor("MDO Firing delayer");
    private RequestProcessor.Task delayedPropFilesTask;
    private static final Object delayedPropFilesLock = new Object();
    static final ErrorManager ERR = ErrorManager.getDefault().getInstance(MultiDataObject.class.getName());
    static final boolean LOG = ERR.isLoggable(1);
    private Entry primary = this.createPrimaryEntry(this, this.getPrimaryFile());
    private HashMap secondary;
    private CookieSet cookieSet;
    boolean checked = false;
    private ChangeListener chLis;
    private static EmptyRecognizer RECOGNIZER = new EmptyRecognizer();

    public MultiDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
    }

    MultiDataObject(FileObject fo, DataLoader loader) throws DataObjectExistsException {
        super(fo, loader);
    }

    public final MultiFileLoader getMultiFileLoader() {
        DataLoader loader = this.getLoader();
        if (!(loader instanceof MultiFileLoader)) {
            return null;
        }
        return (MultiFileLoader)loader;
    }

    public Set files() {
        return new FilesSet(this);
    }

    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existReadOnlySecondary() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            Iterator it = this.getSecondary().keySet().iterator();
            while (it.hasNext()) {
                if (!((FileObject)it.next()).isReadOnly()) continue;
                return true;
            }
        }
        return false;
    }

    private HashMap checkSecondary() {
        if (!this.checked) {
            this.checkFiles(this);
            this.checked = true;
        }
        return this.getSecondary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap getSecondary() {
        Object object = secondaryCreationLock;
        synchronized (object) {
            if (this.secondary == null) {
                this.secondary = new HashMap(4);
            }
            if (LOG) {
                ERR.log("getSecondary for " + this + " is " + this.secondary);
            }
            return this.secondary;
        }
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    Object synchObjectSecondary() {
        HashMap lock = this.checkSecondary();
        if (lock == null) {
            throw new IllegalStateException("checkSecondary was null from " + this);
        }
        return this.checkSecondary();
    }

    protected Node createNodeDelegate() {
        DataNode dataNode = (DataNode)super.createNodeDelegate();
        return dataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addSecondaryEntry(Entry fe) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            this.getSecondary().put(fe.getFile(), fe);
            if (LOG) {
                ERR.log("addSecondaryEntry: " + fe + " for " + this);
            }
        }
        FolderList l = this.getFolderList();
        if (l == null) {
            this.firePropertyChangeLater("files", null, null);
        } else if (l.isCreated()) {
            this.firePropertyChangeLater("files", null, null);
        } else {
            this.firePropFilesAfterFinishing();
        }
    }

    private FolderList getFolderList() {
        FileObject parent = this.primary.file.getParent();
        if (parent != null) {
            return FolderList.find(parent, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeSecondaryEntry(Entry fe) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            this.getSecondary().remove(fe.getFile());
            if (LOG) {
                ERR.log("removeSecondaryEntry: " + fe + " for " + this);
            }
        }
        this.firePropertyChangeLater("files", null, null);
        if (fe.isImportant()) {
            this.checkConsistency(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void markSecondaryEntriesRecognized(DataLoader.RecognizedFiles recognized) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            Iterator it = this.getSecondary().keySet().iterator();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                recognized.markRecognized(fo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry registerEntry(FileObject fo) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            if (fo == null) {
                return this.primary;
            }
            if (fo.equals(this.getPrimaryFile())) {
                return this.primary;
            }
            Entry e = (Entry)this.getSecondary().get(fo);
            if (e != null) {
                return e;
            }
            e = this.createSecondaryEntry(this, fo);
            this.addSecondaryEntry(e);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeFile(FileObject fo) {
        HashMap hashMap = this.getSecondary();
        synchronized (hashMap) {
            Entry e = (Entry)this.getSecondary().get(fo);
            if (e != null) {
                this.removeSecondaryEntry(e);
            }
        }
    }

    public final Entry getPrimaryEntry() {
        return this.primary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set secondaryEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            return new HashSet(this.getSecondary().values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Entry findSecondaryEntry(FileObject fo) {
        Entry e;
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            e = (Entry)this.getSecondary().get(fo);
        }
        return e;
    }

    private void removeAllInvalid() {
        if (LOG) {
            ERR.log("removeAllInvalid, started " + this);
        }
        Iterator it = this.checkSecondary().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            FileObject fo = (FileObject)e.getKey();
            if (fo.isValid()) continue;
            it.remove();
            if (LOG) {
                ERR.log("removeAllInvalid, removed: " + fo + " for " + this);
            }
            this.firePropertyChangeLater("files", null, null);
        }
        if (LOG) {
            ERR.log("removeAllInvalid, finished " + this);
        }
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryEntry().takeLock();
    }

    private String existInFolder(FileObject fo, FileObject folder) {
        if (fo.isFolder() && this.isMergingFolders(fo, folder)) {
            return "";
        }
        String orig = fo.getName();
        String name = FileUtil.findFreeFileName((FileObject)folder, (String)orig, (String)fo.getExt());
        if (name.length() <= orig.length()) {
            return "";
        }
        return name.substring(orig.length());
    }

    boolean isMergingFolders(FileObject who, FileObject targetFolder) {
        return false;
    }

    protected DataObject handleCopy(DataFolder df) throws IOException {
        String suffix = this.existInFolder(this.getPrimaryEntry().getFile(), df.getPrimaryFile());
        if (suffix == null) {
            throw new UserCancelException();
        }
        Iterator it = this.secondaryEntries().iterator();
        while (it.hasNext()) {
            ((Entry)it.next()).copy(df.getPrimaryFile(), suffix);
        }
        FileObject fo = this.getPrimaryEntry().copy(df.getPrimaryFile(), suffix);
        try {
            return this.createMultiObject(fo);
        }
        catch (DataObjectExistsException ex) {
            return ex.getDataObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDelete() throws IOException {
        Iterator it;
        ArrayList toRemove = new ArrayList();
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            it = new ArrayList(this.getSecondary().entrySet()).iterator();
        }
        while (it.hasNext()) {
            Map.Entry e = it.next();
            ((Entry)e.getValue()).delete();
            toRemove.add(e.getKey());
        }
        object = this.synchObjectSecondary();
        synchronized (object) {
            Object[] objects = toRemove.toArray();
            for (int i = 0; i < objects.length; ++i) {
                this.getSecondary().remove(objects[i]);
                if (!LOG) continue;
                ERR.log("  handleDelete, removed entry: " + objects[i]);
            }
        }
        this.getPrimaryEntry().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleRename(String name) throws IOException {
        Iterator it;
        this.getPrimaryEntry().changeFile(this.getPrimaryEntry().rename(name));
        HashMap<FileObject, Entry> add = null;
        ArrayList toRemove = new ArrayList();
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            it = new ArrayList(this.getSecondary().entrySet()).iterator();
        }
        while (it.hasNext()) {
            Map.Entry e = it.next();
            FileObject fo = ((Entry)e.getValue()).rename(name);
            if (fo == null) {
                toRemove.add(e.getKey());
                continue;
            }
            if (fo.equals(e.getKey())) continue;
            if (add == null) {
                add = new HashMap<FileObject, Entry>();
            }
            Entry entry = (Entry)e.getValue();
            entry.changeFile(fo);
            add.put(entry.getFile(), entry);
            toRemove.add(e.getKey());
        }
        if (add != null || !toRemove.isEmpty()) {
            object = this.synchObjectSecondary();
            synchronized (object) {
                if (!toRemove.isEmpty()) {
                    Object[] objects = toRemove.toArray();
                    for (int i = 0; i < objects.length; ++i) {
                        this.getSecondary().remove(objects[i]);
                        if (!LOG) continue;
                        ERR.log("handleRename, removed: " + objects[i] + " for " + this);
                    }
                }
                if (add != null) {
                    this.getSecondary().putAll(add);
                    if (LOG) {
                        ERR.log("handleRename, putAll: " + add + " for " + this);
                    }
                }
            }
            this.firePropertyChangeLater("files", null, null);
        }
        return this.getPrimaryEntry().getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder df) throws IOException {
        String suffix = this.existInFolder(this.getPrimaryEntry().getFile(), df.getPrimaryFile());
        if (suffix == null) {
            throw new UserCancelException();
        }
        List backup = this.saveEntries();
        try {
            Iterator it;
            int count;
            HashMap<FileObject, Entry> add = null;
            ArrayList toRemove = new ArrayList();
            Object object = this.synchObjectSecondary();
            synchronized (object) {
                this.removeAllInvalid();
                ArrayList list = new ArrayList(this.getSecondary().entrySet());
                count = list.size();
                it = list.iterator();
            }
            if (LOG) {
                ERR.log("move " + this + " to " + df + " number of secondary entries: " + count);
                ERR.log("moving primary entry: " + this.getPrimaryEntry());
            }
            this.getPrimaryEntry().changeFile(this.getPrimaryEntry().move(df.getPrimaryFile(), suffix));
            if (LOG) {
                ERR.log("               moved: " + this.getPrimaryEntry().getFile());
            }
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if (LOG) {
                    ERR.log("moving entry :" + e);
                }
                FileObject fo = ((Entry)e.getValue()).move(df.getPrimaryFile(), suffix);
                if (LOG) {
                    ERR.log("  moved to   :" + fo);
                }
                if (fo == null) {
                    toRemove.add(e.getKey());
                    continue;
                }
                if (fo.equals(e.getKey())) continue;
                if (add == null) {
                    add = new HashMap<FileObject, Entry>();
                }
                Entry entry = (Entry)e.getValue();
                entry.changeFile(fo);
                add.put(entry.getFile(), entry);
                toRemove.add(e.getKey());
            }
            if (add != null || !toRemove.isEmpty()) {
                object = this.synchObjectSecondary();
                synchronized (object) {
                    if (!toRemove.isEmpty()) {
                        Object[] objects = toRemove.toArray();
                        for (int i = 0; i < objects.length; ++i) {
                            this.getSecondary().remove(objects[i]);
                            if (!LOG) continue;
                            ERR.log("handleMove, remove: " + objects[i] + " for " + this);
                        }
                    }
                    if (add != null) {
                        this.getSecondary().putAll(add);
                        if (LOG) {
                            ERR.log("handleMove, putAll: " + add + " for " + this);
                        }
                    }
                }
                this.firePropertyChangeLater("files", null, null);
            }
            if (LOG) {
                ERR.log("successfully moved " + this);
            }
            return this.getPrimaryEntry().getFile();
        }
        catch (IOException e) {
            if (LOG) {
                ERR.log("exception is here, restoring entries " + this);
                ERR.notify(1, (Throwable)e);
            }
            this.restoreEntries(backup);
            if (LOG) {
                ERR.log("entries restored " + this);
            }
            throw e;
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder df, String name) throws IOException {
        if (name == null) {
            name = FileUtil.findFreeFileName((FileObject)df.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)this.getPrimaryFile().getExt());
        }
        FileObject fo = this.getPrimaryEntry().createFromTemplate(df.getPrimaryFile(), name);
        Iterator it = this.secondaryEntries().iterator();
        while (it.hasNext()) {
            ((Entry)it.next()).createFromTemplate(df.getPrimaryFile(), name);
        }
        try {
            if (this instanceof DefaultDataObject) {
                return DataObject.find(fo);
            }
            return this.createMultiObject(fo);
        }
        catch (DataObjectExistsException ex) {
            return ex.getDataObject();
        }
    }

    protected final void setCookieSet(CookieSet s) {
        this.setCookieSet(s, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCookieSet(CookieSet s, boolean fireChange) {
        Object object = cookieSetLock;
        synchronized (object) {
            ChangeListener ch = this.getChangeListener();
            if (this.cookieSet != null) {
                this.cookieSet.removeChangeListener(ch);
            }
            s.addChangeListener(ch);
            this.cookieSet = s;
        }
        if (fireChange) {
            this.fireCookieChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        CookieSet s = this.cookieSet;
        if (s != null) {
            return s;
        }
        Object object = cookieSetLock;
        synchronized (object) {
            if (this.cookieSet != null) {
                return this.cookieSet;
            }
            this.setCookieSet(new CookieSet(), false);
            return this.cookieSet;
        }
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie cookie;
        CookieSet c = this.cookieSet;
        if (c != null && (cookie = c.getCookie(type)) != null) {
            return cookie;
        }
        return super.getCookie(type);
    }

    final void fireCookieChange() {
        this.firePropertyChange("cookie", null, null);
    }

    private void firePropertyChangeLater(final String name, final Object oldV, final Object newV) {
        firingProcessor.post(new Runnable(){

            public void run() {
                MultiDataObject.this.firePropertyChange(name, oldV, newV);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropFilesAfterFinishing() {
        Object object = delayedPropFilesLock;
        synchronized (object) {
            if (this.delayedPropFilesTask == null) {
                this.delayedPropFilesTask = delayProcessor.post(new Runnable(){

                    public void run() {
                        FolderList l = MultiDataObject.this.getFolderList();
                        if (l != null) {
                            l.waitProcessingFinished();
                        }
                        MultiDataObject.this.firePropertyChangeLater("files", null, null);
                    }
                });
            } else {
                this.delayedPropFilesTask.schedule(0);
            }
        }
    }

    final void recognizedByFolder() {
        this.checked = true;
    }

    final ChangeListener getChangeListener() {
        if (this.chLis == null) {
            this.chLis = new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    MultiDataObject.this.fireCookieChange();
                }
            };
        }
        return this.chLis;
    }

    private final Entry createPrimaryEntry(MultiDataObject obj, FileObject fo) {
        MultiFileLoader loader = this.getMultiFileLoader();
        if (loader != null) {
            return loader.createPrimaryEntry(obj, fo);
        }
        Entry e = fo.isFolder() ? new FileEntry.Folder(obj, fo) : new FileEntry(obj, fo);
        return e;
    }

    private final Entry createSecondaryEntry(MultiDataObject obj, FileObject fo) {
        MultiFileLoader loader = this.getMultiFileLoader();
        if (loader != null) {
            return loader.createSecondaryEntryImpl(obj, fo);
        }
        Entry e = fo.isFolder() ? new FileEntry.Folder(obj, fo) : new FileEntry(obj, fo);
        return e;
    }

    private final MultiDataObject createMultiObject(FileObject fo) throws DataObjectExistsException, IOException {
        MultiFileLoader loader = this.getMultiFileLoader();
        MultiDataObject obj = loader != null ? DataObjectPool.createMultiObject(loader, fo) : (MultiDataObject)this.getLoader().findDataObject(fo, RECOGNIZER);
        return obj;
    }

    private final void checkConsistency(MultiDataObject obj) {
        MultiFileLoader loader = this.getMultiFileLoader();
        if (loader != null) {
            loader.checkConsistency(obj);
        }
    }

    private final void checkFiles(MultiDataObject obj) {
        MultiFileLoader loader = this.getMultiFileLoader();
        if (loader != null) {
            loader.checkFiles(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List saveEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            LinkedList<Pair> ll = new LinkedList<Pair>();
            Iterator it = this.secondaryEntries().iterator();
            ll.add(new Pair(this.getPrimaryEntry()));
            while (it.hasNext()) {
                Entry en = (Entry)it.next();
                ll.add(new Pair(en));
            }
            return ll;
        }
    }

    final void restoreEntries(List backup) {
        Iterator it = backup.iterator();
        while (it.hasNext()) {
            Pair p = (Pair)it.next();
            if (p.entry.getFile().equals(p.file)) continue;
            if (p.file.isValid()) {
                p.entry.changeFile(p.file);
                continue;
            }
            try {
                if (p.entry.getFile().isData()) {
                    p.entry.changeFile(p.entry.getFile().copy(p.file.getParent(), p.file.getName(), p.file.getExt()));
                    continue;
                }
                FileObject fo = p.file.getParent().createFolder(p.file.getName());
                FileUtil.copyAttributes((FileObject)p.entry.getFile(), (FileObject)fo);
                p.entry.changeFile(fo);
            }
            catch (IOException e) {}
        }
    }

    void notifyFileDeleted(FileEvent fe) {
        this.removeFile(fe.getFile());
        if (fe.getFile().equals(this.getPrimaryFile())) {
            try {
                this.markInvalid0();
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    void notifyFileDataCreated(FileEvent fe) {
        this.checked = false;
    }

    private static final class EntryReplace
    implements Serializable {
        static final long serialVersionUID = -1498798537289529182L;
        private FileObject file;
        private transient Entry entry;

        public EntryReplace(FileObject fo) {
            this.file = fo;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            try {
                DataObject obj = DataObject.find(this.file);
                if (obj instanceof MultiDataObject) {
                    MultiDataObject m = (MultiDataObject)obj;
                    if (this.file.equals(m.getPrimaryFile())) {
                        this.entry = m.getPrimaryEntry();
                    } else {
                        Entry e = m.findSecondaryEntry(this.file);
                        if (e == null) {
                            throw new InvalidObjectException(obj.toString());
                        }
                        this.entry = e;
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                throw new InvalidObjectException(ex.getMessage());
            }
        }

        public Object readResolve() {
            return this.entry;
        }
    }

    public abstract class Entry
    implements Serializable {
        static final long serialVersionUID = 6024795908818133571L;
        private FileObject file;
        private transient WeakReference lock;

        protected Entry(FileObject file) {
            this.file = file;
            if (!this.isImportant()) {
                file.setImportant(false);
            }
        }

        final void changeFile(FileObject newFile) {
            FileLock l;
            if (newFile.equals(this.file)) {
                return;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "changeFile: " + newFile + " for " + this + " of " + this.getDataObject());
            }
            newFile.setImportant(this.isImportant());
            this.file = newFile;
            FileLock fileLock = l = this.lock == null ? null : (FileLock)this.lock.get();
            if (l != null && l.isValid()) {
                if (ERR.isLoggable(1)) {
                    ERR.log("releasing old lock: " + this + " was: " + l);
                }
                l.releaseLock();
            }
            this.lock = null;
        }

        public final FileObject getFile() {
            return this.file;
        }

        public final MultiDataObject getDataObject() {
            return MultiDataObject.this;
        }

        public boolean isImportant() {
            return true;
        }

        public abstract FileObject copy(FileObject var1, String var2) throws IOException;

        public abstract FileObject rename(String var1) throws IOException;

        public abstract FileObject move(FileObject var1, String var2) throws IOException;

        public abstract void delete() throws IOException;

        public abstract FileObject createFromTemplate(FileObject var1, String var2) throws IOException;

        public FileLock takeLock() throws IOException {
            FileLock l;
            FileLock fileLock = l = this.lock == null ? null : (FileLock)this.lock.get();
            if (l == null || !l.isValid()) {
                l = this.getFile().lock();
                this.lock = new WeakReference<FileLock>(l);
            }
            if (ERR.isLoggable(1)) {
                ERR.log("takeLock: " + this + " is: " + l);
            }
            return l;
        }

        public boolean isLocked() {
            FileLock l = this.lock == null ? null : (FileLock)this.lock.get();
            return l != null && l.isValid();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            return this.getFile().equals(((Entry)o).getFile());
        }

        public int hashCode() {
            return this.getFile().hashCode();
        }

        protected Object writeReplace() {
            return new EntryReplace(this.getFile());
        }
    }

    private static final class Pair {
        Entry entry;
        FileObject file;

        Pair(Entry e) {
            this.entry = e;
            this.file = e.getFile();
        }
    }

    private static class EmptyRecognizer
    implements DataLoader.RecognizedFiles {
        EmptyRecognizer() {
        }

        public void markRecognized(FileObject fo) {
        }
    }
}

