/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.netbeans.lib.gjast.test.DumpASTree;

public class ParserDiff
extends TestCase {
    public static final String srcdir = System.getProperty("test.source.dir", "test_sources");
    String diffOutput = "";

    public static Test suite() {
        TestSuite suite = new TestSuite();
        File dir = new File(srcdir);
        String[] files = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        if (files == null) {
            throw new AssertionError((Object)"srcdir directory not found");
        }
        for (int i = 0; i < files.length; ++i) {
            suite.addTest((Test)new ParserDiff(files[i]));
        }
        return suite;
    }

    public ParserDiff(String filename) {
        super(filename);
    }

    protected void runTest() {
        DumpASTree.dump(srcdir + File.separator + this.getName(), "1.4");
        boolean pass = this.diffOutputs();
        ParserDiff.assertTrue((String)this.diffOutput, (boolean)pass);
    }

    boolean diffOutputs() {
        try {
            int n;
            String oldDump = DumpASTree.dumpDir + File.separator + this.getName() + ".old";
            if (!this.hasText(oldDump)) {
                return false;
            }
            String newDump = DumpASTree.dumpDir + File.separator + this.getName() + ".new";
            if (!this.hasText(newDump)) {
                return false;
            }
            String cmd = "diff " + oldDump + " " + newDump;
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader stdin = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringWriter out = new StringWriter();
            char[] buf = new char[1024];
            while ((n = stdin.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            this.diffOutput = out.toString();
            p.waitFor();
            return p.exitValue() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean hasText(String filename) {
        if (new File(filename).length() == 0L) {
            this.diffOutput = filename + " not dumped";
            return false;
        }
        return true;
    }
}

