/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.FileEntry;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Paths;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReader
extends ClassFile
implements Symbol.Completer {
    protected static final Context.Key<ClassReader> classReaderKey;
    Annotate annotate;
    boolean verbose;
    boolean checkClassFile;
    boolean allowVariance;
    public boolean readAllOfClassFile = false;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAnnotations;
    boolean saveParameterNames;
    final Log log;
    Symtab syms;
    Types types;
    final Name.Table names;
    final Name completionFailureName;
    private final Paths paths;
    public SourceCompleter sourceCompleter = null;
    private Map<Name, Symbol.ClassSymbol> classes;
    private Map<Name, Symbol.PackageSymbol> packages;
    protected Scope typevars;
    protected String currentClassFileName = null;
    protected Symbol currentOwner = null;
    byte[] buf = new byte[65520];
    int bp;
    Object[] poolObj;
    int[] poolIdx;
    byte[] signature;
    int sigp;
    int siglimit;
    boolean sigEnterPhase = false;
    Map<String, Archive> archives = new HashMap<String, Archive>();
    private boolean filling = false;
    private Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, null);
    static final boolean fileSystemIsCaseSensitive;
    static final boolean surrogatesSupported;
    protected static final String[] classOnly;
    protected static final String[] javaOnly;
    protected static final String[] classOrJava;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tools$javac$jvm$ClassReader;

    public static ClassReader instance(Context context) {
        ClassReader instance = context.get(classReaderKey);
        if (instance == null) {
            instance = new ClassReader(context, true);
        }
        return instance;
    }

    public void init(Symtab syms) {
        this.init(syms, true);
    }

    private void init(Symtab syms, boolean definitive) {
        if (this.classes != null) {
            return;
        }
        if (definitive) {
            if (!$assertionsDisabled && this.packages != null && this.packages != syms.packages) {
                throw new AssertionError();
            }
            this.packages = syms.packages;
            if (!$assertionsDisabled && this.classes != null && this.classes != syms.classes) {
                throw new AssertionError();
            }
            this.classes = syms.classes;
        } else {
            this.packages = new HashMap<Name, Symbol.PackageSymbol>();
            this.classes = new HashMap<Name, Symbol.ClassSymbol>();
        }
        this.packages.put(syms.rootPackage.fullname, syms.rootPackage);
        syms.rootPackage.completer = this;
        this.packages.put(syms.emptyPackage.fullname, syms.emptyPackage);
        syms.emptyPackage.completer = this;
    }

    protected ClassReader(Context context, boolean definitive) {
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        if (definitive) {
            context.put(classReaderKey, this);
        }
        this.names = Name.Table.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.init(this.syms, definitive);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.annotate = Annotate.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.checkClassFile = options.get("-checkclassfile") != null;
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowVarargs = source.allowVarargs();
        this.allowAnnotations = source.allowAnnotations();
        this.saveParameterNames = options.get("save-parameter-names") != null;
        this.paths = Paths.instance(context);
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString((String)options.get("failcomplete")) : null;
        this.typevars = new Scope(this.syms.noSymbol);
    }

    private void enterMember(Symbol.ClassSymbol c, Symbol sym) {
        if ((sym.flags_field & 0x80001000L) != 4096L) {
            c.members_field.enter(sym);
        }
    }

    public BadClassFile badClassFile(String key, Object[] args) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFileName, Log.getLocalizedString(key, args));
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int bp) {
        return (char)(((this.buf[bp] & 0xFF) << 8) + (this.buf[bp + 1] & 0xFF));
    }

    int getInt(int bp) {
        return ((this.buf[bp] & 0xFF) << 24) + ((this.buf[bp + 1] & 0xFF) << 16) + ((this.buf[bp + 2] & 0xFF) << 8) + (this.buf[bp + 3] & 0xFF);
    }

    long getLong(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 8));
        try {
            return bufin.readLong();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    float getFloat(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 4));
        try {
            return bufin.readFloat();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    double getDouble(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 8));
        try {
            return bufin.readDouble();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int i = 1;
        block6: while (i < this.poolIdx.length) {
            this.poolIdx[i++] = this.bp;
            byte tag = this.buf[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.bp += len;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    continue block6;
                }
            }
            throw this.badClassFile("bad.const.pool.tag.at", new Object[]{Byte.toString(tag), Integer.toString(this.bp - 1)});
        }
    }

    Object readPool(int i) {
        Object result = this.poolObj[i];
        if (result != null) {
            return result;
        }
        int index = this.poolIdx[i];
        if (index == 0) {
            return null;
        }
        byte tag = this.buf[index];
        switch (tag) {
            case 1: {
                this.poolObj[i] = this.names.fromUtf(this.buf, index + 3, this.getChar(index + 1));
                break;
            }
            case 2: {
                throw this.badClassFile("unicode.str.not.supported", new Object[0]);
            }
            case 7: {
                this.poolObj[i] = this.readClassOrType(this.getChar(index + 1));
                break;
            }
            case 8: {
                this.poolObj[i] = this.readName(this.getChar(index + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol owner = this.readClassSymbol(this.getChar(index + 1));
                ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.getChar(index + 3));
                this.poolObj[i] = new Symbol.VarSymbol(0L, nt.name, nt.type, owner);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol owner = this.readClassSymbol(this.getChar(index + 1));
                ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.getChar(index + 3));
                this.poolObj[i] = new Symbol.MethodSymbol(0L, nt.name, nt.type, owner);
                break;
            }
            case 12: {
                this.poolObj[i] = new ClassFile.NameAndType(this.readName(this.getChar(index + 1)), this.readType(this.getChar(index + 3)));
                break;
            }
            case 3: {
                this.poolObj[i] = new Integer(this.getInt(index + 1));
                break;
            }
            case 4: {
                this.poolObj[i] = new Float(this.getFloat(index + 1));
                break;
            }
            case 5: {
                this.poolObj[i] = new Long(this.getLong(index + 1));
                break;
            }
            case 6: {
                this.poolObj[i] = new Double(this.getDouble(index + 1));
                break;
            }
            default: {
                throw this.badClassFile("bad.const.pool.tag", new Object[]{Byte.toString(tag)});
            }
        }
        return this.poolObj[i];
    }

    Type readType(int i) {
        int index = this.poolIdx[i];
        return this.sigToType(this.buf, index + 3, this.getChar(index + 1));
    }

    Object readClassOrType(int i) {
        int index = this.poolIdx[i];
        char len = this.getChar(index + 1);
        int start = index + 3;
        if (!$assertionsDisabled && this.buf[start] != 91 && this.buf[start + len - 1] == 59) {
            throw new AssertionError();
        }
        return this.buf[start] == 91 || this.buf[start + len - 1] == 59 ? this.sigToType(this.buf, start, len) : this.enterClass(this.names.fromUtf(ClassReader.internalize(this.buf, start, len)));
    }

    List<Type> readTypeParams(int i) {
        int index = this.poolIdx[i];
        return this.sigToTypeParams(this.buf, index + 3, this.getChar(index + 1));
    }

    Symbol.ClassSymbol readClassSymbol(int i) {
        return (Symbol.ClassSymbol)this.readPool(i);
    }

    Name readName(int i) {
        return (Name)this.readPool(i);
    }

    Type sigToType(Name sig) {
        return sig == null ? null : this.sigToType(sig.table.names, sig.index, sig.len);
    }

    Type sigToType(byte[] sig, int offset, int len) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + len;
        return this.sigToType();
    }

    Type sigToType() {
        switch ((char)this.signature[this.sigp]) {
            case 'T': {
                ++this.sigp;
                int start = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.sigEnterPhase ? Type.noType : this.findTypeVar(this.names.fromUtf(this.signature, start, this.sigp - 1 - start));
            }
            case '+': {
                ++this.sigp;
                Type t = this.sigToType();
                return new Type.ArgumentType(t, BoundKind.EXTENDS, this.syms.boundClass);
            }
            case '*': {
                ++this.sigp;
                return new Type.ArgumentType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
            case '-': {
                ++this.sigp;
                Type t = this.sigToType();
                return new Type.ArgumentType(t, BoundKind.SUPER, this.syms.boundClass);
            }
            case 'B': {
                ++this.sigp;
                return this.syms.byteType;
            }
            case 'C': {
                ++this.sigp;
                return this.syms.charType;
            }
            case 'D': {
                ++this.sigp;
                return this.syms.doubleType;
            }
            case 'F': {
                ++this.sigp;
                return this.syms.floatType;
            }
            case 'I': {
                ++this.sigp;
                return this.syms.intType;
            }
            case 'J': {
                ++this.sigp;
                return this.syms.longType;
            }
            case 'L': {
                int oldsigp = this.sigp;
                Type t = this.classSigToType();
                if (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    throw this.badClassFile("deprecated inner class signature syntax (please recompile from source)", new Object[0]);
                }
                return t;
            }
            case 'S': {
                ++this.sigp;
                return this.syms.shortType;
            }
            case 'V': {
                ++this.sigp;
                return this.syms.voidType;
            }
            case 'Z': {
                ++this.sigp;
                return this.syms.booleanType;
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.sigToType(), (Symbol.TypeSymbol)this.syms.arrayClass);
            }
            case '(': {
                ++this.sigp;
                List<Type> argtypes = this.sigToTypes(')');
                Type restype = this.sigToType();
                ListBuffer<Type> thrown = new ListBuffer<Type>();
                while (this.signature[this.sigp] == 94) {
                    ++this.sigp;
                    thrown.append(this.sigToType());
                }
                return new Type.MethodType(argtypes, restype, thrown.toList(), this.syms.methodClass);
            }
            case '<': {
                this.typevars = this.typevars.dup(this.currentOwner);
                Type.ForAll poly = new Type.ForAll(this.sigToTypeParams(), this.sigToType());
                this.typevars = this.typevars.leave();
                return poly;
            }
        }
        throw this.badClassFile("bad.signature", new Object[]{Convert.utf2string(this.signature, this.sigp, 10)});
    }

    Type classSigToType() {
        if (this.signature[this.sigp] != 76) {
            throw this.badClassFile("bad.class.signature", new Object[]{Convert.utf2string(this.signature, this.sigp, 10)});
        }
        ++this.sigp;
        Type outer = Type.noType;
        ByteBuffer buf = new ByteBuffer();
        block9: while (true) {
            byte c = this.signature[this.sigp++];
            switch (c) {
                case 46: 
                case 59: {
                    Symbol.ClassSymbol t = this.enterClass(this.names.fromUtf(buf.elems, 0, buf.length));
                    outer = outer == Type.noType ? t.erasure(this.types) : new Type.ClassType(outer, Type.emptyList, t);
                    if (c == 59) {
                        return outer;
                    }
                    buf.appendByte(36);
                    continue block9;
                }
                case 60: {
                    Symbol.ClassSymbol t = this.enterClass(this.names.fromUtf(buf.elems, 0, buf.length));
                    outer = new Type.ClassType(outer, this.sigToTypes('>'), t);
                    switch (this.signature[this.sigp++]) {
                        case 59: {
                            if (this.sigp < this.signature.length && this.signature[this.sigp] == 46) {
                                this.sigp += buf.length + 3;
                                buf.appendByte(36);
                                continue block9;
                            }
                            return outer;
                        }
                        case 46: {
                            buf.appendByte(36);
                            continue block9;
                        }
                    }
                    throw new AssertionError(this.signature[this.sigp - 1]);
                }
                case 47: {
                    buf.appendByte(46);
                    continue block9;
                }
            }
            buf.appendByte(c);
        }
    }

    List<Type> sigToTypes(char terminator) {
        ListBuffer<Type> types = new ListBuffer<Type>();
        while (this.signature[this.sigp] != terminator) {
            types.append(this.sigToType());
        }
        ++this.sigp;
        return types.toList();
    }

    List<Type> sigToTypeParams(Name name) {
        return this.sigToTypeParams(name.table.names, name.index, name.len);
    }

    List<Type> sigToTypeParams(byte[] sig, int offset, int len) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + len;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        ListBuffer<Type> tvars = new ListBuffer<Type>();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            int start = this.sigp;
            this.sigEnterPhase = true;
            while (this.signature[this.sigp] != 62) {
                tvars.append(this.sigToTypeParam());
            }
            this.sigEnterPhase = false;
            this.sigp = start;
            while (this.signature[this.sigp] != 62) {
                this.sigToTypeParam();
            }
            ++this.sigp;
        }
        return tvars.toList();
    }

    Type sigToTypeParam() {
        Type.TypeVar tvar;
        int start = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = this.names.fromUtf(this.signature, start, this.sigp - start);
        if (this.sigEnterPhase) {
            tvar = new Type.TypeVar(name, this.currentOwner);
            this.typevars.enter(tvar.tsym);
        } else {
            tvar = (Type.TypeVar)this.findTypeVar(name);
        }
        ListBuffer<Type> bounds = new ListBuffer<Type>();
        Type st = null;
        if (this.signature[this.sigp] == 58 && this.signature[this.sigp + 1] == 58) {
            ++this.sigp;
            st = this.syms.objectType;
        }
        while (this.signature[this.sigp] == 58) {
            ++this.sigp;
            bounds.append(this.sigToType());
        }
        if (!this.sigEnterPhase) {
            this.types.setBounds(tvar, bounds.toList(), st);
        }
        return tvar;
    }

    Type findTypeVar(Name name) {
        Scope.Entry e = this.typevars.lookup(name);
        if (e.scope != null) {
            return e.sym.type;
        }
        throw this.badClassFile("undecl.type.var", new Object[]{name});
    }

    void unrecognized(Name attrName) {
        if (this.checkClassFile) {
            this.printCCF("ccf.unrecognized.attribute", attrName);
        }
    }

    void readMemberAttr(Symbol sym, Name attrName, int attrLen) {
        if (attrName == this.names.ConstantValue) {
            Object v = this.readPool(this.nextChar());
            if ((sym.flags() & 0x10L) != 0L) {
                ((Symbol.VarSymbol)sym).constValue = v;
            }
        } else if (attrName == this.names.Code) {
            if (this.readAllOfClassFile) {
                ((Symbol.MethodSymbol)sym).code = this.readCode(sym);
            } else {
                this.bp += attrLen;
            }
        } else if (attrName == this.names.Exceptions) {
            int nexceptions = this.nextChar();
            ListBuffer<Type> thrown = new ListBuffer<Type>();
            for (int j = 0; j < nexceptions; ++j) {
                thrown.append(this.readClassSymbol((int)this.nextChar()).type);
            }
            if (sym.type.thrown().isEmpty()) {
                sym.type.asMethodType().thrown = thrown.toList();
            }
        } else if (attrName == this.names.Synthetic) {
            if (this.allowGenerics || (sym.flags_field & 0x80000000L) == 0L) {
                sym.flags_field |= 0x1000L;
            }
        } else if (attrName == this.names.Bridge) {
            sym.flags_field |= 0x80000000L;
            if (!this.allowGenerics) {
                sym.flags_field &= 0xFFFFFFFFFFFFEFFFL;
            }
        } else if (attrName == this.names.Deprecated) {
            sym.flags_field |= 0x20000L;
        } else if (attrName == this.names.Varargs) {
            if (this.allowVarargs) {
                sym.flags_field |= 0x400000000L;
            }
        } else if (attrName == this.names.Annotation) {
            if (this.allowAnnotations) {
                sym.flags_field |= 0x2000L;
            }
        } else if (attrName == this.names.Enum) {
            sym.flags_field |= 0x4000L;
        } else if (this.allowGenerics && attrName == this.names.Signature) {
            List<Type> thrown = sym.type.thrown();
            sym.type = this.readType(this.nextChar());
            if (sym.kind == 16 && sym.type.thrown().isEmpty()) {
                sym.type.asMethodType().thrown = thrown;
            }
        } else if (attrName == this.names.RuntimeVisibleAnnotations) {
            this.attachAnnotations(sym, attrLen);
        } else if (attrName == this.names.RuntimeInvisibleAnnotations) {
            this.attachAnnotations(sym, attrLen);
        } else if (attrName == this.names.RuntimeVisibleParameterAnnotations) {
            this.attachParameterAnnotations(sym, attrLen);
        } else if (attrName == this.names.RuntimeInvisibleParameterAnnotations) {
            this.attachParameterAnnotations(sym, attrLen);
        } else if (attrName == this.names.LocalVariableTable) {
            int newbp = this.bp + attrLen;
            if (this.saveParameterNames) {
                List<Symbol.VarSymbol> params = ((Symbol.MethodSymbol)sym).params();
                int firstParam = (sym.flags() & 8L) == 0L ? 1 : 0;
                int endParam = firstParam + Code.width(sym.type.argtypes());
                int numEntries = this.nextChar();
                block1: for (int i = 0; i < numEntries; ++i) {
                    char start_pc = this.nextChar();
                    char length = this.nextChar();
                    char nameIndex = this.nextChar();
                    char sigIndex = this.nextChar();
                    int register = this.nextChar();
                    if (start_pc != '\u0000' || firstParam > register || register >= endParam) continue;
                    int index = firstParam;
                    for (Symbol.VarSymbol s : params) {
                        if (index == register) {
                            s.name = this.readName(nameIndex);
                            continue block1;
                        }
                        index += Code.width(s.type);
                    }
                }
            }
            this.bp = newbp;
        } else if (attrName == this.names.AnnotationDefault) {
            this.attachAnnotationDefault(sym, attrLen);
        } else {
            this.unrecognized(attrName);
            this.bp += attrLen;
        }
    }

    void readMemberAttrs(Symbol sym) {
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            this.readMemberAttr(sym, attrName, attrLen);
        }
    }

    void readClassAttr(Symbol.ClassSymbol c, Name attrName, int attrLen) {
        if (attrName == this.names.SourceFile) {
            c.sourcefile = this.readName(this.nextChar());
        } else if (attrName == this.names.InnerClasses) {
            this.readInnerClasses(c);
        } else if (this.allowGenerics && attrName == this.names.Signature) {
            Type.ClassType ct1 = (Type.ClassType)c.type;
            ct1.typarams_field = this.readTypeParams(this.nextChar());
            ct1.supertype_field = this.sigToType();
            ListBuffer<Type> is = new ListBuffer<Type>();
            while (this.sigp != this.siglimit) {
                is.append(this.sigToType());
            }
            ct1.interfaces_field = is.toList();
        } else {
            this.readMemberAttr(c, attrName, attrLen);
        }
    }

    void readClassAttrs(Symbol.ClassSymbol c) {
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            this.readClassAttr(c, attrName, attrLen);
        }
    }

    Code readCode(Symbol owner) {
        return null;
    }

    void attachAnnotations(Symbol sym, int attrLen) {
        int numAttributes = this.nextChar();
        if (numAttributes != 0) {
            ListBuffer<CompoundAnnotationProxy> proxies = new ListBuffer<CompoundAnnotationProxy>();
            for (int i = 0; i < numAttributes; ++i) {
                proxies.append(this.readCompoundAnnotation());
            }
            this.annotate.later(new AnnotationCompleter(sym, proxies.toList()));
        }
    }

    void attachParameterAnnotations(Symbol method, int attrLen) {
        Symbol.MethodSymbol meth = (Symbol.MethodSymbol)method;
        int numParameters = this.buf[this.bp++] & 0xFF;
        List<Symbol.VarSymbol> parameters = meth.params();
        for (int i = 0; i < numParameters; ++i) {
            this.attachAnnotations((Symbol)parameters.head, -1);
            parameters = parameters.tail;
        }
    }

    void attachAnnotationDefault(Symbol sym, int attrLen) {
        Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
        Attribute value = this.readAttributeValue();
        this.annotate.later(new AnnotationDefaultCompleter(meth, value));
    }

    Type readTypeOrClassSymbol(int i) {
        if (this.buf[this.poolIdx[i]] == 7) {
            return this.readClassSymbol((int)i).type;
        }
        return this.readType(i);
    }

    Type readEnumType(int i) {
        int index = this.poolIdx[i];
        char length = this.getChar(index + 1);
        if (this.buf[index + length + 2] != 59) {
            return this.enterClass((Name)this.readName((int)i)).type;
        }
        return this.readType(i);
    }

    CompoundAnnotationProxy readCompoundAnnotation() {
        Type t = this.readTypeOrClassSymbol(this.nextChar());
        int numFields = this.nextChar();
        ListBuffer<Pair<Name, Attribute>> pairs = new ListBuffer<Pair<Name, Attribute>>();
        for (int i = 0; i < numFields; ++i) {
            Name name = this.readName(this.nextChar());
            Attribute value = this.readAttributeValue();
            pairs.append(new Pair<Name, Attribute>(name, value));
        }
        return new CompoundAnnotationProxy(t, pairs.toList());
    }

    Attribute readAttributeValue() {
        char c = (char)this.buf[this.bp++];
        switch (c) {
            case 'B': {
                return new Attribute.Constant(this.syms.byteType, this.readPool(this.nextChar()));
            }
            case 'C': {
                return new Attribute.Constant(this.syms.charType, this.readPool(this.nextChar()));
            }
            case 'D': {
                return new Attribute.Constant(this.syms.doubleType, this.readPool(this.nextChar()));
            }
            case 'F': {
                return new Attribute.Constant(this.syms.floatType, this.readPool(this.nextChar()));
            }
            case 'I': {
                return new Attribute.Constant(this.syms.intType, this.readPool(this.nextChar()));
            }
            case 'J': {
                return new Attribute.Constant(this.syms.longType, this.readPool(this.nextChar()));
            }
            case 'S': {
                return new Attribute.Constant(this.syms.shortType, this.readPool(this.nextChar()));
            }
            case 'Z': {
                return new Attribute.Constant(this.syms.booleanType, this.readPool(this.nextChar()));
            }
            case 's': {
                return new Attribute.Constant(this.syms.stringType, this.readPool(this.nextChar()).toString());
            }
            case 'e': {
                return new EnumAttributeProxy(this.readEnumType(this.nextChar()), this.readName(this.nextChar()));
            }
            case 'c': {
                return new Attribute.Class(this.types, this.readTypeOrClassSymbol(this.nextChar()));
            }
            case '[': {
                int n = this.nextChar();
                ListBuffer<Attribute> l = new ListBuffer<Attribute>();
                for (int i = 0; i < n; ++i) {
                    l.append(this.readAttributeValue());
                }
                return new ArrayAttributeProxy(l.toList());
            }
            case '@': {
                return this.readCompoundAnnotation();
            }
        }
        throw new AssertionError((Object)new StringBuffer().append("unknown annotation tag '").append(c).append("'").toString());
    }

    Symbol.VarSymbol readField() {
        long flags = this.adjustFieldFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol v = new Symbol.VarSymbol(flags, name, type, this.currentOwner);
        this.readMemberAttrs(v);
        return v;
    }

    Symbol.MethodSymbol readMethod() {
        long flags = this.adjustMethodFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        if (name == this.names.init && this.currentOwner.hasOuterInstance()) {
            type = new Type.MethodType(type.argtypes().tail, type.restype(), type.thrown(), this.syms.methodClass);
        }
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(flags, name, type, this.currentOwner);
        Symbol prevOwner = this.currentOwner;
        this.currentOwner = m;
        this.readMemberAttrs(m);
        this.currentOwner = prevOwner;
        return m;
    }

    void skipMember() {
        this.bp += 6;
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            this.bp += 2;
            int attrLen = this.nextInt();
            this.bp += attrLen;
        }
    }

    protected void enterTypevars(Type t) {
        if (t.outer().tag == 10) {
            this.enterTypevars(t.outer());
        }
        List<Type> xs = t.typarams();
        while (xs.nonEmpty()) {
            this.typevars.enter(((Type)xs.head).tsym);
            xs = xs.tail;
        }
    }

    void readClass(Symbol.ClassSymbol c) {
        int i;
        int i2;
        Symbol.ClassSymbol self;
        Type.ClassType ct = (Type.ClassType)c.type;
        c.members_field = new Scope(c);
        this.typevars = this.typevars.dup(this.currentOwner);
        if (ct.outer().tag == 10) {
            this.enterTypevars(ct.outer());
        }
        long flags = this.adjustClassFlags(this.nextChar());
        if (c.owner.kind == 1) {
            c.flags_field = flags;
        }
        if (c != (self = this.readClassSymbol(this.nextChar()))) {
            throw this.badClassFile("class.file.wrong.class", new Object[]{self.flatname});
        }
        int startbp = this.bp;
        this.nextChar();
        char interfaceCount = this.nextChar();
        this.bp += interfaceCount * 2;
        int fieldCount = this.nextChar();
        for (int i3 = 0; i3 < fieldCount; ++i3) {
            this.skipMember();
        }
        int methodCount = this.nextChar();
        for (i2 = 0; i2 < methodCount; ++i2) {
            this.skipMember();
        }
        this.readClassAttrs(c);
        if (this.readAllOfClassFile) {
            for (i2 = 1; i2 < this.poolObj.length; ++i2) {
                this.readPool(i2);
            }
            c.pool = new Pool(this.poolObj.length, this.poolObj);
        }
        this.bp = startbp;
        int n = this.nextChar();
        if (ct.supertype_field == null) {
            ct.supertype_field = n == 0 ? Type.noType : this.readClassSymbol(n).erasure(this.types);
        }
        n = this.nextChar();
        ListBuffer<Type> is = new ListBuffer<Type>();
        for (i = 0; i < n; ++i) {
            Type _inter = this.readClassSymbol(this.nextChar()).erasure(this.types);
            is.append(_inter);
        }
        if (ct.interfaces_field == null) {
            ct.interfaces_field = is.toList();
        }
        if (fieldCount != this.nextChar() && !$assertionsDisabled) {
            throw new AssertionError();
        }
        for (i = 0; i < fieldCount; ++i) {
            this.enterMember(c, this.readField());
        }
        if (methodCount != this.nextChar() && !$assertionsDisabled) {
            throw new AssertionError();
        }
        for (i = 0; i < methodCount; ++i) {
            this.enterMember(c, this.readMethod());
        }
        this.typevars = this.typevars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol c) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol outer = this.readClassSymbol(this.nextChar());
            Name name = this.readName(this.nextChar());
            if (name == null) {
                name = this.names.empty;
            }
            long flags = this.adjustClassFlags(this.nextChar());
            if (outer == null) continue;
            if (name == this.names.empty) {
                name = this.names.one;
            }
            Symbol.ClassSymbol member = this.enterClass(name, outer);
            if ((flags & 8L) == 0L) {
                ((Type.ClassType)member.type).outer_field = outer.type;
                if (member.erasure_field != null) {
                    ((Type.ClassType)member.erasure_field).outer_field = this.types.erasure(outer.type);
                }
            }
            if (c != outer) continue;
            member.flags_field = flags;
            this.enterMember(c, member);
        }
    }

    private void readClassFile(Symbol.ClassSymbol c) throws IOException {
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw this.badClassFile("illegal.start.of.class.file", new Object[0]);
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion > Target.MAX().majorVersion || majorVersion * 1000 + minorVersion < Target.MIN().majorVersion * 1000 + Target.MIN().minorVersion) {
            throw this.badClassFile("wrong.version", new Object[]{Integer.toString(majorVersion), Integer.toString(minorVersion), Integer.toString(Target.MAX().majorVersion), Integer.toString(Target.MAX().minorVersion)});
        }
        if (this.checkClassFile && majorVersion == Target.MAX().majorVersion && minorVersion > Target.MAX().minorVersion) {
            this.printCCF("found.later.version", Integer.toString(minorVersion));
        }
        this.indexPool();
        this.readClass(c);
    }

    long adjustFieldFlags(long flags) {
        return flags;
    }

    long adjustMethodFlags(long flags) {
        if ((flags & 0x40L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFFBFL;
            flags |= 0x80000000L;
            if (!this.allowGenerics) {
                flags &= 0xFFFFFFFFFFFFEFFFL;
            }
        }
        if ((flags & 0x80L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFF7FL;
            flags |= 0x400000000L;
        }
        return flags;
    }

    long adjustClassFlags(long flags) {
        return flags & 0xFFFFFFFFFFFFFFDFL;
    }

    protected static boolean isZip(String name) {
        return new File(name).isFile();
    }

    protected Archive openArchive(String dirname) throws IOException {
        Archive archive = this.archives.get(dirname);
        if (archive == null) {
            ZipFile zdir = new ZipFile(dirname);
            ListBuffer<ZipEntry> entries = new ListBuffer<ZipEntry>();
            Enumeration<? extends ZipEntry> e = zdir.entries();
            while (e.hasMoreElements()) {
                entries.append(e.nextElement());
            }
            archive = new Archive(zdir, entries.toList());
            this.archives.put(dirname, archive);
        }
        return archive;
    }

    public void close() {
        Iterator<Archive> i = this.archives.values().iterator();
        while (i.hasNext()) {
            Archive a = i.next();
            i.remove();
            try {
                a.zdir.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol owner) {
        Symbol.ClassSymbol c = new Symbol.ClassSymbol(0L, name, owner);
        c.completer = this;
        return c;
    }

    public Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol owner) {
        Name flatname = Symbol.TypeSymbol.formFlatName(name, owner);
        Symbol.ClassSymbol c = this.classes.get(flatname);
        if (c == null) {
            c = this.defineClass(name, owner);
            this.classes.put(flatname, c);
        } else if ((c.name != name || c.owner != owner) && owner.kind == 2) {
            c.owner.members().remove(c);
            c.name = name;
            c.owner = owner;
            c.fullname = Symbol.ClassSymbol.formFullName(name, owner);
        }
        return c;
    }

    public Symbol.ClassSymbol enterClass(Name flatname) {
        Symbol.ClassSymbol c = this.classes.get(flatname);
        if (c == null) {
            Name packageName = Convert.packagePart(flatname);
            if (packageName == this.names.empty) {
                packageName = this.names.emptyPackage;
            }
            c = this.defineClass(Convert.shortName(flatname), this.enterPackage(packageName));
            this.classes.put(flatname, c);
        }
        return c;
    }

    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (sym.kind == 2) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
            c.members_field = new Scope.ErrorScope(c);
            this.completeOwners(c.owner);
            this.fillIn(c);
        } else if (sym.kind == 1) {
            Symbol.PackageSymbol p = (Symbol.PackageSymbol)sym;
            this.fillIn(p);
        }
        if (!this.filling) {
            this.annotate.flush();
        }
    }

    private void completeOwners(Symbol o) {
        if (o.kind != 1) {
            this.completeOwners(o.owner);
        }
        o.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillIn(Symbol.ClassSymbol c) {
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure(c, "user-selected completion failure by class name");
        }
        this.currentOwner = c;
        FileEntry classfile = c.classfile;
        if (classfile != null) {
            String previousClassFile = this.currentClassFileName;
            InputStream s = null;
            try {
                if (!$assertionsDisabled && this.filling) {
                    throw new AssertionError((Object)new StringBuffer().append("Filling ").append(classfile.getPath()).append(" during ").append(previousClassFile).toString());
                }
                s = classfile.open();
                this.currentClassFileName = classfile.getPath();
                if (this.verbose) {
                    this.printVerbose("loading", this.currentClassFileName);
                }
                if (classfile.getName().endsWith(".class")) {
                    this.filling = true;
                    try {
                        int size = (int)classfile.length();
                        if (this.buf.length < size) {
                            this.buf = new byte[size];
                        }
                        for (int n = 0; n < size; n += s.read(this.buf, n, size - n)) {
                        }
                        s.close();
                        this.bp = 0;
                        this.readClassFile(c);
                    }
                    finally {
                        this.filling = false;
                    }
                } else {
                    this.sourceCompleter.complete(c, this.currentClassFileName, s);
                }
                return;
            }
            catch (IOException ex) {
                throw this.badClassFile("unable.to.access.file", new Object[]{ex.getMessage()});
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (IOException e) {}
                this.filling = false;
                this.currentClassFileName = previousClassFile;
            }
        }
        String fn = ClassReader.externalizeFileName(c.flatname);
        throw this.newCompletionFailure(c, Log.getLocalizedString("dot.class.not.found", new Object[]{fn}));
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.ClassSymbol c, String localized) {
        Symbol.CompletionFailure result = this.cachedCompletionFailure;
        result.sym = c;
        result.errmsg = localized;
        return result;
    }

    public Symbol.ClassSymbol loadClass(Name flatname) throws Symbol.CompletionFailure {
        boolean absent = this.classes.get(flatname) == null;
        Symbol.ClassSymbol c = this.enterClass(flatname);
        if (c.members_field == null && c.completer != null) {
            try {
                c.complete();
            }
            catch (Symbol.CompletionFailure ex) {
                if (absent) {
                    this.classes.remove(flatname);
                }
                throw ex;
            }
        }
        return c;
    }

    public boolean packageExists(Name fullname) {
        return this.enterPackage(fullname).exists();
    }

    public Symbol.PackageSymbol enterPackage(Name fullname) {
        Symbol.PackageSymbol p = this.packages.get(fullname);
        if (p == null) {
            if (!$assertionsDisabled && fullname.length() == 0) {
                throw new AssertionError((Object)"rootPackage missing!");
            }
            p = new Symbol.PackageSymbol(Convert.shortName(fullname), this.enterPackage(Convert.packagePart(fullname)));
            p.completer = this;
            this.packages.put(fullname, p);
        }
        return p;
    }

    public Symbol.PackageSymbol enterPackage(Name name, Symbol.PackageSymbol owner) {
        return this.enterPackage(Symbol.TypeSymbol.formFullName(name, owner));
    }

    protected void includeClassFile(Symbol.PackageSymbol p, FileEntry file) {
        int extlen;
        int seen;
        String filename;
        if ((p.flags_field & 0x800000L) == 0L) {
            Symbol q = p;
            while (q != null && q.kind == 1) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
        }
        if ((filename = file.getName()).endsWith(".class")) {
            seen = 0x2000000;
            extlen = 6;
        } else {
            seen = 0x4000000;
            extlen = 5;
        }
        Name classname = this.names.fromString(filename.substring(0, filename.length() - extlen));
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)p.members_field.lookup((Name)classname).sym;
        if (c == null) {
            c = this.enterClass(classname, p);
            if (c.classfile == null) {
                c.classfile = file;
            }
            if (c.owner == p) {
                p.members_field.enter(c);
            }
        } else if (c.classfile != null && (c.flags_field & (long)seen) == 0L && (c.flags_field & 0x6000000L) != 0L) {
            c.classfile = this.preferredFileEntry(file, c.classfile);
        }
        c.flags_field |= (long)seen;
    }

    protected FileEntry preferredFileEntry(FileEntry sourceEntry, FileEntry classEntry) {
        long fdate = sourceEntry.lastModified();
        long cdate = classEntry.lastModified();
        return fdate >= 0L && cdate >= 0L && fdate > cdate ? sourceEntry : classEntry;
    }

    protected void list(String pathname, String name, String[] extensions, Symbol.PackageSymbol p) {
        try {
            if (ClassReader.isZip(pathname)) {
                Archive archive = this.openArchive(pathname);
                if (name.length() != 0 && !(name = name.replace('\\', '/')).endsWith("/")) {
                    name = new StringBuffer().append(name).append("/").toString();
                }
                int namelen = name.length();
                List<ZipEntry> l = archive.entries;
                while (l.nonEmpty()) {
                    ZipEntry entry = (ZipEntry)l.head;
                    String ename = entry.getName();
                    if (ename.startsWith(name)) {
                        if (this.endsWith(ename, extensions)) {
                            String suffix = ename.substring(namelen);
                            if (suffix.length() > 0 && suffix.indexOf(47) < 0) {
                                this.includeClassFile(p, new FileEntry.Zipped(suffix, archive.zdir, entry));
                            }
                        } else {
                            this.extraZipFileActions(p, ename, name, pathname);
                        }
                    }
                    l = l.tail;
                }
            } else {
                File f = name.length() != 0 ? new File(pathname, name) : new File(pathname);
                String[] names = f.list();
                if (names != null && this.caseMapCheck(f, name)) {
                    for (int i = 0; i < names.length; ++i) {
                        String fname = names[i];
                        if (this.isValidFile(fname, extensions)) {
                            this.includeClassFile(p, new FileEntry.Regular(fname, new File(f, fname)));
                            continue;
                        }
                        this.extraFileActions(p, fname, f);
                    }
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    protected boolean endsWith(String s, String[] extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            if (!s.endsWith(extensions[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidFile(String s, String[] extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            if (!s.endsWith(extension) || !this.isJavaIdentifier(s.substring(0, s.length() - extension.length()))) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaIdentifier(String s) {
        if (s.length() < 1) {
            return false;
        }
        if (surrogatesSupported) {
            int cp = s.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                return false;
            }
            for (int j = Character.charCount(cp); j < s.length(); j += Character.charCount(cp)) {
                cp = s.codePointAt(j);
                if (Character.isJavaIdentifierPart(cp)) continue;
                return false;
            }
        } else {
            if (!Character.isJavaIdentifierStart(s.charAt(0))) {
                return false;
            }
            for (int j = 1; j < s.length(); ++j) {
                if (Character.isJavaIdentifierPart(s.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean caseMapCheck(File f, String name) throws IOException {
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        String path = f.getCanonicalPath();
        char[] pcs = path.toCharArray();
        char[] ncs = name.toCharArray();
        int i = pcs.length - 1;
        int j = ncs.length - 1;
        while (i >= 0 && j >= 0) {
            while (i >= 0 && pcs[i] == File.separatorChar) {
                --i;
            }
            while (j >= 0 && ncs[j] == File.separatorChar) {
                --j;
            }
            if (i < 0 || j < 0) continue;
            if (pcs[i] != ncs[j]) {
                return false;
            }
            --i;
            --j;
        }
        return j < 0;
    }

    protected void extraZipFileActions(Symbol.PackageSymbol pack, String zipEntryName, String classPathName, String zipName) {
    }

    protected void extraFileActions(Symbol.PackageSymbol pack, String fileName, File fileDir) {
    }

    private static boolean surrogatesSupported() {
        try {
            boolean b = Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    private void listAll(Collection<String> files, String name, String[] extensions, Symbol.PackageSymbol p) {
        for (String file : files) {
            this.list(file, name, extensions, p);
        }
    }

    private void fillIn(Symbol.PackageSymbol p) {
        Name packageName;
        if (p.members_field == null) {
            p.members_field = new Scope(p);
        }
        if ((packageName = p.fullname) == this.names.emptyPackage) {
            packageName = this.names.empty;
        }
        String dirname = ClassReader.externalizeFileName(packageName);
        this.listAll(this.paths.bootClassPath(), dirname, classOnly, p);
        if (this.sourceCompleter != null && this.paths.sourcePath() == null) {
            this.listAll(this.paths.userClassPath(), dirname, classOrJava, p);
        } else {
            this.listAll(this.paths.userClassPath(), dirname, classOnly, p);
            if (this.sourceCompleter != null) {
                this.listAll(this.paths.sourcePath(), dirname, javaOnly, p);
            }
        }
    }

    private void printVerbose(String key, String arg) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString(new StringBuffer().append("verbose.").append(key).toString(), new Object[]{arg}));
    }

    private void printCCF(String key, Object arg) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString(new StringBuffer().append("verbose.").append(key).toString(), new Object[]{arg}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tools$javac$jvm$ClassReader == null ? (class$com$sun$tools$javac$jvm$ClassReader = ClassReader.class$("com.sun.tools.javac.jvm.ClassReader")) : class$com$sun$tools$javac$jvm$ClassReader).desiredAssertionStatus();
        classReaderKey = new Context.Key();
        fileSystemIsCaseSensitive = File.separatorChar == '/';
        surrogatesSupported = ClassReader.surrogatesSupported();
        classOnly = new String[]{".class"};
        javaOnly = new String[]{".java"};
        classOrJava = new String[]{".class", ".java"};
    }

    public static interface SourceCompleter {
        public void complete(Symbol.ClassSymbol var1, String var2, InputStream var3) throws Symbol.CompletionFailure;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Archive {
        public ZipFile zdir;
        public List<ZipEntry> entries;

        public Archive(ZipFile zdir, List<ZipEntry> entries) {
            this.zdir = zdir;
            this.entries = entries;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationCompleter
    extends AnnotationDeproxy
    implements Annotate.Annotator {
        final Symbol sym;
        final List<CompoundAnnotationProxy> l;
        final String classFileName;

        @Override
        public String toString() {
            return new StringBuffer().append(" ClassReader annotate ").append(this.sym.owner).append(".").append(this.sym).append(" with ").append(this.l).toString();
        }

        AnnotationCompleter(Symbol sym, List<CompoundAnnotationProxy> l) {
            this.sym = sym;
            this.l = l;
            this.classFileName = ClassReader.this.currentClassFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enterAnnotation() {
            String previousClassFileName = ClassReader.this.currentClassFileName;
            try {
                ClassReader.this.currentClassFileName = this.classFileName;
                List<Attribute.Compound> newList = this.deproxyCompoundList(this.l);
                this.sym.attributes_field = this.sym.attributes_field == null ? newList : newList.prependList(this.sym.attributes_field);
            }
            finally {
                ClassReader.this.currentClassFileName = previousClassFileName;
            }
        }
    }

    class AnnotationDefaultCompleter
    extends AnnotationDeproxy
    implements Annotate.Annotator {
        final Symbol.MethodSymbol sym;
        final Attribute value;
        final String classFileName;

        public String toString() {
            return " ClassReader store default for " + this.sym.owner + "." + this.sym + " is " + this.value;
        }

        AnnotationDefaultCompleter(Symbol.MethodSymbol sym, Attribute value) {
            this.classFileName = ClassReader.this.currentClassFileName;
            this.sym = sym;
            this.value = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterAnnotation() {
            String previousClassFileName = ClassReader.this.currentClassFileName;
            try {
                ClassReader.this.currentClassFileName = this.classFileName;
                this.sym.defaultValue = this.deproxy(this.sym.type.restype(), this.value);
            }
            finally {
                ClassReader.this.currentClassFileName = previousClassFileName;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationDeproxy
    implements ProxyVisitor {
        Attribute result;
        Type type;

        AnnotationDeproxy() {
        }

        List<Attribute.Compound> deproxyCompoundList(List<CompoundAnnotationProxy> pl) {
            ListBuffer<Attribute.Compound> buf = new ListBuffer<Attribute.Compound>();
            List<CompoundAnnotationProxy> l = pl;
            while (l.nonEmpty()) {
                buf.append(this.deproxyCompound((CompoundAnnotationProxy)l.head));
                l = l.tail;
            }
            return buf.toList();
        }

        Attribute.Compound deproxyCompound(CompoundAnnotationProxy a) {
            ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
            List<Pair<Name, Attribute>> l = a.values;
            while (l.nonEmpty()) {
                Symbol.MethodSymbol meth = this.findAccessMethod(a.type, (Name)((Pair)l.head).fst);
                buf.append(new Pair<Symbol.MethodSymbol, Attribute>(meth, this.deproxy(meth.type.restype(), (Attribute)((Pair)l.head).snd)));
                l = l.tail;
            }
            return new Attribute.Compound(a.type, buf.toList());
        }

        Symbol.MethodSymbol findAccessMethod(Type container, Name name) {
            Scope.Entry e = container.tsym.members().lookup(name);
            while (e.scope != null) {
                Symbol sym = e.sym;
                if (sym.kind == 16 && sym.type.argtypes().length() == 0) {
                    return (Symbol.MethodSymbol)sym;
                }
                e = e.next();
            }
            throw new AssertionError((Object)new StringBuffer().append("cannot find method ").append(container).append(".").append(name).append("()").toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Attribute deproxy(Type t, Attribute a) {
            Type oldType = this.type;
            try {
                this.type = t;
                a.accept(this);
                Attribute attribute = this.result;
                return attribute;
            }
            finally {
                this.type = oldType;
            }
        }

        @Override
        public void visitConstant(Attribute.Constant value) {
            this.result = value;
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.result = clazz;
        }

        @Override
        public void visitEnum(Attribute.Enum e) {
            throw new AssertionError();
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            throw new AssertionError();
        }

        @Override
        public void visitArray(Attribute.Array array) {
            throw new AssertionError();
        }

        @Override
        public void visitError(Attribute.Error e) {
            throw new AssertionError();
        }

        @Override
        public void visitEnumAttributeProxy(EnumAttributeProxy proxy) {
            Symbol.TypeSymbol enumTypeSym = proxy.enumType.tsym;
            Symbol.VarSymbol enumerator = null;
            Scope.Entry e = enumTypeSym.members().lookup(proxy.enumerator);
            while (e.scope != null) {
                if (e.sym.kind == 4) {
                    enumerator = (Symbol.VarSymbol)e.sym;
                    break;
                }
                e = e.next();
            }
            if (enumerator == null) {
                ClassReader.this.log.error(-1, "unknown.enum.constant", new Object[]{ClassReader.this.currentClassFileName, enumTypeSym, proxy.enumerator});
                this.result = new Attribute.Error(enumTypeSym.type);
            } else {
                this.result = new Attribute.Enum(enumTypeSym.type, enumerator);
            }
        }

        @Override
        public void visitArrayAttributeProxy(ArrayAttributeProxy proxy) {
            int length = proxy.values.length();
            Attribute[] ats = new Attribute[length];
            Type elemtype = ClassReader.this.types.elemtype(this.type);
            int i = 0;
            List<Attribute> p = proxy.values;
            while (p.nonEmpty()) {
                ats[i++] = this.deproxy(elemtype, (Attribute)p.head);
                p = p.tail;
            }
            this.result = new Attribute.Array(this.type, ats);
        }

        @Override
        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy proxy) {
            this.result = this.deproxyCompound(proxy);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompoundAnnotationProxy
    extends Attribute {
        final List<Pair<Name, Attribute>> values;

        public CompoundAnnotationProxy(Type type, List<Pair<Name, Attribute>> values) {
            super(type);
            this.values = values;
        }

        @Override
        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitCompoundAnnotationProxy(this);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("@");
            buf.append(this.type.tsym.fullName());
            buf.append("/*proxy*/{");
            boolean first = true;
            List<Pair<Name, Attribute>> v = this.values;
            while (v.nonEmpty()) {
                Pair value = (Pair)v.head;
                if (!first) {
                    buf.append(",");
                }
                first = false;
                buf.append(value.fst);
                buf.append("=");
                buf.append(value.snd);
                v = v.tail;
            }
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayAttributeProxy
    extends Attribute {
        List<Attribute> values;

        ArrayAttributeProxy(List<Attribute> values) {
            super(null);
            this.values = values;
        }

        @Override
        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitArrayAttributeProxy(this);
        }

        public String toString() {
            return new StringBuffer().append("{").append(this.values).append("}").toString();
        }
    }

    static class EnumAttributeProxy
    extends Attribute {
        Type enumType;
        Name enumerator;

        public EnumAttributeProxy(Type enumType, Name enumerator) {
            super(null);
            this.enumType = enumType;
            this.enumerator = enumerator;
        }

        public void accept(Attribute.Visitor v) {
            ((ProxyVisitor)v).visitEnumAttributeProxy(this);
        }

        public String toString() {
            return "/*proxy enum*/" + this.enumType + "." + this.enumerator;
        }
    }

    static interface ProxyVisitor
    extends Attribute.Visitor {
        public void visitEnumAttributeProxy(EnumAttributeProxy var1);

        public void visitArrayAttributeProxy(ArrayAttributeProxy var1);

        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy var1);
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.ClassSymbol c, Object cname, Object msg) {
            super(c, Log.getLocalizedString("bad.class.file.header", new Object[]{cname, msg}));
        }
    }
}

