/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.modules.java.project.BrokenReferencesModel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class BrokenReferencesCustomizer
extends JPanel {
    private BrokenReferencesModel model;
    private File lastSelectedFile;
    private JTextArea description;
    private JLabel descriptionLabel;
    private JList errorList;
    private JLabel errorListLabel;
    private JButton fix;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private static Icon brokenRef = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/project/resources/broken-reference.gif"));
    private static Icon resolvedRef = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/project/resources/resolved-reference.gif"));

    public BrokenReferencesCustomizer(BrokenReferencesModel model) {
        this.initComponents();
        this.model = model;
        this.errorList.setModel(model);
        this.errorList.setSelectedIndex(0);
        this.errorList.setCellRenderer(new ListCellRendererImpl(model));
    }

    private void initComponents() {
        this.errorListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.errorList = new JList();
        this.fix = new JButton();
        this.descriptionLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.description = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(450, 300));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"ACSN_BrokenReferencesCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"ACSD_BrokenReferencesCustomizer"));
        this.errorListLabel.setLabelFor(this.errorList);
        Mnemonics.setLocalizedText((JLabel)this.errorListLabel, (String)NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_List"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(6, 12, 3, 0);
        this.add((Component)this.errorListLabel, gridBagConstraints);
        this.errorListLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_List"));
        this.errorList.setSelectionMode(0);
        this.errorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                BrokenReferencesCustomizer.this.errorListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.errorList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.fix, (String)NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Fix"));
        this.fix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BrokenReferencesCustomizer.this.fixActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 12);
        this.add((Component)this.fix, gridBagConstraints);
        this.fix.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_Fix"));
        this.descriptionLabel.setLabelFor(this.description);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 3, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_Description"));
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 60;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    private void errorListValueChanged(ListSelectionEvent evt) {
        this.updateSelection();
    }

    private void fixActionPerformed(ActionEvent evt) {
        int index = this.errorList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        BrokenReferencesModel.OneReference or = this.model.getOneReference(index);
        if (or.getType() == 3 || or.getType() == 5) {
            LibrariesCustomizer.showCustomizer(null);
        } else if (or.getType() == 4) {
            PlatformsCustomizer.showCustomizer(null);
        } else {
            int option;
            JFileChooser chooser;
            if (or.getType() == 1) {
                chooser = ProjectChooser.projectChooser();
                chooser.setDialogTitle(NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Resolve_Project", (Object)or.getDisplayID()));
            } else {
                chooser = new JFileChooser();
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
                chooser.setFileSelectionMode(2);
                chooser.setDialogTitle(NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Resolve_File", (Object)or.getDisplayID()));
            }
            if (this.lastSelectedFile != null) {
                chooser.setSelectedFile(this.lastSelectedFile);
            }
            if ((option = chooser.showOpenDialog(null)) == 0) {
                this.model.updateReference(this.errorList.getSelectedIndex(), chooser.getSelectedFile());
                this.lastSelectedFile = chooser.getSelectedFile();
            }
        }
        this.model.refresh();
        this.updateSelection();
    }

    private void updateSelection() {
        if (this.errorList.getSelectedIndex() != -1 && this.errorList.getSelectedIndex() < this.model.getSize()) {
            if (this.model.isBroken(this.errorList.getSelectedIndex())) {
                this.description.setText(this.model.getDesciption(this.errorList.getSelectedIndex()));
                this.fix.setEnabled(true);
            } else {
                this.description.setText(NbBundle.getMessage((Class)BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Problem_Was_Resolved"));
                this.fix.setEnabled(true);
            }
        } else {
            this.description.setText("");
            this.fix.setEnabled(false);
        }
    }

    private static class ListCellRendererImpl
    extends DefaultListCellRenderer {
        private BrokenReferencesModel model;

        public ListCellRendererImpl(BrokenReferencesModel model) {
            this.model = model;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.model.isBroken(index)) {
                this.setIcon(brokenRef);
            } else {
                this.setIcon(resolvedRef);
            }
            return this;
        }
    }
}

