/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;

public final class SuiteProperties
extends ModuleProperties {
    public static final String DISABLED_MODULES_PROPERTY = "disabled.modules";
    public static final String ENABLED_CLUSTERS_PROPERTY = "enabled.clusters";
    public static final String DISABLED_CLUSTERS_PROPERTY = "disabled.clusters";
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    public static final String JAVA_PLATFORM_PROPERTY = "nbjdk.active";
    private NbPlatform activePlatform;
    private JavaPlatform activeJavaPlatform;
    private SuiteProject project;
    private Set origSubModules;
    private Set subModules;
    private CustomizerComponentFactory.SuiteSubModulesListModel moduleListModel;
    private String[] disabledModules;
    private String[] enabledClusters;
    private boolean changedDisabledModules;
    private boolean changedEnabledClusters;
    private final BasicBrandingModel brandingModel;

    public SuiteProperties(SuiteProject project, AntProjectHelper helper, PropertyEvaluator evaluator, Set subModules) {
        super(helper, evaluator);
        this.project = project;
        this.refresh(subModules);
        this.disabledModules = SuiteProperties.getArrayProperty(evaluator, DISABLED_MODULES_PROPERTY);
        this.enabledClusters = SuiteProperties.getArrayProperty(evaluator, ENABLED_CLUSTERS_PROPERTY);
        if (this.enabledClusters.length == 0) {
            TreeSet<String> clusters = new TreeSet<String>();
            ModuleEntry[] modules = this.activePlatform.getModules();
            for (int i = 0; i < modules.length; ++i) {
                clusters.add(modules[i].getClusterDirectory().getName());
            }
            clusters.removeAll(Arrays.asList(SuiteProperties.getArrayProperty(evaluator, DISABLED_CLUSTERS_PROPERTY)));
            this.enabledClusters = clusters.toArray(new String[clusters.size()]);
        }
        this.brandingModel = new BasicBrandingModel(this);
    }

    void refresh(Set subModules) {
        this.reloadProperties();
        this.origSubModules = Collections.unmodifiableSet(subModules);
        this.subModules = subModules;
        this.moduleListModel = null;
        this.activePlatform = this.project.getPlatform(true);
        this.activeJavaPlatform = ModuleProperties.findJavaPlatformByID(this.getEvaluator().getProperty(JAVA_PLATFORM_PROPERTY));
        this.firePropertiesRefreshed();
    }

    public SuiteProject getProject() {
        return this.project;
    }

    Map getDefaultValues() {
        return Collections.EMPTY_MAP;
    }

    public NbPlatform getActivePlatform() {
        return this.activePlatform;
    }

    void setActivePlatform(NbPlatform newPlaf) {
        NbPlatform oldPlaf = this.activePlatform;
        this.activePlatform = newPlaf;
        this.firePropertyChange(NB_PLATFORM_PROPERTY, oldPlaf, newPlaf);
    }

    JavaPlatform getActiveJavaPlatform() {
        return this.activeJavaPlatform;
    }

    void setActiveJavaPlatform(JavaPlatform nue) {
        JavaPlatform old = this.activeJavaPlatform;
        if (nue != old) {
            this.activeJavaPlatform = nue;
            this.firePropertyChange(JAVA_PLATFORM_PROPERTY, old, nue);
        }
    }

    String[] getEnabledClusters() {
        return this.enabledClusters;
    }

    String[] getDisabledModules() {
        return this.disabledModules;
    }

    void setEnabledClusters(String[] value) {
        if (((Object)Arrays.asList(this.enabledClusters)).equals(Arrays.asList(value))) {
            return;
        }
        this.enabledClusters = value;
        this.changedEnabledClusters = true;
    }

    void setDisabledModules(String[] value) {
        if (((Object)Arrays.asList(this.disabledModules)).equals(Arrays.asList(value))) {
            return;
        }
        this.disabledModules = value;
        this.changedDisabledModules = true;
    }

    public static String[] getArrayProperty(PropertyEvaluator evaluator, String p) {
        String s = evaluator.getProperty(p);
        String[] arr = null;
        if (s != null) {
            StringTokenizer tok = new StringTokenizer(s, ",");
            arr = new String[tok.countTokens()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = tok.nextToken().trim();
            }
        }
        return arr == null ? new String[]{} : arr;
    }

    public void storeProperties() throws IOException {
        ModuleProperties.storePlatform(this.getHelper(), this.getActivePlatform());
        ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), false);
        this.getBrandingModel().store();
        CustomizerComponentFactory.SuiteSubModulesListModel model = this.getModulesListModel();
        if (model.isChanged()) {
            SuiteUtils.replaceSubModules(this);
        }
        if (this.changedDisabledModules || this.changedEnabledClusters) {
            int i;
            String[] separated;
            EditableProperties ep = this.getHelper().getProperties("nbproject/platform.properties");
            if (this.changedDisabledModules) {
                separated = (String[])this.disabledModules.clone();
                for (i = 0; i < this.disabledModules.length - 1; ++i) {
                    separated[i] = this.disabledModules[i] + ',';
                }
                ep.setProperty(DISABLED_MODULES_PROPERTY, separated);
                this.setProperty(DISABLED_MODULES_PROPERTY, (String)null);
            }
            if (this.changedEnabledClusters) {
                int i2;
                separated = (String[])this.enabledClusters.clone();
                for (i = 0; i < this.enabledClusters.length - 1; ++i) {
                    separated[i] = this.enabledClusters[i] + ',';
                }
                ep.setProperty(ENABLED_CLUSTERS_PROPERTY, separated);
                this.setProperty(ENABLED_CLUSTERS_PROPERTY, (String)null);
                TreeSet<String> disabledClusters = new TreeSet<String>();
                ModuleEntry[] modules = this.activePlatform.getModules();
                for (i2 = 0; i2 < modules.length; ++i2) {
                    disabledClusters.add(modules[i2].getClusterDirectory().getName());
                }
                disabledClusters.removeAll(Arrays.asList(this.enabledClusters));
                separated = disabledClusters.toArray(new String[disabledClusters.size()]);
                for (i2 = 0; i2 < separated.length - 1; ++i2) {
                    separated[i2] = separated[i2] + ',';
                }
                ep.setProperty(DISABLED_CLUSTERS_PROPERTY, separated);
                ep.setComment(DISABLED_CLUSTERS_PROPERTY, new String[]{"# Deprecated since 5.0u1; for compatibility with 5.0:"}, false);
            }
            this.getHelper().putProperties("nbproject/platform.properties", ep);
        }
        super.storeProperties();
    }

    Set getSubModules() {
        return this.getModulesListModel().getSubModules();
    }

    Set getOrigSubModules() {
        return this.origSubModules;
    }

    CustomizerComponentFactory.SuiteSubModulesListModel getModulesListModel() {
        if (this.moduleListModel == null) {
            this.moduleListModel = new CustomizerComponentFactory.SuiteSubModulesListModel(this.subModules);
        }
        return this.moduleListModel;
    }

    public BasicBrandingModel getBrandingModel() {
        return this.brandingModel;
    }
}

