/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.ReplaceForSerialization;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.Attributes;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Enumerations;
import org.openide.util.Mutex;

public abstract class BaseFileObj
extends FileObject {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNC_PREFIX = '\\';
    private static final String PATH_SEPARATOR = "/";
    private static final char EXT_SEP = '.';
    static final long serialVersionUID = -1244650210876356809L;
    static final Attributes attribs;
    private final EventListenerList eventSupport = new EventListenerList();
    private final FileNaming fileName;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected BaseFileObj(File file) {
        this.fileName = NamingFactory.fromFile(file);
    }

    protected BaseFileObj(File file, FileNaming name) {
        this.fileName = name;
    }

    public final String toString() {
        return this.getFileName().toString();
    }

    public final String getNameExt() {
        File file = this.getFileName().getFile();
        String retVal = BaseFileObj.getNameExt(file);
        return retVal;
    }

    static String getNameExt(File file) {
        String retVal;
        String string = retVal = file.getParentFile() == null ? file.getAbsolutePath() : file.getName();
        if (retVal.endsWith(String.valueOf('\\')) || retVal.endsWith(PATH_SEPARATOR)) {
            boolean isPermittedToStripSlash;
            if (!$assertionsDisabled && file.getParentFile() != null) {
                throw new AssertionError((Object)(file.getAbsolutePath() + " exists: " + file.exists()));
            }
            boolean bl = isPermittedToStripSlash = file.getParentFile() != null || !new FileInfo(file).isUNCFolder();
            if (isPermittedToStripSlash) {
                retVal = retVal.substring(0, retVal.length() - 1);
            }
        }
        return retVal;
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public final String getName() {
        String retVal;
        String name = this.getFileName().getName();
        int i = name.lastIndexOf(46);
        String string = retVal = i <= 0 || i == name.length() ? name : name.substring(0, i);
        if (!$assertionsDisabled && !BaseFileObj.assertGetNameExt(name, retVal, this.getExt())) {
            throw new AssertionError();
        }
        if (retVal.endsWith(String.valueOf('\\')) || retVal.endsWith(PATH_SEPARATOR)) {
            boolean isPermittedToStripSlash;
            File file = this.getFileName().getFile();
            boolean bl = isPermittedToStripSlash = file.getParentFile() != null || !new FileInfo(file).isUNCFolder();
            if (isPermittedToStripSlash) {
                if (!$assertionsDisabled && file.getParentFile() != null) {
                    throw new AssertionError();
                }
                retVal = retVal.substring(0, retVal.length() - 1);
            }
        }
        return retVal;
    }

    public final String getExt() {
        String retVal;
        String name = this.getFileName().getName();
        int i = name.lastIndexOf(46) + 1;
        String string = retVal = i <= 1 || i == name.length() ? "" : name.substring(i);
        if (retVal.endsWith(String.valueOf('.')) || retVal.endsWith(PATH_SEPARATOR)) {
            retVal = retVal.substring(0, retVal.length() - 1);
        }
        return retVal;
    }

    private static boolean assertGetNameExt(String nameExt, String name, String ext) {
        String computedNameExt = ext == null || ext.length() == 0 ? name : name + '.' + ext;
        boolean retVal = computedNameExt.equals(nameExt);
        if (!$assertionsDisabled && !retVal) {
            throw new AssertionError((Object)(computedNameExt + " | " + nameExt));
        }
        return retVal;
    }

    public final String getPath() {
        return this.isRoot() ? "" : this.getFileName().getFile().getAbsolutePath().replace('\\', '/');
    }

    public final FileSystem getFileSystem() throws FileStateInvalidException {
        return this.getLocalFileSystem();
    }

    public final boolean isRoot() {
        return false;
    }

    public void move(FileLock lock, BaseFileObj target, String name, String ext, ProvidedExtensions.IOHandler moveHandler) throws IOException {
        moveHandler.handle();
        BaseFileObj result = (BaseFileObj)FileBasedFileSystem.getFileObject(new File(target.getFileName().getFile(), FileInfo.composeName(name, ext)));
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        result.fireFileDataCreatedEvent(false);
        this.fireFileDeletedEvent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(FileLock lock, String name, String ext, ProvidedExtensions.IOHandler handler) throws IOException {
        String parentPath;
        FolderObj parentFo;
        File file = this.getFileName().getFile();
        File parent = file.getParentFile();
        File file2Rename = BaseFileObj.getFile(parent, name, ext);
        if (parent == null || !parent.exists()) {
            parentFo = this.getExistingParent();
            parentPath = parentFo != null ? parentFo.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), parentPath, file2Rename.getName());
        }
        if (file2Rename.exists() && !file2Rename.equals(file)) {
            parentFo = this.getExistingParent();
            parentPath = parentFo != null ? parentFo.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), parentPath, file2Rename.getName());
        }
        String originalName = this.getName();
        String originalExt = this.getExt();
        FileNaming[] allRenamed = NamingFactory.rename(this.getFileName(), file2Rename.getName(), handler);
        if (allRenamed == null) {
            FolderObj parentFo2 = this.getExistingParent();
            String parentPath2 = parentFo2 != null ? parentFo2.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotRename", file.getName(), parentPath2, file2Rename.getName());
        }
        FileBasedFileSystem fs = this.getLocalFileSystem();
        fs.getFactory().rename();
        attribs.renameAttributes(file.getAbsolutePath().replace('\\', '/'), file2Rename.getAbsolutePath().replace('\\', '/'));
        for (int i = 0; i < allRenamed.length; ++i) {
            Mutex.Privileged mutexPrivileged;
            FolderObj par;
            FolderObj folderObj = par = allRenamed[i].getParent() != null ? (FolderObj)fs.getFactory().get(allRenamed[i].getParent().getFile()) : null;
            if (par == null) continue;
            ChildrenCache childrenCache = par.getChildrenCache();
            Mutex.Privileged privileged = mutexPrivileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
            if (mutexPrivileged != null) {
                mutexPrivileged.enterWriteAccess();
            }
            try {
                childrenCache.removeChild(allRenamed[i].getName());
                childrenCache.getChild(allRenamed[i].getName(), true);
                continue;
            }
            finally {
                if (mutexPrivileged != null) {
                    mutexPrivileged.exitWriteAccess();
                }
            }
        }
        this.fireFileRenamedEvent(originalName, originalExt);
    }

    public final void rename(FileLock lock, String name, String ext) throws IOException {
        this.rename(lock, name, ext, null);
    }

    public Object getAttribute(String attrName) {
        return attribs.readAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), attrName);
    }

    public final void setAttribute(String attrName, Object value) throws IOException {
        Object oldValue = attribs.readAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), attrName);
        attribs.writeAttribute(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'), attrName, value);
        this.fireFileAttributeChangedEvent(attrName, oldValue, value);
    }

    public final Enumeration getAttributes() {
        return attribs.attributes(this.getFileName().getFile().getAbsolutePath().replace('\\', '/'));
    }

    public final void addFileChangeListener(FileChangeListener fcl) {
        this.eventSupport.add(FileChangeListener.class, fcl);
    }

    public final void removeFileChangeListener(FileChangeListener fcl) {
        this.eventSupport.remove(FileChangeListener.class, fcl);
    }

    private Enumeration getListeners() {
        return Enumerations.array((Object[])this.eventSupport.getListeners(FileChangeListener.class));
    }

    public final long getSize() {
        return this.getFileName().getFile().length();
    }

    public final void setImportant(boolean b) {
    }

    public final boolean isReadOnly() {
        File f = this.getFileName().getFile();
        return !f.canWrite() && f.exists();
    }

    public final FileObject getParent() {
        FileObject retVal;
        FileNaming parent = this.getFileName().getParent();
        if (parent != null) {
            FileBasedFileSystem localFileSystem = this.getLocalFileSystem();
            File file = parent.getFile();
            retVal = localFileSystem.getFactory().get(file);
            retVal = retVal == null ? localFileSystem.findFileObject(file) : retVal;
        } else {
            retVal = this.getLocalFileSystem().getRoot();
        }
        return retVal;
    }

    static File getFile(File f, String name, String ext) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        if (ext != null && ext.length() > 0) {
            sb.append('.');
            sb.append(ext);
        }
        File retVal = new File(f, sb.toString());
        return retVal;
    }

    final FileBasedFileSystem getLocalFileSystem() {
        return FileBasedFileSystem.getInstance(this.getFileName().getFile());
    }

    final void fireFileDataCreatedEvent(boolean expected) {
        Enumeration pListeners;
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj parent = this.getExistingParent();
        Enumeration enumeration = pListeners = parent != null ? super.getListeners() : null;
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError((Object)this.toString());
        }
        this.fireFileDataCreatedEvent(this.getListeners(), new FileEvent((FileObject)this, (FileObject)this, expected));
        if (parent != null && pListeners != null) {
            if (!$assertionsDisabled && !parent.isValid()) {
                throw new AssertionError((Object)parent.toString());
            }
            parent.fireFileDataCreatedEvent(pListeners, new FileEvent((FileObject)parent, (FileObject)this, expected));
        }
        stopWatch.stop();
    }

    final void fireFileFolderCreatedEvent(boolean expected) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj parent = this.getExistingParent();
        Enumeration pListeners = parent != null ? super.getListeners() : null;
        this.fireFileFolderCreatedEvent(this.getListeners(), new FileEvent((FileObject)this, (FileObject)this, expected));
        if (parent != null && pListeners != null) {
            parent.fireFileFolderCreatedEvent(pListeners, new FileEvent((FileObject)parent, (FileObject)this, expected));
        }
        stopWatch.stop();
    }

    FolderObj getExistingParent() {
        File parentFile = this.getFileName().getParent() == null ? null : this.getFileName().getParent().getFile();
        FolderObj parent = parentFile == null ? null : (FolderObj)this.getLocalFileSystem().getFactory().get(parentFile);
        return parent;
    }

    public final void fireFileChangedEvent(boolean expected) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FileObject p = this.getParent();
        BaseFileObj parent = (BaseFileObj)((Object)(p instanceof BaseFileObj ? p : null));
        Enumeration pListeners = parent != null ? parent.getListeners() : null;
        this.fireFileChangedEvent(this.getListeners(), new FileEvent((FileObject)this, (FileObject)this, expected));
        if (parent != null && pListeners != null) {
            parent.fireFileChangedEvent(pListeners, new FileEvent((FileObject)parent, (FileObject)this, expected));
        }
        stopWatch.stop();
    }

    final void fireFileDeletedEvent(boolean expected) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FileObject p = this.getParent();
        BaseFileObj parent = (BaseFileObj)((Object)(p instanceof BaseFileObj ? p : null));
        Enumeration pListeners = parent != null ? parent.getListeners() : null;
        this.fireFileDeletedEvent(this.getListeners(), new FileEvent((FileObject)this, (FileObject)this, expected));
        if (parent != null && pListeners != null) {
            parent.fireFileDeletedEvent(pListeners, new FileEvent((FileObject)parent, (FileObject)this, expected));
        }
        stopWatch.stop();
    }

    private void fireFileRenamedEvent(String originalName, String originalExt) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.LISTENERS_CALLS);
        stopWatch.start();
        FolderObj parent = this.getExistingParent();
        Enumeration pListeners = parent != null ? super.getListeners() : null;
        this.fireFileRenamedEvent(this.getListeners(), new FileRenameEvent((FileObject)this, originalName, originalExt));
        if (parent != null && pListeners != null) {
            parent.fireFileRenamedEvent(pListeners, new FileRenameEvent((FileObject)parent, (FileObject)this, originalName, originalExt));
        }
        stopWatch.stop();
    }

    private void fireFileAttributeChangedEvent(String attrName, Object oldValue, Object newValue) {
        FolderObj parent = this.getExistingParent();
        Enumeration pListeners = parent != null ? super.getListeners() : null;
        this.fireFileAttributeChangedEvent(this.getListeners(), new FileAttributeEvent((FileObject)this, (FileObject)this, attrName, oldValue, newValue));
        if (parent != null && pListeners != null) {
            parent.fireFileAttributeChangedEvent(pListeners, new FileAttributeEvent((FileObject)parent, (FileObject)this, attrName, oldValue, newValue));
        }
    }

    public final FileNaming getFileName() {
        return this.fileName;
    }

    public final void delete(FileLock lock) throws IOException {
        this.delete(lock, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileLock lock, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        Mutex.Privileged mutexPrivileged;
        File f = this.getFileName().getFile();
        FolderObj existingParent = this.getExistingParent();
        ChildrenCache childrenCache = existingParent != null ? existingParent.getChildrenCache() : null;
        Mutex.Privileged privileged = mutexPrivileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
        if (mutexPrivileged != null) {
            mutexPrivileged.enterWriteAccess();
        }
        try {
            boolean deleteStatus;
            if (!this.checkLock(lock)) {
                FSException.io("EXC_InvalidLock", lock, this.getPath());
            }
            boolean bl = deleteStatus = deleteHandler != null ? deleteHandler.delete(f) : f.delete();
            if (!deleteStatus) {
                FolderObj parent = this.getExistingParent();
                String parentPath = parent != null ? parent.getPath() : f.getParentFile().getAbsolutePath();
                FSException.io("EXC_CannotDelete", f.getName(), parentPath);
            }
            attribs.deleteAttributes(f.getAbsolutePath().replace('\\', '/'));
            if (childrenCache != null) {
                if (deleteHandler != null) {
                    childrenCache.removeChild(BaseFileObj.getNameExt(f));
                } else {
                    childrenCache.getChild(BaseFileObj.getNameExt(f), true);
                }
            }
        }
        finally {
            if (mutexPrivileged != null) {
                mutexPrivileged.exitWriteAccess();
            }
            this.setValid(false);
        }
        this.fireFileDeletedEvent(false);
    }

    abstract boolean checkLock(FileLock var1) throws IOException;

    public Object writeReplace() {
        return new ReplaceForSerialization(this.getFileName().getFile());
    }

    protected abstract void setValid(boolean var1);

    public abstract void refresh(boolean var1, boolean var2);

    static {
        $assertionsDisabled = !BaseFileObj.class.desiredAssertionStatus();
        BridgeForAttributes attrBridge = new BridgeForAttributes();
        attribs = new Attributes(attrBridge, attrBridge, attrBridge);
    }

    private static final class BridgeForAttributes
    implements AbstractFileSystem.List,
    AbstractFileSystem.Change,
    AbstractFileSystem.Info {
        private BridgeForAttributes() {
        }

        public final Date lastModified(String name) {
            File file = new File(name);
            return new Date(file.lastModified());
        }

        public final boolean folder(String name) {
            File file = new File(name);
            return file.isDirectory();
        }

        public final boolean readOnly(String name) {
            File file = new File(name);
            return !file.canWrite();
        }

        public final String mimeType(String name) {
            return "content/unknown";
        }

        public final long size(String name) {
            File file = new File(name);
            return file.length();
        }

        public final InputStream inputStream(String name) throws FileNotFoundException {
            File file = new File(name);
            return new FileInputStream(file);
        }

        public final OutputStream outputStream(String name) throws IOException {
            File file = new File(name);
            return new FileOutputStream(file);
        }

        public final void lock(String name) throws IOException {
        }

        public final void unlock(String name) {
        }

        public final void markUnimportant(String name) {
        }

        public final String[] children(String f) {
            File file = new File(f);
            return file.list();
        }

        public final void createFolder(String name) throws IOException {
            File file = new File(name);
            if (!file.mkdirs()) {
                IOException ioException = new IOException(name);
                throw ioException;
            }
        }

        public final void createData(String name) throws IOException {
            File file = new File(name);
            if (!file.createNewFile()) {
                throw new IOException(name);
            }
        }

        public final void rename(String oldName, String newName) throws IOException {
            File file = new File(oldName);
            File dest = new File(newName);
            if (!file.renameTo(dest)) {
                FSException.io("EXC_CannotRename", file.getName(), "", dest.getName());
            }
        }

        public final void delete(String name) throws IOException {
            boolean isDeleted;
            File file = new File(name);
            boolean bl = isDeleted = file.isFile() ? file.delete() : this.deleteFolder(file);
            if (isDeleted) {
                FSException.io("EXC_CannotDelete", file.getName(), "");
            }
        }

        private boolean deleteFolder(File file) throws IOException {
            boolean ret = file.delete();
            if (ret) {
                return true;
            }
            if (!file.exists()) {
                return false;
            }
            if (file.isDirectory()) {
                File[] arr = file.listFiles();
                for (int i = 0; i < arr.length; ++i) {
                    File f2Delete = arr[i];
                    if (this.deleteFolder(f2Delete)) continue;
                    return false;
                }
            }
            return file.delete();
        }
    }
}

