/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;

public abstract class JavaCompletionJavaDoc
extends CompletionJavaDoc {
    private static ArrayList omittedTags = new ArrayList();

    public JavaCompletionJavaDoc(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    protected boolean isNotFullyQualifiedInnerClass(String inner, String pkgName) {
        if (inner.indexOf(".") != inner.lastIndexOf(".")) {
            return false;
        }
        return this.getFinder().getExactClass(pkgName.length() > 0 ? pkgName + "." + inner : inner) != null;
    }

    protected boolean isNotFullyQualifiedInnerClass(String inner, JCClass cls) {
        return this.isNotFullyQualifiedInnerClass(inner, cls.getPackageName());
    }

    protected String findProperClass(String name, String pkgName) {
        String ret = null;
        JCClass retClass = pkgName != null && pkgName.length() > 0 ? this.getFinder().getExactClass(pkgName + "." + name) : this.getFinder().getExactClass(name);
        if (retClass != null) {
            return retClass.getFullName();
        }
        List classes = this.getFinder().findClasses(null, name, true);
        if (classes.size() > 0) {
            ret = ((JCClass)classes.get(0)).getFullName();
        }
        return ret;
    }

    protected String findProperClass(String name, JCClass cls) {
        if (cls == null) {
            return null;
        }
        return this.findProperClass(name, cls.getPackageName());
    }

    private int getLastParenthesisOccurence(String prm) {
        int level = 0;
        for (int i = 0; i < prm.length(); ++i) {
            char ch = prm.charAt(i);
            if (ch == ' ' && level == 0) {
                return i;
            }
            if (ch == '(') {
                ++level;
            }
            if (ch != ')') continue;
            if (level == 1) {
                return i;
            }
            --level;
        }
        return -1;
    }

    protected String createAnchor(String prm, String clsFQN, String clsPkgName, boolean linkedObjectExists) {
        StringBuffer ret = new StringBuffer(prm.length() + 50);
        String label = "";
        int lastParenthesisOccurence = this.getLastParenthesisOccurence(prm);
        int indexOfSpaceAfterLastParenthesis = prm.indexOf(" ", lastParenthesisOccurence);
        if (indexOfSpaceAfterLastParenthesis > 0) {
            label = prm.substring(indexOfSpaceAfterLastParenthesis + 1);
        }
        if (prm.length() > 0 && prm.charAt(0) == '#') {
            if (linkedObjectExists) {
                ret.append("<a href='").append(clsFQN).append(label.length() > 0 ? prm.substring(0, indexOfSpaceAfterLastParenthesis) : prm).append("'>").append(label.length() > 0 ? label : prm.substring(1)).append("</a>");
            } else {
                ret.append(label.length() > 0 ? label : prm.substring(1));
            }
        } else if (linkedObjectExists) {
            String href;
            String string = href = label.length() > 0 ? prm.substring(0, indexOfSpaceAfterLastParenthesis) : prm;
            if (href.indexOf(".") < 0 || this.isNotFullyQualifiedInnerClass(href, clsPkgName)) {
                String refCls = href.indexOf("#") > 0 ? href.substring(0, href.indexOf("#")) : href;
                String refMember = href.indexOf("#") > 0 ? href.substring(href.indexOf("#") + 1) : "";
                String fullClassName = this.findProperClass(refCls, clsPkgName);
                if (fullClassName != null) {
                    href = refMember.length() > 0 ? fullClassName + "#" + refMember : fullClassName;
                } else {
                    return "<a href='" + href + "'>" + (label.length() > 0 ? label : prm.replace('#', '.')) + "</a>";
                }
            }
            ret.append("<a href='").append(href).append("'>").append(label.length() > 0 ? label : prm.replace('#', '.')).append("</a>");
        } else {
            ret.append(label.length() > 0 ? label : prm.replace('#', '.'));
        }
        return ret.toString();
    }

    protected String createAnchor(String prm, String clsFQN, String clsPkgName) {
        boolean linkedObjectExists = this.parseLink(prm, clsFQN, clsPkgName) != null;
        return this.createAnchor(prm, clsFQN, clsPkgName, linkedObjectExists);
    }

    public String createAnchor(String prm, JCClass cls) {
        return this.createAnchor(prm, cls.getFullName(), cls.getPackageName());
    }

    protected String createLinks(String content, String classFQN, String pkgName) {
        StringBuffer ret = new StringBuffer(content.length());
        StringTokenizer strTok = new StringTokenizer(content, "{");
        String next = "";
        boolean linkAppended = false;
        boolean useOriginalContent = true;
        while (strTok.hasMoreTokens()) {
            next = strTok.nextToken("{");
            if (linkAppended && next.length() > 0 && next.charAt(0) == '}') {
                next = next.substring(1);
            }
            linkAppended = false;
            if (strTok.hasMoreTokens()) {
                String link = strTok.nextToken("}");
                int indexOfLink = link.indexOf("@link");
                if (indexOfLink > 0 && link.length() > 6 && Character.isWhitespace(link.charAt(link.indexOf("@link") + 5))) {
                    String prm;
                    useOriginalContent = false;
                    int linkPos = indexOfLink + 6;
                    if (next.length() > 0 && next.charAt(0) == '}') {
                        next = next.substring(1);
                    }
                    boolean linkedObjectExists = this.parseLink(prm = link.substring(linkPos).trim(), classFQN, pkgName) != null;
                    link = this.createAnchor(prm, classFQN, pkgName, linkedObjectExists);
                    linkAppended = true;
                }
                ret.append(next);
                ret.append(link);
                continue;
            }
            ret.append(next);
        }
        return useOriginalContent ? content : ret.toString();
    }

    public String createLinks(String content, JCClass cls) {
        return this.createLinks(content, cls.getFullName(), cls.getPackageName());
    }

    public String prepareJavaDocContent(JCClass cls, String member, String content) {
        return this.prepareJavaDocContent(cls, member, content, null);
    }

    public String prepareJavaDocContent(String rootClsFQN, String rootClsPkgName, String member, String content, CompletionJavaDoc.JavaDocTagItem[] tags) {
        content = content != null ? this.createLinks(content, rootClsFQN, rootClsPkgName) : "";
        StringBuffer sb = new StringBuffer(512);
        sb.append("<font size='+0'><b>").append(this.createAnchor(rootClsFQN, rootClsFQN, rootClsPkgName)).append("</b></font>");
        if (member.length() > 0) {
            sb.append("<pre>").append(member).append("</pre>");
        }
        sb.append("<blockquote>").append(content).append("</blockquote>");
        if (tags != null) {
            Arrays.sort(tags);
            String curParam = "";
            int curItem = 0;
            for (int i = 0; i < tags.length; ++i) {
                if (!curParam.equals(tags[i].getName())) {
                    if (this.isOmittedJavaDocTag(tags[i].getName())) continue;
                    if (!curParam.equals("")) {
                        sb.append("</blockquote>");
                    }
                    sb.append("<b>").append(LocaleSupport.getString((String)("javadoc-tag-" + tags[i].getName()), (String)tags[i].getName())).append("</b><blockquote>");
                    curParam = tags[i].getName();
                    curItem = 0;
                }
                if (curItem > 0) {
                    sb.append("<br>");
                }
                if (curParam.equals("@param")) {
                    String prm = tags[i].getText();
                    int spacePos = prm.indexOf(" ");
                    if (spacePos > 0) {
                        String anchoredText = this.createLinks(prm.substring(spacePos), rootClsFQN, rootClsPkgName);
                        sb.append("<code>").append(prm.substring(0, spacePos)).append("</code> - ").append(anchoredText);
                    } else {
                        sb.append(prm);
                    }
                } else if (curParam.equals("@see")) {
                    char first;
                    String txt = tags[i].getText();
                    char c = first = txt.length() > 0 ? txt.charAt(0) : (char)'\u0000';
                    if (first == '\"') {
                        txt = txt.length() > 1 && txt.charAt(txt.length() - 1) == '\"' ? txt.substring(1, txt.length() - 1) : txt.substring(1, txt.length());
                        sb.append(txt);
                    } else if (first == '<') {
                        sb.append(txt);
                    } else {
                        sb.append(this.createAnchor(txt, rootClsFQN, rootClsPkgName));
                    }
                } else {
                    sb.append(this.createLinks(tags[i].getText(), rootClsFQN, rootClsPkgName));
                }
                ++curItem;
            }
            if (!curParam.equals("")) {
                sb.append("</blockquote>");
            }
        }
        return sb.toString();
    }

    public String prepareJavaDocContent(JCClass cls, String member, String content, CompletionJavaDoc.JavaDocTagItem[] tags) {
        return this.prepareJavaDocContent(cls.getFullName(), cls.getPackageName(), member, content, tags);
    }

    public boolean isOmittedJavaDocTag(String tag) {
        return omittedTags.contains(tag);
    }

    public Object parseLink(String link, JCClass cls) {
        if (cls == null) {
            return this.parseLink(link, null, null);
        }
        return this.parseLink(link, cls.getFullName(), cls.getPackageName());
    }

    public Object parseLink(String link, String clsFQN, String pkgName) {
        return null;
    }

    protected abstract JCFinder getFinder();

    static {
        omittedTags.add("@serial");
        omittedTags.add("@serialField");
        omittedTags.add("@serialData");
        omittedTags.add("@author");
        omittedTags.add("@version");
        omittedTags.add("@beaninfo");
    }
}

