/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCPaintComponent;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;

public abstract class JCResultItem
implements CompletionQuery.ResultItem,
CompletionQuery.ResultItemAssociatedObject {
    Object associatedObject;
    private static final Color KEYWORD_COLOR = Color.darkGray;
    private static final Color TYPE_COLOR = Color.black;

    public JCResultItem(Object associatedObject) {
        this.associatedObject = associatedObject;
    }

    public abstract String getItemText();

    protected abstract Component getPaintComponent(boolean var1);

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    protected String getReplaceText() {
        return this.getItemText();
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = this.getReplaceText();
        int selectionStartOffset = -1;
        int selectionEndOffset = -1;
        if (text != null) {
            doc.atomicLock();
            try {
                String textToReplace = doc.getText(offset, len);
                if (text.equals(textToReplace)) {
                    boolean bl = false;
                    return bl;
                }
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
                if (selectionStartOffset >= 0) {
                    c.select(offset + selectionStartOffset, offset + selectionEndOffset);
                }
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
        }
        return true;
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = this.getPaintComponent(isSelected);
        if (ret == null) {
            return null;
        }
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(this.getItemText());
        ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return ret;
    }

    protected Color getTypeColor(JCClass cls) {
        String s = cls.getName();
        return JavaCompletion.isPrimitiveClassName(s) ? KEYWORD_COLOR : TYPE_COLOR;
    }

    protected static String getTypeName(JCType typ) {
        return typ.format(false);
    }

    static class ExcStr {
        private String name;
        private Color typeColor;

        public ExcStr(String name, Color typeColor) {
            this.name = name;
            this.typeColor = typeColor;
        }

        public String getName() {
            return this.name;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }
    }

    static class ParamStr {
        private String type;
        private String simpleType;
        private String prm;
        private Color typeColor;

        public ParamStr(String type, String simpleType, String prm, Color typeColor) {
            this.type = type;
            this.simpleType = simpleType;
            this.prm = prm;
            this.typeColor = typeColor;
        }

        public String getTypeName() {
            return this.type;
        }

        public String getSimpleTypeName() {
            return this.simpleType;
        }

        public String getName() {
            return this.prm;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }
    }

    public static class ClassResultItem
    extends JCResultItem {
        private JCClass cls;
        private boolean isInterface;
        private int classDisplayOffset;
        private boolean isDeprecated;
        private boolean displayFQN;
        private static JCPaintComponent.ClassPaintComponent clsComponent = null;
        private static JCPaintComponent.InterfacePaintComponent interfaceComponent = null;

        public ClassResultItem(JCClass cls, boolean displayFQN) {
            this(cls, 0, displayFQN);
        }

        public ClassResultItem(JCClass cls, int classDisplayOffset, boolean displayFQN) {
            super(cls);
            this.cls = cls;
            this.isInterface = cls.isInterface();
            this.classDisplayOffset = classDisplayOffset;
            this.isDeprecated = JCUtilities.isDeprecated(cls);
            this.displayFQN = displayFQN;
        }

        protected String getName() {
            return this.cls.getName();
        }

        protected String getReplaceText() {
            String text = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < text.length()) {
                text = text.substring(this.classDisplayOffset);
            }
            return text;
        }

        public String getItemText() {
            return this.displayFQN ? this.cls.getFullName() : this.cls.getName();
        }

        protected JCPaintComponent.InterfacePaintComponent createInterfacePaintComponent() {
            return new JCPaintComponent.InterfacePaintComponent();
        }

        protected JCPaintComponent.ClassPaintComponent createClassPaintComponent() {
            return new JCPaintComponent.ClassPaintComponent();
        }

        public Component getPaintComponent(boolean isSelected) {
            if (this.isInterface) {
                if (interfaceComponent == null) {
                    interfaceComponent = this.createInterfacePaintComponent();
                }
                interfaceComponent.setSelected(isSelected);
                interfaceComponent.setDeprecated(this.isDeprecated);
                interfaceComponent.setFormatClassName(this.getName());
                return interfaceComponent;
            }
            if (clsComponent == null) {
                clsComponent = this.createClassPaintComponent();
            }
            clsComponent.setSelected(isSelected);
            clsComponent.setDeprecated(this.isDeprecated);
            clsComponent.setFormatClassName(this.getName());
            return clsComponent;
        }
    }

    public static class PackageResultItem
    extends JCResultItem {
        private boolean displayFullPackagePath;
        private JCPackage pkg;
        private String pkgName;
        private static JCPaintComponent.PackagePaintComponent pkgComponent;

        public PackageResultItem(JCPackage pkg, boolean displayFullPackagePath) {
            super(pkg);
            this.pkg = pkg;
            this.displayFullPackagePath = displayFullPackagePath;
            this.pkgName = pkg.getName();
        }

        public String getItemText() {
            return this.displayFullPackagePath ? this.pkg.getName() : this.pkg.getLastName();
        }

        protected JCPaintComponent.PackagePaintComponent createPaintComponent() {
            return new JCPaintComponent.PackagePaintComponent();
        }

        public Component getPaintComponent(boolean isSelected) {
            if (pkgComponent == null) {
                pkgComponent = this.createPaintComponent();
            }
            pkgComponent.setSelected(isSelected);
            pkgComponent.setPackageName(this.pkgName);
            pkgComponent.setDisplayFullPackagePath(this.displayFullPackagePath);
            return pkgComponent;
        }
    }

    public static class ConstructorResultItem
    extends JCResultItem {
        private JCConstructor ctr;
        private JCExpression substituteExp;
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private boolean isDeprecated;
        private static JCPaintComponent.ConstructorPaintComponent ctrComponent = null;

        public ConstructorResultItem(JCConstructor ctr, JCExpression substituteExp) {
            super(ctr);
            this.ctr = ctr;
            this.substituteExp = substituteExp;
            this.modifiers = ctr.getModifiers();
            this.isDeprecated = JCUtilities.isDeprecated(ctr);
            JCParameter[] prms = ctr.getParameters();
            for (int i = 0; i < prms.length; ++i) {
                JCParameter prm = prms[i];
                JCType type = prm.getType();
                this.params.add(new ParamStr(type.format(true), type.format(false), prm.getName(), this.getTypeColor(type.getClazz())));
            }
            JCClass[] excepts = ctr.getExceptions();
            for (int i = 0; i < excepts.length; ++i) {
                JCClass ex = excepts[i];
                this.excs.add(new ExcStr(ex.getName(), this.getTypeColor(ex)));
            }
        }

        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.ctr.getClazz().getName();
        }

        public List getParams() {
            return this.params;
        }

        public List getExceptions() {
            return this.excs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            String text = null;
            BaseDocument doc = (BaseDocument)c.getDocument();
            int selectionStartOffset = -1;
            int selectionEndOffset = -1;
            switch (this.substituteExp != null ? this.substituteExp.getExpID() : -1) {
                case 11: {
                    break;
                }
                case 10: {
                    JCParameter[] parms = this.ctr.getParameters();
                    if (parms.length == 0) {
                        try {
                            int fnwpos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(offset + len));
                            if (fnwpos > -1 && doc.getChars(fnwpos, 1)[0] == ')') {
                                text = doc.getText(offset + len, fnwpos + 1 - offset - len);
                                len = fnwpos + 1 - offset;
                            }
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                        if (text != null) break;
                        text = ")";
                        break;
                    }
                    int ind = this.substituteExp.getParameterCount() - 1;
                    boolean addSpace = false;
                    boolean addClosingParen = false;
                    Formatter f = doc.getFormatter();
                    if (f instanceof ExtFormatter) {
                        Object o = ((ExtFormatter)f).getSettingValue("java-format-space-after-comma");
                        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                            addSpace = true;
                        }
                        if ((o = ((ExtFormatter)f).getSettingValue("pair-characters-completion")) instanceof Boolean && ((Boolean)o).booleanValue()) {
                            addClosingParen = true;
                        }
                    }
                    try {
                        if (addSpace && (ind == 0 || offset > 0 && Character.isWhitespace(doc.getText(offset - 1, 1).charAt(0)))) {
                            addSpace = false;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                    if (ind >= parms.length) break;
                    text = addSpace ? " " : "";
                    selectionStartOffset = text.length();
                    text = text + parms[ind].getName();
                    selectionEndOffset = text.length();
                    if (!addClosingParen || ind != parms.length - 1) break;
                    String paramsText = null;
                    try {
                        int fnwpos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(offset + len));
                        if (fnwpos > -1 && doc.getChars(fnwpos, 1)[0] == ')') {
                            paramsText = doc.getText(offset + len, fnwpos + 1 - offset - len);
                            text = text + paramsText;
                            len = fnwpos + 1 - offset;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                    if (paramsText != null) break;
                    text = text + ')';
                    break;
                }
                default: {
                    text = this.getItemText();
                    boolean addSpace = false;
                    boolean addClosingParen = false;
                    Formatter f = doc.getFormatter();
                    if (f instanceof ExtFormatter) {
                        Object o = ((ExtFormatter)f).getSettingValue("java-format-space-before-parenthesis");
                        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                            addSpace = true;
                        }
                        if ((o = ((ExtFormatter)f).getSettingValue("pair-characters-completion")) instanceof Boolean && ((Boolean)o).booleanValue()) {
                            addClosingParen = true;
                        }
                    }
                    String paramsText = null;
                    try {
                        int fnwpos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(offset + len));
                        if (fnwpos > -1 && doc.getChars(fnwpos, 1)[0] == '(') {
                            paramsText = doc.getText(offset + len, fnwpos + 1 - offset - len);
                            if (addSpace && paramsText.length() < 2) {
                                text = text + ' ';
                            }
                            len = fnwpos + 1 - offset;
                            text = text + paramsText;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                    JCParameter[] parms = this.ctr.getParameters();
                    if (paramsText == null) {
                        if (addSpace) {
                            text = text + ' ';
                        }
                        text = text + '(';
                        if (parms.length > 0) {
                            selectionStartOffset = text.length();
                            text = text + parms[0].getName();
                            selectionEndOffset = text.length();
                        }
                        if (parms.length != 0 && (!addClosingParen || parms.length != 1)) break;
                        text = text + ")";
                        break;
                    }
                    try {
                        int fnwpos = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(offset + len));
                        if (fnwpos <= -1 || doc.getChars(fnwpos, 1)[0] != ')') break;
                        paramsText = doc.getText(offset + len, fnwpos + 1 - offset - len);
                        len = fnwpos + 1 - offset;
                        if (parms.length > 0) {
                            selectionStartOffset = text.length();
                            text = text + parms[0].getName();
                            selectionEndOffset = text.length();
                        }
                        text = text + paramsText;
                        break;
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
            }
            if (text != null) {
                doc.atomicLock();
                try {
                    boolean bl;
                    String textToReplace = doc.getText(offset, len);
                    if (text.equals(textToReplace)) {
                        c.setCaretPosition(offset + len);
                        bl = false;
                        return bl;
                    }
                    doc.remove(offset, len);
                    doc.insertString(offset, text, null);
                    if (selectionStartOffset >= 0) {
                        c.select(offset + selectionStartOffset, offset + selectionEndOffset);
                    }
                    bl = true;
                    return bl;
                }
                catch (BadLocationException e) {
                }
                finally {
                    doc.atomicUnlock();
                }
            }
            return false;
        }

        public String getItemText() {
            return this.ctr.getClazz().getName();
        }

        protected JCPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new JCPaintComponent.ConstructorPaintComponent();
        }

        public Component getPaintComponent(boolean isSelected) {
            if (ctrComponent == null) {
                ctrComponent = this.createPaintComponent();
            }
            ctrComponent.setName(this.getItemText());
            ctrComponent.setModifiers(this.getModifiers());
            ctrComponent.setParams(this.getParams());
            ctrComponent.setExceptions(this.getExceptions());
            ctrComponent.setDeprecated(this.isDeprecated);
            ctrComponent.setSelected(isSelected);
            return ctrComponent;
        }
    }

    public static class MethodResultItem
    extends ConstructorResultItem {
        private static JCPaintComponent.MethodPaintComponent mtdComponent = null;
        private String typeName;
        private Color typeColor;
        private String mtdName;

        public MethodResultItem(JCMethod mtd, JCExpression substituteExp) {
            super(mtd, substituteExp);
            this.typeName = MethodResultItem.getTypeName(mtd.getReturnType());
            this.mtdName = mtd.getName();
            this.typeColor = this.getTypeColor(mtd.getReturnType().getClazz());
        }

        public String getName() {
            return this.mtdName;
        }

        public String getItemText() {
            return this.getName();
        }

        protected JCPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new JCPaintComponent.MethodPaintComponent();
        }

        public Component getPaintComponent(boolean isSelected) {
            if (mtdComponent == null) {
                mtdComponent = (JCPaintComponent.MethodPaintComponent)this.createPaintComponent();
            }
            mtdComponent.setName(this.getName());
            mtdComponent.setModifiers(this.getModifiers());
            mtdComponent.setTypeName(this.typeName);
            mtdComponent.setTypeColor(this.typeColor);
            mtdComponent.setParams(this.getParams());
            mtdComponent.setExceptions(this.getExceptions());
            mtdComponent.setDeprecated(this.isDeprecated());
            mtdComponent.setSelected(isSelected);
            return mtdComponent;
        }
    }

    public static class FieldResultItem
    extends JCResultItem {
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;
        private boolean isDeprecated;
        private static JCPaintComponent.FieldPaintComponent fieldComponent = null;

        public FieldResultItem(JCField fld) {
            super(fld);
            this.fldName = fld.getName();
            this.modifiers = fld.getModifiers();
            this.typeName = FieldResultItem.getTypeName(fld.getType());
            this.typeColor = this.getTypeColor(fld.getType().getClazz());
            this.isDeprecated = JCUtilities.isDeprecated(fld);
        }

        public String getItemText() {
            return this.fldName;
        }

        protected JCPaintComponent.FieldPaintComponent createPaintComponent() {
            return new JCPaintComponent.FieldPaintComponent();
        }

        public Component getPaintComponent(boolean isSelected) {
            if (fieldComponent == null) {
                fieldComponent = this.createPaintComponent();
            }
            fieldComponent.setTypeName(this.typeName);
            fieldComponent.setName(this.fldName);
            fieldComponent.setTypeColor(this.typeColor);
            fieldComponent.setModifiers(this.modifiers);
            fieldComponent.setSelected(isSelected);
            fieldComponent.setDeprecated(this.isDeprecated);
            return fieldComponent;
        }
    }
}

