/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import org.netbeans.modules.css.CSSObject;
import org.netbeans.modules.css.actions.Util;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CookieAction;
import org.openide.util.datatransfer.ExClipboard;

public abstract class CopyStyleAction
extends CookieAction {
    protected static final String comment = Util.THIS.getString("Style-Comment") + "\n";
    private static final long serialVersionUID = -6638807099960633334L;

    public int mode() {
        return 8;
    }

    public Class[] cookieClasses() {
        return new Class[]{CSSObject.class};
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length != 1) {
            return;
        }
        if (nodes[0] == null) {
            return;
        }
        CSSObject csso = (CSSObject)nodes[0].getCookie(CSSObject.class);
        if (csso != null) {
            String pi = this.createText(csso);
            StringSelection ss = new StringSelection(pi);
            ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
            clipboard.setContents((Transferable)ss, null);
            StatusDisplayer.getDefault().setStatusText(Util.THIS.getString("MSG_Style_tag_in_clipboard"));
        }
    }

    protected abstract String createText(CSSObject var1);

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected String getHref(FileObject fo) {
        URL u = URLMapper.findURL((FileObject)fo, (int)2);
        if (u != null) {
            return u.toExternalForm();
        }
        return fo.getPath();
    }

    public static final class HTML
    extends CopyStyleAction {
        private static final long serialVersionUID = -6638807099960633336L;

        protected String createText(CSSObject csso) {
            return comment + "<link rel=\"StyleSheet\" type=\"text/css\" href=\"" + this.getHref(csso.getPrimaryFile()) + "\" media=\"screen\" >";
        }

        public String getName() {
            return Util.THIS.getString("Copy-HTML-Style");
        }
    }

    public static final class XML
    extends CopyStyleAction {
        private static final long serialVersionUID = -6638807099960633335L;

        protected String createText(CSSObject csso) {
            return comment + "<?xml-stylesheet type=\"text/css\" href=\"" + this.getHref(csso.getPrimaryFile()) + "\" ?>";
        }

        public String getName() {
            return Util.THIS.getString("Copy-XML-Style");
        }
    }
}

