/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

public class ContextTreeView
extends TreeView {
    static final long serialVersionUID = -8282594827988436813L;
    static /* synthetic */ Class class$org$openide$explorer$view$ContextTreeView;

    public ContextTreeView() {
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    protected boolean selectionAccept(Node[] nodes) {
        if (nodes.length == 0) {
            return true;
        }
        Node parent = nodes[0].getParentNode();
        for (int i = 1; i < nodes.length; ++i) {
            if (nodes[i].getParentNode() == parent) continue;
            return false;
        }
        return true;
    }

    protected void selectionChanged(Node[] nodes, ExplorerManager man) throws PropertyVetoException {
        if (nodes.length > 0) {
            man.setExploredContext(nodes[0]);
        }
        man.setSelectedNodes(nodes);
    }

    protected void showPath(TreePath path) {
        this.tree.makeVisible(path);
        Rectangle rect = this.tree.getPathBounds(path);
        if (rect != null) {
            rect.width += rect.x;
            rect.x = 0;
            this.tree.scrollRectToVisible(rect);
        }
        this.tree.setSelectionPath(path);
    }

    protected void showSelection(TreePath[] paths) {
        if (paths.length == 0) {
            this.tree.setSelectionPaths(new TreePath[0]);
        } else {
            this.tree.setSelectionPath(paths[0].getParentPath());
        }
    }

    protected boolean useExploredContextMenu() {
        return true;
    }

    protected NodeTreeModel createModel() {
        return new NodeContextModel();
    }

    static final class NodeContextModel
    extends NodeTreeModel {
        private int[] newIndices;
        private Object[] newChildren;
        static final /* synthetic */ boolean $assertionsDisabled;

        NodeContextModel() {
        }

        public Object getChild(Object parent, int index) {
            int superCnt = super.getChildCount(parent);
            int myCnt = 0;
            for (int i = 0; i < superCnt; ++i) {
                Object origChild = super.getChild(parent, i);
                Node n = Visualizer.findNode(origChild);
                if (n.isLeaf() || myCnt++ != index) continue;
                return origChild;
            }
            return null;
        }

        public int getChildCount(Object parent) {
            int superCnt = super.getChildCount(parent);
            int myCnt = 0;
            for (int i = 0; i < superCnt; ++i) {
                Node n = Visualizer.findNode(super.getChild(parent, i));
                if (n.isLeaf()) continue;
                ++myCnt;
            }
            return myCnt;
        }

        public int getIndexOfChild(Object parent, Object child) {
            int superCnt = super.getChildCount(parent);
            int myCnt = 0;
            for (int i = 0; i < superCnt; ++i) {
                Object origChild = super.getChild(parent, i);
                if (child.equals(origChild)) {
                    return myCnt;
                }
                Node n = Visualizer.findNode(origChild);
                if (n.isLeaf()) continue;
                ++myCnt;
            }
            return -1;
        }

        public boolean isLeaf(Object node) {
            return false;
        }

        private boolean filterEvent(Object[] path, int[] childIndices, Object[] children) {
            int i;
            if (!($assertionsDisabled || childIndices != null && children != null)) {
                throw new AssertionError((Object)(" ch: " + children + " indices: " + childIndices));
            }
            if (!$assertionsDisabled && children.length != childIndices.length) {
                throw new AssertionError((Object)("They should be the same: " + children.length + " == " + childIndices.length));
            }
            if (!$assertionsDisabled && this.newChildren != null) {
                throw new AssertionError((Object)("Children should be cleared: " + this.newChildren));
            }
            if (!$assertionsDisabled && this.newIndices != null) {
                throw new AssertionError((Object)("indices should be cleared: " + this.newIndices));
            }
            if (!$assertionsDisabled && path.length <= 0) {
                throw new AssertionError((Object)("Path has to be greater than zero " + path.length));
            }
            VisualizerNode parent = (VisualizerNode)path[path.length - 1];
            int[] filter = new int[childIndices.length];
            int accepted = 0;
            for (i = 0; i < childIndices.length; ++i) {
                VisualizerNode n = (VisualizerNode)children[i];
                if (n.isLeaf()) continue;
                filter[accepted++] = i;
            }
            if (accepted == 0) {
                return false;
            }
            this.newIndices = new int[accepted];
            this.newChildren = new Object[accepted];
            for (i = 0; i < accepted; ++i) {
                this.newChildren[i] = children[filter[i]];
                this.newIndices[i] = this.getIndexOfChild(parent, this.newChildren[i]);
            }
            return true;
        }

        private boolean removalEvent(Object[] path, int[] childIndices, Object[] children) {
            if (!($assertionsDisabled || childIndices != null && children != null)) {
                throw new AssertionError((Object)(" ch: " + children + " indices: " + childIndices));
            }
            if (!$assertionsDisabled && children.length != childIndices.length) {
                throw new AssertionError((Object)("They should be the same: " + children.length + " == " + childIndices.length));
            }
            if (!$assertionsDisabled && this.newChildren != null) {
                throw new AssertionError((Object)("Children should be cleared: " + this.newChildren));
            }
            if (!$assertionsDisabled && this.newIndices != null) {
                throw new AssertionError((Object)("indices should be cleared: " + this.newIndices));
            }
            if (!$assertionsDisabled && path.length <= 0) {
                throw new AssertionError((Object)("Path has to be greater than zero " + path.length));
            }
            VisualizerNode parent = (VisualizerNode)path[path.length - 1];
            int[] filter = new int[childIndices.length];
            int accepted = 0;
            for (int i = 0; i < childIndices.length; ++i) {
                VisualizerNode n = (VisualizerNode)children[i];
                if (n.isLeaf()) continue;
                filter[accepted++] = i;
            }
            if (accepted == 0) {
                return false;
            }
            this.newIndices = new int[accepted];
            this.newChildren = new Object[accepted];
            int size = this.getChildCount(parent);
            int index = 0;
            int myPos = 0;
            int actualI = 0;
            int i = 0;
            int pos = 0;
            while (pos < accepted) {
                VisualizerNode n;
                if (childIndices[index] <= i) {
                    n = (VisualizerNode)children[index];
                    if (!n.isLeaf()) {
                        this.newIndices[pos] = myPos++;
                        this.newChildren[pos] = n;
                        ++pos;
                    }
                    ++index;
                } else if ((n = (VisualizerNode)this.getChild(parent, actualI++)) != null && !n.isLeaf()) {
                    ++myPos;
                }
                ++i;
            }
            return true;
        }

        protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            if (!this.removalEvent(path, childIndices, children)) {
                return;
            }
            super.fireTreeNodesRemoved(source, path, this.newIndices, this.newChildren);
            this.newIndices = null;
            this.newChildren = null;
        }

        protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            if (!this.filterEvent(path, childIndices, children)) {
                return;
            }
            super.fireTreeNodesInserted(source, path, this.newIndices, this.newChildren);
            this.newIndices = null;
            this.newChildren = null;
        }

        protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            if (!this.filterEvent(path, childIndices, children)) {
                return;
            }
            super.fireTreeNodesChanged(source, path, this.newIndices, this.newChildren);
            this.newIndices = null;
            this.newChildren = null;
        }

        static {
            $assertionsDisabled = !(class$org$openide$explorer$view$ContextTreeView == null ? (class$org$openide$explorer$view$ContextTreeView = ContextTreeView.class$("org.openide.explorer.view.ContextTreeView")) : class$org$openide$explorer$view$ContextTreeView).desiredAssertionStatus();
        }
    }
}

