/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.action;

import java.io.IOException;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.core.webservices.action.WebServiceClassesCookie;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebServiceClassesCookieImpl
implements WebServiceClassesCookie {
    WebserviceDescription webServiceDescription;
    FileObject implClassFO;

    public WebServiceClassesCookieImpl(WebserviceDescription webServiceDescription, FileObject implClassFO) {
        this.webServiceDescription = webServiceDescription;
        this.implClassFO = implClassFO;
    }

    private JavaClass getSEIClass() {
        PortComponent portComponent = this.webServiceDescription.getPortComponent(0);
        String sei = portComponent.getServiceEndpointInterface();
        JavaClass cl = JMIUtils.findClass((String)sei, (FileObject)this.implClassFO);
        return cl;
    }

    private JavaClass getImplBeanClass() {
        WebServicesSupport wsSupport;
        String implBean;
        PortComponent portComponent = this.webServiceDescription.getPortComponent(0);
        ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
        String link = serviceImplBean.getServletLink();
        if (link == null) {
            link = serviceImplBean.getEjbLink();
        }
        if ((implBean = (wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)this.implClassFO)).getImplementationBean(link)) != null) {
            return JMIUtils.findClass((String)implBean, (FileObject)this.implClassFO);
        }
        return null;
    }

    private String getImplicitValue(Type t) {
        String ret = "return ";
        if (t instanceof PrimitiveType) {
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.BOOLEAN)) {
                return "false";
            }
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.CHAR)) {
                return "''";
            }
            return "0";
        }
        if (t instanceof JavaClass) {
            return "null";
        }
        if (t instanceof Array) {
            return "new " + t.getName() + " { }";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(Method m) {
        JavaClass implClass = null;
        JavaClass seiClass = null;
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            String retString;
            m.setJavadocText("Web service operation");
            implClass = this.getImplBeanClass();
            String body = NbBundle.getMessage(WebServiceClassesCookieImpl.class, (String)"TXT_VoidOperation");
            Type returnType = m.getType();
            if (!(returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getKind().equals(PrimitiveTypeKindEnum.VOID) || (retString = this.getImplicitValue(m.getType())) == null)) {
                body = body + "return " + retString + ";";
            }
            seiClass = this.getSEIClass();
            String remoteExceptionName = "java.rmi.RemoteException";
            boolean excFound = false;
            for (MultipartId id : m.getExceptionNames()) {
                if (!"java.rmi.RemoteException".equals(id.getName())) continue;
                excFound = true;
                break;
            }
            if (!excFound) {
                JMIUtils.addException((Method)m, (String)"java.rmi.RemoteException");
            }
            if (seiClass != null) {
                Method newMet = (Method)JavaModelUtil.duplicateInScope((Element)seiClass, (Element)m);
                seiClass.getContents().add(newMet);
            }
            if (implClass != null) {
                implClass.getContents().add(m);
            }
            JMIUtils.fixImports((JavaClass)implClass);
            JMIUtils.fixImports((JavaClass)seiClass);
            m.setBodyText(body);
            rollback = false;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        this.save(seiClass);
        JMIUtils.openInEditor((Element)m);
    }

    private void save(JavaClass jc) {
        if (jc == null) {
            return;
        }
        SaveCookie saveCookie = (SaveCookie)JMIUtils.getCookie((Feature)jc, SaveCookie.class);
        if (saveCookie != null) {
            try {
                saveCookie.save();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(4096, (Throwable)ioe);
            }
        }
    }
}

