/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JaxWsTesterCookie;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

public class WsTesterPageAction
extends CookieAction {
    public String getName() {
        return NbBundle.getMessage(WsTesterPageAction.class, (String)"LBL_TesterPageAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{JaxWsTesterCookie.class};
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        JaxWsTesterCookie cookie = (JaxWsTesterCookie)activatedNodes[0].getCookie(JaxWsTesterCookie.class);
        String wsdlURL = cookie.getTesterPageURL();
        try {
            final URL url = new URL(wsdlURL);
            if (url != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        boolean connectionOK;
                        block11: {
                            connectionOK = false;
                            try {
                                URLConnection connection = url.openConnection();
                                if (!(connection instanceof HttpURLConnection)) break block11;
                                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                                try {
                                    httpConnection.setRequestMethod("GET");
                                    httpConnection.connect();
                                    if (200 == httpConnection.getResponseCode()) {
                                        connectionOK = true;
                                    }
                                }
                                catch (ConnectException ex) {
                                }
                                finally {
                                    if (httpConnection != null) {
                                        httpConnection.disconnect();
                                    }
                                }
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify((Throwable)ex);
                            }
                        }
                        if (connectionOK) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                        } else {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WsTesterPageAction.class, (String)"MSG_UNABLE_TO_OPEN_TEST_PAGE", (Object)url), 2));
                        }
                    }
                });
            }
        }
        catch (MalformedURLException ex) {
            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(NbBundle.getMessage(WsTesterPageAction.class, (String)"TXT_TesterPageUrl"), wsdlURL));
            System.out.println(cookie.getTesterPageURL());
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        Project project;
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        FileObject srcRoot = (FileObject)activatedNodes[0].getLookup().lookup(FileObject.class);
        if (srcRoot != null && (project = FileOwnerQuery.getOwner((FileObject)srcRoot)) != null) {
            return this.isTesterPageSupported(project);
        }
        return false;
    }

    private boolean isTesterPageSupported(Project project) {
        J2eePlatform j2eePlatform;
        Map properties;
        String serverInstance;
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        if (wss != null && (serverInstance = (String)(properties = wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties()).get("j2ee.server.instance")) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null) {
            return j2eePlatform.isToolSupported("jaxws-tester");
        }
        return false;
    }
}

