/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Context;
import org.apache.catalina.Group;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Role;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;

public class UserDatabaseRealm
extends RealmBase {
    protected UserDatabase database = null;
    protected final String info = "org.apache.catalina.realm.UserDatabaseRealm/1.0";
    protected static final String name = "UserDatabaseRealm";
    protected String resourceName = "UserDatabase";
    private static StringManager sm = StringManager.getManager("org.apache.catalina.realm");

    public String getInfo() {
        return "org.apache.catalina.realm.UserDatabaseRealm/1.0";
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean hasRole(Principal principal, String role) {
        GenericPrincipal gp;
        if (principal instanceof GenericPrincipal && (gp = (GenericPrincipal)principal).getUserPrincipal() instanceof User) {
            principal = gp.getUserPrincipal();
        }
        if (!(principal instanceof User)) {
            return super.hasRole(principal, role);
        }
        if ("*".equals(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        User user = (User)principal;
        Role dbrole = this.database.findRole(role);
        if (dbrole == null) {
            return false;
        }
        if (user.isInRole(dbrole)) {
            return true;
        }
        Iterator groups = user.getGroups();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            if (!group.isInRole(dbrole)) continue;
            return true;
        }
        return false;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        User user = this.database.findUser(username);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    protected Principal getPrincipal(String username) {
        User user = this.database.findUser(username);
        if (user == null) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>();
        Iterator uroles = user.getRoles();
        while (uroles.hasNext()) {
            Role role = (Role)uroles.next();
            roles.add(role.getName());
        }
        Iterator groups = user.getGroups();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            uroles = user.getRoles();
            while (uroles.hasNext()) {
                Role role = (Role)uroles.next();
                roles.add(role.getName());
            }
        }
        return new GenericPrincipal(this, username, user.getPassword(), roles, user);
    }

    public synchronized void start() throws LifecycleException {
        super.start();
        try {
            StandardServer server = (StandardServer)ServerFactory.getServer();
            Context context = server.getGlobalNamingContext();
            this.database = (UserDatabase)context.lookup(this.resourceName);
        }
        catch (Throwable e) {
            this.containerLog.error((Object)sm.getString("userDatabaseRealm.lookup", this.resourceName), e);
            this.database = null;
        }
        if (this.database == null) {
            throw new LifecycleException(sm.getString("userDatabaseRealm.noDatabase", this.resourceName));
        }
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
        this.database = null;
    }
}

