/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class TagHandlerGenerator {
    private Object[][] attributes;
    private ClassElement clazz;
    private boolean isBodyTag;
    private boolean evaluateBody;

    public TagHandlerGenerator(ClassElement clazz, Object[][] attributes, boolean isBodyTag, boolean evaluateBody) {
        this.clazz = clazz;
        this.attributes = attributes;
        this.isBodyTag = isBodyTag;
        this.evaluateBody = evaluateBody;
    }

    public void generate() throws SourceException {
        this.addFields();
        if (this.isBodyTag) {
            this.addBodyEvaluatorCheck(this.evaluateBody);
        }
        this.addSetters();
    }

    private void addFields() throws SourceException {
        for (int i = 0; i < this.attributes.length; ++i) {
            FieldElement field = new FieldElement();
            field.setName(Identifier.create((String)((String)this.attributes[i][0])));
            field.setModifiers(2);
            String type = (String)this.attributes[i][1];
            field.setType(Type.parse((String)type));
            JavaDoc.Field doc = field.getJavaDoc();
            doc.setRawText("Initialization of " + this.attributes[i][0] + " property.");
            this.clazz.addField(field);
        }
    }

    private void addSetters() throws SourceException {
        for (int i = 0; i < this.attributes.length; ++i) {
            MethodElement method = new MethodElement();
            String attrName = (String)this.attributes[i][0];
            String firstLetter = attrName.substring(0, 1).toUpperCase();
            String methodName = "set" + firstLetter + attrName.substring(1);
            method.setName(Identifier.create((String)methodName));
            method.setReturn(Type.VOID);
            method.setModifiers(1);
            String type = (String)this.attributes[i][1];
            MethodParameter mp = MethodParameter.parse((String)(type + " value"));
            method.setParameters(new MethodParameter[]{mp});
            method.setBody("this." + attrName + " = value;");
            JavaDoc.Method doc = method.getJavaDoc();
            doc.setRawText("Setter for the " + attrName + " attribute.");
            this.clazz.addMethod(method);
        }
    }

    private void addBodyEvaluatorCheck(boolean evaluateBody) throws SourceException {
        MethodElement method = new MethodElement();
        String methodName = "theBodyShouldBeEvaluated";
        method.setName(Identifier.create((String)methodName));
        method.setReturn(Type.BOOLEAN);
        method.setModifiers(2);
        method.setParameters(new MethodParameter[0]);
        StringBuffer buf = new StringBuffer();
        buf.append("\n//");
        buf.append("\n// TODO: code that determines whether the body should be");
        buf.append("\n//       evaluated should be placed here.");
        buf.append("\n//       Called from the doStartTag() method.");
        buf.append("\n//");
        buf.append("\nreturn " + (evaluateBody ? "true;" : "false;"));
        buf.append("\n");
        method.setBody(buf.toString());
        JavaDoc.Method doc = method.getJavaDoc();
        buf = new StringBuffer();
        buf.append("Fill in this method to determine if the tag body should be evaluated.");
        buf.append("\nCalled from doStartTag().");
        doc.setRawText(buf.toString());
        this.clazz.addMethod(method);
    }
}

