/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.selectvalue;

import com.sun.j2ee.blueprints.ui.selectvalue.SelectValueComponent;
import com.sun.j2ee.blueprints.ui.util.BaseRenderer;
import com.sun.j2ee.blueprints.ui.util.Util;
import java.beans.Beans;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class SelectValueRenderer
extends BaseRenderer {
    private static final String SELECT_SUFFIX = "_selectdiv";
    private static final String INPUT_SUFFIX = "_text";
    private static final String SCRIPT_RESOURCE = "/META-INF/selectvalue/script.js";
    private static final String SELECTVALUE_HANDLER = "/bpui_selectvalue_handler/matchValue";
    private static XhtmlHelper helper = new XhtmlHelper();

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!(component instanceof UIInput)) {
            return;
        }
        if (SelectValueRenderer.componentIsDisabledOnReadonly(component)) {
            return;
        }
        String clientId = this.replaceColon(component.getClientId(context));
        clientId = clientId + INPUT_SUFFIX;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        if (requestMap.containsKey(clientId)) {
            String newValue = (String)requestMap.get(clientId);
            ((UIInput)component).setSubmittedValue((Object)newValue);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        SelectValueComponent comp = (SelectValueComponent)component;
        String itemsMethod = null;
        if (comp.getItemsMethod() != null) {
            itemsMethod = comp.getItemsMethod().getExpressionString();
        }
        if (!Beans.isDesignTime()) {
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, "/META-INF/common/script.js");
            Util.renderDojoLoading(context, component, writer);
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, SCRIPT_RESOURCE);
            writer.startElement("script", (UIComponent)comp);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("\n");
            writer.write("bpui.selectvalue.messages[\"bindError\"] = \"" + Util.getMessage("selectvalue.bindError") + "\";");
            writer.write("\n");
            writer.endElement("script");
            writer.write("\n");
        }
        writer.startElement("div", component);
        String clientId = this.replaceColon(component.getClientId(context));
        writer.writeAttribute("id", (Object)clientId, "id");
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        String width = null;
        String height = null;
        String style = comp.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
            int beginIdx = style.indexOf("width");
            int endIdx = style.indexOf(";", beginIdx);
            if (endIdx == -1) {
                endIdx = style.length();
            }
            if (beginIdx != -1 && endIdx != 1) {
                width = style.substring(beginIdx, endIdx);
            }
            if ((endIdx = style.indexOf(";", (beginIdx = style.indexOf("height")) + 1)) == -1) {
                endIdx = style.length();
            }
            if (beginIdx != -1 && endIdx != 1) {
                height = style.substring(beginIdx, endIdx);
            }
        }
        String id = clientId + INPUT_SUFFIX;
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)id, "id");
        String inputStyle = "";
        if (width != null) {
            inputStyle = inputStyle + width;
        }
        if (height != null) {
            if (width != null) {
                inputStyle = inputStyle + ";";
            }
            inputStyle = inputStyle + height;
        }
        if (inputStyle != "") {
            writer.writeAttribute("style", (Object)inputStyle, "style");
        }
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("name", (Object)id, "clientId");
        Object text = comp.getValue();
        if (text != null) {
            writer.writeAttribute("value", text, "value");
        }
        if (!Beans.isDesignTime() && itemsMethod != null && itemsMethod.length() > 0) {
            String callback = helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, SELECTVALUE_HANDLER);
            String jsScript = "bpui.selectvalue.executeQuery('" + clientId + "','" + itemsMethod + "'" + ",'" + callback + "');";
            String onkeyup = (String)component.getAttributes().get("onkeyup");
            onkeyup = onkeyup != null && onkeyup.length() > 0 ? jsScript + onkeyup : jsScript;
            writer.writeAttribute("onkeyup", (Object)onkeyup, null);
            String onfocus = (String)component.getAttributes().get("onfocus");
            onfocus = onfocus != null && onfocus.length() > 0 ? jsScript + onfocus : jsScript;
            writer.writeAttribute("onfocus", (Object)onfocus, null);
        }
        SelectValueRenderer.renderPassThruAttributes(writer, component, new String[]{"onkeyup, onfocus"});
        SelectValueRenderer.renderBooleanPassThruAttributes(writer, component);
        writer.endElement("input");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(clientId + SELECT_SUFFIX), null);
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (Beans.isDesignTime()) {
            String item1 = Util.getMessage("selectvalue.design.selectitem1");
            String item2 = Util.getMessage("selectvalue.design.selectitem2");
            String item3 = Util.getMessage("selectvalue.design.selectitem3");
            writer.write("<br/><select id= '" + clientId + "_select" + "' size=\"1\" >" + "<option value='" + item1 + "'>" + item1 + "</option>" + "<option value='" + item2 + "'>" + item2 + "</option>" + "<option value='" + item3 + "'>" + item3 + "</option>" + "</select>\n");
        } else {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        writer.endElement("div");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
    }

    private String replaceColon(String clientId) {
        return clientId.replace(':', '_');
    }
}

