/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;

class BeanRepository {
    private Vector sessionBeans;
    private Vector pageBeans;
    private Vector appBeans;
    private Vector requestBeans;
    private Hashtable beanTypes;
    private ClassLoader loader;
    private ErrorDispatcher errDispatcher;

    public BeanRepository(ClassLoader loader, ErrorDispatcher err) {
        this.loader = loader;
        this.errDispatcher = err;
        this.sessionBeans = new Vector(11);
        this.pageBeans = new Vector(11);
        this.appBeans = new Vector(11);
        this.requestBeans = new Vector(11);
        this.beanTypes = new Hashtable();
    }

    public void addBean(Node.UseBean n, String s, String type, String scope) throws JasperException {
        if (scope == null || scope.equals("page")) {
            this.pageBeans.addElement(s);
        } else if (scope.equals("request")) {
            this.requestBeans.addElement(s);
        } else if (scope.equals("session")) {
            this.sessionBeans.addElement(s);
        } else if (scope.equals("application")) {
            this.appBeans.addElement(s);
        } else {
            this.errDispatcher.jspError(n, "jsp.error.invalid.scope", scope);
        }
        this.putBeanType(s, type);
    }

    public Class getBeanType(String bean) throws JasperException {
        Class<?> clazz = null;
        try {
            clazz = this.loader.loadClass((String)this.beanTypes.get(bean));
        }
        catch (ClassNotFoundException ex) {
            throw new JasperException(ex);
        }
        return clazz;
    }

    public boolean checkVariable(String bean) {
        return this.checkPageBean(bean) || this.checkSessionBean(bean) || this.checkRequestBean(bean) || this.checkApplicationBean(bean);
    }

    private void putBeanType(String bean, String type) {
        this.beanTypes.put(bean, type);
    }

    private boolean checkPageBean(String s) {
        return this.pageBeans.contains(s);
    }

    private boolean checkRequestBean(String s) {
        return this.requestBeans.contains(s);
    }

    private boolean checkSessionBean(String s) {
        return this.sessionBeans.contains(s);
    }

    private boolean checkApplicationBean(String s) {
        return this.appBeans.contains(s);
    }
}

