/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.form.FormI18nString;
import org.netbeans.modules.i18n.form.FormI18nStringEditor;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class FormI18nSupport
extends JavaI18nSupport {
    private static final String RAD_PROPERTIES = "properties";
    private static final String RAD_PROPERTIES2 = "properties2";
    private static final String RAD_ACCESSIBILITY = "accessibility";
    private static final String RAD_LAYOUT = "layout";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$form$FormI18nSupport;
    static /* synthetic */ Class class$org$netbeans$modules$form$FormDataObject;

    private FormI18nSupport(DataObject sourceDataObject) {
        super(sourceDataObject);
    }

    protected I18nSupport.I18nFinder createFinder() {
        return new FormI18nFinder(this.sourceDataObject, this.document);
    }

    protected I18nSupport.I18nReplacer createReplacer() {
        return new FormI18nReplacer((FormI18nFinder)this.getFinder());
    }

    public JPanel getInfo(HardCodedString hcString) {
        return new FormInfoPanel(hcString, this.document);
    }

    public static class Factory
    extends I18nSupport.Factory {
        Factory() {
        }

        public I18nSupport create(DataObject dataObject) throws IOException {
            I18nSupport support = super.create(dataObject);
            FormEditorSupport formSupport = ((FormDataObject)dataObject).getFormEditor();
            if (formSupport.isOpened()) {
                return support;
            }
            if (formSupport.loadForm()) {
                return support;
            }
            throw new IOException("I18N: Loading form for " + dataObject.getName() + " was not succesful.");
        }

        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new FormI18nSupport(dataObject);
        }

        public Class getDataObjectClass() {
            return class$org$netbeans$modules$form$FormDataObject == null ? (class$org$netbeans$modules$form$FormDataObject = FormI18nSupport.class$("org.netbeans.modules.form.FormDataObject")) : class$org$netbeans$modules$form$FormDataObject;
        }
    }

    private static class FormInfoPanel
    extends InfoPanel {
        public FormInfoPanel(HardCodedString hcString, StyledDocument document) {
            super(hcString, document);
        }

        protected void setHardCodedString(HardCodedString hcString, StyledDocument document) {
            String hardLine;
            this.getStringText().setText(hcString == null ? "" : hcString.getText());
            if (hcString.getStartPosition() == null) {
                hardLine = "";
            } else {
                int pos = hcString.getStartPosition().getOffset();
                try {
                    Element paragraph = document.getParagraphElement(pos);
                    hardLine = document.getText(paragraph.getStartOffset(), paragraph.getEndOffset() - paragraph.getStartOffset()).trim();
                }
                catch (BadLocationException ble) {
                    hardLine = "";
                }
            }
            this.getFoundInText().setText(hardLine);
            if (hcString instanceof FormHardCodedString) {
                this.getComponentText().setText(((FormHardCodedString)hcString).getValidProperty().getRADComponentName());
                this.getPropertyText().setText(((FormHardCodedString)hcString).getNodeProperty().getName());
            } else {
                this.remove(this.getComponentLabel());
                this.remove(this.getComponentText());
                this.remove(this.getPropertyLabel());
                this.remove(this.getPropertyText());
            }
        }
    }

    private static class FormHardCodedString
    extends HardCodedString {
        private ValidFormProperty validProperty;
        private Node.Property nodeProperty;

        FormHardCodedString(String text, Position startPosition, Position endPosition, ValidFormProperty validProperty, Node.Property nodeProperty) {
            super(text, startPosition, endPosition);
            this.validProperty = validProperty;
            this.nodeProperty = nodeProperty;
        }

        public ValidFormProperty getValidProperty() {
            return this.validProperty;
        }

        public Node.Property getNodeProperty() {
            return this.nodeProperty;
        }
    }

    private static class FormI18nReplacer
    extends JavaI18nSupport.JavaI18nReplacer {
        private FormI18nFinder finder;
        private final ResourceBundle bundle;

        public FormI18nReplacer(FormI18nFinder finder) {
            this.finder = finder;
            this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$form$FormI18nSupport == null ? (class$org$netbeans$modules$i18n$form$FormI18nSupport = FormI18nSupport.class$("org.netbeans.modules.i18n.form.FormI18nSupport")) : class$org$netbeans$modules$i18n$form$FormI18nSupport));
        }

        public void replace(HardCodedString hcString, I18nString i18nString) {
            if (hcString instanceof FormHardCodedString) {
                this.replaceInGuarded((FormHardCodedString)hcString, (JavaI18nString)i18nString);
            } else {
                super.replace(hcString, i18nString);
            }
        }

        private void replaceInGuarded(FormHardCodedString formHcString, JavaI18nString javaI18nString) {
            try {
                Object newValue;
                StringBuffer buff;
                String oldString;
                String replaceString = javaI18nString.getReplaceString();
                int lastPos = this.finder.getLastPosition().getOffset();
                int pos = formHcString.getEndPosition().getOffset();
                Node.Property nodeProperty = formHcString.getNodeProperty();
                ValidFormProperty validProp = formHcString.getValidProperty();
                Object oldValue = nodeProperty.getValue();
                if (nodeProperty instanceof FormProperty) {
                    if (oldValue instanceof RADConnectionPropertyEditor.RADConnectionDesignValue && ((RADConnectionPropertyEditor.RADConnectionDesignValue)oldValue).getType() == 2) {
                        oldString = ((RADConnectionPropertyEditor.RADConnectionDesignValue)oldValue).getCode();
                        buff = new StringBuffer(oldString);
                        int index = this.indexOfHardString(oldString, formHcString.getText(), validProp.getSkip());
                        if (index == -1) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)this.bundle.getString("MSG_StringNotFoundInGuarded"), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                        int startOffset = index;
                        int endOffset = startOffset + formHcString.getText().length() + 2;
                        buff.replace(startOffset, endOffset, replaceString);
                        RADConnectionPropertyEditor.RADConnectionDesignValue newConnectionValue = new RADConnectionPropertyEditor.RADConnectionDesignValue(buff.toString());
                        newValue = newConnectionValue;
                    } else {
                        ((FormProperty)nodeProperty).setCurrentEditor((PropertyEditor)new FormI18nStringEditor());
                        newValue = new FormI18nString(javaI18nString);
                    }
                } else {
                    oldString = (String)oldValue;
                    buff = new StringBuffer(oldString);
                    int index = this.indexOfHardString(oldString, formHcString.getText(), validProp.getSkip());
                    if (index == -1) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)this.bundle.getString("MSG_StringNotFoundInGuarded"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        return;
                    }
                    int startOffset = index;
                    int endOffset = startOffset + formHcString.getText().length() + 2;
                    buff.replace(startOffset, endOffset, replaceString);
                    newValue = buff.toString();
                }
                nodeProperty.setValue(newValue);
                this.finder.decrementLastFoundSkip();
                final StyledDocument document = javaI18nString.getSupport().getDocument();
                final int lastP = lastPos + replaceString.length() - formHcString.getText().length() - 2;
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (document instanceof AbstractDocument) {
                            ((AbstractDocument)((Object)document)).readLock();
                        }
                        try {
                            FormI18nReplacer.this.finder.setLastPosition(document.createPosition(lastP));
                        }
                        catch (BadLocationException ble) {
                            ErrorManager.getDefault().notify(1, (Throwable)ble);
                        }
                        finally {
                            if (document instanceof AbstractDocument) {
                                ((AbstractDocument)((Object)document)).readUnlock();
                            }
                        }
                    }
                });
            }
            catch (IllegalAccessException iae) {
                ErrorManager.getDefault().notify(1, (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                ErrorManager.getDefault().notify(1, (Throwable)ite);
            }
        }

        private int indexOfHardString(String source, String hardString, int skip) {
            while (skip >= 0) {
                int index = this.finder.indexOfNonI18nString(source, hardString, skip);
                if (index >= 0) {
                    return index;
                }
                --skip;
            }
            return -1;
        }
    }

    private static class FormI18nFinder
    extends JavaI18nSupport.JavaI18nFinder {
        private DataObject sourceDataObject;
        private String componentName = "";
        private String propertyName = "";
        private TreeSet formProperties;
        private ValidFormProperty lastFoundProp;

        public FormI18nFinder(DataObject sourceDataObject, StyledDocument document) {
            super(document);
            this.sourceDataObject = sourceDataObject;
            this.init();
        }

        private void init() {
            this.clearFormInfoValues();
            this.lastFoundProp = null;
            this.createFormProperties();
        }

        protected void reset() {
            super.reset();
            this.init();
        }

        void decrementLastFoundSkip() {
            if (this.lastFoundProp != null) {
                this.lastFoundProp.decrementSkip();
            }
        }

        private synchronized boolean createFormProperties() {
            this.formProperties = new TreeSet(new ValidFormPropertyComparator((FormDataObject)this.sourceDataObject));
            this.updateFormProperties();
            return true;
        }

        private synchronized void updateFormProperties() {
            if (this.formProperties == null) {
                return;
            }
            List c = ((FormDataObject)this.sourceDataObject).getFormEditor().getFormModel().getMetaComponents();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                RADComponent radComponent = (RADComponent)it.next();
                Node.PropertySet[] propSets = radComponent.getProperties();
                for (int i = 0; i < propSets.length; ++i) {
                    String setName = propSets[i].getName();
                    if (!(FormI18nSupport.RAD_PROPERTIES.equals(setName) || FormI18nSupport.RAD_PROPERTIES2.equals(setName) || FormI18nSupport.RAD_ACCESSIBILITY.equals(setName) || FormI18nSupport.RAD_LAYOUT.equals(setName))) continue;
                    Node.Property[] properties = propSets[i].getProperties();
                    for (int j = 0; j < properties.length; ++j) {
                        Object value;
                        Node.Property property = properties[j];
                        if (property.isHidden() || !(property instanceof FormProperty) || !((FormProperty)property).isChanged()) continue;
                        try {
                            value = property.getValue();
                        }
                        catch (IllegalAccessException iae) {
                            continue;
                        }
                        catch (InvocationTargetException ite) {
                            continue;
                        }
                        if (value == null || !property.getValueType().equals(class$java$lang$String == null ? FormI18nSupport.class$("java.lang.String") : class$java$lang$String) && (!(value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) || ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getType() != 3 && ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getType() != 2)) continue;
                        this.formProperties.add(new ValidFormProperty(radComponent.getName(), property));
                    }
                }
            }
        }

        protected HardCodedString findNextString() {
            HardCodedString hcString;
            this.clearFormInfoValues();
            boolean guarded = false;
            do {
                hcString = super.findNextString();
                if (this.i18nSearch) {
                    return hcString;
                }
                if (hcString == null) break;
                guarded = this.isInGuardedSection(hcString.getStartPosition(), hcString.getEndPosition());
                if (!guarded) continue;
                hcString = this.findInForm(hcString);
            } while (guarded && hcString == null);
            return hcString;
        }

        private void clearFormInfoValues() {
            this.componentName = "";
            this.propertyName = "";
        }

        private synchronized HardCodedString findInForm(HardCodedString hcString) {
            Iterator it;
            boolean found = false;
            String hardString = hcString.getText();
            ValidFormProperty validProp = null;
            Node.Property nodeProperty = null;
            if (this.lastFoundProp != null) {
                validProp = this.lastFoundProp;
                it = this.formProperties.tailSet(this.lastFoundProp).iterator();
            } else {
                it = this.formProperties.iterator();
            }
            do {
                Object value;
                if (validProp == null && it.hasNext()) {
                    validProp = (ValidFormProperty)it.next();
                }
                if (validProp == null) break;
                Node.Property property = validProp.getProperty();
                String radCompName = validProp.getRADComponentName();
                try {
                    value = property.getValue();
                }
                catch (IllegalAccessException iae) {
                    ErrorManager.getDefault().notify(1, (Throwable)iae);
                    validProp = null;
                    continue;
                }
                catch (InvocationTargetException ite) {
                    ErrorManager.getDefault().notify(1, (Throwable)ite);
                    validProp = null;
                    continue;
                }
                if (value != null && (property.getValueType().equals(class$java$lang$String == null ? FormI18nSupport.class$("java.lang.String") : class$java$lang$String) || value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue && (((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getType() == 3 || ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getType() == 2))) {
                    String string;
                    if (property instanceof FormProperty) {
                        if (value instanceof FormI18nString) {
                            validProp = null;
                            continue;
                        }
                        if (value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue) {
                            string = "";
                            RADConnectionPropertyEditor.RADConnectionDesignValue connectionValue = (RADConnectionPropertyEditor.RADConnectionDesignValue)value;
                            if (connectionValue.getType() == 3) {
                                string = connectionValue.getValue();
                                if (this.indexOfNonI18nString(string, hardString, validProp.getSkip()) != -1) {
                                    found = true;
                                }
                            } else if (connectionValue.getType() == 2 && this.indexOfNonI18nString(string = connectionValue.getCode(), hardString, validProp.getSkip()) != -1) {
                                found = true;
                            }
                        } else {
                            string = FormI18nFinder.toAscii((String)value);
                            if (validProp.getSkip() == 0 && string.equals(hardString)) {
                                found = true;
                            }
                        }
                    } else {
                        string = (String)value;
                        if (this.indexOfNonI18nString(string, hardString, validProp.getSkip()) != -1) {
                            found = true;
                        }
                    }
                }
                if (found) {
                    nodeProperty = property;
                    this.componentName = radCompName;
                    this.propertyName = property.getName();
                    break;
                }
                validProp = null;
            } while (it.hasNext());
            if (found) {
                this.lastFoundProp = new ValidFormProperty(validProp);
                this.lastFoundProp.incrementSkip();
                return new FormHardCodedString(hcString.getText(), hcString.getStartPosition(), hcString.getEndPosition(), validProp, nodeProperty);
            }
            return null;
        }

        public Position getLastPosition() {
            return this.lastPosition;
        }

        public void setLastPosition(Position lastPosition) {
            this.lastPosition = lastPosition;
        }

        public int indexOfNonI18nString(String source, String hardString, int skip) {
            int startString;
            int index = 0;
            int startIndex = 0;
            while ((startString = source.indexOf(34, startIndex)) != -1) {
                int endString = source.indexOf(34, startString + 1);
                int endLineIndex = source.indexOf(10, startString + 1);
                if (endLineIndex == -1 || endString < endLineIndex) {
                    int quote;
                    String partLine;
                    String foundString = source.substring(startString, endString + 1);
                    int startLine = source.indexOf(10, startIndex + 1);
                    if (startLine != -1 && startLine < startString) {
                        startIndex = startLine + 1;
                    }
                    if (this.isSearchedString(partLine = endLineIndex == -1 ? source.substring(startIndex) : ((quote = source.indexOf(34, endString + 1)) != -1 && quote < endLineIndex ? source.substring(startIndex, quote) + source.substring(quote, endLineIndex).replace('\"', '_') : source.substring(startIndex, endLineIndex)), foundString)) {
                        if (index == skip) {
                            if (foundString.equals("\"" + hardString + "\"")) {
                                return startString;
                            }
                            return -1;
                        }
                        ++index;
                    }
                    startIndex = endString + 1;
                    continue;
                }
                startIndex = endLineIndex + 1;
            }
            return -1;
        }

        private static String toAscii(String str) {
            StringBuffer buf = new StringBuffer(str.length() * 6);
            char[] chars = str.toCharArray();
            block9: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (c) {
                    case '\b': {
                        buf.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block9;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block9;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block9;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block9;
                    }
                    default: {
                        if (c >= ' ' && c <= '\u007f') {
                            buf.append(c);
                            continue block9;
                        }
                        buf.append("\\u");
                        String hex = Integer.toHexString(c);
                        for (int j = 0; j < 4 - hex.length(); ++j) {
                            buf.append('0');
                        }
                        buf.append(hex);
                    }
                }
            }
            return buf.toString();
        }

        private synchronized boolean isInGuardedSection(Position startPos, Position endPos) {
            JavaEditor javaEditor = ((JavaDataObject)this.sourceDataObject).getJavaEditor();
            return javaEditor.testOverlap(javaEditor.createBounds(startPos.getOffset(), endPos.getOffset(), false));
        }

        DataObject getSourceDataObject() {
            return this.sourceDataObject;
        }
    }

    private static class ValidFormPropertyComparator
    implements Comparator {
        private static final String CREATION_CODE_PRE = "creationCodePre";
        private static final String CREATION_CODE_CUSTOM = "creationCodeCustom";
        private static final String CREATION_CODE_POST = "creationCodePost";
        private static final String INIT_CODE_PRE = "initCodePre";
        private static final String INIT_CODE_POST = "initCodePost";
        private final FormModel formModel;

        public ValidFormPropertyComparator(FormDataObject formDataObject) {
            this.formModel = formDataObject.getFormEditor().getFormModel();
        }

        public int compare(Object o1, Object o2) {
            String propName1 = ((ValidFormProperty)o1).getProperty().getName();
            String propName2 = ((ValidFormProperty)o2).getProperty().getName();
            boolean isInCreation1 = false;
            boolean isInCreation2 = false;
            if (propName1.equals(CREATION_CODE_PRE) || propName1.equals(CREATION_CODE_CUSTOM) || propName1.equals(CREATION_CODE_POST)) {
                isInCreation1 = true;
            }
            if (propName2.equals(CREATION_CODE_PRE) || propName2.equals(CREATION_CODE_CUSTOM) || propName2.equals(CREATION_CODE_POST)) {
                isInCreation2 = true;
            }
            if (isInCreation1 != isInCreation2) {
                return isInCreation1 ? -1 : 1;
            }
            RADComponent comp1 = this.formModel.findRADComponent(((ValidFormProperty)o1).getRADComponentName());
            RADComponent comp2 = this.formModel.findRADComponent(((ValidFormProperty)o2).getRADComponentName());
            int index1 = -1;
            int index2 = -1;
            if (!comp1.equals(comp2)) {
                Object[] components = this.formModel.getMetaComponents().toArray();
                for (int i = 0; i < components.length; ++i) {
                    if (comp1.equals(components[i])) {
                        index1 = i;
                    }
                    if (comp2.equals(components[i])) {
                        index2 = i;
                    }
                    if (index1 != -1 && index2 != -1) break;
                }
                return index1 - index2;
            }
            if (isInCreation1) {
                index1 = -1;
                index2 = -1;
                if (propName1.equals(CREATION_CODE_PRE)) {
                    index1 = 0;
                } else if (propName1.equals(CREATION_CODE_CUSTOM)) {
                    index1 = 1;
                } else if (propName1.equals(CREATION_CODE_POST)) {
                    index1 = 2;
                }
                if (propName2.equals(CREATION_CODE_PRE)) {
                    index2 = 0;
                } else if (propName2.equals(CREATION_CODE_CUSTOM)) {
                    index2 = 1;
                } else if (propName2.equals(CREATION_CODE_POST)) {
                    index2 = 2;
                }
                return index1 - index2;
            }
            index1 = -1;
            index2 = -1;
            index1 = propName1.equals(INIT_CODE_PRE) ? 0 : (propName1.equals(INIT_CODE_POST) ? 2 : 1);
            index2 = propName2.equals(INIT_CODE_PRE) ? 0 : (propName2.equals(INIT_CODE_POST) ? 2 : 1);
            if (index1 != 1 || index2 != 1) {
                return index1 - index2;
            }
            Node.PropertySet[] propSets = comp1.getProperties();
            Object[] properties = new Node.Property[]{};
            ArrayList<Node.Property> aList = new ArrayList<Node.Property>();
            for (int i = 0; i < propSets.length; ++i) {
                if (!FormI18nSupport.RAD_PROPERTIES.equals(propSets[i].getName()) && !FormI18nSupport.RAD_PROPERTIES2.equals(propSets[i].getName()) && !FormI18nSupport.RAD_LAYOUT.equals(propSets[i].getName()) && !FormI18nSupport.RAD_ACCESSIBILITY.equals(propSets[i].getName())) continue;
                aList.addAll(Arrays.asList(propSets[i].getProperties()));
            }
            properties = aList.toArray();
            index1 = -1;
            index2 = -1;
            Node.Property prop1 = ((ValidFormProperty)o1).getProperty();
            Node.Property prop2 = ((ValidFormProperty)o2).getProperty();
            for (int i = 0; i < properties.length; ++i) {
                if (prop1.equals((Object)properties[i])) {
                    index1 = i;
                }
                if (prop2.equals((Object)properties[i])) {
                    index2 = i;
                }
                if (index1 != -1 && index2 != -1) break;
            }
            return index1 - index2;
        }
    }

    private static class ValidFormProperty {
        private Node.Property property;
        private String radCompName;
        private int skip;

        public ValidFormProperty(String radCompName, Node.Property property) {
            this.radCompName = radCompName;
            this.property = property;
            this.skip = 0;
        }

        public ValidFormProperty(ValidFormProperty validProperty) {
            this.radCompName = validProperty.getRADComponentName();
            this.property = validProperty.getProperty();
            this.skip = validProperty.getSkip();
        }

        public String getRADComponentName() {
            return this.radCompName;
        }

        public Node.Property getProperty() {
            return this.property;
        }

        public int getSkip() {
            return this.skip;
        }

        public void incrementSkip() {
            ++this.skip;
        }

        public void decrementSkip() {
            if (this.skip > 0) {
                --this.skip;
            }
        }
    }
}

