/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.JMSDestination;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.MessageDestinationPanelController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.ServiceLocatorStrategyPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MessageDestinationPanel
extends JPanel {
    public static final String IS_VALID = "MessageDestinationPanel_isValid";
    private MessageDestinationPanelController controller;
    private DefaultComboBoxModel destinationModel;
    private ServiceLocatorStrategyPanel slPanel;
    private JComboBox destination;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox project;
    private JPanel serviceLocatorPanel;

    public MessageDestinationPanel(final JButton okButton, String lastLocator) {
        this.initComponents();
        this.controller = new MessageDestinationPanelController();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(this.controller.getJMSProjectRepresentation());
        this.project.setModel(model);
        this.destinationModel = new DefaultComboBoxModel();
        okButton.setEnabled(false);
        this.destination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                okButton.setEnabled(MessageDestinationPanel.this.destination.getSelectedIndex() > -1);
            }
        });
        if (model.getSize() > 0) {
            this.project.setSelectedIndex(0);
        }
        this.slPanel = new ServiceLocatorStrategyPanel(lastLocator);
        this.slPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("ServiceLocatorStrategyPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    boolean isServiceLocatorOk = (Boolean)newvalue;
                    if (isServiceLocatorOk) {
                        MessageDestinationPanel.this.checkDestination();
                    } else {
                        MessageDestinationPanel.this.firePropertyChange(MessageDestinationPanel.IS_VALID, true, false);
                    }
                }
            }
        });
        this.serviceLocatorPanel.add((Component)this.slPanel, "Center");
    }

    public JMSDestination getSelectedDestination() {
        return (JMSDestination)this.destination.getSelectedItem();
    }

    public String getServiceLocator() {
        return this.slPanel.classSelected();
    }

    private void populateDestinationCombo(Object selectedItem) {
        this.destinationModel = new DefaultComboBoxModel();
        try {
            this.populateEjbDestinationCombo(selectedItem);
        }
        catch (IOException ioe) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ioe.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        this.destination.setModel(this.destinationModel);
        if (this.destinationModel.getSize() > 0) {
            this.destination.setSelectedIndex(0);
        }
    }

    private void populateEjbDestinationCombo(Object selectedItem) throws IOException {
        EjbJar dd = this.controller.getEjbJar(selectedItem);
        if (dd != null) {
            List l = this.controller.extractEjbProjectDestinations(dd, selectedItem);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                this.destinationModel.addElement(it.next());
            }
        }
    }

    private void initComponents() {
        this.project = new JComboBox();
        this.destination = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.serviceLocatorPanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.project.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageDestinationPanel.this.projectActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.project, gridBagConstraints);
        this.project.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"ACSD_Project_Combo"));
        this.destination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageDestinationPanel.this.destinationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.destination, gridBagConstraints);
        this.destination.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessageDestinationPanel.class, (String)"ACSD_Destination_Combo"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ProjectMneumonic").charAt(0));
        this.jLabel1.setLabelFor(this.project);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_DestinationMneumonic").charAt(0));
        this.jLabel2.setLabelFor(this.destination);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_Destination"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.serviceLocatorPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.serviceLocatorPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entres/Bundle").getString("LBL_ProjectMustBeInSameApplication"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel3, gridBagConstraints);
    }

    private void destinationActionPerformed(ActionEvent evt) {
        this.checkDestination();
    }

    private void projectActionPerformed(ActionEvent evt) {
        Object p = this.project.getSelectedItem();
        this.populateDestinationCombo(p);
    }

    protected void checkDestination() {
        if (this.destination.getSelectedItem() == null) {
            this.firePropertyChange(IS_VALID, true, false);
        } else {
            this.firePropertyChange(IS_VALID, false, true);
        }
    }
}

