/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodParams;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityGenerateFromImplVisitor;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityGenerateFromIntfVisitor;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EntityMethodController
extends AbstractMethodController {
    private Entity model;
    private EjbJar parent;
    private static final int MODIFIERS_PUBLIC_ABSTRACT = 1025;

    public EntityMethodController(Entity model, ClassPath cp, EjbJar parent) {
        super((EntityAndSession)model, cp);
        this.model = model;
        this.parent = parent;
    }

    public List getMethods(CmpField field) {
        return this.getMethods(field.getFieldName());
    }

    public List getMethods(CmrField field) {
        return this.getMethods(field.getCmrFieldName());
    }

    public void deleteQueryMapping(Method method, FileObject dd) throws IOException {
        String methodName;
        Query[] queries = this.model.getQuery();
        Query q = null;
        for (int i = 0; i < queries.length && !(methodName = (q = queries[i]).getQueryMethod().getMethodName()).equals(method.getName()); ++i) {
        }
        if (q != null) {
            this.model.removeQuery(q);
            this.parent.write(dd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteField(CmpField field, FileObject dd) throws IOException {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        Query query = null;
        try {
            JavaClass declaringClass;
            Method me;
            String fieldName = field.getFieldName();
            query = this.findQueryByCmpField(fieldName);
            for (JavaClass ce : this.getLocalInterfaces()) {
                me = EntityMethodController.getFinderMethod(ce, fieldName, EntityMethodController.getGetterMethod(this.getBeanClass(), fieldName));
                if (me == null) continue;
                declaringClass = (JavaClass)me.getDeclaringClass();
                this.registerClassForSave(declaringClass);
                declaringClass.getContents().remove(me);
            }
            for (JavaClass ce : this.getRemoteInterfaces()) {
                me = EntityMethodController.getFinderMethod(ce, fieldName, EntityMethodController.getGetterMethod(this.getBeanClass(), fieldName));
                if (me == null) continue;
                declaringClass = (JavaClass)me.getDeclaringClass();
                this.registerClassForSave(declaringClass);
                declaringClass.getContents().remove(me);
            }
            this.removeMethodsFromBean(this.getMethods(fieldName));
            this.updateFieldAccessors(fieldName, false, false, false, false);
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
        if (query != null) {
            this.model.removeQuery(query);
        }
        this.model.removeCmpField(field);
        this.parent.write(dd);
    }

    private Query findQueryByCmpField(String fieldName) {
        Query[] queries = this.model.getQuery();
        for (int i = 0; i < queries.length; ++i) {
            Query query = queries[i];
            String queryMethodName = query.getQueryMethod().getMethodName();
            if (!queryMethodName.equals(EntityMethodController.prependAndUpper(fieldName, "findBy"))) continue;
            return query;
        }
        return null;
    }

    private void removeMethodsFromBean(List methods) {
        for (Method method : methods) {
            JavaClass declaringClass;
            Method me;
            if (this.hasLocal() && (me = this.getInterface(method, true)) != null) {
                declaringClass = (JavaClass)me.getDeclaringClass();
                this.registerClassForSave(declaringClass);
                declaringClass.getFeatures().remove(me);
            }
            if (this.hasRemote() && (me = this.getInterface(method, false)) != null) {
                declaringClass = (JavaClass)me.getDeclaringClass();
                this.registerClassForSave(declaringClass);
                declaringClass.getContents().remove(me);
            }
            JavaClass declaringClass2 = (JavaClass)method.getDeclaringClass();
            this.registerClassForSave(declaringClass2);
            declaringClass2.getContents().remove(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteField(CmrField field, FileObject dd) throws IOException {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            List methods = this.getMethods(field.getCmrFieldName());
            this.removeMethodsFromBean(methods);
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
        this.deleteRelationships(field.getCmrFieldName());
        this.parent.write(dd);
    }

    public static String getMethodName(String fieldName, boolean get) {
        String prefix = get ? "get" : "set";
        return EntityMethodController.prependAndUpper(fieldName, prefix);
    }

    private static String getFieldName(String methodName) {
        if (methodName.length() < 3) {
            return null;
        }
        String prefix = methodName.substring(0, 3);
        if (prefix.equals("set") || prefix.equals("get")) {
            return EntityMethodController.lower(methodName.substring(3, methodName.length()));
        }
        return null;
    }

    public boolean hasJavaImplementation(Method intfView) {
        return this.hasJavaImplementation(this.getMethodTypeFromInterface(intfView));
    }

    public boolean hasJavaImplementation(MethodType mt) {
        return !this.isCMP() || !this.isFinder(mt) && !this.isSelect(mt);
    }

    public MethodType getMethodTypeFromImpl(Method implView) {
        MethodType mt = null;
        if (implView.getName().startsWith("ejbCreate") || implView.getName().startsWith("ejbPostCreate")) {
            mt = new MethodType.CreateMethodType(implView);
        } else if (!implView.getName().startsWith("ejb")) {
            mt = new MethodType.BusinessMethodType(implView);
        } else if (implView.getName().startsWith("ejbFind")) {
            mt = new MethodType.FinderMethodType(implView);
        } else if (implView.getName().startsWith("ejbHome")) {
            mt = new MethodType.HomeMethodType(implView);
        }
        return mt;
    }

    public MethodType getMethodTypeFromInterface(Method clientView) {
        if (!clientView.isValid()) {
            return null;
        }
        assert (clientView.getDeclaringClass() != null) : "declaring class cannot be null";
        String cName = clientView.getDeclaringClass().getName();
        MethodType mt = cName.equals(this.model.getLocalHome()) || cName.equals(this.model.getHome()) ? (clientView.getName().startsWith("create") ? new MethodType.CreateMethodType(clientView) : (clientView.getName().startsWith("find") ? new MethodType.FinderMethodType(clientView) : new MethodType.HomeMethodType(clientView))) : new MethodType.BusinessMethodType(clientView);
        return mt;
    }

    public AbstractMethodController.GenerateFromImpl createGenerateFromImpl() {
        return new EntityGenerateFromImplVisitor(this.model);
    }

    public AbstractMethodController.GenerateFromIntf createGenerateFromIntf() {
        return new EntityGenerateFromIntfVisitor(this.model);
    }

    public void addSelectMethod(Method selectMethod, String ql, FileObject dd) throws IOException {
        this.getBeanClass().getContents().add(selectMethod);
        this.addEjbQl(selectMethod, ql, dd);
    }

    public void addEjbQl(Method clientView, String ejbql, FileObject dd) throws IOException {
        if (this.isBMP()) {
            super.addEjbQl(clientView, ejbql, dd);
        }
        this.model.addQuery(this.buildQuery(clientView, ejbql));
        this.parent.write(dd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(Field field, FileObject ddFile, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter, String description) throws IOException {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            JavaClass beanClass = this.getBeanClass();
            this.registerClassForSave(beanClass);
            EntityMethodController.addSetterMethod(beanClass, field, 1025, false, this.model);
            EntityMethodController.addGetterMethod(beanClass, field, 1025, false, this.model);
            String fieldName = field.getName();
            this.updateFieldAccessors(fieldName, localGetter, localSetter, remoteGetter, remoteSetter);
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
        CmpField f = this.model.newCmpField();
        f.setFieldName(field.getName());
        f.setDescription(description);
        this.model.addCmpField(f);
        this.parent.write(ddFile);
    }

    public void validateNewCmpFieldName(String name) {
        CmpField[] cmpField = this.model.getCmpField();
        for (int i = 0; i < cmpField.length; ++i) {
            CmpField field = cmpField[i];
            if (!name.equals(field.getFieldName())) continue;
            throw new IllegalArgumentException(NbBundle.getMessage(EntityMethodController.class, (String)"MSG_Duplicate_Field_Name", (Object)name));
        }
    }

    private static Method addSetterMethod(JavaClass javaClass, Field field, int modifiers, boolean remote, Entity e) {
        Method method = EntityMethodController.createSetterMethod(javaClass, field, modifiers, remote);
        EntityMethodController.addMethod(javaClass, method, e);
        return method;
    }

    private static Method addGetterMethod(JavaClass javaClass, Field fe, int modifiers, boolean remote, Entity e) {
        Method method = EntityMethodController.createGetterMethod(javaClass, fe, modifiers, remote);
        EntityMethodController.addMethod(javaClass, method, e);
        return method;
    }

    private static void addMethod(JavaClass javaClass, Method method, Entity e) {
        ArrayList<String> cmpFields = new ArrayList<String>();
        CmpField[] cmpFieldArray = e.getCmpField();
        for (int i = 0; i < cmpFieldArray.length; ++i) {
            cmpFields.add(cmpFieldArray[i].getFieldName());
        }
        int index = -1;
        for (Object elem : javaClass.getContents()) {
            String fieldName;
            if (!(elem instanceof Method) || !cmpFields.contains(fieldName = EntityMethodController.getFieldName(((Method)elem).getName()))) continue;
            index = javaClass.getContents().indexOf(elem);
        }
        if (index != -1) {
            javaClass.getContents().add(index + 1, method);
        } else {
            javaClass.getContents().add(method);
        }
    }

    private static void removeMethod(JavaClass javaClass, Method method) {
        javaClass.getContents().remove(method);
    }

    private static Method createGetterMethod(JavaClass javaClass, Field field, int modifiers, boolean remote) {
        Method method = JMIUtils.createMethod((JavaClass)javaClass);
        method.setModifiers(modifiers);
        method.setType(field.getType());
        method.setName(EntityMethodController.getMethodName(field.getName(), true));
        if (remote) {
            JMIUtils.addException((Method)method, (String)RemoteException.class.getName());
        }
        return method;
    }

    private static Method createSetterMethod(JavaClass javaClass, Field field, int modifiers, boolean remote) {
        Method method = JMIUtils.createMethod((JavaClass)javaClass);
        method.setModifiers(modifiers);
        method.setType(JMIUtils.resolveType((String)"void"));
        String fieldName = field.getName();
        method.setName(EntityMethodController.getMethodName(fieldName, false));
        method.getParameters().add(JMIUtils.createParameter((Method)method, (String)fieldName, (Type)field.getType(), (boolean)false));
        if (remote) {
            JMIUtils.addException((Method)method, (String)RemoteException.class.getName());
        }
        return method;
    }

    private boolean isBMP() {
        return "Bean".equals(this.model.getPersistenceType());
    }

    public boolean isCMP() {
        return !this.isBMP();
    }

    private boolean isFinder(MethodType mt) {
        return mt instanceof MethodType.FinderMethodType;
    }

    private boolean isSelect(MethodType mt) {
        return mt instanceof MethodType.SelectMethodType;
    }

    private boolean isFinder(int mt) {
        return mt == 4;
    }

    private boolean isSelect(int mt) {
        return mt == 2;
    }

    public String createDefaultQL(MethodType mt) {
        String ql = null;
        if (this.isFinder(mt) && this.isCMP()) {
            ql = "SELECT OBJECT(o) \nFROM " + this.model.getAbstractSchemaName() + " o";
        }
        if (this.isSelect(mt)) {
            ql = "SELECT COUNT(o) \nFROM " + this.model.getAbstractSchemaName() + " o";
        }
        return ql;
    }

    private Query buildQuery(Method clientView, String ejbql) {
        Query q = this.model.newQuery();
        QueryMethod qm = q.newQueryMethod();
        qm.setMethodName(clientView.getName());
        MethodParams mParams = qm.newMethodParams();
        Parameter[] params = clientView.getParameters().toArray(new Parameter[clientView.getParameters().size()]);
        for (int i = 0; i < params.length; ++i) {
            mParams.addMethodParam(params[i].getType().getName());
        }
        qm.setMethodParams(mParams);
        q.setQueryMethod(qm);
        q.setEjbQl(ejbql);
        return q;
    }

    private static String prependAndUpper(String fullName, String prefix) {
        StringBuffer sb = new StringBuffer(fullName);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return prefix + sb.toString();
    }

    private static String lower(String fullName) {
        StringBuffer sb = new StringBuffer(fullName);
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    private boolean isEjbUsed(EjbRelationshipRole role, String ejbName, String fieldName) {
        return role != null && role.getRelationshipRoleSource() != null && ejbName.equals(role.getRelationshipRoleSource().getEjbName()) && fieldName.equals(role.getCmrField().getCmrFieldName());
    }

    private boolean relationContainsField(EjbRelation relation, String ejbName, String fieldName) {
        return this.isEjbUsed(relation.getEjbRelationshipRole(), ejbName, fieldName) || this.isEjbUsed(relation.getEjbRelationshipRole2(), ejbName, fieldName);
    }

    private void deleteRelationships(String fieldName) {
        EjbRelation[] relations;
        String ejbName = this.model.getEjbName();
        Relationships r = this.parent.getSingleRelationships();
        if (r != null && (relations = r.getEjbRelation()) != null) {
            for (int i = 0; i < relations.length; ++i) {
                if (!this.relationContainsField(relations[i], ejbName, fieldName)) continue;
                boolean uniDirectional = false;
                EjbRelationshipRole role = relations[i].getEjbRelationshipRole();
                if (this.isEjbUsed(role, ejbName, fieldName)) {
                    role.setCmrField(null);
                } else {
                    uniDirectional = role.getCmrField() == null;
                }
                role = relations[i].getEjbRelationshipRole2();
                if (this.isEjbUsed(role, ejbName, fieldName)) {
                    role.setCmrField(null);
                } else {
                    boolean bl = uniDirectional = role.getCmrField() == null;
                }
                if (!uniDirectional) continue;
                r.removeEjbRelation(relations[i]);
            }
            if (r.sizeEjbRelation() == 0) {
                this.parent.setRelationships(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getMethods(String propName) {
        assert (propName != null);
        JMIUtils.beginJmiTransaction();
        try {
            LinkedList<Method> l = new LinkedList<Method>();
            JavaClass ce = this.getBeanClass();
            Method getMethod = EntityMethodController.getGetterMethod(ce, propName);
            if (getMethod != null) {
                l.add(getMethod);
                Method setMethod = EntityMethodController.getSetterMethod(ce, propName, getMethod.getType());
                if (setMethod != null) {
                    l.add(setMethod);
                }
            }
            LinkedList<Method> linkedList = l;
            return linkedList;
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    public static Method getGetterMethod(JavaClass javaClass, String fieldName) {
        if (javaClass == null || fieldName == null) {
            return null;
        }
        return javaClass.getMethod(EntityMethodController.getMethodName(fieldName, true), Collections.EMPTY_LIST, false);
    }

    public static Method getSetterMethod(JavaClass classElement, String fieldName, Method getterMethod) {
        return EntityMethodController.getSetterMethod(classElement, fieldName, getterMethod.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getGetterMethod(String fieldName, boolean local) {
        JMIUtils.beginJmiTransaction();
        try {
            Method method = EntityMethodController.getGetterMethod(this.getBeanInterface(local, true), fieldName);
            return method;
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getSetterMethod(JavaClass classElement, String fieldName, Type type) {
        if (classElement == null) {
            return null;
        }
        JMIUtils.beginJmiTransaction();
        try {
            if (type == null) {
                Method method = null;
                return method;
            }
            type = JMIUtils.resolveType((String)type.getName());
            String methodName = EntityMethodController.getMethodName(fieldName, false);
            List<Type> parameters = Arrays.asList(type);
            try {
                Method method = classElement.getMethod(methodName, parameters, false);
                return method;
            }
            catch (Exception e) {
                e.printStackTrace();
                Method method = null;
                JMIUtils.endJmiTransaction();
                return method;
            }
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getSetterMethod(String fieldName, boolean local) {
        JMIUtils.beginJmiTransaction();
        try {
            Field field = this.getField(fieldName, true);
            if (field == null) {
                Method method = null;
                return method;
            }
            Method method = EntityMethodController.getSetterMethod(this.getBeanInterface(local, true), fieldName, field.getType());
            return method;
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
    }

    public static Method getFinderMethod(JavaClass classElement, String fieldName, Method getterMethod) {
        if (getterMethod == null) {
            return null;
        }
        return classElement.getMethod(EntityMethodController.prependAndUpper(fieldName, "findBy"), Arrays.asList(getterMethod.getType()), false);
    }

    public boolean supportsMethodType(int mt) {
        return !this.isSelect(mt) || this.isCMP();
    }

    private void updateFieldAccessors(String fieldName, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter) {
        this.updateFieldAccessor(fieldName, true, true, localGetter);
        this.updateFieldAccessor(fieldName, false, true, localSetter);
        this.updateFieldAccessor(fieldName, true, false, remoteGetter);
        this.updateFieldAccessor(fieldName, false, false, remoteSetter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFieldAccessor(String fieldName, boolean getter, boolean local, boolean shouldExist) {
        this.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            Field field = this.getField(fieldName, true);
            if (field == null) {
                return;
            }
            JavaClass businessInterface = this.getBeanInterface(local, true);
            if (businessInterface != null) {
                this.registerClassForSave(businessInterface);
                Method method = getter ? EntityMethodController.getGetterMethod(businessInterface, fieldName) : EntityMethodController.getSetterMethod(businessInterface, fieldName, field.getType());
                if (shouldExist) {
                    if (method == null) {
                        if (getter) {
                            EntityMethodController.addGetterMethod(businessInterface, field, 0, !local, this.model);
                        } else {
                            EntityMethodController.addSetterMethod(businessInterface, field, 0, !local, this.model);
                        }
                    }
                } else if (method != null) {
                    EntityMethodController.removeMethod(businessInterface, method);
                }
            }
            rollback = false;
        }
        finally {
            this.endWriteJmiTransaction(rollback);
        }
    }

    private Field getField(String fieldName, boolean create) {
        JavaClass beanClass = this.getBeanClass();
        Method getterMethod = EntityMethodController.getGetterMethod(beanClass, fieldName);
        if (getterMethod == null) {
            if (!create) {
                return null;
            }
            Field field = JMIUtils.createField((JavaClass)beanClass, (String)fieldName, (String)"String");
            EntityMethodController.createGetterMethod(this.getBeanClass(), field, 1025, false);
            return field;
        }
        Type type = getterMethod.getType();
        if (type == null) {
            return null;
        }
        return JMIUtils.createField((JavaClass)beanClass, (String)fieldName, (String)type.getName());
    }
}

