/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.event.ActionEvent;
import java.beans.Beans;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

class NbApplicationAdapter
implements ApplicationListener {
    private static final String OPTIONS_ACTION = "Actions/Window/org-netbeans-modules-options-OptionsWindowAction.instance";
    private static final String ABOUT_ACTION = "Actions/Help/org-netbeans-core-actions-AboutAction.instance";
    private static final String OPENFILE_ACTION = "Menu/File/org-netbeans-modules-openfile-OpenFileAction";
    private static final String EXIT_ACTION = "Actions/System/org-netbeans-core-actions-SystemExit.instance";
    private static ApplicationListener al = null;

    private NbApplicationAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void install() {
        boolean wasDesignTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(false);
            al = new NbApplicationAdapter();
            Application.getApplication().addApplicationListener(al);
            Application.getApplication().setEnabledAboutMenu(true);
            Application.getApplication().setEnabledPreferencesMenu(true);
        }
        finally {
            Beans.setDesignTime(wasDesignTime);
        }
    }

    static void uninstall() {
        if (al != null) {
            Application.getApplication().removeApplicationListener(al);
            al = null;
        }
    }

    public void handleAbout(ApplicationEvent e) {
        e.setHandled(this.performAction(ABOUT_ACTION));
    }

    public void handleOpenApplication(ApplicationEvent e) {
    }

    public void handleOpenFile(ApplicationEvent e) {
        e.setHandled(this.performAction(OPENFILE_ACTION, e.getFilename()));
    }

    public void handlePreferences(ApplicationEvent e) {
        e.setHandled(this.performAction(OPTIONS_ACTION));
    }

    public void handlePrintFile(ApplicationEvent e) {
    }

    public void handleQuit(ApplicationEvent e) {
        e.setHandled(!this.performAction(EXIT_ACTION));
    }

    public void handleReOpenApplication(ApplicationEvent e) {
    }

    private boolean performAction(String key) {
        return this.performAction(key, null);
    }

    private boolean performAction(String key, String command) {
        Action a = this.findAction(key);
        if (a == null) {
            return false;
        }
        if (command == null) {
            command = "foo";
        }
        ActionEvent ae = new ActionEvent(this, 1001, command);
        try {
            a.actionPerformed(ae);
            return true;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            return false;
        }
    }

    private Action findAction(String key) {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(key);
        if (fo != null && fo.isValid()) {
            try {
                Object instance;
                DataObject dob = DataObject.find((FileObject)fo);
                InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                if (ic != null && (instance = ic.instanceCreate()) instanceof Action) {
                    return (Action)instance;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

