/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class JPDAObjectWatchImpl
extends AbstractVariable
implements JPDAWatch,
ObjectVariable {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;

    JPDAObjectWatchImpl(JPDADebuggerImpl debugger, Watch watch, ObjectReference v) {
        super(debugger, v, "" + watch + (v instanceof ObjectReference ? "^" : ""));
        this.debugger = debugger;
        this.watch = watch;
    }

    JPDAObjectWatchImpl(JPDADebuggerImpl debugger, Watch watch, String exceptionDescription) {
        super(debugger, null, "" + watch);
        this.debugger = debugger;
        this.watch = watch;
        this.exceptionDescription = exceptionDescription;
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String expression) {
        this.watch.setExpression(expression);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        CallStackFrameImpl frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
        if (frame == null) {
            throw new InvalidExpressionException("No curent frame.");
        }
        try {
            LocalVariable local = frame.getStackFrame().visibleVariableByName(this.getExpression());
            if (local != null) {
                try {
                    frame.getStackFrame().setValue(local, value);
                    return;
                }
                catch (InvalidTypeException ex) {
                    throw new InvalidExpressionException((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    throw new InvalidExpressionException((Throwable)ex);
                }
            }
        }
        catch (AbsentInformationException ex) {
            // empty catch block
        }
        ObjectReference thisObject = frame.getStackFrame().thisObject();
        if (thisObject == null) {
            throw new InvalidExpressionException("Can not set value to expression.");
        }
        Field field = thisObject.referenceType().fieldByName(this.getExpression());
        if (field == null) {
            throw new InvalidExpressionException("Can not set value to expression.");
        }
        try {
            thisObject.setValue(field, value);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
    }

    protected void setInnerValue(Value v) {
        super.setInnerValue(v);
        this.exceptionDescription = null;
    }

    void setException(String exceptionDescription) {
        super.setInnerValue(null);
        this.exceptionDescription = exceptionDescription;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }
}

