/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;

public class SmartSteppingFilterImpl
implements SmartSteppingFilter {
    private HashSet filter = new HashSet();
    private ArrayList exact = new ArrayList();
    private ArrayList start = new ArrayList();
    private ArrayList end = new ArrayList();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public SmartSteppingFilterImpl() {
        this.addExclusionPatterns((Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET));
    }

    public void addExclusionPatterns(Set patterns) {
        HashSet reallyNew = new HashSet(patterns);
        reallyNew.removeAll(this.filter);
        if (reallyNew.size() < 1) {
            return;
        }
        this.filter.addAll(reallyNew);
        this.refreshFilters(reallyNew);
        this.pcs.firePropertyChange("exclusionPatterns", null, reallyNew);
    }

    public void removeExclusionPatterns(Set patterns) {
        this.filter.removeAll(patterns);
        this.exact = new ArrayList();
        this.start = new ArrayList();
        this.end = new ArrayList();
        this.refreshFilters(this.filter);
        this.pcs.firePropertyChange("exclusionPatterns", patterns, null);
    }

    public String[] getExclusionPatterns() {
        String[] ef = new String[this.filter.size()];
        return this.filter.toArray(ef);
    }

    public boolean stopHere(String className) {
        int i;
        int k = this.exact.size();
        for (i = 0; i < k; ++i) {
            if (!this.exact.get(i).equals(className)) continue;
            return false;
        }
        k = this.start.size();
        for (i = 0; i < k; ++i) {
            if (!className.startsWith((String)this.start.get(i))) continue;
            return false;
        }
        k = this.end.size();
        for (i = 0; i < k; ++i) {
            if (!className.endsWith((String)this.end.get(i))) continue;
            return false;
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private void refreshFilters(Set newFilters) {
        Iterator i = newFilters.iterator();
        while (i.hasNext()) {
            String p = (String)i.next();
            if (p.startsWith("*")) {
                this.end.add(p.substring(1));
                continue;
            }
            if (p.endsWith("*")) {
                this.start.add(p.substring(0, p.length() - 1));
                continue;
            }
            this.exact.add(p);
        }
    }
}

