/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.EventObject;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;

final class LayoutEvent
extends EventObject {
    static final int COMPONENT_ADDED = 1;
    static final int COMPONENT_REMOVED = 2;
    static final int INTERVAL_ADDED = 3;
    static final int INTERVAL_REMOVED = 4;
    static final int INTERVAL_ALIGNMENT_CHANGED = 5;
    static final int GROUP_ALIGNMENT_CHANGED = 6;
    static final int INTERVAL_SIZE_CHANGED = 7;
    static final int INTERVAL_ATTRIBUTES_CHANGED = 8;
    static final int INTERVAL_LINKSIZE_CHANGED = 9;
    static final int CONTAINER_ATTR_CHANGED = 10;
    static final int COMPONENT_REGISTERED = 11;
    static final int COMPONENT_UNREGISTERED = 12;
    private int changeType;
    private LayoutComponent component;
    private LayoutComponent parentComp;
    private LayoutInterval interval;
    private LayoutInterval parentInt;
    private LayoutInterval[] layoutRoots;
    private int index;
    private int oldAlignment;
    private int newAlignment;
    private int oldAttributes;
    private int newAttributes;
    private int[] oldSizes;
    private int[] newSizes;
    private int oldLinkSizeId;
    private int newLinkSizeId;
    private int dimension;

    LayoutEvent(LayoutModel source, int changeType) {
        super(source);
        this.changeType = changeType;
    }

    void setComponent(LayoutComponent comp) {
        this.component = comp;
    }

    void setComponent(LayoutComponent comp, LayoutComponent parent, int index) {
        this.component = comp;
        this.parentComp = parent;
        this.index = index;
    }

    void setContainer(LayoutComponent comp, LayoutInterval[] roots) {
        this.component = comp;
        this.layoutRoots = roots;
    }

    void setInterval(LayoutInterval interval, LayoutInterval parent, int index) {
        this.interval = interval;
        this.parentInt = parent;
        this.index = index;
    }

    void setAlignment(LayoutInterval interval, int oldAlign, int newAlign) {
        this.interval = interval;
        this.oldAlignment = oldAlign;
        this.newAlignment = newAlign;
    }

    void setLinkSizeGroup(LayoutComponent component, int oldLinkSizeId, int newLinkSizeId, int dimension) {
        if (component == null) {
            Thread.dumpStack();
        }
        this.component = component;
        this.oldLinkSizeId = oldLinkSizeId;
        this.newLinkSizeId = newLinkSizeId;
        this.dimension = dimension;
    }

    void setAttributes(LayoutInterval interval, int oldAttributes, int newAttributes) {
        this.interval = interval;
        this.oldAttributes = oldAttributes;
        this.newAttributes = newAttributes;
    }

    void setSize(LayoutInterval interval, int oldMin, int oldPref, int oldMax, int newMin, int newPref, int newMax) {
        this.interval = interval;
        this.oldSizes = new int[]{oldMin, oldPref, oldMax};
        this.newSizes = new int[]{newMin, newPref, newMax};
    }

    LayoutModel getModel() {
        return (LayoutModel)this.source;
    }

    int getType() {
        return this.changeType;
    }

    LayoutComponent getComponent() {
        return this.component;
    }

    LayoutComponent getParentComponent() {
        return this.parentComp;
    }

    LayoutInterval getInterval() {
        return this.interval;
    }

    LayoutInterval getParentInterval() {
        return this.parentInt;
    }

    int getIndex() {
        return this.index;
    }

    void undo() {
        switch (this.changeType) {
            case 1: {
                this.undoComponentAddition();
                break;
            }
            case 2: {
                this.undoComponentRemoval();
                break;
            }
            case 3: {
                this.undoIntervalAddition();
                break;
            }
            case 4: {
                this.undoIntervalRemoval();
                break;
            }
            case 5: {
                this.interval.setAlignment(this.oldAlignment);
                break;
            }
            case 6: {
                this.interval.setGroupAlignment(this.oldAlignment);
                break;
            }
            case 7: {
                this.interval.setSizes(this.oldSizes[0], this.oldSizes[1], this.oldSizes[2]);
                break;
            }
            case 8: {
                this.interval.setAttributes(this.oldAttributes);
                break;
            }
            case 9: {
                this.undoLinkSize(this.oldLinkSizeId);
                break;
            }
            case 10: {
                this.changeContainerAttr();
                break;
            }
            case 11: {
                this.undoComponentRegistration();
                break;
            }
            case 12: {
                this.undoComponentUnregistration();
            }
        }
    }

    void redo() {
        switch (this.changeType) {
            case 1: {
                this.undoComponentRemoval();
                break;
            }
            case 2: {
                this.undoComponentAddition();
                break;
            }
            case 3: {
                this.undoIntervalRemoval();
                break;
            }
            case 4: {
                this.undoIntervalAddition();
                break;
            }
            case 5: {
                this.interval.setAlignment(this.newAlignment);
                break;
            }
            case 6: {
                this.interval.setGroupAlignment(this.newAlignment);
                break;
            }
            case 7: {
                this.interval.setSizes(this.newSizes[0], this.newSizes[1], this.newSizes[2]);
                break;
            }
            case 8: {
                this.interval.setAttributes(this.newAttributes);
                break;
            }
            case 9: {
                this.undoLinkSize(this.newLinkSizeId);
                break;
            }
            case 10: {
                this.changeContainerAttr();
                break;
            }
            case 11: {
                this.undoComponentUnregistration();
                break;
            }
            case 12: {
                this.undoComponentRegistration();
            }
        }
    }

    private void undoLinkSize(int id) {
        this.getModel().removeComponentFromLinkSizedGroup(this.component, this.dimension);
        if (id != -1) {
            this.getModel().addComponentToLinkSizedGroupImpl(id, this.component.getId(), this.dimension);
        }
    }

    private void undoComponentAddition() {
        this.getModel().removeComponentImpl(this.component);
    }

    private void undoComponentRemoval() {
        this.getModel().addComponentImpl(this.component, this.parentComp, this.index);
    }

    private void undoIntervalAddition() {
        this.getModel().removeInterval(this.parentInt, this.index);
    }

    private void undoIntervalRemoval() {
        this.getModel().addInterval(this.interval, this.parentInt, this.index);
    }

    private void changeContainerAttr() {
        this.component.setLayoutContainer(!this.component.isLayoutContainer(), this.layoutRoots);
    }

    private void undoComponentRegistration() {
        this.getModel().unregisterComponentImpl(this.component);
    }

    private void undoComponentUnregistration() {
        this.getModel().registerComponentImpl(this.component);
    }
}

