/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorState;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.HtmlPrintContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

public class ExportHtmlAction
extends CookieAction {
    private static final String HTML_EXT = ".html";
    private static final String OPEN_HTML_HIST = "ExportHtmlAction_open_html_history";
    private static final String SHOW_LINES_HIST = "ExportHtmlAction_show_lines_history";
    private static final String SELECTION_HIST = "ExportHtmlAction_selection_history";
    private static final String FOLDER_NAME_HIST = "ExportHtmlAction_folder_name_history";
    private static final String CHARSET = "UTF-8";
    private Dialog dlg;

    protected final int mode() {
        return 8;
    }

    protected final Class[] cookieClasses() {
        return new Class[]{EditorCookie.class};
    }

    protected final void performAction(Node[] activatedNodes) {
        EditorCookie ec = (EditorCookie)activatedNodes[0].getCookie(EditorCookie.class);
        if (ec == null) {
            return;
        }
        StyledDocument doc = null;
        try {
            doc = ec.openDocument();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (doc instanceof BaseDocument) {
            final BaseDocument bdoc = (BaseDocument)doc;
            final JTextComponent jtc = Utilities.getLastActiveComponent();
            Presenter p = new Presenter();
            String folderName = (String)EditorState.get((Object)FOLDER_NAME_HIST);
            if (folderName == null) {
                folderName = System.getProperty("user.home");
            }
            p.setFileName(folderName + File.separatorChar + ((DataObject)bdoc.getProperty((Object)"stream")).getPrimaryFile().getName() + HTML_EXT);
            Boolean bool = (Boolean)EditorState.get((Object)SHOW_LINES_HIST);
            boolean showLineNumbers = bool != null ? bool : (Boolean)SettingsUtil.getValue((Class)bdoc.getKitClass(), (String)"line-number-visible", (Object)Boolean.FALSE);
            p.setShowLines(showLineNumbers);
            bool = (Boolean)EditorState.get((Object)SELECTION_HIST);
            p.setSelectionActive(jtc != null && jtc.getSelectionStart() != jtc.getSelectionEnd());
            boolean selection = jtc != null && jtc.getSelectionStart() != jtc.getSelectionEnd() && (bool == null || bool != false);
            p.setSelection(selection);
            bool = (Boolean)EditorState.get((Object)OPEN_HTML_HIST);
            boolean setOpen = bool != null ? bool : false;
            p.setOpenHtml(setOpen);
            DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage((Class)ExportHtmlAction.class, (String)"CTL_ExportHtml"));
            boolean overwrite = true;
            this.dlg = DialogDisplayer.getDefault().createDialog(dd);
            do {
                this.dlg.setVisible(true);
                overwrite = true;
                if (dd.getValue() != DialogDescriptor.OK_OPTION || !new File(p.getFileName()).exists()) continue;
                NotifyDescriptor.Confirmation NDConfirm = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction") : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"MSG_FileExists", (Object)p.getFileName()), 0, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)NDConfirm);
                if (NDConfirm.getValue() == NotifyDescriptor.YES_OPTION) continue;
                overwrite = false;
            } while (!overwrite);
            this.dlg.dispose();
            this.dlg = null;
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                boolean open;
                boolean lineNumbers;
                String file;
                int idx;
                if (selection != p.isSelection()) {
                    selection = p.isSelection();
                    EditorState.put((Object)SELECTION_HIST, (Object)(selection ? Boolean.TRUE : Boolean.FALSE));
                }
                if ((idx = (file = p.getFileName()).lastIndexOf(File.separatorChar)) != -1) {
                    EditorState.put((Object)FOLDER_NAME_HIST, (Object)file.substring(0, idx));
                }
                if (showLineNumbers != (lineNumbers = p.isShowLines())) {
                    EditorState.put((Object)SHOW_LINES_HIST, (Object)(lineNumbers ? Boolean.TRUE : Boolean.FALSE));
                }
                if (setOpen != (open = p.isOpenHtml())) {
                    EditorState.put((Object)OPEN_HTML_HIST, (Object)(open ? Boolean.TRUE : Boolean.FALSE));
                }
                final int selectionStart = selection ? jtc.getSelectionStart() : 0;
                final int selectionEnd = selection ? jtc.getSelectionEnd() : bdoc.getLength();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            if (jtc != null) {
                                this.setCursor(org.openide.util.Utilities.createProgressCursor((Component)jtc));
                            }
                            ExportHtmlAction.this.export(bdoc, file, lineNumbers, selectionStart, selectionEnd);
                            if (open) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(new File(file).toURI().toURL());
                            }
                        }
                        catch (MalformedURLException mue) {
                            ErrorManager.getDefault().notify((Throwable)mue);
                        }
                        catch (IOException ioe) {
                            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"ERR_IOError", (Object[])new Object[]{((DataObject)bdoc.getProperty((Object)"stream")).getPrimaryFile().getNameExt() + ExportHtmlAction.HTML_EXT, file}), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                            return;
                        }
                        finally {
                            if (jtc != null) {
                                this.setCursor(null);
                            }
                        }
                    }

                    private void setCursor(final Cursor c) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                jtc.setCursor(c);
                            }
                        });
                    }
                });
            }
        } else {
            ErrorManager.getDefault().log(NbBundle.getMessage((Class)ExportHtmlAction.class, (String)"MSG_DocError"));
        }
    }

    public final String getName() {
        return NbBundle.getMessage((Class)ExportHtmlAction.class, (String)"CTL_ExportHtmlAction");
    }

    public final HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected final boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(BaseDocument bdoc, String fileName, boolean lineNumbers, int selectionStart, int selectionEnd) throws IOException {
        Coloring coloring = SettingsUtil.getColoring((Class)bdoc.getKitClass(), (String)"default", (boolean)false);
        Color bgColor = coloring.getBackColor();
        Color fgColor = coloring.getForeColor();
        Font font = coloring.getFont();
        coloring = SettingsUtil.getColoring((Class)bdoc.getKitClass(), (String)"line-number", (boolean)false);
        Color lnbgColor = coloring.getBackColor();
        Color lnfgColor = coloring.getForeColor();
        FileObject fo = ((DataObject)bdoc.getProperty((Object)"stream")).getPrimaryFile();
        HtmlPrintContainer htmlPrintContainer = new HtmlPrintContainer();
        htmlPrintContainer.begin(fo, font, fgColor, bgColor, lnfgColor, lnbgColor, bdoc.getKitClass(), CHARSET);
        bdoc.print((PrintContainer)htmlPrintContainer, false, new Boolean(lineNumbers), selectionStart, selectionEnd);
        String result = htmlPrintContainer.end();
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), CHARSET));
            out.print(result);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private class Presenter
    extends JPanel {
        private JTextField fileName;
        private JCheckBox showLineNumbers;
        private JCheckBox openHtml;
        private JCheckBox selection;

        public Presenter() {
            this.initGUI();
        }

        public final String getFileName() {
            return this.fileName.getText();
        }

        public final void setFileName(String name) {
            this.fileName.setText(name);
        }

        public final boolean isShowLines() {
            return this.showLineNumbers.isSelected();
        }

        public final void setShowLines(boolean value) {
            this.showLineNumbers.setSelected(value);
        }

        public final boolean isSelection() {
            return this.selection.isSelected();
        }

        public final void setSelection(boolean value) {
            this.selection.setSelected(value);
        }

        public final boolean isOpenHtml() {
            return this.openHtml.isSelected();
        }

        public final void setOpenHtml(boolean value) {
            this.openHtml.setSelected(value);
        }

        public final void setSelectionActive(boolean value) {
            this.selection.setEnabled(value);
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"ACSN_ExportToHTML"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"ACSD_ExportToHTML"));
            JLabel label = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"CTL_OutputDir"));
            label.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"MNE_OutputDir").charAt(0));
            label.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AN_OutputDir"));
            label.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AD_OutputDir"));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.anchor = 17;
            c.insets = new Insets(12, 12, 6, 6);
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            this.fileName = new JTextField();
            this.fileName.setColumns(25);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 2;
            c.anchor = 17;
            c.insets = new Insets(12, 6, 6, 6);
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.fileName, c);
            this.add(this.fileName);
            label.setLabelFor(this.fileName);
            JButton button = new JButton(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"CTL_Select"));
            button.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"MNE_Select").charAt(0));
            button.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AN_Select"));
            button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AD_Select"));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Presenter.this.selectFile();
                }
            });
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.anchor = 17;
            c.insets = new Insets(12, 6, 6, 12);
            ((GridBagLayout)this.getLayout()).setConstraints(button, c);
            this.add(button);
            this.selection = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"CTL_Selection"));
            this.selection.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"MNE_Selection").charAt(0));
            this.selection.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AN_Selection"));
            this.selection.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AD_Selection"));
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(6, 6, 6, 12);
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.selection, c);
            this.add(this.selection);
            this.showLineNumbers = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"CTL_ShowLineNumbers"));
            this.showLineNumbers.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"MNE_ShowLineNumbers").charAt(0));
            this.showLineNumbers.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AN_ShowLineNumbers"));
            this.showLineNumbers.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AD_ShowLineNumbers"));
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(6, 6, 6, 12);
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.showLineNumbers, c);
            this.add(this.showLineNumbers);
            this.openHtml = new JCheckBox(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"CTL_OpenHTML"));
            this.openHtml.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"MNE_OpenHTML").charAt(0));
            this.openHtml.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AN_OpenHTML"));
            this.openHtml.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"AD_OpenHTML"));
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 3;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(6, 6, 12, 12);
            c.weightx = 1.0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.openHtml, c);
            this.add(this.openHtml);
        }

        private void selectFile() {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(ExportHtmlAction.HTML_EXT) || f.isDirectory();
                }

                public String getDescription() {
                    return NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$ExportHtmlAction == null ? (class$org$netbeans$modules$editor$ExportHtmlAction = ExportHtmlAction.class$("org.netbeans.modules.editor.ExportHtmlAction")) : class$org$netbeans$modules$editor$ExportHtmlAction), (String)"TXT_HTMLFileType");
                }
            });
            chooser.setSelectedFile(new File(this.fileName.getText()));
            if (chooser.showOpenDialog(ExportHtmlAction.this.dlg) == 0) {
                this.fileName.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

