/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.TestsuiteNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;

final class TestsuiteNode
extends AbstractNode {
    private String suiteName;
    private Report report;
    private boolean filtered;

    TestsuiteNode(String suiteName, boolean filtered) {
        this(null, suiteName, filtered);
    }

    TestsuiteNode(Report report, boolean filtered) {
        this(report, null, filtered);
    }

    private TestsuiteNode(Report report, String suiteName, boolean filtered) {
        super((Children)(report != null ? new TestsuiteNodeChildren(report, filtered) : Children.LEAF));
        this.report = report;
        this.suiteName = report != null ? report.suiteClassName : suiteName;
        this.filtered = filtered;
        assert (this.suiteName != null);
        this.setDisplayName();
        this.setIconBaseWithExtension("org/netbeans/modules/junit/output/res/class.gif");
    }

    void displayReport(Report report) {
        assert (this.report == null && report != null);
        assert (report.suiteClassName.equals(this.suiteName) || this.suiteName == ResultDisplayHandler.ANONYMOUS_SUITE);
        this.report = report;
        this.suiteName = report.suiteClassName;
        this.setDisplayName();
        this.setChildren((Children)new TestsuiteNodeChildren(report, this.filtered));
    }

    Report getReport() {
        return this.report;
    }

    private void setDisplayName() {
        boolean containsFailed;
        String displayName = this.report == null ? (this.suiteName != ResultDisplayHandler.ANONYMOUS_SUITE ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunning", (Object)this.suiteName) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunningNoname")) : ((containsFailed = this.containsFailed()) ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteFailed", (Object)this.suiteName) : this.suiteName);
        this.setDisplayName(displayName);
    }

    public String getHtmlDisplayName() {
        assert (this.suiteName != null);
        StringBuffer buf = new StringBuffer(60);
        if (this.suiteName != ResultDisplayHandler.ANONYMOUS_SUITE) {
            buf.append(this.suiteName);
            buf.append("&nbsp;&nbsp;");
        } else {
            buf.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteNoname"));
            buf.append("&nbsp;");
        }
        if (this.report != null) {
            boolean containsFailed = this.containsFailed();
            buf.append("<font color='#");
            buf.append(containsFailed ? "FF0000'>" : "00CC00'>");
            buf.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(containsFailed ? "MSG_TestsuiteFailed_HTML" : "MSG_TestsuitePassed_HTML")));
            buf.append("</font>");
        } else {
            buf.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunning_HTML"));
        }
        return buf.toString();
    }

    void setFiltered(boolean filtered) {
        if (filtered == this.filtered) {
            return;
        }
        this.filtered = filtered;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((TestsuiteNodeChildren)children).setFiltered(filtered);
        }
    }

    private boolean containsFailed() {
        return this.report != null && this.report.failures + this.report.errors != 0;
    }
}

